/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.multiBodySystem;

import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.mecano.yoVariables.tools.YoMecanoFactories;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoPlanarJoint
extends Joint
implements PlanarJointBasics {
    private final YoRegistry registry;
    private final Pose3DBasics jointPose;
    private final FixedFrameTwistBasics jointTwist;
    private final FixedFrameSpatialAccelerationBasics jointAcceleration;
    private FixedFrameWrenchBasics jointWrench;
    private final List<TwistReadOnly> unitTwists;

    public YoPlanarJoint(String name, RigidBodyBasics predecessor, YoRegistry registry) {
        this(name, predecessor, null, registry);
    }

    public YoPlanarJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent, YoRegistry registry) {
        super(name, predecessor, transformToParent);
        this.registry = registry;
        YoDouble x = new YoDouble(name + "X", registry);
        YoDouble z = new YoDouble(name + "Z", registry);
        YoDouble pitch = new YoDouble(name + "Pitch", registry);
        this.jointPose = YoMecanoFactories.newPlanarYoPose3DBasics(pitch, x, z);
        YoDouble angularVelocityY = new YoDouble(name + "AngularVelocityY", registry);
        YoDouble linearVelocityX = new YoDouble(name + "LinearVelocityX", registry);
        YoDouble linearVelocityZ = new YoDouble(name + "LinearVelocityZ", registry);
        this.jointTwist = YoMecanoFactories.newPlanarYoFixedFrameTwistBasics(angularVelocityY, linearVelocityX, linearVelocityZ, (ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, (ReferenceFrame)this.afterJointFrame);
        YoDouble angularAccelerationY = new YoDouble(name + "AngularAccelerationY", registry);
        YoDouble linearAccelerationX = new YoDouble(name + "LinearAccelerationX", registry);
        YoDouble linearAccelerationZ = new YoDouble(name + "LinearAccelerationZ", registry);
        this.jointAcceleration = YoMecanoFactories.newPlanarYoFixedFrameSpatialAccelerationVectorBasics(angularAccelerationY, linearAccelerationX, linearAccelerationZ, (ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, (ReferenceFrame)this.afterJointFrame);
        this.unitTwists = MecanoTools.computePlanarJointMotionSubspace((ReferenceFrame)this.beforeJointFrame, (ReferenceFrame)this.afterJointFrame);
    }

    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        MovingReferenceFrame successorFrame = successor.getBodyFixedFrame();
        YoDouble torqueY = new YoDouble(this.name + "TorqueY", this.registry);
        YoDouble forceX = new YoDouble(this.name + "ForceX", this.registry);
        YoDouble forceZ = new YoDouble(this.name + "ForceZ", this.registry);
        this.jointWrench = YoMecanoFactories.newPlanarYoFixedFrameWrenchBasics(torqueY, forceX, forceZ, (ReferenceFrame)successorFrame, (ReferenceFrame)this.afterJointFrame);
    }

    public Pose3DBasics getJointPose() {
        return this.jointPose;
    }

    public FixedFrameTwistBasics getJointTwist() {
        return this.jointTwist;
    }

    public FixedFrameSpatialAccelerationBasics getJointAcceleration() {
        return this.jointAcceleration;
    }

    public FixedFrameWrenchBasics getJointWrench() {
        return this.jointWrench;
    }

    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }
}

