/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.yoVariables.multiBodySystem;

import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class YoOneDoFJoint
extends OneDoFJoint {
    private final YoDouble q;
    private final YoDouble qd;
    private final YoDouble qdd;
    private final YoDouble tau;
    private final YoDouble jointLimitLower;
    private final YoDouble jointLimitUpper;
    private final YoDouble velocityLimitLower;
    private final YoDouble velocityLimitUpper;
    private final YoDouble effortLimitLower;
    private final YoDouble effortLimitUpper;

    public YoOneDoFJoint(String name, RigidBodyBasics predecessor, Vector3DReadOnly jointAxisAngularPart, Vector3DReadOnly jointAxisLinearPart, RigidBodyTransformReadOnly transformToParent, YoRegistry registry) {
        super(name, predecessor, jointAxisAngularPart, jointAxisLinearPart, transformToParent);
        this.q = new YoDouble("q_" + this.getName(), registry);
        this.qd = new YoDouble("qd_" + this.getName(), registry);
        this.qdd = new YoDouble("qdd_" + this.getName(), registry);
        this.tau = new YoDouble("tau_" + this.getName(), registry);
        this.jointLimitLower = new YoDouble("q_min_" + this.getName(), registry);
        this.jointLimitUpper = new YoDouble("q_max_" + this.getName(), registry);
        this.velocityLimitLower = new YoDouble("qd_min_" + this.getName(), registry);
        this.velocityLimitUpper = new YoDouble("qd_max_" + this.getName(), registry);
        this.effortLimitLower = new YoDouble("tau_min_" + this.getName(), registry);
        this.effortLimitUpper = new YoDouble("tau_max_" + this.getName(), registry);
        this.jointLimitLower.set(Double.NEGATIVE_INFINITY);
        this.jointLimitUpper.set(Double.POSITIVE_INFINITY);
        this.velocityLimitLower.set(Double.NEGATIVE_INFINITY);
        this.velocityLimitUpper.set(Double.POSITIVE_INFINITY);
        this.effortLimitLower.set(Double.NEGATIVE_INFINITY);
        this.effortLimitUpper.set(Double.POSITIVE_INFINITY);
    }

    public void setQ(double q) {
        this.q.set(q);
    }

    public void setQd(double qd) {
        this.qd.set(qd);
    }

    public void setQdd(double qdd) {
        this.qdd.set(qdd);
    }

    public void setTau(double tau) {
        this.tau.set(tau);
    }

    public void setJointLimits(double jointLimitLower, double jointLimitUpper) {
        this.jointLimitLower.set(jointLimitLower);
        this.jointLimitUpper.set(jointLimitUpper);
    }

    public void setVelocityLimits(double velocityLimitLower, double velocityLimitUpper) {
        this.velocityLimitLower.set(velocityLimitLower);
        this.velocityLimitUpper.set(velocityLimitUpper);
    }

    public void setEffortLimits(double effortLimitLower, double effortLimitUpper) {
        this.effortLimitLower.set(effortLimitLower);
        this.effortLimitUpper.set(effortLimitUpper);
    }

    public double getQ() {
        return this.q.getValue();
    }

    public double getQd() {
        return this.qd.getValue();
    }

    public double getQdd() {
        return this.qdd.getValue();
    }

    public double getTau() {
        return this.tau.getValue();
    }

    public double getJointLimitLower() {
        return this.jointLimitLower.getValue();
    }

    public double getJointLimitUpper() {
        return this.jointLimitUpper.getValue();
    }

    public double getVelocityLimitLower() {
        return this.velocityLimitLower.getValue();
    }

    public double getVelocityLimitUpper() {
        return this.velocityLimitUpper.getValue();
    }

    public double getEffortLimitLower() {
        return this.effortLimitLower.getValue();
    }

    public double getEffortLimitUpper() {
        return this.effortLimitUpper.getValue();
    }
}

