/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.fourBar;

import java.util.Random;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.fourBar.CrossFourBarJointTest;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteTwinsJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteTwinsJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoTestTools;

public abstract class RevoluteTwinsJointBasicsTest<J extends RevoluteTwinsJointBasics> {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int ITERATIONS = 1000;

    public abstract J nextRevoluteTwinsJoint(Random var1, String var2);

    @Test
    public void testMotionSubspaceDot() {
        Random random = new Random(346346L);
        for (int i = 0; i < 1000; ++i) {
            J joint = this.nextRevoluteTwinsJoint(random, "joint" + i);
            double dt = 5.0E-7;
            DMatrixRMaj Sprev = new DMatrixRMaj(6, 1);
            DMatrixRMaj Scurr = new DMatrixRMaj(6, 1);
            DMatrixRMaj actualSPrime = new DMatrixRMaj(6, 1);
            DMatrixRMaj expectedSPrime = new DMatrixRMaj(6, 1);
            DMatrixRMaj errorSPrime = new DMatrixRMaj(6, 1);
            double qMin = Math.max(joint.getJointLimitLower(), -Math.PI);
            double qMax = Math.min(joint.getJointLimitUpper(), Math.PI);
            double q = EuclidCoreRandomTools.nextDouble((Random)random, (double)qMin, (double)qMax);
            double qd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            joint.setQ(q);
            joint.setQd(qd);
            joint.updateFramesRecursively();
            joint.getMotionSubspace((DMatrix1Row)Sprev);
            joint.getMotionSubspaceDot((DMatrix1Row)actualSPrime);
            joint.setQ(q += qd * dt);
            joint.updateFramesRecursively();
            joint.getMotionSubspace((DMatrix1Row)Scurr);
            CrossFourBarJointTest.numericallyDifferentiate((DMatrix1Row)expectedSPrime, (DMatrix1Row)Sprev, (DMatrix1Row)Scurr, dt);
            CommonOps_DDRM.subtract((DMatrixD1)expectedSPrime, (DMatrixD1)actualSPrime, (DMatrixD1)errorSPrime);
            Assertions.assertTrue((boolean)MatrixFeatures_DDRM.isEquals((DMatrixD1)expectedSPrime, (DMatrixD1)actualSPrime, (double)1.0E-4), (String)String.format("Iteration: %d\nExpected:\n%s\nwas:\n%s\nDifference:\n%s", i, expectedSPrime, actualSPrime, errorSPrime));
        }
    }

    @Test
    public void testJointPose() {
        Random random = new Random(346346L);
        for (int i = 0; i < 1000; ++i) {
            J joint = this.nextRevoluteTwinsJoint(random, "joint" + i);
            double qMin = Math.max(joint.getJointLimitLower(), -Math.PI);
            double qMax = Math.min(joint.getJointLimitUpper(), Math.PI);
            double q = EuclidCoreRandomTools.nextDouble((Random)random, (double)qMin, (double)qMax);
            joint.setQ(q);
            joint.updateFramesRecursively();
            FramePose3D actualPose = new FramePose3D((ReferenceFrame)joint.getFrameAfterJoint());
            actualPose.changeFrame(worldFrame);
            RigidBody rootClone = new RigidBody("rootClone", worldFrame);
            RevoluteJoint jointAClone = new RevoluteJoint("jointAClone", (RigidBodyBasics)rootClone, (RigidBodyTransformReadOnly)joint.getJointA().getFrameBeforeJoint().getTransformToParent(), (Vector3DReadOnly)joint.getJointA().getJointAxis());
            RigidBody bodyABClone = new RigidBody("bodyABClone", (JointBasics)jointAClone, (Matrix3DReadOnly)new Matrix3D(), 0.0, (RigidBodyTransformReadOnly)joint.getJointA().getSuccessor().getBodyFixedFrame().getTransformToParent());
            RevoluteJoint jointBClone = new RevoluteJoint("jointBClone", (RigidBodyBasics)bodyABClone, (RigidBodyTransformReadOnly)joint.getJointB().getFrameBeforeJoint().getTransformToParent(), (Vector3DReadOnly)joint.getJointB().getJointAxis());
            jointAClone.setQ(joint.getJointA().getQ());
            jointBClone.setQ(joint.getJointB().getQ());
            rootClone.updateFramesRecursively();
            FramePose3D expectedPose = new FramePose3D((ReferenceFrame)jointBClone.getFrameAfterJoint());
            expectedPose.changeFrame(worldFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedPose, (EuclidFrameGeometry)actualPose, (double)1.0E-12);
        }
    }

    @Test
    public void testJointTwist() {
        Random random = new Random(346346L);
        double dt = 1.0E-8;
        for (int i = 0; i < 1000; ++i) {
            J joint = this.nextRevoluteTwinsJoint(random, "joint" + i);
            double qMin = Math.max(joint.getJointLimitLower(), -Math.PI);
            double qMax = Math.min(joint.getJointLimitUpper(), Math.PI);
            double q = EuclidCoreRandomTools.nextDouble((Random)random, (double)qMin, (double)qMax);
            double qd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            joint.setQ(q);
            joint.setQd(qd);
            joint.updateFramesRecursively();
            Twist actualTwist = new Twist((SpatialMotionReadOnly)joint.getJointTwist());
            FramePose3D posePrev = new FramePose3D((ReferenceFrame)joint.getFrameAfterJoint());
            posePrev.changeFrame((ReferenceFrame)joint.getFrameBeforeJoint());
            joint.setQ(q += qd * dt);
            joint.updateFramesRecursively();
            FramePose3D poseCurr = new FramePose3D((ReferenceFrame)joint.getFrameAfterJoint());
            poseCurr.changeFrame((ReferenceFrame)joint.getFrameBeforeJoint());
            Twist expectedTwist = new Twist((ReferenceFrame)joint.getFrameAfterJoint(), (ReferenceFrame)joint.getFrameBeforeJoint(), (ReferenceFrame)joint.getFrameAfterJoint());
            expectedTwist.getLinearPart().setMatchingFrame((FrameTuple3DReadOnly)RevoluteTwinsJointBasicsTest.finiteDifference((FrameTuple3DReadOnly)poseCurr.getPosition(), (FrameTuple3DReadOnly)posePrev.getPosition(), dt));
            expectedTwist.getAngularPart().setMatchingFrame((FrameTuple3DReadOnly)RevoluteTwinsJointBasicsTest.finiteDifference((FrameQuaternionReadOnly)poseCurr.getOrientation(), (FrameQuaternionReadOnly)posePrev.getOrientation(), dt));
            MecanoTestTools.assertTwistEquals((String)("Iteration: " + i), (TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-6);
            actualTwist.setIncludingFrame((SpatialMotionReadOnly)joint.getUnitJointTwist());
            actualTwist.scale(qd);
            MecanoTestTools.assertTwistEquals((String)("Iteration: " + i), (TwistReadOnly)joint.getJointTwist(), (TwistReadOnly)actualTwist, (double)1.0E-12);
            expectedTwist.setIncludingFrame((SpatialMotionReadOnly)joint.getUnitJointTwist());
            expectedTwist.changeFrame((ReferenceFrame)joint.getSuccessor().getBodyFixedFrame());
            expectedTwist.setBodyFrame((ReferenceFrame)joint.getSuccessor().getBodyFixedFrame());
            expectedTwist.setBaseFrame((ReferenceFrame)joint.getPredecessor().getBodyFixedFrame());
            MecanoTestTools.assertTwistEquals((String)("Iteration: " + i), (TwistReadOnly)expectedTwist, (TwistReadOnly)joint.getUnitSuccessorTwist(), (double)1.0E-12);
            expectedTwist.invert();
            expectedTwist.changeFrame((ReferenceFrame)joint.getPredecessor().getBodyFixedFrame());
            MecanoTestTools.assertTwistEquals((String)("Iteration: " + i), (TwistReadOnly)expectedTwist, (TwistReadOnly)joint.getUnitPredecessorTwist(), (double)1.0E-12);
        }
    }

    @Test
    public void testJointSpatialAcceleration() {
        Random random = new Random(346346L);
        double dt = 5.0E-9;
        for (int i = 0; i < 1000; ++i) {
            J joint = this.nextRevoluteTwinsJoint(random, "joint" + i);
            double qMin = Math.max(joint.getJointLimitLower(), -Math.PI);
            double qMax = Math.min(joint.getJointLimitUpper(), Math.PI);
            double q = EuclidCoreRandomTools.nextDouble((Random)random, (double)qMin, (double)qMax);
            double qd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double qdd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            joint.setQ(q);
            joint.setQd(qd);
            joint.setQdd(qdd);
            joint.updateFramesRecursively();
            SpatialAcceleration actualAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)joint.getJointAcceleration());
            Twist twistPrev = new Twist((SpatialMotionReadOnly)joint.getJointTwist());
            twistPrev.changeFrame((ReferenceFrame)joint.getFrameBeforeJoint());
            q += qd * dt + 0.5 * qdd * dt * dt;
            joint.setQ(q);
            joint.setQd(qd += qdd * dt);
            joint.updateFramesRecursively();
            Twist twistCurr = new Twist((SpatialMotionReadOnly)joint.getJointTwist());
            twistCurr.changeFrame((ReferenceFrame)joint.getFrameBeforeJoint());
            SpatialAcceleration expectedAcceleration = new SpatialAcceleration((ReferenceFrame)joint.getFrameAfterJoint(), (ReferenceFrame)joint.getFrameBeforeJoint(), (ReferenceFrame)joint.getFrameBeforeJoint());
            expectedAcceleration.set((SpatialVectorReadOnly)RevoluteTwinsJointBasicsTest.finiteDifference((SpatialVectorReadOnly)twistCurr, (SpatialVectorReadOnly)twistPrev, dt));
            expectedAcceleration.changeFrame((ReferenceFrame)joint.getFrameAfterJoint(), (TwistReadOnly)twistCurr, (TwistReadOnly)twistCurr);
            MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration: " + i), (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)actualAcceleration, (double)5.0E-6);
            actualAcceleration.setIncludingFrame((SpatialMotionReadOnly)joint.getUnitJointAcceleration());
            actualAcceleration.scale(qdd);
            actualAcceleration.add((SpatialVectorReadOnly)joint.getJointBiasAcceleration());
            MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration: " + i), (SpatialAccelerationReadOnly)joint.getJointAcceleration(), (SpatialAccelerationReadOnly)actualAcceleration, (double)1.0E-12);
            expectedAcceleration.setIncludingFrame((SpatialMotionReadOnly)joint.getUnitJointAcceleration());
            expectedAcceleration.changeFrame((ReferenceFrame)joint.getSuccessor().getBodyFixedFrame());
            expectedAcceleration.setBodyFrame((ReferenceFrame)joint.getSuccessor().getBodyFixedFrame());
            expectedAcceleration.setBaseFrame((ReferenceFrame)joint.getPredecessor().getBodyFixedFrame());
            MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration: " + i), (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)joint.getUnitSuccessorAcceleration(), (double)1.0E-12);
            expectedAcceleration.invert();
            expectedAcceleration.changeFrame((ReferenceFrame)joint.getPredecessor().getBodyFixedFrame());
            MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration: " + i), (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)joint.getUnitPredecessorAcceleration(), (double)1.0E-12);
        }
    }

    @Test
    public void testJointBiasAcceleration() {
        Random random = new Random(346346L);
        double dt = 5.0E-9;
        for (int i = 0; i < 1000; ++i) {
            J joint = this.nextRevoluteTwinsJoint(random, "joint" + i);
            double qMin = Math.max(joint.getJointLimitLower(), -Math.PI);
            double qMax = Math.min(joint.getJointLimitUpper(), Math.PI);
            double q = EuclidCoreRandomTools.nextDouble((Random)random, (double)qMin, (double)qMax);
            double qd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            joint.setQ(q);
            joint.setQd(qd);
            joint.setQdd(0.0);
            joint.updateFramesRecursively();
            SpatialAcceleration actualAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)joint.getJointBiasAcceleration());
            Twist twistPrev = new Twist((SpatialMotionReadOnly)joint.getJointTwist());
            twistPrev.changeFrame((ReferenceFrame)joint.getFrameBeforeJoint());
            joint.setQ(q += qd * dt);
            joint.setQd(qd);
            joint.updateFramesRecursively();
            Twist twistCurr = new Twist((SpatialMotionReadOnly)joint.getJointTwist());
            twistCurr.changeFrame((ReferenceFrame)joint.getFrameBeforeJoint());
            SpatialAcceleration expectedAcceleration = new SpatialAcceleration((ReferenceFrame)joint.getFrameAfterJoint(), (ReferenceFrame)joint.getFrameBeforeJoint(), (ReferenceFrame)joint.getFrameBeforeJoint());
            expectedAcceleration.set((SpatialVectorReadOnly)RevoluteTwinsJointBasicsTest.finiteDifference((SpatialVectorReadOnly)twistCurr, (SpatialVectorReadOnly)twistPrev, dt));
            expectedAcceleration.changeFrame((ReferenceFrame)joint.getFrameAfterJoint(), joint.getJointTwist(), joint.getJointTwist());
            MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration: " + i), (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)actualAcceleration, (double)5.0E-6);
            expectedAcceleration.setIncludingFrame((SpatialMotionReadOnly)joint.getJointBiasAcceleration());
            expectedAcceleration.changeFrame((ReferenceFrame)joint.getSuccessor().getBodyFixedFrame());
            expectedAcceleration.setBodyFrame((ReferenceFrame)joint.getSuccessor().getBodyFixedFrame());
            expectedAcceleration.setBaseFrame((ReferenceFrame)joint.getPredecessor().getBodyFixedFrame());
            MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration: " + i), (SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)joint.getSuccessorBiasAcceleration(), (double)1.0E-12);
        }
    }

    @Test
    public void testConstraint() {
        Random random = new Random(346346L);
        for (int i = 0; i < 1000; ++i) {
            J joint = this.nextRevoluteTwinsJoint(random, "joint" + i);
            double qMin = Math.max(joint.getJointLimitLower(), -Math.PI);
            double qMax = Math.min(joint.getJointLimitUpper(), Math.PI);
            double q = EuclidCoreRandomTools.nextDouble((Random)random, (double)qMin, (double)qMax);
            double qd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double qdd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double tau = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            joint.setQ(q);
            joint.setQd(qd);
            joint.setQdd(qdd);
            joint.setTau(tau);
            joint.updateFramesRecursively();
            double epsilon = 1.0E-12;
            Assertions.assertEquals((double)q, (double)joint.getQ(), (double)epsilon);
            Assertions.assertEquals((double)qd, (double)joint.getQd(), (double)epsilon);
            Assertions.assertEquals((double)qdd, (double)joint.getQdd(), (double)epsilon);
            Assertions.assertEquals((double)tau, (double)joint.getTau(), (double)epsilon);
            RevoluteJointBasics jointActuated = joint.getActuatedJoint();
            RevoluteJointBasics jointConstrained = joint.getConstrainedJoint();
            Assertions.assertEquals((double)(jointActuated.getQ() * joint.getConstraintRatio() + joint.getConstraintOffset()), (double)jointConstrained.getQ(), (double)epsilon, (String)("Iteration: " + i));
            Assertions.assertEquals((double)(jointActuated.getQd() * joint.getConstraintRatio()), (double)jointConstrained.getQd(), (double)epsilon, (String)("Iteration: " + i));
            Assertions.assertEquals((double)(jointActuated.getQdd() * joint.getConstraintRatio()), (double)jointConstrained.getQdd(), (double)epsilon, (String)("Iteration: " + i));
            Assertions.assertEquals((double)jointActuated.getTau(), (double)joint.computeActuatedJointTau(joint.getTau()), (double)epsilon, (String)("Iteration: " + i));
            Assertions.assertEquals((double)0.0, (double)jointConstrained.getTau(), (double)epsilon);
            DMatrixRMaj qdMatrix = new DMatrixRMaj(2, 1);
            DMatrixRMaj qddMatrix = new DMatrixRMaj(2, 1);
            DMatrixRMaj ydMatrix = new DMatrixRMaj(1, 1);
            DMatrixRMaj yddMatrix = new DMatrixRMaj(1, 1);
            ydMatrix.set(0, 0, jointActuated.getQd());
            yddMatrix.set(0, 0, jointActuated.getQdd());
            CommonOps_DDRM.mult((DMatrix1Row)((DMatrix1Row)joint.getConstraintJacobian()), (DMatrix1Row)ydMatrix, (DMatrix1Row)qdMatrix);
            CommonOps_DDRM.mult((DMatrix1Row)((DMatrix1Row)joint.getConstraintJacobian()), (DMatrix1Row)yddMatrix, (DMatrix1Row)qddMatrix);
            CommonOps_DDRM.addEquals((DMatrixD1)qddMatrix, (DMatrixD1)((DMatrixD1)joint.getConstraintConvectiveTerm()));
            int actuatedJointIndex = joint.getActuatedJointIndex();
            Assertions.assertEquals((double)jointActuated.getQd(), (double)qdMatrix.get(actuatedJointIndex, 0), (double)epsilon);
            Assertions.assertEquals((double)jointConstrained.getQd(), (double)qdMatrix.get(1 - actuatedJointIndex, 0), (double)epsilon);
            Assertions.assertEquals((double)jointActuated.getQdd(), (double)qddMatrix.get(actuatedJointIndex, 0), (double)epsilon);
            Assertions.assertEquals((double)jointConstrained.getQdd(), (double)qddMatrix.get(1 - actuatedJointIndex, 0), (double)epsilon);
        }
    }

    @Test
    public void testJointLimits() {
        Random random = new Random(346346L);
        for (int i = 0; i < 1000; ++i) {
            J joint = this.nextRevoluteTwinsJoint(random, "joint" + i);
            RevoluteJointBasics jointA = joint.getJointA();
            RevoluteJointBasics jointB = joint.getJointB();
            double qMinA = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            double qRangeA = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)(Math.PI * 2));
            double qMaxA = qMinA + qRangeA;
            jointA.setJointLimitLower(qMinA);
            jointA.setJointLimitUpper(qMaxA);
            double qMinB = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            double qRangeB = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)(Math.PI * 2));
            double qMaxB = qMinB + qRangeB;
            jointB.setJointLimitLower(qMinB);
            jointB.setJointLimitUpper(qMaxB);
            if (RevoluteTwinsJointReadOnly.computeJointLimitLower(joint) > RevoluteTwinsJointReadOnly.computeJointLimitUpper(joint)) {
                Assertions.assertThrows(IllegalStateException.class, () -> joint.getJointLimitLower());
                Assertions.assertThrows(IllegalStateException.class, () -> joint.getJointLimitUpper());
                continue;
            }
            double jointLimitLower = joint.getJointLimitLower();
            joint.setQ(jointLimitLower);
            joint.updateFramesRecursively();
            double qA = jointA.getQ();
            double qB = jointB.getQ();
            Assertions.assertTrue((qA >= qMinA - 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointA is violating its lower limit. q=" + qA + ", qMinA=" + qMinA));
            Assertions.assertTrue((qA <= qMaxA + 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointA is violating its upper limit. q=" + qA + ", qMaxA=" + qMaxA));
            Assertions.assertTrue((qB >= qMinB - 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointB is violating its lower limit. q=" + qB + ", qMinB=" + qMinB));
            Assertions.assertTrue((qB <= qMaxB + 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointB is violating its upper limit. q=" + qB + ", qMaxB=" + qMaxB));
            joint.setQ(joint.getJointLimitUpper());
            joint.updateFramesRecursively();
            qA = jointA.getQ();
            qB = jointB.getQ();
            Assertions.assertTrue((qA >= qMinA - 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointA is violating its lower limit. q=" + qA + ", qMinA=" + qMinA));
            Assertions.assertTrue((qA <= qMaxA + 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointA is violating its upper limit. q=" + qA + ", qMaxA=" + qMaxA));
            Assertions.assertTrue((qB >= qMinB - 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointB is violating its lower limit. q=" + qB + ", qMinB=" + qMinB));
            Assertions.assertTrue((qB <= qMaxB + 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointB is violating its upper limit. q=" + qB + ", qMaxB=" + qMaxB));
        }
    }

    @Test
    public void testJointVelocityLimits() {
        Random random = new Random(346346L);
        for (int i = 0; i < 1000; ++i) {
            J joint = this.nextRevoluteTwinsJoint(random, "joint" + i);
            double qDotMinA = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double qDotRangeA = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double qDotMaxA = qDotMinA + qDotRangeA;
            joint.getJointA().setVelocityLimitLower(qDotMinA);
            joint.getJointA().setVelocityLimitUpper(qDotMaxA);
            double qDotMinB = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double qDotRangeB = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double qDotMaxB = qDotMinB + qDotRangeB;
            joint.getJointB().setVelocityLimitLower(qDotMinB);
            joint.getJointB().setVelocityLimitUpper(qDotMaxB);
            if (RevoluteTwinsJointReadOnly.computeVelocityLimitLower(joint) > RevoluteTwinsJointReadOnly.computeVelocityLimitUpper(joint)) {
                Assertions.assertThrows(IllegalStateException.class, () -> joint.getVelocityLimitLower());
                Assertions.assertThrows(IllegalStateException.class, () -> joint.getVelocityLimitUpper());
                continue;
            }
            double velocityLimitLower = joint.getVelocityLimitLower();
            joint.setQd(velocityLimitLower);
            joint.updateFramesRecursively();
            double qdA = joint.getJointA().getQd();
            double qdB = joint.getJointB().getQd();
            Assertions.assertTrue((qdA >= qDotMinA - 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointA is violating its lower limit. qd=" + qdA + ", qDotMinA=" + qDotMinA));
            Assertions.assertTrue((qdA <= qDotMaxA + 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointA is violating its upper limit. qd=" + qdA + ", qDotMaxA=" + qDotMaxA));
            Assertions.assertTrue((qdB >= qDotMinB - 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointB is violating its lower limit. qd=" + qdB + ", qDotMinB=" + qDotMinB));
            Assertions.assertTrue((qdB <= qDotMaxB + 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointB is violating its upper limit. qd=" + qdB + ", qDotMaxB=" + qDotMaxB));
            joint.setQd(joint.getVelocityLimitUpper());
            joint.updateFramesRecursively();
            qdA = joint.getJointA().getQd();
            qdB = joint.getJointB().getQd();
            Assertions.assertTrue((qdA >= qDotMinA - 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointA is violating its lower limit. qd=" + qdA + ", qDotMinA=" + qDotMinA));
            Assertions.assertTrue((qdA <= qDotMaxA + 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointA is violating its upper limit. qd=" + qdA + ", qDotMaxA=" + qDotMaxA));
            Assertions.assertTrue((qdB >= qDotMinB - 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointB is violating its lower limit. qd=" + qdB + ", qDotMinB=" + qDotMinB));
            Assertions.assertTrue((qdB <= qDotMaxB + 1.0E-12 ? 1 : 0) != 0, (String)("Iteration: " + i + ", jointB is violating its upper limit. qd=" + qdB + ", qDotMaxB=" + qDotMaxB));
        }
    }

    public static SpatialVector finiteDifference(SpatialVectorReadOnly current, SpatialVectorReadOnly previous, double dt) {
        SpatialVector diff = new SpatialVector(current.getReferenceFrame());
        diff.sub(current, previous);
        diff.scale(1.0 / dt);
        return diff;
    }

    public static FrameVector3D finiteDifference(FrameTuple3DReadOnly current, FrameTuple3DReadOnly previous, double dt) {
        FrameVector3D diff = new FrameVector3D(current.getReferenceFrame());
        diff.sub(current, previous);
        diff.scale(1.0 / dt);
        return diff;
    }

    public static FrameVector3D finiteDifference(FrameQuaternionReadOnly current, FrameQuaternionReadOnly previous, double dt) {
        FrameQuaternion diff = new FrameQuaternion(current.getReferenceFrame());
        diff.difference(previous, current);
        FrameVector3D angularVelocity = new FrameVector3D(current.getReferenceFrame());
        diff.getRotationVector((FrameVector3DBasics)angularVelocity);
        angularVelocity.scale(1.0 / dt);
        current.transform((FixedFrameTuple3DBasics)angularVelocity);
        return angularVelocity;
    }
}

