/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.algorithms.RigidBodyTwistCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class RigidBodyTwistCalculatorTest {
    public static final int ITERATIONS = 1000;
    public static final double EPSILON = 1.0E-12;

    @Test
    public void testAgainstMovingReferenceFrame() {
        Random random = new Random(1776L);
        Twist expectedTwist = new Twist();
        for (int i = 0; i < 1000; ++i) {
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)10);
            RigidBodyBasics root = ((JointBasics)joints.get(0)).getPredecessor();
            for (JointStateType stateType : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateType, (Iterable)joints);
            }
            root.updateFramesRecursively();
            RigidBodyTwistCalculator twistCalculator = new RigidBodyTwistCalculator(MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)root));
            twistCalculator.setJointVelocityAccessor((joint, matrixToPack) -> joint.getJointVelocity(0, matrixToPack));
            for (JointBasics joint2 : joints) {
                RigidBodyBasics body = joint2.getSuccessor();
                MecanoTestTools.assertTwistEquals((TwistReadOnly)body.getBodyFixedFrame().getTwistOfFrame(), (TwistReadOnly)twistCalculator.getTwistOfBody((RigidBodyReadOnly)body), (double)1.0E-12);
                for (JointBasics otherJoint : joints) {
                    RigidBodyBasics otherBody = otherJoint.getSuccessor();
                    body.getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)otherBody.getBodyFixedFrame(), (TwistBasics)expectedTwist);
                    MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)twistCalculator.getRelativeTwist((RigidBodyReadOnly)otherBody, (RigidBodyReadOnly)body), (double)1.0E-12);
                }
            }
        }
    }

    @Test
    public void testAgainstMovingReferenceFrameWithMatrixAccessor() {
        Random random = new Random(1776L);
        Twist expectedTwist = new Twist();
        for (int i = 0; i < 1000; ++i) {
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)10);
            RigidBodyBasics root = ((JointBasics)joints.get(0)).getPredecessor();
            for (JointStateType stateType : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateType, (Iterable)joints);
            }
            root.updateFramesRecursively();
            MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)root);
            DMatrixRMaj jointVelocities = new DMatrixRMaj(multiBodySystemInput.getNumberOfDoFs(), 1);
            MultiBodySystemTools.extractJointsState((List)multiBodySystemInput.getJointsToConsider(), (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
            RigidBodyTwistCalculator twistCalculator = new RigidBodyTwistCalculator(multiBodySystemInput);
            twistCalculator.useAllJointVelocityMatrix((DMatrix)jointVelocities);
            for (JointBasics joint : joints) {
                RigidBodyBasics body = joint.getSuccessor();
                MecanoTestTools.assertTwistEquals((TwistReadOnly)body.getBodyFixedFrame().getTwistOfFrame(), (TwistReadOnly)twistCalculator.getTwistOfBody((RigidBodyReadOnly)body), (double)1.0E-12);
                for (JointBasics otherJoint : joints) {
                    RigidBodyBasics otherBody = otherJoint.getSuccessor();
                    body.getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)otherBody.getBodyFixedFrame(), (TwistBasics)expectedTwist);
                    MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)twistCalculator.getRelativeTwist((RigidBodyReadOnly)otherBody, (RigidBodyReadOnly)body), (double)1.0E-12);
                }
            }
        }
    }
}

