/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.Random;
import org.ejml.EjmlUnitTests;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.CentroidalMomentumCalculator;
import us.ihmc.mecano.algorithms.MomentumCalculator;
import us.ihmc.mecano.frames.CenterOfMassReferenceFrame;
import us.ihmc.mecano.multiBodySystem.PrismaticJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.interfaces.FixedFrameMomentumBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class MomentumCalculatorTest {
    private final ReferenceFrame world = ReferenceFrame.getWorldFrame();

    @Test
    public void testSingleRigidBodyTranslation() {
        Random random = new Random(1766L);
        RigidBody elevator = new RigidBody("elevator", this.world);
        Vector3D jointAxis = EuclidCoreRandomTools.nextVector3D((Random)random);
        jointAxis.normalize();
        PrismaticJoint joint = new PrismaticJoint("joint", (RigidBodyBasics)elevator, (Tuple3DReadOnly)new Vector3D(), (Vector3DReadOnly)jointAxis);
        RigidBody body = new RigidBody("body", (JointBasics)joint, (Matrix3DReadOnly)EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random), random.nextDouble(), (Tuple3DReadOnly)new Vector3D());
        joint.setQ(random.nextDouble());
        joint.setQd(random.nextDouble());
        Momentum momentum = this.computeMomentum((RigidBodyBasics)elevator, this.world);
        momentum.changeFrame(this.world);
        FrameVector3D linearMomentum = new FrameVector3D(momentum.getReferenceFrame(), (Tuple3DReadOnly)new Vector3D((Tuple3DReadOnly)momentum.getLinearPart()));
        FrameVector3D angularMomentum = new FrameVector3D(momentum.getReferenceFrame(), (Tuple3DReadOnly)new Vector3D((Tuple3DReadOnly)momentum.getAngularPart()));
        FrameVector3D linearMomentumCheck = new FrameVector3D((ReferenceFrame)joint.getFrameBeforeJoint(), (Tuple3DReadOnly)jointAxis);
        linearMomentumCheck.scale(body.getInertia().getMass() * joint.getQd());
        FrameVector3D angularMomentumCheck = new FrameVector3D(this.world);
        double epsilon = 1.0E-9;
        EuclidCoreTestTools.assertEquals((EuclidGeometry)linearMomentumCheck, (EuclidGeometry)linearMomentum, (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)angularMomentumCheck, (EuclidGeometry)angularMomentum, (double)epsilon);
        Assertions.assertTrue((linearMomentum.norm() > epsilon ? 1 : 0) != 0);
    }

    @Test
    public void testSingleRigidBodyRotation() {
        Random random = new Random(1766L);
        RigidBody elevator = new RigidBody("elevator", this.world);
        Vector3D jointAxis = EuclidCoreRandomTools.nextVector3D((Random)random);
        jointAxis.normalize();
        RigidBodyTransform transformToParent = new RigidBodyTransform();
        transformToParent.setIdentity();
        RevoluteJoint joint = new RevoluteJoint("joint", (RigidBodyBasics)elevator, (RigidBodyTransformReadOnly)transformToParent, (Vector3DReadOnly)jointAxis);
        RigidBody body = new RigidBody("body", (JointBasics)joint, (Matrix3DReadOnly)EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random), random.nextDouble(), (Tuple3DReadOnly)new Vector3D());
        joint.setQ(random.nextDouble());
        joint.setQd(random.nextDouble());
        Momentum momentum = this.computeMomentum((RigidBodyBasics)elevator, this.world);
        momentum.changeFrame(this.world);
        FrameVector3D linearMomentum = new FrameVector3D(momentum.getReferenceFrame(), (Tuple3DReadOnly)new Vector3D((Tuple3DReadOnly)momentum.getLinearPart()));
        FrameVector3D angularMomentum = new FrameVector3D(momentum.getReferenceFrame(), (Tuple3DReadOnly)new Vector3D((Tuple3DReadOnly)momentum.getAngularPart()));
        FrameVector3D linearMomentumCheck = new FrameVector3D(this.world);
        Matrix3D inertia = new Matrix3D((Matrix3DReadOnly)body.getInertia().getMomentOfInertia());
        Vector3D angularMomentumCheckVector = new Vector3D((Tuple3DReadOnly)jointAxis);
        angularMomentumCheckVector.scale(joint.getQd());
        inertia.transform((Tuple3DBasics)angularMomentumCheckVector);
        FrameVector3D angularMomentumCheck = new FrameVector3D(body.getInertia().getReferenceFrame(), (Tuple3DReadOnly)angularMomentumCheckVector);
        angularMomentumCheck.changeFrame(this.world);
        double epsilon = 1.0E-9;
        EuclidCoreTestTools.assertEquals((EuclidGeometry)linearMomentumCheck, (EuclidGeometry)linearMomentum, (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)angularMomentumCheck, (EuclidGeometry)angularMomentum, (double)epsilon);
        Assertions.assertTrue((angularMomentum.norm() > epsilon ? 1 : 0) != 0);
    }

    @Test
    public void testChainAgainstCentroidalMomentumMatrix() {
        Random random = new Random(17679L);
        ArrayList joints = new ArrayList();
        RigidBody elevator = new RigidBody("elevator", this.world);
        int nJoints = 10;
        Vector3D[] jointAxes = new Vector3D[nJoints];
        for (int i = 0; i < nJoints; ++i) {
            Vector3D jointAxis = EuclidCoreRandomTools.nextVector3D((Random)random);
            jointAxis.normalize();
            jointAxes[i] = jointAxis;
        }
        joints.addAll(MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (String)"randomChain", (RigidBodyBasics)elevator, (Vector3DReadOnly[])jointAxes));
        RevoluteJoint[] jointsArray = new RevoluteJoint[joints.size()];
        joints.toArray(jointsArray);
        CenterOfMassReferenceFrame centerOfMassFrame = new CenterOfMassReferenceFrame("comFrame", this.world, (RigidBodyReadOnly)elevator);
        for (RevoluteJoint joint : joints) {
            joint.setQ(random.nextDouble());
            joint.setQd(random.nextDouble());
        }
        Momentum momentum = this.computeMomentum((RigidBodyBasics)elevator, (ReferenceFrame)centerOfMassFrame);
        DMatrixRMaj momentumMatrix = new DMatrixRMaj(6, 1);
        momentum.get((DMatrix)momentumMatrix);
        CentroidalMomentumCalculator centroidalMomentumMatrix = new CentroidalMomentumCalculator((RigidBodyReadOnly)elevator, (ReferenceFrame)centerOfMassFrame);
        centroidalMomentumMatrix.reset();
        DMatrixRMaj centroidalMomentumMatrixMatrix = centroidalMomentumMatrix.getCentroidalMomentumMatrix();
        DMatrixRMaj jointVelocitiesMatrix = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointsArray), 1);
        MultiBodySystemTools.extractJointsState((JointReadOnly[])jointsArray, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocitiesMatrix);
        DMatrixRMaj momentumFromCentroidalMomentumMatrix = new DMatrixRMaj(6, 1);
        CommonOps_DDRM.mult((DMatrix1Row)centroidalMomentumMatrixMatrix, (DMatrix1Row)jointVelocitiesMatrix, (DMatrix1Row)momentumFromCentroidalMomentumMatrix);
        double epsilon = 1.0E-9;
        Assertions.assertEquals((Object)momentum.getReferenceFrame(), (Object)centerOfMassFrame);
        EjmlUnitTests.assertEquals((DMatrix)momentumFromCentroidalMomentumMatrix, (DMatrix)momentumMatrix, (double)epsilon);
        double norm = NormOps_DDRM.normP2((DMatrixRMaj)momentumMatrix);
        Assertions.assertTrue((norm > epsilon ? 1 : 0) != 0);
    }

    private Momentum computeMomentum(RigidBodyBasics elevator, ReferenceFrame frame) {
        elevator.updateFramesRecursively();
        MomentumCalculator momentumCalculator = new MomentumCalculator((RigidBodyReadOnly)elevator);
        Momentum momentum = new Momentum(frame);
        momentumCalculator.computeAndPack((FixedFrameMomentumBasics)momentum);
        return momentum;
    }
}

