/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.GeometricJacobianCalculator;
import us.ihmc.mecano.algorithms.InverseDynamicsCalculator;
import us.ihmc.mecano.algorithms.JointTorqueRegressorCalculator;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class JointTorqueRegressorCalculatorTest {
    private static final int STATE_ITERATIONS = 100;
    private static final int SYSTEM_ITERATIONS = 5;
    private static final double EPSILON = 1.0E-12;
    private static final double GRAVITY_Z = -9.81;
    private static final int PARAMETERS_PER_BODY = 10;
    private static final int WARMUP_ITERATIONS = 100;
    private static final int ITERATIONS = 1000;

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsSimple() {
        Random random = new Random(25L);
        int numberOfJoints = 2;
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
        for (JointStateType type : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)system.getAllJoints());
        }
        InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
        inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
        inverseDynamicsCalculator.compute();
        DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
        JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
        DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
        regressorCalculator.setGravitationalAcceleration(-9.81);
        regressorCalculator.compute();
        DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
        DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
        CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
        Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
        Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
    }

    @Test
    public void testThrowsUnsupportedOperationExceptionWithKinematicLoop() {
        Random random = new Random(25L);
        int numberOfJoints = 10;
        List joints = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
        int loopStartIndex = 2;
        int loopEndIndex = 7;
        int kinematicLoopSize = 5;
        RigidBodyBasics loopStart = ((RevoluteJoint)joints.get(loopStartIndex)).getSuccessor();
        RigidBodyBasics loopEnd = ((RevoluteJoint)joints.get(loopEndIndex)).getSuccessor();
        List loop = MultiBodySystemRandomTools.nextKinematicLoopRevoluteJoints((Random)random, (String)"loop", (RigidBodyBasics)loopStart, (RigidBodyBasics)loopEnd, (int)kinematicLoopSize);
        joints.addAll(loop);
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
        try {
            JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
            Assertions.fail((String)"Should have thrown an exception.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsOneDoFJointChain() {
        Random random = new Random(25L);
        for (int i = 0; i < 5; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            for (int j = 0; j < 100; ++j) {
                for (JointStateType type : JointStateType.values()) {
                    MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)system.getAllJoints());
                }
                InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
                inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
                inverseDynamicsCalculator.compute();
                DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
                JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
                DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
                regressorCalculator.setGravitationalAcceleration(-9.81);
                regressorCalculator.compute();
                DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
                DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
                Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
                Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void benchmarkOneDoFJointChain() {
        int i;
        Random random = new Random(25L);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)30);
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
        JointTorqueRegressorCalculator calculator = new JointTorqueRegressorCalculator(system);
        calculator.setGravitationalAcceleration(-9.81);
        long totalTime = 0L;
        for (i = 0; i < 100; ++i) {
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)joints);
            }
            calculator.compute();
        }
        for (i = 0; i < 1000; ++i) {
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)joints);
            }
            long startTime = System.nanoTime();
            calculator.compute();
            totalTime += System.nanoTime() - startTime;
        }
        LogTools.info((String)("1-DoF chain: Took on average per iteration: " + (double)totalTime / 1.0E9 / 1000.0 + " seconds"));
    }

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsFloatingOneDoFJointChain() {
        Random random = new Random(25L);
        for (int i = 0; i < 5; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
            RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
            joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
            RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
            joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (RigidBodyBasics)floatingBody, (int)numberOfJoints));
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
            for (int j = 0; j < 100; ++j) {
                for (JointStateType type : JointStateType.values()) {
                    MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)system.getAllJoints());
                }
                InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
                inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
                inverseDynamicsCalculator.compute();
                DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
                JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
                DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
                regressorCalculator.setGravitationalAcceleration(-9.81);
                regressorCalculator.compute();
                DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
                DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
                Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
                Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void benchmarkForFloatingOneDoFJointChain() {
        int i;
        Random random = new Random(25L);
        ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
        RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
        RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
        joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (RigidBodyBasics)floatingBody, (int)30));
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
        JointTorqueRegressorCalculator calculator = new JointTorqueRegressorCalculator(system);
        calculator.setGravitationalAcceleration(-9.81);
        long totalTime = 0L;
        for (i = 0; i < 100; ++i) {
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, joints);
            }
            calculator.compute();
        }
        for (i = 0; i < 1000; ++i) {
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, joints);
            }
            long startTime = System.nanoTime();
            calculator.compute();
            totalTime += System.nanoTime() - startTime;
        }
        LogTools.info((String)("Floating 1-DoF chain: Took on average per iteration: " + (double)totalTime / 1.0E9 / 1000.0 + " seconds"));
    }

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsOneDoFJointTree() {
        Random random = new Random(25L);
        for (int i = 0; i < 5; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)numberOfJoints);
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            for (int j = 0; j < 100; ++j) {
                for (JointStateType type : JointStateType.values()) {
                    MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)system.getAllJoints());
                }
                InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
                inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
                inverseDynamicsCalculator.compute();
                DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
                JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
                DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
                regressorCalculator.setGravitationalAcceleration(-9.81);
                regressorCalculator.compute();
                DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
                DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
                Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
                Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void benchmarkForOneDoFJointTree() {
        int i;
        Random random = new Random(25L);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)30);
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
        JointTorqueRegressorCalculator calculator = new JointTorqueRegressorCalculator(system);
        calculator.setGravitationalAcceleration(-9.81);
        long totalTime = 0L;
        for (i = 0; i < 100; ++i) {
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)joints);
            }
            calculator.compute();
        }
        for (i = 0; i < 1000; ++i) {
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)joints);
            }
            long startTime = System.nanoTime();
            calculator.compute();
            totalTime += System.nanoTime() - startTime;
        }
        LogTools.info((String)("1-DoF tree: Took on average per iteration: " + (double)totalTime / 1.0E9 / 1000.0 + " seconds"));
    }

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsFloatingOneDoFJointTree() {
        Random random = new Random(25L);
        for (int i = 0; i < 5; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
            RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
            joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
            RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
            joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (RigidBodyBasics)floatingBody, (int)numberOfJoints));
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
            for (int j = 0; j < 100; ++j) {
                for (JointStateType type : JointStateType.values()) {
                    MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)system.getAllJoints());
                }
                InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
                inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
                inverseDynamicsCalculator.compute();
                DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
                JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
                DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
                regressorCalculator.setGravitationalAcceleration(-9.81);
                regressorCalculator.compute();
                DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
                DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
                Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
                Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void benchmarkForFloatingOneDoFJointTree() {
        int i;
        Random random = new Random(25L);
        ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
        RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
        RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
        joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (RigidBodyBasics)floatingBody, (int)30));
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
        JointTorqueRegressorCalculator calculator = new JointTorqueRegressorCalculator(system);
        calculator.setGravitationalAcceleration(-9.81);
        long totalTime = 0L;
        for (i = 0; i < 100; ++i) {
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, joints);
            }
            calculator.compute();
        }
        for (i = 0; i < 1000; ++i) {
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, joints);
            }
            long startTime = System.nanoTime();
            calculator.compute();
            totalTime += System.nanoTime() - startTime;
        }
        LogTools.info((String)("Floating 1-DoF tree: Took on average per iteration: " + (double)totalTime / 1.0E9 / 1000.0 + " seconds"));
    }

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsOneDoFJointChainWithExternalWrenches() {
        Random random = new Random(25L);
        for (int i = 0; i < 5; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            for (int j = 0; j < 100; ++j) {
                for (JointStateType type : JointStateType.values()) {
                    MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)system.getAllJoints());
                }
                InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
                inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
                LinkedHashMap<RigidBodyBasics, Wrench> rigidBodiesToExternalWrenchMap = new LinkedHashMap<RigidBodyBasics, Wrench>();
                for (RigidBodyBasics body : system.getRootBody().subtreeArray()) {
                    if (body.getInertia() == null || !random.nextBoolean()) continue;
                    Wrench wrenchToApply = MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)body.getBodyFixedFrame(), (ReferenceFrame)body.getBodyFixedFrame());
                    inverseDynamicsCalculator.setExternalWrench((RigidBodyReadOnly)body, (WrenchReadOnly)wrenchToApply);
                    rigidBodiesToExternalWrenchMap.put(body, wrenchToApply);
                }
                inverseDynamicsCalculator.compute();
                DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
                JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
                DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
                regressorCalculator.setGravitationalAcceleration(-9.81);
                LinkedHashMap<RigidBodyReadOnly, DMatrixRMaj> rigidBodyToContactJacobianMap = new LinkedHashMap<RigidBodyReadOnly, DMatrixRMaj>();
                GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
                DMatrixRMaj torques = new DMatrixRMaj(system.getNumberOfDoFs());
                for (RigidBodyReadOnly body : rigidBodiesToExternalWrenchMap.keySet()) {
                    jacobianCalculator.setKinematicChain((RigidBodyReadOnly)system.getRootBody(), body);
                    jacobianCalculator.getJointTorques((WrenchReadOnly)rigidBodiesToExternalWrenchMap.get(body), (DMatrix1Row)torques);
                    rigidBodyToContactJacobianMap.put(body, new DMatrixRMaj(torques));
                    ((DMatrixRMaj)rigidBodyToContactJacobianMap.get(body)).reshape(system.getNumberOfDoFs(), 1, true);
                }
                regressorCalculator.compute();
                DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
                DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
                for (DMatrixRMaj torque : rigidBodyToContactJacobianMap.values()) {
                    CommonOps_DDRM.add((DMatrixD1)actualJointTau, (double)-1.0, (DMatrixD1)torque, (DMatrixD1)actualJointTau);
                }
                Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
                Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsNoAccelerations() {
        Random random = new Random(25L);
        for (int i = 0; i < 5; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            for (int j = 0; j < 100; ++j) {
                for (JointStateType type : JointStateType.values()) {
                    MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)system.getAllJoints());
                }
                InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
                inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
                inverseDynamicsCalculator.setConsiderJointAccelerations(false);
                inverseDynamicsCalculator.compute();
                DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
                JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
                DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
                regressorCalculator.setConsiderJointAccelerations(false);
                regressorCalculator.setGravitationalAcceleration(-9.81);
                regressorCalculator.compute();
                DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
                DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
                Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
                Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testRegressorAndParametersMatchInverseDynamicsNoCoriolisOrCentrifugal() {
        Random random = new Random(25L);
        for (int i = 0; i < 5; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            for (int j = 0; j < 100; ++j) {
                for (JointStateType type : JointStateType.values()) {
                    MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)system.getAllJoints());
                }
                InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
                inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
                inverseDynamicsCalculator.setConsiderCoriolisAndCentrifugalForces(false);
                inverseDynamicsCalculator.compute();
                DMatrixRMaj expectedjointTau = inverseDynamicsCalculator.getJointTauMatrix();
                JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(system);
                DMatrixRMaj parameterVector = regressorCalculator.getParameterVector();
                regressorCalculator.setConsiderCoriolisAndCentrifugalForces(false);
                regressorCalculator.setGravitationalAcceleration(-9.81);
                regressorCalculator.compute();
                DMatrixRMaj regressorMatrix = regressorCalculator.getJointTorqueRegressorMatrix();
                DMatrixRMaj actualJointTau = new DMatrixRMaj(numberOfJoints, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorMatrix, (DMatrix1Row)parameterVector, (DMatrix1Row)actualJointTau);
                Assertions.assertEquals((int)expectedjointTau.getData().length, (int)actualJointTau.getData().length);
                Assertions.assertArrayEquals((double[])expectedjointTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testMixOfInverseDynamicsAndBodywiseRegressorSimple() {
        Random random = new Random(3987L);
        int numberOfJoints = 3;
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
        MultiBodySystemBasics systemNominal = MultiBodySystemBasics.clone((MultiBodySystemReadOnly)system, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        MultiBodySystemBasics systemRegressor = MultiBodySystemBasics.clone((MultiBodySystemReadOnly)system, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        for (JointStateType type : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)system.getAllJoints());
            MultiBodySystemTools.copyJointsState((List)system.getAllJoints(), (List)systemNominal.getAllJoints(), (JointStateType)type);
            MultiBodySystemTools.copyJointsState((List)system.getAllJoints(), (List)systemRegressor.getAllJoints(), (JointStateType)type);
        }
        InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
        inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
        inverseDynamicsCalculator.compute();
        DMatrixRMaj expectedTau = inverseDynamicsCalculator.getJointTauMatrix();
        int jointIndexToZero = 1;
        RigidBodyBasics bodyToZeroNominal = ((JointBasics)systemNominal.getAllJoints().get(jointIndexToZero)).getSuccessor();
        bodyToZeroNominal.getInertia().setToZero();
        RigidBodyBasics bodyToZeroRegressor = ((JointBasics)systemRegressor.getAllJoints().get(jointIndexToZero)).getSuccessor();
        InverseDynamicsCalculator inverseDynamicsCalculatorNominal = new InverseDynamicsCalculator((MultiBodySystemReadOnly)systemNominal);
        inverseDynamicsCalculatorNominal.setGravitationalAcceleration(-9.81);
        inverseDynamicsCalculatorNominal.compute();
        DMatrixRMaj nominalTau = inverseDynamicsCalculatorNominal.getJointTauMatrix();
        JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(systemRegressor);
        regressorCalculator.setGravitationalAcceleration(-9.81);
        regressorCalculator.compute((RigidBodyReadOnly)bodyToZeroRegressor);
        DMatrixRMaj regressorBlock = regressorCalculator.getJointTorqueRegressorMatrixBlock((RigidBodyReadOnly)bodyToZeroRegressor);
        DMatrixRMaj parameterBlock = regressorCalculator.getParameterVectorSlice((RigidBodyReadOnly)bodyToZeroRegressor);
        int nDoFs = MultiBodySystemTools.computeDegreesOfFreedom((List)system.getAllJoints());
        DMatrixRMaj regressorTau = new DMatrixRMaj(nDoFs, 1);
        CommonOps_DDRM.mult((DMatrix1Row)regressorBlock, (DMatrix1Row)parameterBlock, (DMatrix1Row)regressorTau);
        DMatrixRMaj actualJointTau = new DMatrixRMaj(nDoFs, 1);
        CommonOps_DDRM.add((DMatrixD1)nominalTau, (DMatrixD1)regressorTau, (DMatrixD1)actualJointTau);
        Assertions.assertEquals((int)expectedTau.getData().length, (int)actualJointTau.getData().length);
        Assertions.assertArrayEquals((double[])expectedTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
    }

    @Test
    public void testMixOfInverseDynamicsAndBodywiseRegressor() {
        Random random = new Random(45376L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
            RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
            joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
            RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
            joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (RigidBodyBasics)floatingBody, (int)numberOfJoints));
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
            MultiBodySystemBasics systemNominal = MultiBodySystemBasics.clone((MultiBodySystemReadOnly)system, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            MultiBodySystemBasics systemRegressor = MultiBodySystemBasics.clone((MultiBodySystemReadOnly)system, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)system.getAllJoints());
                MultiBodySystemTools.copyJointsState((List)system.getAllJoints(), (List)systemNominal.getAllJoints(), (JointStateType)type);
                MultiBodySystemTools.copyJointsState((List)system.getAllJoints(), (List)systemRegressor.getAllJoints(), (JointStateType)type);
            }
            InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
            inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
            inverseDynamicsCalculator.compute();
            DMatrixRMaj expectedTau = inverseDynamicsCalculator.getJointTauMatrix();
            int nBodiesToProcessWithRegressor = numberOfJoints / 2;
            ArrayList<Integer> jointIndices = new ArrayList<Integer>();
            RigidBodyBasics[] bodies = new RigidBodyBasics[nBodiesToProcessWithRegressor];
            int j = 0;
            while (j < nBodiesToProcessWithRegressor) {
                int jointIndex = random.nextInt(numberOfJoints);
                if (jointIndices.contains(jointIndex)) continue;
                jointIndices.add(jointIndex);
                ((JointBasics)systemNominal.getAllJoints().get(jointIndex)).getSuccessor().getInertia().setToZero();
                bodies[j] = ((JointBasics)systemRegressor.getAllJoints().get(jointIndex)).getSuccessor();
                ++j;
            }
            InverseDynamicsCalculator inverseDynamicsCalculatorNominal = new InverseDynamicsCalculator((MultiBodySystemReadOnly)systemNominal);
            inverseDynamicsCalculatorNominal.setGravitationalAcceleration(-9.81);
            inverseDynamicsCalculatorNominal.compute();
            DMatrixRMaj nominalTau = inverseDynamicsCalculatorNominal.getJointTauMatrix();
            JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(systemRegressor);
            regressorCalculator.setGravitationalAcceleration(-9.81);
            regressorCalculator.compute((RigidBodyReadOnly[])bodies);
            int nDoFs = MultiBodySystemTools.computeDegreesOfFreedom((List)system.getAllJoints());
            DMatrixRMaj actualJointTau = new DMatrixRMaj(nDoFs, 1);
            actualJointTau.set((DMatrixD1)nominalTau);
            for (int k = 0; k < nBodiesToProcessWithRegressor; ++k) {
                DMatrixRMaj regressorBlock = regressorCalculator.getJointTorqueRegressorMatrixBlock((RigidBodyReadOnly)bodies[k]);
                DMatrixRMaj parameterSlice = regressorCalculator.getParameterVectorSlice((RigidBodyReadOnly)bodies[k]);
                DMatrixRMaj regressorTau = new DMatrixRMaj(nDoFs, 1);
                CommonOps_DDRM.mult((DMatrix1Row)regressorBlock, (DMatrix1Row)parameterSlice, (DMatrix1Row)regressorTau);
                CommonOps_DDRM.addEquals((DMatrixD1)actualJointTau, (DMatrixD1)regressorTau);
            }
            Assertions.assertEquals((int)expectedTau.getData().length, (int)actualJointTau.getData().length);
            Assertions.assertArrayEquals((double[])expectedTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
        }
    }

    @Test
    public void benchmarkMixOfInverseDynamicsAndBodywiseRegressorForFloatingOneDoFJointTree() {
        Random random = new Random(25L);
        ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
        RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
        RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
        int numberOfJoints = 30;
        joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (RigidBodyBasics)floatingBody, (int)numberOfJoints));
        MultiBodySystemBasics systemNominal = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
        MultiBodySystemBasics systemRegressor = MultiBodySystemBasics.clone((MultiBodySystemReadOnly)systemNominal, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)systemNominal);
        inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
        JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(systemRegressor);
        regressorCalculator.setGravitationalAcceleration(-9.81);
        int nBodiesToProcessWithRegressor = numberOfJoints / 2;
        ArrayList<Integer> jointIndices = new ArrayList<Integer>();
        RigidBodyBasics[] bodies = new RigidBodyBasics[nBodiesToProcessWithRegressor];
        int i = 0;
        while (i < nBodiesToProcessWithRegressor) {
            int jointIndex = random.nextInt(numberOfJoints);
            if (jointIndices.contains(jointIndex)) continue;
            jointIndices.add(jointIndex);
            ((JointBasics)systemNominal.getAllJoints().get(jointIndex)).getSuccessor().getInertia().setToZero();
            bodies[i] = ((JointBasics)systemRegressor.getAllJoints().get(jointIndex)).getSuccessor();
            ++i;
        }
        long totalTime = 0L;
        for (int j = 0; j < 100; ++j) {
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)systemNominal.getAllJoints());
                MultiBodySystemTools.copyJointsState((List)systemNominal.getAllJoints(), (List)systemRegressor.getAllJoints(), (JointStateType)type);
            }
            inverseDynamicsCalculator.compute();
            regressorCalculator.compute((RigidBodyReadOnly[])bodies);
        }
        for (int k = 0; k < 1000; ++k) {
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)systemNominal.getAllJoints());
                MultiBodySystemTools.copyJointsState((List)systemNominal.getAllJoints(), (List)systemRegressor.getAllJoints(), (JointStateType)type);
            }
            long startTime = System.nanoTime();
            inverseDynamicsCalculator.compute();
            regressorCalculator.compute((RigidBodyReadOnly[])bodies);
            totalTime += System.nanoTime() - startTime;
        }
        LogTools.info((String)("Floating 1-DoF tree: Took on average per iteration: " + (double)totalTime / 1.0E9 / 1000.0 + " seconds"));
    }

    @Test
    public void testMixOfInverseDynamicsAndParameterwiseRegressorSimple() {
        Random random = new Random(9823L);
        int numberOfJoints = 3;
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
        MultiBodySystemBasics systemNominal = MultiBodySystemBasics.clone((MultiBodySystemReadOnly)system, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        MultiBodySystemBasics systemRegressor = MultiBodySystemBasics.clone((MultiBodySystemReadOnly)system, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        for (JointStateType type : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)system.getAllJoints());
            MultiBodySystemTools.copyJointsState((List)system.getAllJoints(), (List)systemNominal.getAllJoints(), (JointStateType)type);
            MultiBodySystemTools.copyJointsState((List)system.getAllJoints(), (List)systemRegressor.getAllJoints(), (JointStateType)type);
        }
        int jointIndexToModify = 1;
        JointTorqueRegressorCalculatorTest.compareMixedIDAndParameterwiseRegressor(system, systemNominal, systemRegressor, List.of(Integer.valueOf(jointIndexToModify)), List.of(Arrays.asList(JointTorqueRegressorCalculator.SpatialInertiaBasisOption.values)));
    }

    @Test
    public void testMixOfInverseDynamicsAndParameterwiseRegressor() {
        Random random = new Random(45376L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = random.nextInt(30) + 1;
            ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
            RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
            joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
            RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
            joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (RigidBodyBasics)floatingBody, (int)numberOfJoints));
            MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
            MultiBodySystemBasics systemNominal = MultiBodySystemBasics.clone((MultiBodySystemReadOnly)system, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            MultiBodySystemBasics systemRegressor = MultiBodySystemBasics.clone((MultiBodySystemReadOnly)system, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)system.getAllJoints());
                MultiBodySystemTools.copyJointsState((List)system.getAllJoints(), (List)systemNominal.getAllJoints(), (JointStateType)type);
                MultiBodySystemTools.copyJointsState((List)system.getAllJoints(), (List)systemRegressor.getAllJoints(), (JointStateType)type);
            }
            int nParametersToProcessWithRegressor = numberOfJoints * 10 / 20;
            ArrayList<Integer> jointIndices = new ArrayList<Integer>();
            ArrayList<List<JointTorqueRegressorCalculator.SpatialInertiaBasisOption>> listOfBasesPerBody = new ArrayList<List<JointTorqueRegressorCalculator.SpatialInertiaBasisOption>>();
            int j = 0;
            while (j < nParametersToProcessWithRegressor) {
                int jointIndex = random.nextInt(numberOfJoints);
                if (jointIndices.contains(jointIndex)) continue;
                jointIndices.add(jointIndex);
                List bases = JointTorqueRegressorCalculator.SpatialInertiaBasisOption.generateRandomBases((Random)random);
                listOfBasesPerBody.add(bases);
                j += bases.size();
            }
            JointTorqueRegressorCalculatorTest.compareMixedIDAndParameterwiseRegressor(system, systemNominal, systemRegressor, jointIndices, listOfBasesPerBody);
        }
    }

    @Test
    public void benchmarkMixOfInverseDynamicsAndParameterwiseRegressorForFloatingOneDoFJointTree() {
        int i;
        Random random = new Random(25L);
        ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
        RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
        RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
        int numberOfJoints = 30;
        joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (RigidBodyBasics)floatingBody, (int)numberOfJoints));
        MultiBodySystemBasics systemNominal = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
        MultiBodySystemBasics systemRegressor = MultiBodySystemBasics.clone((MultiBodySystemReadOnly)systemNominal, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)systemNominal);
        inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
        JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(systemRegressor);
        regressorCalculator.setGravitationalAcceleration(-9.81);
        int nParametersToProcessWithRegressor = numberOfJoints * 10 / 20;
        ArrayList<Integer> jointIndices = new ArrayList<Integer>();
        ArrayList<Object> listOfBasesPerBody = new ArrayList<Object>();
        int j = 0;
        while (j < nParametersToProcessWithRegressor) {
            int jointIndex = random.nextInt(numberOfJoints);
            if (jointIndices.contains(jointIndex)) continue;
            jointIndices.add(jointIndex);
            List bases = JointTorqueRegressorCalculator.SpatialInertiaBasisOption.generateRandomBases((Random)random);
            listOfBasesPerBody.add(bases);
            Iterator iterator = bases.iterator();
            while (iterator.hasNext()) {
                JointTorqueRegressorCalculator.SpatialInertiaBasisOption basis = (JointTorqueRegressorCalculator.SpatialInertiaBasisOption)iterator.next();
                JointTorqueRegressorCalculatorTest.zeroSpatialInertiaComponents(((JointBasics)systemNominal.getAllJoints().get(jointIndex)).getSuccessor(), basis);
            }
            j += bases.size();
        }
        ArrayList<JointTorqueRegressorCalculator.SpatialInertiaBasisOption[]> basesPerBodyArrays = new ArrayList<JointTorqueRegressorCalculator.SpatialInertiaBasisOption[]>();
        for (List list : listOfBasesPerBody) {
            basesPerBodyArrays.add(list.toArray(new JointTorqueRegressorCalculator.SpatialInertiaBasisOption[0]));
        }
        long totalTime = 0L;
        for (i = 0; i < 100; ++i) {
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)systemNominal.getAllJoints());
                MultiBodySystemTools.copyJointsState((List)systemNominal.getAllJoints(), (List)systemRegressor.getAllJoints(), (JointStateType)type);
            }
            inverseDynamicsCalculator.compute();
            for (int k = 0; k < jointIndices.size(); ++k) {
                RigidBodyBasics bodyToZeroRegressor = ((JointBasics)systemRegressor.getAllJoints().get((Integer)jointIndices.get(k))).getSuccessor();
                regressorCalculator.compute((RigidBodyReadOnly)bodyToZeroRegressor, (JointTorqueRegressorCalculator.SpatialInertiaBasisOption[])basesPerBodyArrays.get(k));
            }
        }
        for (i = 0; i < 1000; ++i) {
            for (JointStateType type : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)type, (Iterable)systemNominal.getAllJoints());
                MultiBodySystemTools.copyJointsState((List)systemNominal.getAllJoints(), (List)systemRegressor.getAllJoints(), (JointStateType)type);
            }
            long startTime = System.nanoTime();
            inverseDynamicsCalculator.compute();
            for (int k = 0; k < jointIndices.size(); ++k) {
                RigidBodyBasics bodyToZeroRegressor = ((JointBasics)systemRegressor.getAllJoints().get((Integer)jointIndices.get(k))).getSuccessor();
                regressorCalculator.compute((RigidBodyReadOnly)bodyToZeroRegressor, (JointTorqueRegressorCalculator.SpatialInertiaBasisOption[])basesPerBodyArrays.get(k));
            }
            totalTime += System.nanoTime() - startTime;
        }
        LogTools.info((String)("Floating 1-DoF tree: Took on average per iteration: " + (double)totalTime / 1.0E9 / 1000.0 + " seconds"));
    }

    private static void compareMixedIDAndParameterwiseRegressor(MultiBodySystemBasics system, MultiBodySystemBasics systemNominal, MultiBodySystemBasics systemRegressor, List<Integer> jointIndicesList, List<List<JointTorqueRegressorCalculator.SpatialInertiaBasisOption>> listOfBasesList) {
        if (jointIndicesList.size() != listOfBasesList.size()) {
            throw new IllegalArgumentException("jointIndicesList and basesList must have the same size");
        }
        InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)system);
        inverseDynamicsCalculator.setGravitationalAcceleration(-9.81);
        inverseDynamicsCalculator.compute();
        DMatrixRMaj expectedTau = inverseDynamicsCalculator.getJointTauMatrix();
        ArrayList<RigidBodyBasics> groundTruthBodies = new ArrayList<RigidBodyBasics>();
        for (int i = 0; i < jointIndicesList.size(); ++i) {
            groundTruthBodies.add(((JointBasics)system.getAllJoints().get(jointIndicesList.get(i))).getSuccessor());
            RigidBodyBasics bodyToModifyNominal = ((JointBasics)systemNominal.getAllJoints().get(jointIndicesList.get(i))).getSuccessor();
            List<JointTorqueRegressorCalculator.SpatialInertiaBasisOption> basesList = listOfBasesList.get(i);
            for (JointTorqueRegressorCalculator.SpatialInertiaBasisOption basis : basesList) {
                JointTorqueRegressorCalculatorTest.zeroSpatialInertiaComponents(bodyToModifyNominal, basis);
            }
        }
        InverseDynamicsCalculator inverseDynamicsCalculatorNominal = new InverseDynamicsCalculator((MultiBodySystemReadOnly)systemNominal);
        inverseDynamicsCalculatorNominal.setGravitationalAcceleration(-9.81);
        inverseDynamicsCalculatorNominal.compute();
        DMatrixRMaj nominalTau = inverseDynamicsCalculatorNominal.getJointTauMatrix();
        JointTorqueRegressorCalculator regressorCalculator = new JointTorqueRegressorCalculator(systemRegressor);
        regressorCalculator.setGravitationalAcceleration(-9.81);
        int nDoFs = MultiBodySystemTools.computeDegreesOfFreedom((List)system.getAllJoints());
        DMatrixRMaj actualJointTau = new DMatrixRMaj(nDoFs, 1);
        actualJointTau.set((DMatrixD1)nominalTau);
        for (int i = 0; i < jointIndicesList.size(); ++i) {
            RigidBodyBasics bodyToModifyRegressor = ((JointBasics)systemRegressor.getAllJoints().get(jointIndicesList.get(i))).getSuccessor();
            List<JointTorqueRegressorCalculator.SpatialInertiaBasisOption> basisList = listOfBasesList.get(i);
            regressorCalculator.compute((RigidBodyReadOnly)bodyToModifyRegressor, basisList.toArray(new JointTorqueRegressorCalculator.SpatialInertiaBasisOption[0]));
            for (JointTorqueRegressorCalculator.SpatialInertiaBasisOption basis : basisList) {
                DMatrixRMaj regressorSlice = regressorCalculator.getJointTorqueRegressorMatrixSlice((RigidBodyReadOnly)bodyToModifyRegressor, basis);
                double parameter = JointTorqueRegressorCalculatorTest.getGroundTruthParameter((RigidBodyReadOnly)groundTruthBodies.get(i), basis);
                DMatrixRMaj regressorTau = new DMatrixRMaj(nDoFs, 1);
                CommonOps_DDRM.scale((double)parameter, (DMatrixD1)regressorSlice, (DMatrixD1)regressorTau);
                CommonOps_DDRM.addEquals((DMatrixD1)actualJointTau, (DMatrixD1)regressorTau);
            }
        }
        Assertions.assertEquals((int)expectedTau.getData().length, (int)actualJointTau.getData().length);
        Assertions.assertArrayEquals((double[])expectedTau.getData(), (double[])actualJointTau.getData(), (double)1.0E-12);
    }

    private static void zeroSpatialInertiaComponents(RigidBodyBasics body, JointTorqueRegressorCalculator.SpatialInertiaBasisOption basis) {
        switch (basis) {
            case M: {
                body.getInertia().setMass(0.0);
                break;
            }
            case MCOM_X: {
                body.getInertia().getCenterOfMassOffset().setX(0.0);
                break;
            }
            case MCOM_Y: {
                body.getInertia().getCenterOfMassOffset().setY(0.0);
                break;
            }
            case MCOM_Z: {
                body.getInertia().getCenterOfMassOffset().setZ(0.0);
                break;
            }
            case I_XX: {
                body.getInertia().getMomentOfInertia().setM00(0.0);
                break;
            }
            case I_XY: {
                body.getInertia().getMomentOfInertia().setM01(0.0);
                body.getInertia().getMomentOfInertia().setM10(0.0);
                break;
            }
            case I_YY: {
                body.getInertia().getMomentOfInertia().setM11(0.0);
                break;
            }
            case I_XZ: {
                body.getInertia().getMomentOfInertia().setM02(0.0);
                body.getInertia().getMomentOfInertia().setM20(0.0);
                break;
            }
            case I_YZ: {
                body.getInertia().getMomentOfInertia().setM12(0.0);
                body.getInertia().getMomentOfInertia().setM21(0.0);
                break;
            }
            case I_ZZ: {
                body.getInertia().getMomentOfInertia().setM22(0.0);
            }
        }
    }

    private static double getGroundTruthParameter(RigidBodyReadOnly bodyGroundTruth, JointTorqueRegressorCalculator.SpatialInertiaBasisOption basis) {
        double parameter = 0.0;
        switch (basis) {
            case M: {
                parameter = bodyGroundTruth.getInertia().getMass();
                break;
            }
            case MCOM_X: {
                parameter = bodyGroundTruth.getInertia().getCenterOfMassOffset().getX();
                break;
            }
            case MCOM_Y: {
                parameter = bodyGroundTruth.getInertia().getCenterOfMassOffset().getY();
                break;
            }
            case MCOM_Z: {
                parameter = bodyGroundTruth.getInertia().getCenterOfMassOffset().getZ();
                break;
            }
            case I_XX: {
                parameter = bodyGroundTruth.getInertia().getMomentOfInertia().getM00();
                break;
            }
            case I_XY: {
                parameter = bodyGroundTruth.getInertia().getMomentOfInertia().getM01();
                break;
            }
            case I_YY: {
                parameter = bodyGroundTruth.getInertia().getMomentOfInertia().getM11();
                break;
            }
            case I_XZ: {
                parameter = bodyGroundTruth.getInertia().getMomentOfInertia().getM02();
                break;
            }
            case I_YZ: {
                parameter = bodyGroundTruth.getInertia().getMomentOfInertia().getM12();
                break;
            }
            case I_ZZ: {
                parameter = bodyGroundTruth.getInertia().getMomentOfInertia().getM22();
            }
        }
        return parameter;
    }

    @Test
    public void testSpatialInertiaParameterBasis() {
        DMatrixRMaj expectedBasis = new DMatrixRMaj(6, 6);
        DMatrixRMaj actualBasis = new DMatrixRMaj(6, 6);
        int numberOfJoints = 1;
        Random random = new Random(25L);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        MultiBodySystemBasics system = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
        RigidBodyBasics body = system.findRigidBody("Body0");
        JointTorqueRegressorCalculator.SpatialInertiaParameterBasis basis = new JointTorqueRegressorCalculator.SpatialInertiaParameterBasis(body);
        block12: for (JointTorqueRegressorCalculator.SpatialInertiaBasisOption basisOption : JointTorqueRegressorCalculator.SpatialInertiaBasisOption.values) {
            switch (basisOption) {
                case M: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case MCOM_X: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, -1.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, -1.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case MCOM_Y: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, -1.0, 0.0, 0.0}, {0.0, 0.0, -1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case MCOM_Z: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, -1.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {-1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case I_XX: {
                    double[][] expectedBasisToPack = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case I_YY: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case I_ZZ: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case I_XY: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case I_XZ: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                    continue block12;
                }
                case I_YZ: {
                    double[][] expectedBasisToPack = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                    expectedBasis.set((double[][])expectedBasisToPack);
                    basis.setBasis(basisOption);
                    basis.get((DMatrix)actualBasis);
                    Assertions.assertArrayEquals((double[])expectedBasis.getData(), (double[])actualBasis.getData(), (double)1.0E-12);
                }
            }
        }
    }
}

