/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.CentroidalMomentumRateCalculator;
import us.ihmc.mecano.algorithms.CompositeRigidBodyMassMatrixCalculator;
import us.ihmc.mecano.algorithms.InverseDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class CompositeRigidBodyMassMatrixCalculatorTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testCentroidalMomentumPart() {
        CompositeRigidBodyMassMatrixCalculator compositeRigidBodyMassMatrixCalculator;
        CentroidalMomentumRateCalculator centroidalMomentumRateCalculator;
        MultiBodySystemReadOnly input;
        ReferenceFrame matrixFrame;
        List joints;
        int numberOfJoints;
        int i;
        Random random = new Random(2342L);
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            matrixFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            input = MultiBodySystemReadOnly.toMultiBodySystemInput((List)joints);
            centroidalMomentumRateCalculator = new CentroidalMomentumRateCalculator(input, matrixFrame);
            compositeRigidBodyMassMatrixCalculator = new CompositeRigidBodyMassMatrixCalculator(input, matrixFrame);
            Assertions.assertTrue((boolean)MatrixFeatures_DDRM.isEquals((DMatrixD1)centroidalMomentumRateCalculator.getCentroidalMomentumMatrix(), (DMatrixD1)compositeRigidBodyMassMatrixCalculator.getCentroidalMomentumMatrix(), (double)1.0E-12));
            MecanoTestTools.assertSpatialForceEquals((SpatialForceReadOnly)centroidalMomentumRateCalculator.getBiasSpatialForce(), (SpatialForceReadOnly)compositeRigidBodyMassMatrixCalculator.getCentroidalConvectiveTerm(), (double)1.0E-12);
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            centroidalMomentumRateCalculator.reset();
            compositeRigidBodyMassMatrixCalculator.reset();
            Assertions.assertTrue((boolean)MatrixFeatures_DDRM.isEquals((DMatrixD1)centroidalMomentumRateCalculator.getCentroidalMomentumMatrix(), (DMatrixD1)compositeRigidBodyMassMatrixCalculator.getCentroidalMomentumMatrix(), (double)1.0E-12));
            MecanoTestTools.assertSpatialForceEquals((SpatialForceReadOnly)centroidalMomentumRateCalculator.getBiasSpatialForce(), (SpatialForceReadOnly)compositeRigidBodyMassMatrixCalculator.getCentroidalConvectiveTerm(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            matrixFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            input = MultiBodySystemReadOnly.toMultiBodySystemInput((List)joints);
            centroidalMomentumRateCalculator = new CentroidalMomentumRateCalculator(input, matrixFrame);
            compositeRigidBodyMassMatrixCalculator = new CompositeRigidBodyMassMatrixCalculator(input);
            compositeRigidBodyMassMatrixCalculator.setCentroidalMomentumFrame(matrixFrame);
            Assertions.assertTrue((boolean)MatrixFeatures_DDRM.isEquals((DMatrixD1)centroidalMomentumRateCalculator.getCentroidalMomentumMatrix(), (DMatrixD1)compositeRigidBodyMassMatrixCalculator.getCentroidalMomentumMatrix(), (double)1.0E-12));
            MecanoTestTools.assertSpatialForceEquals((SpatialForceReadOnly)centroidalMomentumRateCalculator.getBiasSpatialForce(), (SpatialForceReadOnly)compositeRigidBodyMassMatrixCalculator.getCentroidalConvectiveTerm(), (double)1.0E-12);
        }
    }

    @Test
    public void testCoriolisMatrix() {
        DMatrixRMaj expectedJointTaus;
        InverseDynamicsCalculator inverseDynamicsCalculator;
        DMatrixRMaj actualJointTaus;
        DMatrixRMaj jointVelocities;
        CompositeRigidBodyMassMatrixCalculator massMatrixCalculator;
        MultiBodySystemBasics input;
        List joints;
        int numberOfJoints;
        int i;
        Random random = new Random(547467L);
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(20) + 1;
            joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            input = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            input.getRootBody().updateFramesRecursively();
            massMatrixCalculator = new CompositeRigidBodyMassMatrixCalculator((MultiBodySystemReadOnly)input);
            massMatrixCalculator.setEnableCoriolisMatrixCalculation(true);
            jointVelocities = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((List)joints), 1);
            MultiBodySystemTools.extractJointsState((List)joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
            actualJointTaus = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((List)joints), 1);
            CommonOps_DDRM.mult((DMatrix1Row)massMatrixCalculator.getCoriolisMatrix(), (DMatrix1Row)jointVelocities, (DMatrix1Row)actualJointTaus);
            inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)input);
            inverseDynamicsCalculator.setConsiderJointAccelerations(false);
            inverseDynamicsCalculator.compute();
            expectedJointTaus = inverseDynamicsCalculator.getJointTauMatrix();
            MecanoTestTools.assertDMatrixEquals((String)("Iteration " + i), (DMatrix)expectedJointTaus, (DMatrix)actualJointTaus, (double)1.0E-11);
        }
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(20) + 1;
            joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            input = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            input.getRootBody().updateFramesRecursively();
            massMatrixCalculator = new CompositeRigidBodyMassMatrixCalculator((MultiBodySystemReadOnly)input);
            massMatrixCalculator.setEnableCoriolisMatrixCalculation(true);
            jointVelocities = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((List)joints), 1);
            MultiBodySystemTools.extractJointsState((List)joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
            actualJointTaus = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((List)joints), 1);
            CommonOps_DDRM.mult((DMatrix1Row)massMatrixCalculator.getCoriolisMatrix(), (DMatrix1Row)jointVelocities, (DMatrix1Row)actualJointTaus);
            inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)input);
            inverseDynamicsCalculator.setConsiderJointAccelerations(false);
            inverseDynamicsCalculator.compute();
            expectedJointTaus = inverseDynamicsCalculator.getJointTauMatrix();
            MecanoTestTools.assertDMatrixEquals((String)("Iteration " + i), (DMatrix)expectedJointTaus, (DMatrix)actualJointTaus, (double)1.0E-11);
        }
    }

    @Test
    public void testModifiedRigidBodyParameters() {
        Random random = new Random(3249875L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = random.nextInt(20) + 1;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            RigidBodyBasics rootBody = ((JointBasics)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            CompositeRigidBodyMassMatrixCalculator massMatrixCalculator = new CompositeRigidBodyMassMatrixCalculator((RigidBodyReadOnly)rootBody);
            massMatrixCalculator.setEnableCoriolisMatrixCalculation(true);
            DMatrixRMaj jointVelocities = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((List)joints), 1);
            MultiBodySystemTools.extractJointsState((List)joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
            DMatrixRMaj actualJointTaus = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((List)joints), 1);
            CommonOps_DDRM.mult((DMatrix1Row)massMatrixCalculator.getCoriolisMatrix(), (DMatrix1Row)jointVelocities, (DMatrix1Row)actualJointTaus);
            InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((RigidBodyReadOnly)rootBody);
            inverseDynamicsCalculator.setConsiderJointAccelerations(false);
            inverseDynamicsCalculator.compute();
            DMatrixRMaj expectedJointTaus = inverseDynamicsCalculator.getJointTauMatrix();
            MecanoTestTools.assertDMatrixEquals((String)("Iteration " + i), (DMatrix)expectedJointTaus, (DMatrix)actualJointTaus, (double)1.0E-11);
            RigidBodyBasics body = ((JointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            body.getInertia().set((SpatialInertiaReadOnly)MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)body.getInertia().getBodyFrame(), (ReferenceFrame)body.getInertia().getReferenceFrame()));
            massMatrixCalculator.reset();
            actualJointTaus = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((List)joints), 1);
            CommonOps_DDRM.mult((DMatrix1Row)massMatrixCalculator.getCoriolisMatrix(), (DMatrix1Row)jointVelocities, (DMatrix1Row)actualJointTaus);
            inverseDynamicsCalculator.compute();
            expectedJointTaus = inverseDynamicsCalculator.getJointTauMatrix();
            MecanoTestTools.assertDMatrixEquals((String)("Iteration " + i), (DMatrix)expectedJointTaus, (DMatrix)actualJointTaus, (double)1.0E-11);
        }
    }

    @Test
    @Disabled
    public void testBenchmarkCoriolisMatrix() {
        Random random = new Random(547467L);
        for (int i = 0; i < 5000; ++i) {
            int numberOfJoints = random.nextInt(100) + 1;
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            MultiBodySystemBasics input = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            input.getRootBody().updateFramesRecursively();
            CompositeRigidBodyMassMatrixCalculator massMatrixCalculator = new CompositeRigidBodyMassMatrixCalculator((MultiBodySystemReadOnly)input);
            massMatrixCalculator.setEnableCoriolisMatrixCalculation(true);
            massMatrixCalculator.getCoriolisMatrix();
        }
        long totalTimeNoCoriolis = 0L;
        long totalTimeCoriolis = 0L;
        int benchmarkIterations = 50000;
        for (int i = 0; i < benchmarkIterations; ++i) {
            int numberOfJoints = random.nextInt(100) + 1;
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            MultiBodySystemBasics input = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            input.getRootBody().updateFramesRecursively();
            CompositeRigidBodyMassMatrixCalculator massMatrixCalculator = new CompositeRigidBodyMassMatrixCalculator((MultiBodySystemReadOnly)input);
            long start = System.nanoTime();
            massMatrixCalculator.getMassMatrix();
            totalTimeNoCoriolis += System.nanoTime() - start;
            input.getRootBody().updateFramesRecursively();
            massMatrixCalculator = new CompositeRigidBodyMassMatrixCalculator((MultiBodySystemReadOnly)input);
            massMatrixCalculator.setEnableCoriolisMatrixCalculation(true);
            start = System.nanoTime();
            massMatrixCalculator.getCoriolisMatrix();
            totalTimeCoriolis += System.nanoTime() - start;
        }
        LogTools.info((String)("Time w/o  Coriolis: avg: " + (double)totalTimeNoCoriolis / 1000.0 / (double)benchmarkIterations + "microsec."));
        LogTools.info((String)("Time with Coriolis: avg: " + (double)totalTimeCoriolis / 1000.0 / (double)benchmarkIterations + "microsec."));
    }
}

