/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.mecano.algorithms.CenterOfMassCalculator;
import us.ihmc.mecano.algorithms.CenterOfMassJacobian;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class CenterOfMassJacobianTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int ITERATIONS = 500;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testOneDoFJointChain() {
        CenterOfMassCalculator centerOfMassCalculator;
        CenterOfMassJacobian centerOfMassJacobian;
        RigidBodyBasics rootBody;
        List joints;
        int numberOfJoints;
        int i;
        Random random = new Random(34532L);
        for (i = 0; i < 500; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody = ((OneDoFJoint)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, worldFrame);
            centerOfMassCalculator = new CenterOfMassCalculator((RigidBodyReadOnly)rootBody, worldFrame);
            Assertions.assertEquals((double)centerOfMassCalculator.getTotalMass(), (double)centerOfMassJacobian.getTotalMass(), (double)1.0E-12);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)centerOfMassCalculator.getCenterOfMass(), (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMass(), (double)1.0E-12);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)this.computeCenterOfMassVelocity((RigidBodyReadOnly)rootBody, centerOfMassJacobian.getReferenceFrame()), (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMassVelocity(), (double)1.0E-12);
        }
        for (i = 0; i < 500; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody = ((OneDoFJoint)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, "centerOfMassFrame");
            centerOfMassCalculator = new CenterOfMassCalculator((RigidBodyReadOnly)rootBody, worldFrame);
            Assertions.assertEquals((double)centerOfMassCalculator.getTotalMass(), (double)centerOfMassJacobian.getTotalMass(), (double)1.0E-12);
            FramePoint3D centerOfMass = new FramePoint3D((FrameTuple3DReadOnly)centerOfMassJacobian.getCenterOfMass());
            centerOfMass.changeFrame(worldFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)centerOfMassCalculator.getCenterOfMass(), (EuclidFrameGeometry)centerOfMass, (double)1.0E-12);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)this.computeCenterOfMassVelocity((RigidBodyReadOnly)rootBody, centerOfMassJacobian.getReferenceFrame()), (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMassVelocity(), (double)1.0E-12);
        }
    }

    @Test
    public void testJointChain() {
        CenterOfMassCalculator centerOfMassCalculator;
        CenterOfMassJacobian centerOfMassJacobian;
        RigidBodyBasics rootBody;
        List joints;
        int numberOfJoints;
        int i;
        Random random = new Random(342532L);
        for (i = 0; i < 500; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody = ((JointBasics)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, worldFrame);
            centerOfMassCalculator = new CenterOfMassCalculator((RigidBodyReadOnly)rootBody, worldFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)centerOfMassCalculator.getCenterOfMass(), (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMass(), (double)1.0E-12);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)this.computeCenterOfMassVelocity((RigidBodyReadOnly)rootBody, centerOfMassJacobian.getReferenceFrame()), (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMassVelocity(), (double)1.0E-12);
        }
        for (i = 0; i < 500; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody = ((JointBasics)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, "centerOfMassFrame");
            centerOfMassCalculator = new CenterOfMassCalculator((RigidBodyReadOnly)rootBody, worldFrame);
            Assertions.assertEquals((double)centerOfMassCalculator.getTotalMass(), (double)centerOfMassJacobian.getTotalMass(), (double)1.0E-12);
            FramePoint3D centerOfMass = new FramePoint3D((FrameTuple3DReadOnly)centerOfMassJacobian.getCenterOfMass());
            centerOfMass.changeFrame(worldFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)centerOfMassCalculator.getCenterOfMass(), (EuclidFrameGeometry)centerOfMass, (double)1.0E-12);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)this.computeCenterOfMassVelocity((RigidBodyReadOnly)rootBody, centerOfMassJacobian.getReferenceFrame()), (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMassVelocity(), (double)1.0E-12);
        }
    }

    @Test
    public void testOnDoFJointTree() {
        CenterOfMassCalculator centerOfMassCalculator;
        CenterOfMassJacobian centerOfMassJacobian;
        RigidBodyBasics rootBody;
        List joints;
        int numberOfJoints;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 500; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody = ((OneDoFJoint)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, worldFrame);
            centerOfMassCalculator = new CenterOfMassCalculator((RigidBodyReadOnly)rootBody, worldFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)centerOfMassCalculator.getCenterOfMass(), (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMass(), (double)1.0E-12);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)this.computeCenterOfMassVelocity((RigidBodyReadOnly)rootBody, centerOfMassJacobian.getReferenceFrame()), (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMassVelocity(), (double)1.0E-12);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody.updateFramesRecursively();
            DMatrixRMaj jointVelocities = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((List)joints), 1);
            MultiBodySystemTools.extractJointsState((List)joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
            DMatrixRMaj centerOfMassVelocityMatrix = new DMatrixRMaj(3, 1);
            CommonOps_DDRM.mult((DMatrix1Row)centerOfMassJacobian.getJacobianMatrix(), (DMatrix1Row)jointVelocities, (DMatrix1Row)centerOfMassVelocityMatrix);
            Vector3D actualVelocity = new Vector3D();
            actualVelocity.set((DMatrix)centerOfMassVelocityMatrix);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)this.computeCenterOfMassVelocity((RigidBodyReadOnly)rootBody, centerOfMassJacobian.getReferenceFrame()), (EuclidGeometry)actualVelocity, (double)1.0E-12);
        }
        for (i = 0; i < 500; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody = ((OneDoFJoint)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, "centerOfMassFrame");
            centerOfMassCalculator = new CenterOfMassCalculator((RigidBodyReadOnly)rootBody, worldFrame);
            FramePoint3D centerOfMass = new FramePoint3D((FrameTuple3DReadOnly)centerOfMassJacobian.getCenterOfMass());
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)centerOfMassCalculator.getCenterOfMass(), (EuclidFrameGeometry)centerOfMass, (double)1.0E-12);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)this.computeCenterOfMassVelocity((RigidBodyReadOnly)rootBody, centerOfMassJacobian.getReferenceFrame()), (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMassVelocity(), (double)1.0E-12);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody.updateFramesRecursively();
            DMatrixRMaj jointVelocities = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((List)joints), 1);
            MultiBodySystemTools.extractJointsState((List)joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
            DMatrixRMaj centerOfMassVelocityMatrix = new DMatrixRMaj(3, 1);
            CommonOps_DDRM.mult((DMatrix1Row)centerOfMassJacobian.getJacobianMatrix(), (DMatrix1Row)jointVelocities, (DMatrix1Row)centerOfMassVelocityMatrix);
            Vector3D actualVelocity = new Vector3D();
            actualVelocity.set((DMatrix)centerOfMassVelocityMatrix);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)this.computeCenterOfMassVelocity((RigidBodyReadOnly)rootBody, centerOfMassJacobian.getReferenceFrame()), (EuclidGeometry)actualVelocity, (double)1.0E-12);
        }
    }

    @Test
    public void testModifiedRigidBodyParameters() {
        FrameVector3D expectedCenterOfMassVelocityAfterUpdate;
        RigidBodyBasics body;
        FrameVector3D expectedCenterOfMassVelocityBeforeUpdate;
        FramePoint3D expectedCenterOfMassAfterUpdate;
        RigidBodyBasics body2;
        FramePoint3D expectedCenterOfMassBeforeUpdate;
        CenterOfMassCalculator centerOfMassCalculator;
        CenterOfMassJacobian centerOfMassJacobian;
        RigidBodyBasics rootBody;
        List joints;
        int numberOfJoints;
        int i;
        Random random = new Random(23L);
        for (i = 0; i < 500; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody = ((JointBasics)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, worldFrame);
            centerOfMassCalculator = new CenterOfMassCalculator((RigidBodyReadOnly)rootBody, worldFrame);
            expectedCenterOfMassBeforeUpdate = new FramePoint3D((FrameTuple3DReadOnly)centerOfMassCalculator.getCenterOfMass());
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedCenterOfMassBeforeUpdate, (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMass(), (double)1.0E-12);
            body2 = ((JointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            body2.getInertia().set((SpatialInertiaReadOnly)MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)body2.getInertia().getBodyFrame(), (ReferenceFrame)body2.getInertia().getReferenceFrame()));
            centerOfMassCalculator.reset();
            centerOfMassJacobian.reset();
            expectedCenterOfMassAfterUpdate = new FramePoint3D((FrameTuple3DReadOnly)centerOfMassCalculator.getCenterOfMass());
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedCenterOfMassAfterUpdate, (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMass(), (double)1.0E-12);
        }
        for (i = 0; i < 500; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody = ((JointBasics)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, "centerOfMassFrame");
            centerOfMassCalculator = new CenterOfMassCalculator((RigidBodyReadOnly)rootBody, worldFrame);
            expectedCenterOfMassBeforeUpdate = new FramePoint3D((FrameTuple3DReadOnly)centerOfMassCalculator.getCenterOfMass());
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedCenterOfMassBeforeUpdate, (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMass(), (double)1.0E-12);
            body2 = ((JointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            body2.getInertia().set((SpatialInertiaReadOnly)MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)body2.getInertia().getBodyFrame(), (ReferenceFrame)body2.getInertia().getReferenceFrame()));
            centerOfMassCalculator.reset();
            centerOfMassJacobian.reset();
            expectedCenterOfMassAfterUpdate = new FramePoint3D((FrameTuple3DReadOnly)centerOfMassCalculator.getCenterOfMass());
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedCenterOfMassAfterUpdate, (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMass(), (double)1.0E-12);
        }
        for (i = 0; i < 500; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody = ((JointBasics)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, worldFrame);
            expectedCenterOfMassVelocityBeforeUpdate = new FrameVector3D((FrameTuple3DReadOnly)this.computeCenterOfMassVelocity((RigidBodyReadOnly)rootBody, centerOfMassJacobian.getReferenceFrame()));
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedCenterOfMassVelocityBeforeUpdate, (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMassVelocity(), (double)1.0E-12);
            body = ((JointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            body.getInertia().set((SpatialInertiaReadOnly)MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)body.getInertia().getBodyFrame(), (ReferenceFrame)body.getInertia().getReferenceFrame()));
            centerOfMassJacobian.reset();
            expectedCenterOfMassVelocityAfterUpdate = new FrameVector3D((FrameTuple3DReadOnly)this.computeCenterOfMassVelocity((RigidBodyReadOnly)rootBody, centerOfMassJacobian.getReferenceFrame()));
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedCenterOfMassVelocityAfterUpdate, (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMassVelocity(), (double)1.0E-12);
        }
        for (i = 0; i < 500; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody = ((JointBasics)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, "centerOfMassFrame");
            expectedCenterOfMassVelocityBeforeUpdate = new FrameVector3D((FrameTuple3DReadOnly)this.computeCenterOfMassVelocity((RigidBodyReadOnly)rootBody, centerOfMassJacobian.getReferenceFrame()));
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedCenterOfMassVelocityBeforeUpdate, (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMassVelocity(), (double)1.0E-12);
            body = ((JointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            body.getInertia().set((SpatialInertiaReadOnly)MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)body.getInertia().getBodyFrame(), (ReferenceFrame)body.getInertia().getReferenceFrame()));
            centerOfMassJacobian.reset();
            expectedCenterOfMassVelocityAfterUpdate = new FrameVector3D((FrameTuple3DReadOnly)this.computeCenterOfMassVelocity((RigidBodyReadOnly)rootBody, centerOfMassJacobian.getReferenceFrame()));
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedCenterOfMassVelocityAfterUpdate, (EuclidFrameGeometry)centerOfMassJacobian.getCenterOfMassVelocity(), (double)1.0E-12);
        }
    }

    private FrameVector3D computeCenterOfMassVelocity(RigidBodyReadOnly rootBody, ReferenceFrame referenceFrame) {
        FrameVector3D centerOfMassVelocity = new FrameVector3D(referenceFrame);
        for (RigidBodyReadOnly rigidBody : rootBody.subtreeIterable()) {
            if (rigidBody.getInertia() == null) continue;
            FramePoint3D com = new FramePoint3D((FrameTuple3DReadOnly)rigidBody.getInertia().getCenterOfMassOffset());
            com.changeFrame((ReferenceFrame)rigidBody.getBodyFixedFrame());
            FrameVector3D bodyLinearMomentum = new FrameVector3D();
            rigidBody.getBodyFixedFrame().getTwistOfFrame().getLinearVelocityAt((FramePoint3DReadOnly)com, (FrameVector3DBasics)bodyLinearMomentum);
            bodyLinearMomentum.scale(rigidBody.getInertia().getMass());
            bodyLinearMomentum.changeFrame(referenceFrame);
            centerOfMassVelocity.add((FrameTuple3DReadOnly)bodyLinearMomentum);
        }
        centerOfMassVelocity.scale(1.0 / rootBody.subtreeStream().filter(body -> body.getInertia() != null).mapToDouble(body -> body.getInertia().getMass()).sum());
        return centerOfMassVelocity;
    }
}

