/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.mecano.algorithms.CenterOfMassJacobian;
import us.ihmc.mecano.algorithms.CentroidalMomentumCalculator;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.interfaces.MomentumReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;

public class CentroidalMomentumCalculatorTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int ITERATIONS = 500;
    private static final double EPSILON = 2.0E-10;

    @Test
    public void testMomentumWithOneDoFJointChain() {
        Random random = new Random(360675L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            RigidBodyBasics rootBody = ((OneDoFJoint)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            CentroidalMomentumCalculator centroidalMomentumCalculator = new CentroidalMomentumCalculator((RigidBodyReadOnly)rootBody, worldFrame);
            MomentumReadOnly actualMomentum = centroidalMomentumCalculator.getMomentum();
            Momentum expectedMomentum = CentroidalMomentumCalculatorTest.computeMomentum((RigidBodyReadOnly)rootBody, centroidalMomentumCalculator.getReferenceFrame());
            MecanoTestTools.assertMomentumEquals((MomentumReadOnly)expectedMomentum, (MomentumReadOnly)actualMomentum, (double)2.0E-10);
            FrameVector3DReadOnly actualCenterOfMassVelocity = centroidalMomentumCalculator.getCenterOfMassVelocity();
            CenterOfMassJacobian centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, worldFrame);
            Assertions.assertEquals((double)centerOfMassJacobian.getTotalMass(), (double)centroidalMomentumCalculator.getTotalMass(), (double)2.0E-10);
            FrameVector3DReadOnly expectedCenterOfMassVelocity = centerOfMassJacobian.getCenterOfMassVelocity();
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedCenterOfMassVelocity, (EuclidFrameGeometry)actualCenterOfMassVelocity, (double)2.0E-10);
        }
    }

    @Test
    public void testMomentumWithOneDoFJointTree() {
        Random random = new Random(360675L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            RigidBodyBasics rootBody = ((OneDoFJoint)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            CentroidalMomentumCalculator centroidalMomentumCalculator = new CentroidalMomentumCalculator((RigidBodyReadOnly)rootBody, worldFrame);
            MomentumReadOnly actualMomentum = centroidalMomentumCalculator.getMomentum();
            Momentum expectedMomentum = CentroidalMomentumCalculatorTest.computeMomentum((RigidBodyReadOnly)rootBody, centroidalMomentumCalculator.getReferenceFrame());
            MecanoTestTools.assertMomentumEquals((MomentumReadOnly)expectedMomentum, (MomentumReadOnly)actualMomentum, (double)2.0E-10);
            FrameVector3DReadOnly actualCenterOfMassVelocity = centroidalMomentumCalculator.getCenterOfMassVelocity();
            CenterOfMassJacobian centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, worldFrame);
            Assertions.assertEquals((double)centerOfMassJacobian.getTotalMass(), (double)centroidalMomentumCalculator.getTotalMass(), (double)2.0E-10);
            FrameVector3DReadOnly expectedCenterOfMassVelocity = centerOfMassJacobian.getCenterOfMassVelocity();
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedCenterOfMassVelocity, (EuclidFrameGeometry)actualCenterOfMassVelocity, (double)2.0E-10);
        }
    }

    @Test
    public void testMomentumWithJointChain() {
        Random random = new Random(360675L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            RigidBodyBasics rootBody = ((JointBasics)joints.get(0)).getPredecessor();
            rootBody.updateFramesRecursively();
            CentroidalMomentumCalculator centroidalMomentumCalculator = new CentroidalMomentumCalculator((RigidBodyReadOnly)rootBody, worldFrame);
            MomentumReadOnly actualMomentum = centroidalMomentumCalculator.getMomentum();
            Momentum expectedMomentum = CentroidalMomentumCalculatorTest.computeMomentum((RigidBodyReadOnly)rootBody, centroidalMomentumCalculator.getReferenceFrame());
            MecanoTestTools.assertMomentumEquals((MomentumReadOnly)expectedMomentum, (MomentumReadOnly)actualMomentum, (double)2.0E-10);
            FrameVector3DReadOnly actualCenterOfMassVelocity = centroidalMomentumCalculator.getCenterOfMassVelocity();
            CenterOfMassJacobian centerOfMassJacobian = new CenterOfMassJacobian((RigidBodyReadOnly)rootBody, worldFrame);
            Assertions.assertEquals((double)centerOfMassJacobian.getTotalMass(), (double)centroidalMomentumCalculator.getTotalMass(), (double)2.0E-10);
            FrameVector3DReadOnly expectedCenterOfMassVelocity = centerOfMassJacobian.getCenterOfMassVelocity();
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedCenterOfMassVelocity, (EuclidFrameGeometry)actualCenterOfMassVelocity, (double)2.0E-10);
        }
    }

    public static Momentum computeMomentum(RigidBodyReadOnly rootBody, ReferenceFrame referenceFrame) {
        Momentum momentum = new Momentum(referenceFrame);
        for (RigidBodyReadOnly rigidBody : rootBody.subtreeIterable()) {
            if (rigidBody.getInertia() == null) continue;
            Momentum bodyMomentum = new Momentum((ReferenceFrame)rigidBody.getBodyFixedFrame());
            bodyMomentum.compute(rigidBody.getInertia(), rigidBody.getBodyFixedFrame().getTwistOfFrame());
            bodyMomentum.changeFrame(momentum.getReferenceFrame());
            momentum.add((SpatialVectorReadOnly)bodyMomentum);
        }
        return momentum;
    }
}

