/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionTest;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;

public class SpatialAccelerationTest
extends SpatialMotionTest<SpatialAcceleration> {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Override
    public SpatialAcceleration createSpatialMotionVector(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        return new SpatialAcceleration(bodyFrame, baseFrame, expressedInFrame, angularPart, linearPart);
    }

    @Override
    public SpatialAcceleration createSpatialMotionVector(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, DMatrixRMaj matrix) {
        return new SpatialAcceleration(bodyFrame, baseFrame, expressedInFrame, (DMatrix)matrix);
    }

    @Test
    public void testChangeFrameUsingNumericalDifferentiationVersusAnalytical() {
        double epsilon = 0.001;
        double deltaT = 1.0E-6;
        double[] linearAmplitudes = new double[]{1.0, 2.0, 3.0};
        double[] angularAmplitudes = new double[]{4.0, 5.0, 6.0};
        double[] linearFrequencies = new double[]{1.0, 2.0, 3.0};
        double[] angularFrequencies = new double[]{4.0, 5.0, 6.0};
        Vector3D previousLinearVelocity = new Vector3D();
        Vector3D previousAngularVelocity = new Vector3D();
        double tMax = 1.0;
        for (double t = 0.0; t < tMax; t += deltaT) {
            Vector3D linearVelocity = SpatialAccelerationTest.getSinusoidalVelocity(linearAmplitudes, linearFrequencies, t);
            Vector3D angularVelocity = SpatialAccelerationTest.getSinusoidalVelocity(angularAmplitudes, angularFrequencies, t);
            Vector3D linearAcceleration = SpatialAccelerationTest.getSinusoidalAcceleration(linearAmplitudes, linearFrequencies, t);
            Vector3D angularAcceleration = SpatialAccelerationTest.getSinusoidalAcceleration(angularAmplitudes, angularFrequencies, t);
            Twist twistInB = new Twist(this.frameB, this.frameA, this.frameB, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity);
            Twist twistInA = new Twist((SpatialMotionReadOnly)twistInB);
            twistInA.changeFrame(this.frameA);
            SpatialAcceleration acceleration = new SpatialAcceleration(this.frameB, this.frameA, this.frameB, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration);
            acceleration.changeFrame(this.frameA, (TwistReadOnly)twistInB, (TwistReadOnly)twistInB);
            if (t > deltaT / 2.0) {
                Vector3D linearAccelerationNewFrameNumeric = SpatialAccelerationTest.numericallyDifferentiate((Vector3DReadOnly)previousLinearVelocity, (Vector3DReadOnly)twistInA.getLinearPart(), deltaT);
                Vector3D angularAccelerationNewFrameNumeric = SpatialAccelerationTest.numericallyDifferentiate((Vector3DReadOnly)previousAngularVelocity, (Vector3DReadOnly)twistInA.getAngularPart(), deltaT);
                FixedFrameVector3DBasics linearAccelerationNewFrameAnalytic = acceleration.getLinearPart();
                FixedFrameVector3DBasics angularAccelerationNewFrameAnalytic = acceleration.getAngularPart();
                EuclidCoreTestTools.assertEquals((String)("t = " + t), (EuclidGeometry)linearAccelerationNewFrameNumeric, (EuclidGeometry)linearAccelerationNewFrameAnalytic, (double)epsilon);
                EuclidCoreTestTools.assertEquals((String)("t = " + t), (EuclidGeometry)angularAccelerationNewFrameNumeric, (EuclidGeometry)angularAccelerationNewFrameAnalytic, (double)epsilon);
            }
            previousLinearVelocity.set((Tuple3DReadOnly)twistInA.getLinearPart());
            previousAngularVelocity.set((Tuple3DReadOnly)twistInA.getAngularPart());
        }
    }

    @Test
    public void testGetLinearAccelerationOfPointFixedInBodyFrame() {
        Random random = new Random(1456L);
        SpatialAcceleration accel = new SpatialAcceleration(this.frameB, this.frameA, this.frameA, (Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)new Vector3D());
        Twist twist = new Twist(this.frameB, this.frameA, this.frameA, (Vector3DReadOnly)this.getRandomVector(random), (Vector3DReadOnly)new Vector3D());
        FramePoint3D pointFixedInFrameB = new FramePoint3D(this.frameA, (Tuple3DReadOnly)this.getRandomVector(random));
        FrameVector3D accelerationOfPointFixedInFrameB = new FrameVector3D(ReferenceFrame.getWorldFrame());
        accel.getLinearAccelerationAt((TwistReadOnly)twist, (FramePoint3DReadOnly)pointFixedInFrameB, (FrameVector3DBasics)accelerationOfPointFixedInFrameB);
        Vector3D expected = new Vector3D((Tuple3DReadOnly)pointFixedInFrameB);
        expected.cross((Tuple3DReadOnly)twist.getAngularPart(), (Tuple3DReadOnly)expected);
        expected.cross((Tuple3DReadOnly)twist.getAngularPart(), (Tuple3DReadOnly)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)accelerationOfPointFixedInFrameB, (double)1.0E-7);
    }

    @Test
    public void testGetAccelerationOfPointFixedInBodyFrameComputedInDifferentFrames() throws Exception {
        Random random = new Random(345345L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
            ReferenceFrame baseFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"baseFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            ReferenceFrame bodyFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"bodyFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            Vector3D linearAcceleration = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            Vector3D angularAcceleration = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            SpatialAcceleration spatialAccelerationVector = new SpatialAcceleration(bodyFrame, baseFrame, bodyFrame, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularAcceleration);
            Vector3D linearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            Vector3D angularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            Twist twist = new Twist(bodyFrame, baseFrame, bodyFrame, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity);
            FramePoint3D pointFixedInBodyFrame = new FramePoint3D(bodyFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0));
            FrameVector3D bodyFixedPointLinearAccelerationInBody = new FrameVector3D();
            FrameVector3D bodyFixedPointLinearAccelerationInBase = new FrameVector3D();
            pointFixedInBodyFrame.changeFrame(bodyFrame);
            spatialAccelerationVector.getLinearAccelerationAt((TwistReadOnly)twist, (FramePoint3DReadOnly)pointFixedInBodyFrame, (FrameVector3DBasics)bodyFixedPointLinearAccelerationInBody);
            pointFixedInBodyFrame.changeFrame(baseFrame);
            spatialAccelerationVector.changeFrame(baseFrame, (TwistReadOnly)twist, (TwistReadOnly)twist);
            twist.changeFrame(baseFrame);
            spatialAccelerationVector.getLinearAccelerationAt((TwistReadOnly)twist, (FramePoint3DReadOnly)pointFixedInBodyFrame, (FrameVector3DBasics)bodyFixedPointLinearAccelerationInBase);
            bodyFixedPointLinearAccelerationInBody.changeFrame(baseFrame);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)bodyFixedPointLinearAccelerationInBase, (EuclidGeometry)bodyFixedPointLinearAccelerationInBody, (double)1.0E-12);
        }
    }

    @Test
    public void testAddExpressedInDifferentFrames() {
        Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
            SpatialAcceleration acceleration1 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameC, (Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)new Vector3D());
            SpatialAcceleration acceleration2 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameA, (Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)new Vector3D());
            acceleration1.add((SpatialAccelerationReadOnly)acceleration2);
        });
    }

    @Test
    public void testAddNotRelative() {
        Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
            SpatialAcceleration acceleration1 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameC, (Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)new Vector3D());
            SpatialAcceleration acceleration2 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameC, (Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)new Vector3D());
            acceleration1.add((SpatialAccelerationReadOnly)acceleration2);
        });
    }

    @Test
    public void testAdd() {
        Vector3D angularVelocity1 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Vector3D linearVelocity1 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        SpatialAcceleration spatialMotionVector1 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameD, (Vector3DReadOnly)angularVelocity1, (Vector3DReadOnly)linearVelocity1);
        Vector3D angularVelocity2 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Vector3D linearVelocity2 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        SpatialAcceleration spatialMotionVector2 = this.createSpatialMotionVector(this.frameC, this.frameB, this.frameD, (Vector3DReadOnly)angularVelocity2, (Vector3DReadOnly)linearVelocity2);
        spatialMotionVector1.add((SpatialAccelerationReadOnly)spatialMotionVector2);
        Assertions.assertEquals((Object)this.frameD, (Object)spatialMotionVector1.getReferenceFrame());
        Assertions.assertEquals((Object)this.frameA, (Object)spatialMotionVector1.getBaseFrame());
        Assertions.assertEquals((Object)this.frameC, (Object)spatialMotionVector1.getBodyFrame());
        angularVelocity1.add((Tuple3DReadOnly)angularVelocity2);
        linearVelocity1.add((Tuple3DReadOnly)linearVelocity2);
        double epsilon = 1.0E-14;
        EuclidCoreTestTools.assertEquals((EuclidGeometry)angularVelocity1, (EuclidGeometry)spatialMotionVector1.getAngularPart(), (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)linearVelocity1, (EuclidGeometry)spatialMotionVector1.getLinearPart(), (double)epsilon);
        spatialMotionVector1 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameD, (Vector3DReadOnly)angularVelocity1, (Vector3DReadOnly)linearVelocity1);
        spatialMotionVector2 = this.createSpatialMotionVector(this.frameC, this.frameB, this.frameD, (Vector3DReadOnly)angularVelocity2, (Vector3DReadOnly)linearVelocity2);
        try {
            spatialMotionVector2.add((SpatialAccelerationReadOnly)spatialMotionVector1);
            throw new RuntimeException("Should not be able to add in this direction");
        }
        catch (Exception exception) {
            spatialMotionVector1 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameD, (Vector3DReadOnly)angularVelocity1, (Vector3DReadOnly)linearVelocity1);
            try {
                spatialMotionVector1.add((SpatialAccelerationReadOnly)spatialMotionVector1);
                throw new RuntimeException("Should not be able to add in this direction");
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    @Test
    public void testSub() {
        Random random = new Random(3454L);
        SpatialAcceleration vector1 = new SpatialAcceleration(this.frameB, this.frameA, this.frameD, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        SpatialAcceleration vector2 = new SpatialAcceleration(this.frameC, this.frameB, this.frameD, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        SpatialAcceleration vector3 = new SpatialAcceleration((SpatialMotionReadOnly)vector1);
        vector3.add((SpatialAccelerationReadOnly)vector2);
        double epsilon = 1.0E-15;
        SpatialAcceleration vector2Back = new SpatialAcceleration((SpatialMotionReadOnly)vector3);
        vector2Back.sub((SpatialAccelerationReadOnly)vector1);
        MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)vector2, (SpatialAccelerationReadOnly)vector2Back, (double)epsilon);
        SpatialAcceleration vector1Back = new SpatialAcceleration((SpatialMotionReadOnly)vector3);
        vector1Back.sub((SpatialAccelerationReadOnly)vector2);
        MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)vector1, (SpatialAccelerationReadOnly)vector1Back, (double)epsilon);
    }

    @Test
    public void testSubWrongExpressedInFrame() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            SpatialAcceleration vector1 = new SpatialAcceleration(this.frameB, this.frameA, this.frameD);
            SpatialAcceleration vector2 = new SpatialAcceleration(this.frameB, this.frameC, this.frameC);
            vector1.sub((SpatialAccelerationReadOnly)vector2);
        });
    }

    @Test
    public void testSubFramesDontMatchUp() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            SpatialAcceleration vector1 = new SpatialAcceleration(this.frameD, this.frameA, this.frameC);
            SpatialAcceleration vector2 = new SpatialAcceleration(this.frameB, this.frameC, this.frameC);
            vector1.sub((SpatialAccelerationReadOnly)vector2);
        });
    }

    @Test
    public void testSetBasedOnOriginAcceleration() {
        SpatialAcceleration acceleration = new SpatialAcceleration(this.frameA, this.frameB, this.frameA);
        Twist twistOfBodyWithRespectToBase = new Twist(this.frameA, this.frameB, this.frameA, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)this.random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)this.random));
        FrameVector3D angularAcceleration = new FrameVector3D(twistOfBodyWithRespectToBase.getReferenceFrame(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)this.random));
        FrameVector3D originAcceleration = new FrameVector3D(twistOfBodyWithRespectToBase.getReferenceFrame(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)this.random));
        acceleration.setBasedOnOriginAcceleration((FrameVector3DReadOnly)angularAcceleration, (FrameVector3DReadOnly)originAcceleration, (TwistReadOnly)twistOfBodyWithRespectToBase);
        FrameVector3D linearAccelerationCheck = new FrameVector3D();
        acceleration.getLinearAccelerationAtBodyOrigin((TwistReadOnly)twistOfBodyWithRespectToBase, (FrameVector3DBasics)linearAccelerationCheck);
        linearAccelerationCheck.changeFrame(originAcceleration.getReferenceFrame());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)linearAccelerationCheck, (EuclidGeometry)originAcceleration, (double)1.0E-12);
        FrameVector3D originAccelerationBack = new FrameVector3D(twistOfBodyWithRespectToBase.getReferenceFrame());
        FramePoint3D origin = new FramePoint3D(acceleration.getBodyFrame());
        ReferenceFrame baseFrame = acceleration.getBaseFrame();
        origin.changeFrame(baseFrame);
        acceleration.changeFrame(baseFrame, (TwistReadOnly)twistOfBodyWithRespectToBase, (TwistReadOnly)twistOfBodyWithRespectToBase);
        twistOfBodyWithRespectToBase.changeFrame(baseFrame);
        acceleration.getLinearAccelerationAt((TwistReadOnly)twistOfBodyWithRespectToBase, (FramePoint3DReadOnly)origin, (FrameVector3DBasics)originAccelerationBack);
        originAccelerationBack.changeFrame(originAcceleration.getReferenceFrame());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)originAccelerationBack, (EuclidGeometry)originAcceleration, (double)1.0E-12);
    }

    @Test
    public void testChangeFrameNoRelativeMotion() {
        ReferenceFrame bodyFrame = this.frameA;
        ReferenceFrame baseFrame = this.frameB;
        ReferenceFrame expressedInFrame = this.frameC;
        Twist twist = new Twist(bodyFrame, baseFrame, expressedInFrame, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)this.random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)this.random));
        SpatialAcceleration acceleration = new SpatialAcceleration(bodyFrame, baseFrame, expressedInFrame, (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart());
        twist.changeFrame(this.frameA);
        acceleration.changeFrame(twist.getReferenceFrame());
        double epsilon = 1.0E-12;
        Assertions.assertEquals((Object)twist.getReferenceFrame(), (Object)acceleration.getReferenceFrame());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)twist.getAngularPart(), (EuclidGeometry)acceleration.getAngularPart(), (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)twist.getLinearPart(), (EuclidGeometry)acceleration.getLinearPart(), (double)epsilon);
    }

    @Test
    public void testChangeFrame() throws Exception {
        Random random = new Random(462L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame baseFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame initialFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame desiredFrame = ReferenceFrameTools.constructFrameWithChangingTransformFromParent((String)("randomFrame" + random.nextInt()), (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            SpatialAcceleration accelerationMethod1 = MecanoRandomTools.nextSpatialAcceleration((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)baseFrame, (ReferenceFrame)initialFrame);
            SpatialAcceleration accelerationMethod2 = new SpatialAcceleration((SpatialMotionReadOnly)accelerationMethod1);
            SpatialAcceleration accelerationMethod3 = new SpatialAcceleration((SpatialMotionReadOnly)accelerationMethod1);
            SpatialAcceleration accelerationMethod4 = new SpatialAcceleration((SpatialMotionReadOnly)accelerationMethod1);
            Twist bodyTwist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)baseFrame, (ReferenceFrame)initialFrame);
            Twist deltaTwist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)initialFrame, (ReferenceFrame)desiredFrame, (ReferenceFrame)initialFrame);
            accelerationMethod1.changeFrame(desiredFrame, (TwistReadOnly)deltaTwist, (TwistReadOnly)bodyTwist);
            bodyTwist.changeFrame(desiredFrame);
            deltaTwist.changeFrame(desiredFrame);
            accelerationMethod2.changeFrame(desiredFrame, (TwistReadOnly)deltaTwist, (TwistReadOnly)bodyTwist);
            deltaTwist.invert();
            bodyTwist.changeFrame(initialFrame);
            deltaTwist.changeFrame(initialFrame);
            accelerationMethod3.changeFrame(desiredFrame, (TwistReadOnly)deltaTwist, (TwistReadOnly)bodyTwist);
            bodyTwist.changeFrame(desiredFrame);
            deltaTwist.changeFrame(desiredFrame);
            accelerationMethod4.changeFrame(desiredFrame, (TwistReadOnly)deltaTwist, (TwistReadOnly)bodyTwist);
            MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)accelerationMethod1, (SpatialAccelerationReadOnly)accelerationMethod2, (double)1.0E-12);
            MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)accelerationMethod1, (SpatialAccelerationReadOnly)accelerationMethod3, (double)1.0E-12);
            MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)accelerationMethod1, (SpatialAccelerationReadOnly)accelerationMethod4, (double)1.0E-12);
            deltaTwist.changeFrame(EuclidFrameRandomTools.nextReferenceFrame((Random)random));
            accelerationMethod1.setReferenceFrame(initialFrame);
            MecanoTestTools.assertExceptionIsThrown(() -> accelerationMethod1.changeFrame(desiredFrame, (TwistReadOnly)deltaTwist, (TwistReadOnly)bodyTwist), ReferenceFrameMismatchException.class);
            bodyTwist.setReferenceFrame(initialFrame);
            deltaTwist.setReferenceFrame(desiredFrame);
            accelerationMethod1.setReferenceFrame(initialFrame);
            MecanoTestTools.assertExceptionIsThrown(() -> accelerationMethod1.changeFrame(desiredFrame, (TwistReadOnly)deltaTwist, (TwistReadOnly)bodyTwist), ReferenceFrameMismatchException.class);
            bodyTwist.setReferenceFrame(desiredFrame);
            deltaTwist.setReferenceFrame(initialFrame);
            accelerationMethod1.setReferenceFrame(initialFrame);
            MecanoTestTools.assertExceptionIsThrown(() -> accelerationMethod1.changeFrame(desiredFrame, (TwistReadOnly)deltaTwist, (TwistReadOnly)bodyTwist), ReferenceFrameMismatchException.class);
            bodyTwist.setReferenceFrame(initialFrame);
            bodyTwist.setBodyFrame(initialFrame);
            accelerationMethod1.setReferenceFrame(initialFrame);
            MecanoTestTools.assertExceptionIsThrown(() -> accelerationMethod1.changeFrame(desiredFrame, (TwistReadOnly)deltaTwist, (TwistReadOnly)bodyTwist), ReferenceFrameMismatchException.class);
            bodyTwist.setBodyFrame(bodyFrame);
            bodyTwist.setBaseFrame(desiredFrame);
            accelerationMethod1.setReferenceFrame(initialFrame);
            MecanoTestTools.assertExceptionIsThrown(() -> accelerationMethod1.changeFrame(desiredFrame, (TwistReadOnly)deltaTwist, (TwistReadOnly)bodyTwist), ReferenceFrameMismatchException.class);
            bodyTwist.setReferenceFrame(EuclidFrameRandomTools.nextReferenceFrame((Random)random));
            bodyTwist.setBaseFrame(baseFrame);
            accelerationMethod1.setReferenceFrame(initialFrame);
            MecanoTestTools.assertExceptionIsThrown(() -> accelerationMethod1.changeFrame(desiredFrame, (TwistReadOnly)deltaTwist, (TwistReadOnly)bodyTwist), ReferenceFrameMismatchException.class);
        }
    }

    private static Vector3D numericallyDifferentiate(Vector3DReadOnly previousLinearVelocity, Vector3DReadOnly linearVelocity, double deltaT) {
        Vector3D ret = new Vector3D((Tuple3DReadOnly)linearVelocity);
        ret.sub((Tuple3DReadOnly)previousLinearVelocity);
        ret.scale(1.0 / deltaT);
        return ret;
    }

    private static Vector3D getSinusoidalVelocity(double[] amplitudes, double[] frequencies, double t) {
        double[] velocities = new double[3];
        for (int i = 0; i < 3; ++i) {
            double linearAmplitude = amplitudes[i];
            double linearFrequency = frequencies[i];
            velocities[i] = linearAmplitude * Math.sin(linearFrequency * t);
        }
        return new Vector3D(velocities);
    }

    private static Vector3D getSinusoidalAcceleration(double[] amplitudes, double[] frequencies, double t) {
        double[] accelerations = new double[3];
        for (int i = 0; i < 3; ++i) {
            double linearAmplitude = amplitudes[i];
            double linearFrequency = frequencies[i];
            accelerations[i] = linearFrequency * linearAmplitude * Math.cos(linearFrequency * t);
        }
        return new Vector3D(accelerations);
    }

    private Vector3D getRandomVector(Random random) {
        return new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
    }
}

