/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.fourBar;

import com.sun.javafx.application.PlatformImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.UnitVector2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.mecano.fourBar.ConvexFourBarTest;
import us.ihmc.mecano.fourBar.FourBar;
import us.ihmc.mecano.fourBar.FourBarAngle;
import us.ihmc.mecano.fourBar.FourBarVertex;

public class CrossFourBarTest {
    static final double EPSILON = 1.0E-9;
    private static final double FD_DOT_EPSILON = 1.0E-4;
    private static final double FD_DDOT_EPSILON = 0.01;
    private static final int ITERATIONS = 10000;
    static final boolean VERBOSE = false;

    @Test
    public void testAngleLimits() throws InterruptedException {
        Random random = new Random(67547L);
        FourBar fourBar = new FourBar();
        for (int i = 0; i < 10000; ++i) {
            List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)5.0, (int)4);
            int flippedIndex = random.nextInt(4);
            Collections.swap(vertices, flippedIndex, (flippedIndex + 1) % 4);
            Point2D A = (Point2D)vertices.get(0);
            Point2D B = (Point2D)vertices.get(1);
            Point2D C = (Point2D)vertices.get(2);
            Point2D D = (Point2D)vertices.get(3);
            ArrayList<Point2D> verticesNew = new ArrayList<Point2D>();
            verticesNew.addAll(Arrays.asList(new Point2D(), new Point2D(), new Point2D(), new Point2D()));
            UnitVector2D direction = new UnitVector2D();
            fourBar.setup((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
            for (FourBarAngle angle : FourBarAngle.values) {
                int j;
                fourBar.setup((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
                fourBar.setToMin(angle);
                int startIndex = angle.ordinal();
                FourBarVertex vertex = fourBar.getVertex(angle);
                for (j = 0; j < 4; ++j) {
                    ((Point2D)verticesNew.get(j)).set((Point2D)vertices.get(j));
                }
                for (j = 0; j < 2; ++j) {
                    Point2D vPrevNew = (Point2D)CrossFourBarTest.getPrevious(startIndex + j, verticesNew);
                    Point2D vCurrNew = (Point2D)CrossFourBarTest.getWrap(startIndex + j, verticesNew);
                    Point2D vNextNew = (Point2D)CrossFourBarTest.getNext(startIndex + j, verticesNew);
                    direction.sub((Tuple2DReadOnly)vPrevNew, (Tuple2DReadOnly)vCurrNew);
                    RotationMatrixTools.applyYawRotation((double)vertex.getAngle(), (Tuple2DReadOnly)direction, (Tuple2DBasics)direction);
                    vNextNew.scaleAdd(vertex.getNextEdge().getLength(), (Tuple2DReadOnly)direction, (Tuple2DReadOnly)vCurrNew);
                    vertex = vertex.getNextVertex();
                }
                try {
                    for (j = 0; j < 4; ++j) {
                        Assertions.assertEquals((double)((Point2D)vertices.get(j)).distance((Point2DReadOnly)vertices.get((j + 1) % 4)), (double)((Point2D)verticesNew.get(j)).distance((Point2DReadOnly)verticesNew.get((j + 1) % 4)), (double)1.0E-9);
                    }
                    Assertions.assertEquals((double)0.0, (double)(fourBar.getAngleDAB() + fourBar.getAngleABC() + fourBar.getAngleBCD() + fourBar.getAngleCDA()), (double)1.0E-9);
                }
                catch (Throwable e) {
                    Viewer viewer = CrossFourBarTest.startupViewer();
                    viewer.updateFOV(new Point2DReadOnly[]{A, B, C, D, (Point2DReadOnly)verticesNew.get(0), (Point2DReadOnly)verticesNew.get(1), (Point2DReadOnly)verticesNew.get(2), (Point2DReadOnly)verticesNew.get(3)});
                    CrossFourBarTest.draw(viewer, (Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
                    CrossFourBarTest.draw(viewer, verticesNew, "'");
                    viewer.waitUntilClosed();
                    throw e;
                }
            }
        }
    }

    private static int wrap(int index, List<?> list) {
        if ((index %= list.size()) < 0) {
            index += list.size();
        }
        return index;
    }

    private static <T> T getWrap(int index, List<T> list) {
        return list.get(CrossFourBarTest.wrap(index, list));
    }

    private static <T> T getNext(int index, List<T> list) {
        return list.get(CrossFourBarTest.wrap(index + 1, list));
    }

    private static <T> T getPrevious(int index, List<T> list) {
        return list.get(CrossFourBarTest.wrap(index - 1, list));
    }

    @Test
    public void testAtLimits() {
        Random random = new Random(3465764L);
        FourBar fourBar = new FourBar();
        for (int i = 0; i < 10000; ++i) {
            List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)5.0, (int)4);
            int flippedIndex = random.nextInt(4);
            Collections.swap(vertices, flippedIndex, (flippedIndex + 1) % 4);
            Point2D A = (Point2D)vertices.get(0);
            Point2D B = (Point2D)vertices.get(1);
            Point2D C = (Point2D)vertices.get(2);
            Point2D D = (Point2D)vertices.get(3);
            fourBar.setup((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
            double angleLimitVariation = 1.0E-10;
            double tolerance = 0.001;
            for (FourBarAngle fourBarAngle : FourBarAngle.values) {
                double minAngle = fourBar.getVertex(fourBarAngle).getMinAngle();
                double maxAngle = fourBar.getVertex(fourBarAngle).getMaxAngle();
                Assertions.assertNull((Object)fourBar.update(fourBarAngle, minAngle + angleLimitVariation));
                double expectedDAB = fourBar.getAngleDAB();
                double expectedABC = fourBar.getAngleABC();
                double expectedBCD = fourBar.getAngleBCD();
                double expectedCDA = fourBar.getAngleCDA();
                fourBar.setToMin(fourBarAngle);
                Assertions.assertEquals((double)expectedDAB, (double)fourBar.getAngleDAB(), (double)tolerance);
                Assertions.assertEquals((double)expectedABC, (double)fourBar.getAngleABC(), (double)tolerance);
                Assertions.assertEquals((double)expectedBCD, (double)fourBar.getAngleBCD(), (double)tolerance);
                Assertions.assertEquals((double)expectedCDA, (double)fourBar.getAngleCDA(), (double)tolerance);
                Assertions.assertEquals((Object)Bound.MIN, (Object)fourBar.update(fourBarAngle, minAngle));
                Assertions.assertEquals((double)expectedDAB, (double)fourBar.getAngleDAB(), (double)tolerance);
                Assertions.assertEquals((double)expectedABC, (double)fourBar.getAngleABC(), (double)tolerance);
                Assertions.assertEquals((double)expectedBCD, (double)fourBar.getAngleBCD(), (double)tolerance);
                Assertions.assertEquals((double)expectedCDA, (double)fourBar.getAngleCDA(), (double)tolerance);
                Assertions.assertNull((Object)fourBar.update(fourBarAngle, maxAngle - angleLimitVariation));
                expectedDAB = fourBar.getAngleDAB();
                expectedABC = fourBar.getAngleABC();
                expectedBCD = fourBar.getAngleBCD();
                expectedCDA = fourBar.getAngleCDA();
                fourBar.setToMax(fourBarAngle);
                Assertions.assertEquals((double)expectedDAB, (double)fourBar.getAngleDAB(), (double)tolerance);
                Assertions.assertEquals((double)expectedABC, (double)fourBar.getAngleABC(), (double)tolerance);
                Assertions.assertEquals((double)expectedBCD, (double)fourBar.getAngleBCD(), (double)tolerance);
                Assertions.assertEquals((double)expectedCDA, (double)fourBar.getAngleCDA(), (double)tolerance);
                Assertions.assertEquals((Object)Bound.MAX, (Object)fourBar.update(fourBarAngle, maxAngle));
                Assertions.assertEquals((double)expectedDAB, (double)fourBar.getAngleDAB(), (double)tolerance);
                Assertions.assertEquals((double)expectedABC, (double)fourBar.getAngleABC(), (double)tolerance);
                Assertions.assertEquals((double)expectedBCD, (double)fourBar.getAngleBCD(), (double)tolerance);
                Assertions.assertEquals((double)expectedCDA, (double)fourBar.getAngleCDA(), (double)tolerance);
            }
        }
    }

    @Test
    public void testGeometry() throws Throwable {
        int i;
        Random random = new Random(345L);
        FourBar fourBar = new FourBar();
        for (i = 0; i < 10000; ++i) {
            List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)5.0, (int)4);
            int flippedIndex = random.nextInt(4);
            Collections.swap(vertices, flippedIndex, (flippedIndex + 1) % 4);
            Point2D A = (Point2D)vertices.get(0);
            Point2D B = (Point2D)vertices.get(1);
            Point2D C = (Point2D)vertices.get(2);
            Point2D D = (Point2D)vertices.get(3);
            ConvexFourBarTest.performBasicGeometricAssertions(random, fourBar, i, A, B, C, D);
        }
        for (i = 0; i < 10000; ++i) {
            Point2D A = new Point2D();
            Point2D B = new Point2D();
            Point2D C = new Point2D();
            Point2D D = new Point2D();
            Point2D X = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D XA = new Vector2D();
            Vector2D XB = new Vector2D();
            Vector2D XC = new Vector2D();
            Vector2D XD = new Vector2D();
            if (random.nextBoolean()) {
                direction = EuclidCoreRandomTools.nextUnitVector2D((Random)random);
                XA.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)direction);
                XD.setAndScale(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)direction);
                yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)3.1405926535897932);
                if (random.nextBoolean()) {
                    yaw = -yaw;
                }
                RotationMatrixTools.applyYawRotation((double)yaw, (Tuple2DReadOnly)direction, (Tuple2DBasics)direction);
                XB.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)direction);
                XC.setAndScale(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)direction);
            } else {
                direction = EuclidCoreRandomTools.nextUnitVector2D((Random)random);
                XA.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)direction);
                XB.setAndScale(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)direction);
                yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)3.1405926535897932);
                if (random.nextBoolean()) {
                    yaw = -yaw;
                }
                RotationMatrixTools.applyYawRotation((double)yaw, (Tuple2DReadOnly)direction, (Tuple2DBasics)direction);
                XD.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)direction);
                XC.setAndScale(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)direction);
            }
            A.add((Tuple2DReadOnly)X, (Tuple2DReadOnly)XA);
            B.add((Tuple2DReadOnly)X, (Tuple2DReadOnly)XB);
            C.add((Tuple2DReadOnly)X, (Tuple2DReadOnly)XC);
            D.add((Tuple2DReadOnly)X, (Tuple2DReadOnly)XD);
            ConvexFourBarTest.performBasicGeometricAssertions(random, fourBar, i, A, B, C, D);
        }
    }

    @Test
    public void testVelocityAgainstFiniteDifference() {
        Random random = new Random(4545786L);
        for (int i = 0; i < 10000; ++i) {
            double angleEnd;
            List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)5.0, (int)4);
            int flippedIndex = random.nextInt(4);
            Collections.swap(vertices, flippedIndex, (flippedIndex + 1) % 4);
            Point2D A = (Point2D)vertices.get(0);
            Point2D B = (Point2D)vertices.get(1);
            Point2D C = (Point2D)vertices.get(2);
            Point2D D = (Point2D)vertices.get(3);
            FourBar fourBar = new FourBar();
            fourBar.setup((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
            FourBarAngle fourBarAngle = (FourBarAngle)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])FourBarAngle.values);
            double angleStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBar.getVertex(fourBarAngle).getMinAngle(), (double)fourBar.getVertex(fourBarAngle).getMaxAngle());
            fourBar.update(fourBarAngle, angleStart);
            double DAB_start = fourBar.getAngleDAB();
            double ABC_start = fourBar.getAngleABC();
            double BCD_start = fourBar.getAngleBCD();
            double CDA_start = fourBar.getAngleCDA();
            double AC_start = fourBar.getDiagonalAC().getLength();
            double BD_start = fourBar.getDiagonalBD().getLength();
            double angleMaxDelta = 5.0E-8;
            double dt = 5.0E-7;
            if (random.nextBoolean()) {
                angleMaxDelta = Math.min(angleMaxDelta, fourBar.getVertex(fourBarAngle).getMaxAngle() - angleStart);
                angleEnd = angleStart + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)angleMaxDelta);
            } else {
                angleMaxDelta = Math.max(-angleMaxDelta, fourBar.getVertex(fourBarAngle).getMinAngle() - angleStart);
                angleEnd = angleStart + EuclidCoreRandomTools.nextDouble((Random)random, (double)angleMaxDelta, (double)0.0);
            }
            fourBar.update(fourBarAngle, angleEnd);
            double DAB_end = fourBar.getAngleDAB();
            double ABC_end = fourBar.getAngleABC();
            double BCD_end = fourBar.getAngleBCD();
            double CDA_end = fourBar.getAngleCDA();
            double AC_end = fourBar.getDiagonalAC().getLength();
            double BD_end = fourBar.getDiagonalBD().getLength();
            double angleDot = (angleEnd - angleStart) / dt;
            double expected_dtDAB = (DAB_end - DAB_start) / dt;
            double expected_dtABC = (ABC_end - ABC_start) / dt;
            double expected_dtBCD = (BCD_end - BCD_start) / dt;
            double expected_dtCDA = (CDA_end - CDA_start) / dt;
            double expected_dtAC = (AC_end - AC_start) / dt;
            double expected_dtBD = (BD_end - BD_start) / dt;
            fourBar.update(fourBarAngle, angleStart, angleDot);
            this.assertEqualsDynEpsilon(expected_dtDAB, fourBar.getAngleDtDAB(), 1.0E-4, "Iteration= " + i);
            this.assertEqualsDynEpsilon(expected_dtABC, fourBar.getAngleDtABC(), 1.0E-4, "Iteration= " + i);
            this.assertEqualsDynEpsilon(expected_dtBCD, fourBar.getAngleDtBCD(), 1.0E-4, "Iteration= " + i);
            this.assertEqualsDynEpsilon(expected_dtCDA, fourBar.getAngleDtCDA(), 1.0E-4, "Iteration= " + i);
            this.assertEqualsDynEpsilon(expected_dtAC, fourBar.getDiagonalAC().getLengthDot(), 1.0E-4, "Iteration= " + i);
            this.assertEqualsDynEpsilon(expected_dtBD, fourBar.getDiagonalBD().getLengthDot(), 1.0E-4, "Iteration= " + i);
        }
    }

    @Test
    public void testAccelerationAgainstFiniteDifference() {
        Random random = new Random(4545786L);
        for (int i = 0; i < 10000; ++i) {
            double angleDDot;
            double angleDotEnd;
            double angleDotDelta;
            double angleDotStart;
            double angleEnd;
            List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)5.0, (int)4);
            int flippedIndex = random.nextInt(4);
            Collections.swap(vertices, flippedIndex, (flippedIndex + 1) % 4);
            Point2D A = (Point2D)vertices.get(0);
            Point2D B = (Point2D)vertices.get(1);
            Point2D C = (Point2D)vertices.get(2);
            Point2D D = (Point2D)vertices.get(3);
            FourBar fourBar = new FourBar();
            fourBar.setup((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
            FourBarAngle fourBarAngle = FourBarAngle.DAB;
            double dt = 1.0E-6;
            double angleStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBar.getVertex(fourBarAngle).getMinAngle(), (double)fourBar.getVertex(fourBarAngle).getMaxAngle());
            do {
                angleDotDelta = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-6);
                angleDotStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5);
                angleDotEnd = angleDotStart + angleDotDelta;
                angleDDot = angleDotDelta / dt;
            } while ((angleEnd = angleStart + (angleDotStart + 0.5 * angleDotDelta) * dt) > fourBar.getVertex(fourBarAngle).getMaxAngle() || angleEnd < fourBar.getVertex(fourBarAngle).getMinAngle());
            fourBar.update(fourBarAngle, angleStart, angleDotStart);
            double dtDAB_start = fourBar.getAngleDtDAB();
            double dtABC_start = fourBar.getAngleDtABC();
            double dtBCD_start = fourBar.getAngleDtBCD();
            double dtCDA_start = fourBar.getAngleDtCDA();
            double dtAC_start = fourBar.getDiagonalAC().getLengthDot();
            double dtBD_start = fourBar.getDiagonalBD().getLengthDot();
            fourBar.update(fourBarAngle, angleEnd, angleDotEnd);
            double dtDAB_end = fourBar.getAngleDtDAB();
            double dtABC_end = fourBar.getAngleDtABC();
            double dtBCD_end = fourBar.getAngleDtBCD();
            double dtCDA_end = fourBar.getAngleDtCDA();
            double dtAC_end = fourBar.getDiagonalAC().getLengthDot();
            double dtBD_end = fourBar.getDiagonalBD().getLengthDot();
            double expected_dt2DAB = (dtDAB_end - dtDAB_start) / dt;
            double expected_dt2ABC = (dtABC_end - dtABC_start) / dt;
            double expected_dt2BCD = (dtBCD_end - dtBCD_start) / dt;
            double expected_dt2CDA = (dtCDA_end - dtCDA_start) / dt;
            double expected_dt2AC = (dtAC_end - dtAC_start) / dt;
            double expected_dt2BD = (dtBD_end - dtBD_start) / dt;
            if (Math.abs(expected_dt2AC) > 1000.0 || Math.abs(expected_dt2BD) > 1000.0) {
                --i;
                continue;
            }
            fourBar.update(fourBarAngle, angleStart, angleDotStart, angleDDot);
            this.assertEqualsDynEpsilon(expected_dt2DAB, fourBar.getAngleDt2DAB(), 0.01, "Iteration= " + i);
            this.assertEqualsDynEpsilon(expected_dt2ABC, fourBar.getAngleDt2ABC(), 0.01, "Iteration= " + i);
            this.assertEqualsDynEpsilon(expected_dt2BCD, fourBar.getAngleDt2BCD(), 0.01, "Iteration= " + i);
            this.assertEqualsDynEpsilon(expected_dt2CDA, fourBar.getAngleDt2CDA(), 0.01, "Iteration= " + i);
            this.assertEqualsDynEpsilon(expected_dt2AC, fourBar.getDiagonalAC().getLengthDDot(), 0.01, "Iteration= " + i);
            this.assertEqualsDynEpsilon(expected_dt2BD, fourBar.getDiagonalBD().getLengthDDot(), 0.01, "Iteration= " + i);
        }
    }

    private void assertEqualsDynEpsilon(double expected, double actual, double epsilon, String messagePrefix) {
        double dynEspilon = epsilon * Math.max(1.0, Math.abs(expected));
        String errorMessage = "rror= " + Math.abs(expected - actual) + ", epsilon= " + dynEspilon;
        messagePrefix = messagePrefix == null || ((String)messagePrefix).isEmpty() ? "E" + errorMessage : (String)messagePrefix + ", e" + errorMessage;
        Assertions.assertEquals((double)expected, (double)actual, (double)dynEspilon, (String)messagePrefix);
    }

    @Test
    public void testAccelerationsWithRandomQuadrilateral() {
        double eps = 1.0E-5;
        Random random = new Random(1984L);
        double DAB_t0 = 0.0;
        double DAB_tf = 0.0;
        double DAB_tj = 0.0;
        double dDAB_t0 = 0.0;
        double dDAB_tf = 0.0;
        double dDAB_tj = 0.0;
        double ddDAB = 0.0;
        double ABC_t0 = 0.0;
        double CDA_t0 = 0.0;
        double BCD_t0 = 0.0;
        double ABC_next_tj = 0.0;
        double CDA_next_tj = 0.0;
        double BCD_next_tj = 0.0;
        double ABC_numerical_tf = 0.0;
        double CDA_numerical_tf = 0.0;
        double BCD_numerical_tf = 0.0;
        double ABC_fourbar_tf = 0.0;
        double CDA_fourbar_tf = 0.0;
        double BCD_fourbar_tf = 0.0;
        int nSteps = 10000;
        double T = 0.001;
        double deltaT = T / ((double)nSteps - 1.0);
        for (int i = 0; i < 50; ++i) {
            List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)5.0, (int)4);
            int flippedIndex = random.nextInt(4);
            Collections.swap(vertices, flippedIndex, (flippedIndex + 1) % 4);
            Point2D A = (Point2D)vertices.get(0);
            Point2D B = (Point2D)vertices.get(1);
            Point2D C = (Point2D)vertices.get(2);
            Point2D D = (Point2D)vertices.get(3);
            FourBar fourBar = new FourBar();
            fourBar.setup((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
            DAB_t0 = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBar.getMinDAB(), (double)fourBar.getMaxDAB());
            DAB_tf = EuclidCoreRandomTools.nextDouble((Random)random, (double)fourBar.getMinDAB(), (double)fourBar.getMaxDAB());
            dDAB_t0 = 0.0;
            ddDAB = 2.0 * (DAB_tf - DAB_t0 - dDAB_t0 * T) / EuclidCoreTools.square((double)T);
            dDAB_tf = dDAB_t0 + ddDAB * T;
            fourBar.update(FourBarAngle.DAB, DAB_t0, dDAB_t0);
            ABC_t0 = fourBar.getAngleABC();
            CDA_t0 = fourBar.getAngleCDA();
            BCD_t0 = fourBar.getAngleBCD();
            fourBar.update(FourBarAngle.DAB, DAB_tf, dDAB_tf);
            ABC_fourbar_tf = fourBar.getAngleABC();
            CDA_fourbar_tf = fourBar.getAngleCDA();
            BCD_fourbar_tf = fourBar.getAngleBCD();
            ABC_next_tj = ABC_t0;
            CDA_next_tj = CDA_t0;
            BCD_next_tj = BCD_t0;
            for (int j = 0; j < nSteps - 1; ++j) {
                DAB_tj = ddDAB * EuclidCoreTools.square((double)((double)j * deltaT)) / 2.0 + dDAB_t0 * (double)j * deltaT + DAB_t0;
                dDAB_tj = ddDAB * (double)j * deltaT + dDAB_t0;
                fourBar.update(FourBarAngle.DAB, DAB_tj, dDAB_tj, ddDAB);
                ABC_next_tj += fourBar.getAngleDtABC() * deltaT + fourBar.getAngleDt2ABC() * EuclidCoreTools.square((double)deltaT) / 2.0;
                CDA_next_tj += fourBar.getAngleDtCDA() * deltaT + fourBar.getAngleDt2CDA() * EuclidCoreTools.square((double)deltaT) / 2.0;
                BCD_next_tj += fourBar.getAngleDtBCD() * deltaT + fourBar.getAngleDt2BCD() * EuclidCoreTools.square((double)deltaT) / 2.0;
            }
            ABC_numerical_tf = ABC_next_tj;
            CDA_numerical_tf = CDA_next_tj;
            BCD_numerical_tf = BCD_next_tj;
            Assertions.assertEquals((double)ABC_numerical_tf, (double)ABC_fourbar_tf, (double)eps);
            Assertions.assertEquals((double)CDA_numerical_tf, (double)CDA_fourbar_tf, (double)eps);
            Assertions.assertEquals((double)BCD_numerical_tf, (double)BCD_fourbar_tf, (double)eps);
        }
    }

    public static Viewer startupViewer() {
        Viewer viewerComponents = new Viewer();
        PlatformImpl.startup(() -> {
            Stage stage = new Stage();
            viewerComponents.root = new Group();
            viewerComponents.scene = new Scene((Parent)viewerComponents.root, 600.0, 600.0);
            stage.setScene(viewerComponents.scene);
            stage.show();
            stage.setOnCloseRequest(e -> viewerComponents.countDownLatch.countDown());
        });
        return viewerComponents;
    }

    public static void draw(Viewer viewer, List<? extends Point2DReadOnly> vertices) throws InterruptedException {
        CrossFourBarTest.draw(viewer, vertices, "");
    }

    public static void draw(Viewer viewer, Point2DReadOnly A, Point2DReadOnly B, Point2DReadOnly C, Point2DReadOnly D) throws InterruptedException {
        CrossFourBarTest.draw(viewer, A, B, C, D, "");
    }

    public static void draw(Viewer viewer, List<? extends Point2DReadOnly> vertices, String suffix) throws InterruptedException {
        CrossFourBarTest.draw(viewer, vertices.get(0), vertices.get(1), vertices.get(2), vertices.get(3), suffix);
    }

    public static void draw(Viewer viewer, Point2DReadOnly A, Point2DReadOnly B, Point2DReadOnly C, Point2DReadOnly D, String suffix) throws InterruptedException {
        VertexGraphics AGraphics = new VertexGraphics(A, "A" + suffix, Color.INDIANRED);
        VertexGraphics BGraphics = new VertexGraphics(B, "B" + suffix, Color.CORNFLOWERBLUE);
        VertexGraphics CGraphics = new VertexGraphics(C, "C" + suffix, Color.DARKGREEN);
        VertexGraphics DGraphics = new VertexGraphics(D, "D" + suffix, Color.GOLD);
        CrossFourBarTest.draw(viewer, AGraphics, BGraphics, CGraphics, DGraphics);
    }

    public static void draw(Viewer viewer, VertexGraphics ... vertices) throws InterruptedException {
        Platform.runLater(() -> {
            VertexGraphics nextVertex;
            VertexGraphics vertex;
            int i;
            Group root = viewer.root;
            Scene scene = viewer.scene;
            for (i = 0; i < 4; ++i) {
                vertex = vertices[i];
                nextVertex = vertices[(i + 1) % 4];
                VertexGraphics previousVertex = vertices[(i + 3) % 4];
                boolean moveRight = vertex.getX() > previousVertex.getX() && vertex.getX() > nextVertex.getX();
                boolean moveLeft = vertex.getX() < previousVertex.getX() && vertex.getX() < nextVertex.getX();
                boolean moveTop = vertex.getY() > previousVertex.getY() && vertex.getY() > nextVertex.getY();
                boolean moveBottom = vertex.getY() < previousVertex.getY() && vertex.getY() < nextVertex.getY();
                Text text = new Text(vertex.name);
                text.setStroke((Paint)vertex.color);
                DoubleBinding xPositionProperty = viewer.xPositionProperty(viewer.span, viewer.center, scene, vertex);
                DoubleBinding yPositionProperty = viewer.yPositionProperty(viewer.span, viewer.center, scene, vertex);
                if (moveLeft) {
                    xPositionProperty = xPositionProperty.subtract(15.0);
                } else if (moveRight) {
                    xPositionProperty = xPositionProperty.add(10.0);
                }
                text.xProperty().bind((ObservableValue)xPositionProperty);
                if (moveTop) {
                    yPositionProperty = yPositionProperty.subtract(10.0);
                } else if (moveBottom) {
                    yPositionProperty = yPositionProperty.add(15.0);
                }
                text.yProperty().bind((ObservableValue)yPositionProperty);
                root.getChildren().add((Object)text);
            }
            for (i = 0; i < 4; ++i) {
                vertex = vertices[i];
                nextVertex = vertices[(i + 1) % 4];
                Line line = new Line();
                line.startXProperty().bind((ObservableValue)viewer.xPositionProperty(viewer.span, viewer.center, scene, vertex));
                line.startYProperty().bind((ObservableValue)viewer.yPositionProperty(viewer.span, viewer.center, scene, vertex));
                line.endXProperty().bind((ObservableValue)viewer.xPositionProperty(viewer.span, viewer.center, scene, nextVertex));
                line.endYProperty().bind((ObservableValue)viewer.yPositionProperty(viewer.span, viewer.center, scene, nextVertex));
                line.setStrokeWidth(2.0);
                line.setStroke((Paint)vertex.color.interpolate(nextVertex.color, 0.5));
                root.getChildren().add((Object)line);
            }
            for (i = 0; i < 4; ++i) {
                vertex = vertices[i];
                Circle circle = new Circle(5.0);
                circle.centerXProperty().bind((ObservableValue)viewer.xPositionProperty(viewer.span, viewer.center, scene, vertex));
                circle.centerYProperty().bind((ObservableValue)viewer.yPositionProperty(viewer.span, viewer.center, scene, vertex));
                circle.setFill((Paint)vertex.color);
                root.getChildren().add((Object)circle);
            }
        });
    }

    public static class Viewer {
        double span = 10.0;
        Point2D center = new Point2D();
        Scene scene;
        Group root;
        final CountDownLatch countDownLatch = new CountDownLatch(1);

        public void updateFOV(List<? extends Point2DReadOnly> points) {
            this.updateFOV(points.toArray(new Point2DReadOnly[0]));
        }

        public void updateFOV(Point2DReadOnly ... points) {
            BoundingBox2D bbx = new BoundingBox2D();
            bbx.updateToIncludePoints(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])points));
            this.span = 1.2 * Math.max(bbx.getMaxX() - bbx.getMinX(), bbx.getMaxY() - bbx.getMinY());
            bbx.getCenterPoint((Point2DBasics)this.center);
        }

        public void waitUntilClosed() throws InterruptedException {
            this.countDownLatch.await();
        }

        public DoubleBinding yPositionProperty(double span, Point2D center, Scene scene, Point2DReadOnly vertex) {
            return Bindings.multiply((double)(0.5 - (vertex.getY() - center.getY()) / span), (ObservableNumberValue)scene.heightProperty());
        }

        public DoubleBinding xPositionProperty(double span, Point2D center, Scene scene, Point2DReadOnly vertex) {
            return Bindings.multiply((double)(0.5 + (vertex.getX() - center.getX()) / span), (ObservableNumberValue)scene.widthProperty());
        }
    }

    private static class VertexGraphics
    implements Point2DReadOnly {
        private Point2DReadOnly vertex;
        private String name;
        private Color color;

        public VertexGraphics(Point2DReadOnly vertex, String name, Color color) {
            this.vertex = vertex;
            this.name = name;
            this.color = color;
        }

        public double getX() {
            return this.vertex.getX();
        }

        public double getY() {
            return this.vertex.getY();
        }
    }
}

