/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import java.util.Arrays;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.EigenDecomposition_F64;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameNameRestrictionLevel;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MecanoTools;

public class SpatialInertiaTest {
    private static final double EPSILON = 1.0E-12;
    private static final int ITERATIONS = 1000;

    @BeforeEach
    public void disableNameRestriction() {
        ReferenceFrame.getWorldFrame().setNameRestrictionLevel(FrameNameRestrictionLevel.NONE);
    }

    @Test
    public void testApplyInverseTransform() throws Exception {
        SpatialInertia actual;
        SpatialInertia expected;
        int i;
        Random random = new Random(654L);
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame expressedInFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            expected = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)expressedInFrame);
            actual = new SpatialInertia((SpatialInertiaReadOnly)expected);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            actual.applyTransform((RigidBodyTransformReadOnly)transform);
            actual.applyInverseTransform((RigidBodyTransformReadOnly)transform);
            MecanoTestTools.assertSpatialInertiaEquals((SpatialInertiaReadOnly)expected, (SpatialInertiaReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)worldFrame, (ReferenceFrame)worldFrame);
            actual = new SpatialInertia((SpatialInertiaReadOnly)expected);
            expected.applyInverseTransform((RigidBodyTransformReadOnly)transform);
            actual.applyInverseTransform((Transform)new AffineTransform((RigidBodyTransformReadOnly)transform));
            MecanoTestTools.assertSpatialInertiaEquals((SpatialInertiaReadOnly)expected, (SpatialInertiaReadOnly)actual, (double)1.0E-12);
            actual = new SpatialInertia((SpatialInertiaReadOnly)expected);
            expected.applyInverseTransform((RigidBodyTransformReadOnly)transform);
            actual.applyInverseTransform((RigidBodyTransformReadOnly)new Pose3D((RigidBodyTransformReadOnly)transform));
            MecanoTestTools.assertSpatialInertiaEquals((SpatialInertiaReadOnly)expected, (SpatialInertiaReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testComputeKineticCoEnergy() throws Exception {
        Random random = new Random(334523L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame expressedInFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialInertia inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)expressedInFrame);
            Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)expressedInFrame);
            double expected = MecanoTools.computeKineticCoEnergy((Matrix3DReadOnly)inertia.getMomentOfInertia(), (double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart());
            double actual = inertia.computeKineticCoEnergy((TwistReadOnly)twist);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
        ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        ReferenceFrame expressedInFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        ReferenceFrame nonStationaryFrame = new ReferenceFrame("nonStationaryFrame", worldFrame, false, false){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            }
        };
        ReferenceFrame anotherFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        SpatialInertia inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)expressedInFrame);
        Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)nonStationaryFrame, (ReferenceFrame)expressedInFrame);
        MecanoTestTools.assertExceptionIsThrown(() -> inertia.computeKineticCoEnergy((TwistReadOnly)twist), RuntimeException.class);
        twist.setToZero(anotherFrame, worldFrame, expressedInFrame);
        MecanoTestTools.assertExceptionIsThrown(() -> inertia.computeKineticCoEnergy((TwistReadOnly)twist), ReferenceFrameMismatchException.class);
        twist.setToZero(bodyFrame, worldFrame, anotherFrame);
        MecanoTestTools.assertExceptionIsThrown(() -> inertia.computeKineticCoEnergy((TwistReadOnly)twist), ReferenceFrameMismatchException.class);
        twist.setToZero(bodyFrame, worldFrame, bodyFrame);
        MecanoTestTools.assertExceptionIsThrown(() -> inertia.computeKineticCoEnergy((TwistReadOnly)twist), ReferenceFrameMismatchException.class);
    }

    @Test
    public void testComputeDynamicWrenchFast() throws Exception {
        Random random = new Random(345346L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialInertia inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrame);
            inertia.getCenterOfMassOffset().setToZero();
            SpatialAcceleration acceleration = MecanoRandomTools.nextSpatialAcceleration((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)bodyFrame);
            Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)bodyFrame);
            Wrench expected = new Wrench(bodyFrame, bodyFrame);
            MecanoTools.computeDynamicMomentFast((Matrix3DReadOnly)inertia.getMomentOfInertia(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DBasics)expected.getAngularPart());
            MecanoTools.computeDynamicForceFast((double)inertia.getMass(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)expected.getLinearPart());
            Wrench actual = new Wrench(worldFrame, worldFrame);
            inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)actual);
            MecanoTestTools.assertWrenchEquals((WrenchReadOnly)expected, (WrenchReadOnly)actual, (double)1.0E-12);
        }
        ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        ReferenceFrame anotherFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        ReferenceFrame nonStationaryFrame = new ReferenceFrame("nonStationaryFrame", worldFrame, false, false){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            }
        };
        SpatialInertia inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrame);
        SpatialAcceleration acceleration = MecanoRandomTools.nextSpatialAcceleration((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)bodyFrame);
        Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)bodyFrame);
        Wrench wrench = new Wrench(worldFrame, worldFrame);
        MecanoTestTools.assertExceptionIsThrown(() -> inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench), RuntimeException.class);
        inertia.getCenterOfMassOffset().setToZero();
        inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench);
        inertia.setReferenceFrame(anotherFrame);
        MecanoTestTools.assertExceptionIsThrown(() -> inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench), ReferenceFrameMismatchException.class);
        inertia.setReferenceFrame(bodyFrame);
        inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench);
        twist.setBaseFrame(nonStationaryFrame);
        MecanoTestTools.assertExceptionIsThrown(() -> inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench), RuntimeException.class);
        twist.setBaseFrame(worldFrame);
        inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench);
        acceleration.setBaseFrame(nonStationaryFrame);
        MecanoTestTools.assertExceptionIsThrown(() -> inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench), RuntimeException.class);
        acceleration.setBaseFrame(worldFrame);
        inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench);
        twist.setReferenceFrame(anotherFrame);
        MecanoTestTools.assertExceptionIsThrown(() -> inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench), ReferenceFrameMismatchException.class);
        twist.setReferenceFrame(bodyFrame);
        inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench);
        acceleration.setReferenceFrame(anotherFrame);
        MecanoTestTools.assertExceptionIsThrown(() -> inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench), ReferenceFrameMismatchException.class);
        acceleration.setReferenceFrame(bodyFrame);
        inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench);
        twist.setBodyFrame(anotherFrame);
        MecanoTestTools.assertExceptionIsThrown(() -> inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench), ReferenceFrameMismatchException.class);
        twist.setBodyFrame(bodyFrame);
        inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench);
        acceleration.setBodyFrame(anotherFrame);
        MecanoTestTools.assertExceptionIsThrown(() -> inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench), ReferenceFrameMismatchException.class);
        acceleration.setBodyFrame(bodyFrame);
        inertia.computeDynamicWrenchFast((SpatialAccelerationReadOnly)acceleration, (TwistReadOnly)twist, (WrenchBasics)wrench);
    }

    @Test
    public void testChangeFrame() throws Exception {
        SpatialInertia inertia;
        ReferenceFrame finalFrame;
        ReferenceFrame initialFrame;
        ReferenceFrame finalFrame2;
        ReferenceFrame initialFrame2;
        ReferenceFrame baseFrame;
        ReferenceFrame bodyFrame;
        int i;
        Random random = new Random(43L);
        for (i = 0; i < 1000; ++i) {
            bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            baseFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            initialFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            finalFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialInertia inertia2 = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)initialFrame2);
            Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)baseFrame, (ReferenceFrame)initialFrame2);
            Assertions.assertTrue((inertia2.getReferenceFrame() == initialFrame2 ? 1 : 0) != 0);
            double expected = SpatialInertiaTest.computeKineticCoEnergy(twist, inertia2);
            double initialMass = inertia2.getMass();
            inertia2.changeFrame(finalFrame2);
            twist.changeFrame(finalFrame2);
            Assertions.assertTrue((inertia2.getReferenceFrame() == finalFrame2 ? 1 : 0) != 0);
            double actual = SpatialInertiaTest.computeKineticCoEnergy(twist, inertia2);
            double finalMass = inertia2.getMass();
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
            Assertions.assertEquals((double)initialMass, (double)finalMass, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            baseFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            initialFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            finalFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialAcceleration acceleration = MecanoRandomTools.nextSpatialAcceleration((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)baseFrame, (ReferenceFrame)initialFrame2);
            SpatialInertia inertia3 = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)initialFrame2);
            Wrench expected = SpatialInertiaTest.computeWrench(acceleration, inertia3);
            acceleration.changeFrame(finalFrame2);
            inertia3.changeFrame(finalFrame2);
            Wrench actual = SpatialInertiaTest.computeWrench(acceleration, inertia3);
            actual.changeFrame(initialFrame2);
            MecanoTestTools.assertWrenchEquals((WrenchReadOnly)expected, (WrenchReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            initialFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            finalFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)initialFrame, (ReferenceFrame)initialFrame);
            SimpleMatrix inertiaInitial = new SimpleMatrix(6, 6);
            inertia.get((DMatrix)inertiaInitial.getMatrix());
            RigidBodyTransform finalToInitial = finalFrame.getTransformToDesiredFrame(initialFrame);
            SimpleMatrix finalToInitialAdjoint = SimpleMatrix.wrap((Matrix)SpatialInertiaTest.adjoint(finalToInitial));
            SimpleMatrix finalToInitialAdjointTranspose = (SimpleMatrix)finalToInitialAdjoint.transpose();
            DMatrixRMaj expected = (DMatrixRMaj)((SimpleMatrix)((SimpleMatrix)finalToInitialAdjointTranspose.mult((SimpleBase)inertiaInitial)).mult((SimpleBase)finalToInitialAdjoint)).getMatrix();
            inertia.changeFrame(finalFrame);
            DMatrixRMaj actual = new DMatrixRMaj(6, 6);
            inertia.get((DMatrix)actual);
            Assertions.assertTrue((boolean)MatrixFeatures_DDRM.isEquals((DMatrixD1)expected, (DMatrixD1)actual, (double)1.0E-12));
        }
        for (i = 0; i < 1000; ++i) {
            initialFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            finalFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"finalFrame", (ReferenceFrame)initialFrame, (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Point3D()));
            inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)initialFrame, (ReferenceFrame)initialFrame);
            double expected = inertia.getCenterOfMassOffset().norm();
            inertia.changeFrame(finalFrame);
            double actual = inertia.getCenterOfMassOffset().norm();
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            initialFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            finalFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"finalFrame", (ReferenceFrame)initialFrame, (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Point3D()));
            inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)initialFrame, (ReferenceFrame)initialFrame);
            inertia.getMomentOfInertia().set((Matrix3DReadOnly)MecanoRandomTools.nextSymmetricPositiveDefiniteMatrix3D((Random)random));
            inertia.getCenterOfMassOffset().setToZero();
            Matrix3D initialMomentOfInertia = new Matrix3D((Matrix3DReadOnly)inertia.getMomentOfInertia());
            inertia.changeFrame(finalFrame);
            Matrix3D finalMomentOfInertia = new Matrix3D((Matrix3DReadOnly)inertia.getMomentOfInertia());
            SpatialInertiaTest.assertEigenValuesPositiveAndEqual(initialMomentOfInertia, finalMomentOfInertia, 1.0E-12);
        }
    }

    @Test
    public void testTransform() {
        ReferenceFrame worldFrame;
        int i;
        Random random = new Random(6457645L);
        for (i = 0; i < 1000; ++i) {
            worldFrame = ReferenceFrame.getWorldFrame();
            SpatialInertia spatialInertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)worldFrame, (ReferenceFrame)worldFrame);
            SpatialVector vectorOriginal = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)worldFrame);
            SpatialVector expectedVectorTransformed = new SpatialVector();
            SpatialVector actualVectorTransformed = new SpatialVector();
            DMatrixRMaj spatialInertia_ejml = new DMatrixRMaj(6, 6);
            DMatrixRMaj vectorOriginal_ejml = new DMatrixRMaj(6, 1);
            DMatrixRMaj expectedVectorTransformed_ejml = new DMatrixRMaj(6, 1);
            spatialInertia.get((DMatrix)spatialInertia_ejml);
            vectorOriginal.get((DMatrix)vectorOriginal_ejml);
            CommonOps_DDRM.mult((DMatrix1Row)spatialInertia_ejml, (DMatrix1Row)vectorOriginal_ejml, (DMatrix1Row)expectedVectorTransformed_ejml);
            expectedVectorTransformed.set((DMatrix)expectedVectorTransformed_ejml);
            spatialInertia.transform((SpatialVectorReadOnly)vectorOriginal, (FixedFrameSpatialVectorBasics)actualVectorTransformed);
            MecanoTestTools.assertSpatialVectorEquals((SpatialVectorReadOnly)expectedVectorTransformed, (SpatialVectorReadOnly)actualVectorTransformed, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            worldFrame = ReferenceFrame.getWorldFrame();
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            SpatialInertia expected = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)worldFrame, (ReferenceFrame)worldFrame);
            SpatialInertia actual = new SpatialInertia((SpatialInertiaReadOnly)expected);
            expected.applyTransform((RigidBodyTransformReadOnly)transform);
            actual.applyTransform((Transform)new AffineTransform((RigidBodyTransformReadOnly)transform));
            MecanoTestTools.assertSpatialInertiaEquals((SpatialInertiaReadOnly)expected, (SpatialInertiaReadOnly)actual, (double)1.0E-12);
            actual = new SpatialInertia((SpatialInertiaReadOnly)expected);
            expected.applyTransform((RigidBodyTransformReadOnly)transform);
            actual.applyTransform((RigidBodyTransformReadOnly)new Pose3D((RigidBodyTransformReadOnly)transform));
            MecanoTestTools.assertSpatialInertiaEquals((SpatialInertiaReadOnly)expected, (SpatialInertiaReadOnly)actual, (double)1.0E-12);
        }
    }

    private static void assertEigenValuesPositiveAndEqual(Matrix3D matrix1, Matrix3D matrix2, double epsilon) {
        int i;
        DMatrixRMaj denseMatrix1 = new DMatrixRMaj(3, 3);
        matrix1.get((DMatrix)denseMatrix1);
        DMatrixRMaj denseMatrix2 = new DMatrixRMaj(3, 3);
        matrix2.get((DMatrix)denseMatrix2);
        EigenDecomposition_F64 eig1 = DecompositionFactory_DDRM.eig((int)3, (boolean)false);
        eig1.decompose((Matrix)denseMatrix1);
        double[] eigRealParts1 = new double[3];
        for (int i2 = 0; i2 < eig1.getNumberOfEigenvalues(); ++i2) {
            eigRealParts1[i2] = eig1.getEigenvalue(i2).getReal();
        }
        Arrays.sort(eigRealParts1);
        EigenDecomposition_F64 eig2 = DecompositionFactory_DDRM.eig((int)3, (boolean)false);
        eig2.decompose((Matrix)denseMatrix2);
        double[] eigRealParts2 = new double[3];
        for (i = 0; i < eig2.getNumberOfEigenvalues(); ++i) {
            eigRealParts2[i] = eig2.getEigenvalue(i).getReal();
        }
        Arrays.sort(eigRealParts2);
        for (i = 0; i < eig1.getNumberOfEigenvalues(); ++i) {
            Assertions.assertEquals((double)0.0, (double)eig1.getEigenvalue(i).getImaginary(), (double)epsilon);
            Assertions.assertEquals((double)0.0, (double)eig2.getEigenvalue(i).getImaginary(), (double)epsilon);
            Assertions.assertEquals((double)eigRealParts2[0], (double)eigRealParts2[0], (double)epsilon);
        }
    }

    private static double computeKineticCoEnergy(Twist twist, SpatialInertia inertia) {
        DMatrixRMaj twistMatrix = new DMatrixRMaj(6, 1);
        DMatrixRMaj inertiaMatrix = new DMatrixRMaj(6, 6);
        twist.get((DMatrix)twistMatrix);
        inertia.get((DMatrix)inertiaMatrix);
        DMatrixRMaj intermediate = new DMatrixRMaj(1, 6);
        CommonOps_DDRM.multTransA((DMatrix1Row)twistMatrix, (DMatrix1Row)inertiaMatrix, (DMatrix1Row)intermediate);
        DMatrixRMaj result = new DMatrixRMaj(1, 1);
        CommonOps_DDRM.mult((DMatrix1Row)intermediate, (DMatrix1Row)twistMatrix, (DMatrix1Row)result);
        return 0.5 * result.get(0);
    }

    private static Wrench computeWrench(SpatialAcceleration acceleration, SpatialInertia inertia) {
        acceleration.getReferenceFrame().checkReferenceFrameMatch(inertia.getReferenceFrame());
        DMatrixRMaj accelerationMatrix = new DMatrixRMaj(6, 1);
        DMatrixRMaj inertiaMatrix = new DMatrixRMaj(6, 6);
        acceleration.get((DMatrix)accelerationMatrix);
        inertia.get((DMatrix)inertiaMatrix);
        DMatrixRMaj wrenchMatrix = new DMatrixRMaj(6, 1);
        CommonOps_DDRM.mult((DMatrix1Row)inertiaMatrix, (DMatrix1Row)accelerationMatrix, (DMatrix1Row)wrenchMatrix);
        return new Wrench(acceleration.getBodyFrame(), acceleration.getReferenceFrame(), (DMatrix)wrenchMatrix);
    }

    private static DMatrixRMaj adjoint(RigidBodyTransform transform) {
        Matrix3D translationTilde = new Matrix3D();
        translationTilde.setToTildeForm((Tuple3DReadOnly)transform.getTranslation());
        DMatrixRMaj translationTildeDense = new DMatrixRMaj(3, 3);
        translationTilde.get((DMatrix)translationTildeDense);
        DMatrixRMaj rotationDense = new DMatrixRMaj(3, 3);
        transform.getRotation().get((DMatrix)rotationDense);
        DMatrixRMaj adjointMatrix = new DMatrixRMaj(6, 6);
        CommonOps_DDRM.insert((DMatrix)rotationDense, (DMatrix)adjointMatrix, (int)0, (int)0);
        DMatrixRMaj lowerLeft = new DMatrixRMaj(translationTildeDense.getNumRows(), rotationDense.getNumCols());
        CommonOps_DDRM.mult((DMatrix1Row)translationTildeDense, (DMatrix1Row)rotationDense, (DMatrix1Row)lowerLeft);
        CommonOps_DDRM.insert((DMatrix)lowerLeft, (DMatrix)adjointMatrix, (int)3, (int)0);
        CommonOps_DDRM.insert((DMatrix)rotationDense, (DMatrix)adjointMatrix, (int)3, (int)3);
        return adjointMatrix;
    }
}

