/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameNameRestrictionLevel;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;

public class MomentumTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @BeforeEach
    public void disableNameRestriction() {
        ReferenceFrame.getWorldFrame().setNameRestrictionLevel(FrameNameRestrictionLevel.NONE);
    }

    @Test
    public void testComputeKineticCoEnergy() {
        Random random = new Random(1776L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame baseFrame = ReferenceFrame.getWorldFrame();
            ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame expressedInFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialInertia spatialInertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)expressedInFrame);
            Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)baseFrame, (ReferenceFrame)expressedInFrame);
            double expected = spatialInertia.computeKineticCoEnergy((TwistReadOnly)twist);
            Momentum momentum = new Momentum(expressedInFrame);
            momentum.compute((SpatialInertiaReadOnly)spatialInertia, (TwistReadOnly)twist);
            double actual = momentum.computeKineticCoEnergy((TwistReadOnly)twist);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
    }
}

