/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.fourBar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameNameRestrictionLevel;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.fourBar.CrossFourBarTest;
import us.ihmc.mecano.fourBar.FourBar;
import us.ihmc.mecano.fourBar.FourBarAngle;
import us.ihmc.mecano.fourBar.FourBarKinematicLoopFunction;
import us.ihmc.mecano.fourBar.FourBarKinematicLoopFunctionTools;
import us.ihmc.mecano.fourBar.FourBarVertex;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class FourBarKinematicLoopFunctionTest {
    private static final int ITERATIONS = 1000;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double EPSILON = 1.0E-10;
    private static final String[] names = new String[]{"A", "B", "C", "D"};

    @BeforeEach
    public void disableNameRestriction() {
        ReferenceFrame.getWorldFrame().setNameRestrictionLevel(FrameNameRestrictionLevel.NONE);
    }

    @Test
    public void testConfigurationConvexFourBar() throws InterruptedException {
        Random random = new Random(78934678L);
        for (int i = 0; i < 1000; ++i) {
            boolean clockwise = random.nextBoolean();
            int actuatedJointIndex = random.nextInt(4);
            boolean flipAxesRandomly = true;
            boolean crossFourBar = false;
            FourBarKinematicLoopFunction fourBarKinematicLoop = this.nextFourBar(random, clockwise, actuatedJointIndex, flipAxesRandomly, crossFourBar);
            RevoluteJointBasics actuatedJoint = fourBarKinematicLoop.getActuatedJoint();
            FourBarVertices2D verticesZeroConfig = FourBarKinematicLoopFunctionTest.computeFourBarVertices2D(fourBarKinematicLoop);
            actuatedJoint.setQ(0.01);
            MultiBodySystemRandomTools.nextStateWithinJointLimits((Random)random, (JointStateType)JointStateType.CONFIGURATION, (OneDoFJointBasics)actuatedJoint);
            fourBarKinematicLoop.updateState(false, false);
            MultiBodySystemTools.getRootBody((RigidBodyBasics)actuatedJoint.getPredecessor()).updateFramesRecursively();
            FourBarVertices2D vertices = FourBarKinematicLoopFunctionTest.computeFourBarVertices2D(fourBarKinematicLoop);
            try {
                for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                    FourBarAngle fourBarAngle = FourBarAngle.values[vertexIndex];
                    FramePoint2D prev = vertices.getPrevious(vertexIndex);
                    FramePoint2D curr = vertices.get(vertexIndex);
                    FramePoint2D next = vertices.getNext(vertexIndex);
                    double expectedAngle = FourBarKinematicLoopFunctionTools.angleABC((Point2DReadOnly)prev, (Point2DReadOnly)curr, (Point2DReadOnly)next);
                    double actualAngle = fourBarKinematicLoop.getFourBar().getVertex(fourBarAngle).getAngle();
                    Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-10, (String)String.format("Iteration: %d. Interior angle at %s. Joint angle: %f. Error: %g", i, names[vertexIndex], actuatedJoint.getQ(), Math.abs(expectedAngle - actualAngle)));
                    double expectedLength = fourBarKinematicLoop.getFourBar().getVertex(fourBarAngle).getNextEdge().getLength();
                    double actualLength = curr.distance((FramePoint2DReadOnly)next);
                    Assertions.assertEquals((double)expectedLength, (double)actualLength, (double)1.0E-10, (String)String.format("Iteration: %d. Side %s%s. Joint angle: %f. Error: %g.", i, names[vertexIndex], names[(vertexIndex + 1) % 4], actuatedJoint.getQ(), Math.abs(expectedLength - actualLength)));
                    FourBarKinematicLoopFunctionTest.assertFourBarIsClosed(i, fourBarKinematicLoop);
                }
                continue;
            }
            catch (Throwable e) {
                LogTools.info((String)("Actuated joint: " + names[actuatedJointIndex]));
                LogTools.error((String)("\n\n" + e.getMessage() + "\n\n"));
                CrossFourBarTest.Viewer viewer = CrossFourBarTest.startupViewer();
                ArrayList<FramePoint2D> allVertices = new ArrayList<FramePoint2D>();
                allVertices.addAll(verticesZeroConfig.vertexList());
                allVertices.addAll(vertices.vertexList());
                viewer.updateFOV(allVertices);
                CrossFourBarTest.draw(viewer, verticesZeroConfig.vertexList());
                CrossFourBarTest.draw(viewer, vertices.vertexList(), "'");
                viewer.waitUntilClosed();
                throw e;
            }
        }
    }

    @Test
    public void testConfigurationCrossFourBar() throws InterruptedException {
        Random random = new Random(7834678L);
        for (int i = 0; i < 1000; ++i) {
            boolean clockwise = random.nextBoolean();
            int actuatedJointIndex = random.nextInt(4);
            boolean flipAxesRandomly = true;
            boolean crossFourBar = true;
            FourBarKinematicLoopFunction fourBarKinematicLoop = this.nextFourBar(random, clockwise, actuatedJointIndex, flipAxesRandomly, crossFourBar);
            FourBar fourBar = fourBarKinematicLoop.getFourBar();
            RevoluteJointBasics actuatedJoint = fourBarKinematicLoop.getActuatedJoint();
            FourBarVertices2D verticesZeroConfig = FourBarKinematicLoopFunctionTest.computeFourBarVertices2D(fourBarKinematicLoop);
            actuatedJoint.setQ(0.01);
            MultiBodySystemRandomTools.nextStateWithinJointLimits((Random)random, (JointStateType)JointStateType.CONFIGURATION, (OneDoFJointBasics)actuatedJoint);
            fourBarKinematicLoop.updateState(false, false);
            MultiBodySystemTools.getRootBody((RigidBodyBasics)actuatedJoint.getPredecessor()).updateFramesRecursively();
            FourBarVertices2D vertices = FourBarKinematicLoopFunctionTest.computeFourBarVertices2D(fourBarKinematicLoop);
            boolean reverse = false;
            if (FourBarKinematicLoopFunctionTools.angleABC((Point2DReadOnly)vertices.D, (Point2DReadOnly)vertices.A, (Point2DReadOnly)vertices.B) < 0.0 && fourBar.getVertex(FourBarAngle.DAB).isConvex()) {
                reverse = true;
            }
            try {
                for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                    FourBarAngle fourBarAngle = FourBarAngle.values[vertexIndex];
                    FramePoint2D prev = vertices.getPrevious(vertexIndex);
                    FramePoint2D curr = vertices.get(vertexIndex);
                    FramePoint2D next = vertices.getNext(vertexIndex);
                    FourBarVertex fourBarVertex = fourBar.getVertex(fourBarAngle);
                    double expectedAngle = FourBarKinematicLoopFunctionTools.angleABC((Point2DReadOnly)prev, (Point2DReadOnly)curr, (Point2DReadOnly)next);
                    if (reverse) {
                        expectedAngle = -expectedAngle;
                    }
                    double actualAngle = fourBarVertex.getAngle();
                    Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-10, (String)String.format("Iteration: %d. Interior angle at %s. Joint angle: %f. Error: %g", i, names[vertexIndex], actuatedJoint.getQ(), Math.abs(expectedAngle - actualAngle)));
                    double expectedLength = fourBarVertex.getNextEdge().getLength();
                    double actualLength = curr.distance((FramePoint2DReadOnly)next);
                    Assertions.assertEquals((double)expectedLength, (double)actualLength, (double)1.0E-10, (String)String.format("Iteration: %d. Side: %s%s. Joint angle: %f. Error: %g.", i, names[vertexIndex], names[(vertexIndex + 1) % 4], actuatedJoint.getQ(), Math.abs(expectedLength - actualLength)));
                    FourBarKinematicLoopFunctionTest.assertFourBarIsClosed(i, fourBarKinematicLoop);
                }
                continue;
            }
            catch (Throwable e) {
                LogTools.info((String)("\n-------------------\nActuated joint: " + names[actuatedJointIndex]));
                LogTools.error((String)"\n----------------------------------");
                LogTools.error((String)e.getMessage());
                LogTools.error((String)"-------------------------------------\n");
                CrossFourBarTest.Viewer viewer = CrossFourBarTest.startupViewer();
                ArrayList<FramePoint2D> allVertices = new ArrayList<FramePoint2D>();
                allVertices.addAll(verticesZeroConfig.vertexList());
                allVertices.addAll(vertices.vertexList());
                viewer.updateFOV(allVertices);
                CrossFourBarTest.draw(viewer, verticesZeroConfig.vertexList());
                CrossFourBarTest.draw(viewer, vertices.vertexList(), "'");
                viewer.waitUntilClosed();
                throw e;
            }
        }
    }

    @Test
    public void testLimitConfigurationCrossFourBar() {
        Random random = new Random(7834678L);
        for (int i = 0; i < 1000; ++i) {
            boolean clockwise = random.nextBoolean();
            int actuatedJointIndex = random.nextInt(4);
            boolean flipAxesRandomly = true;
            boolean crossFourBar = true;
            FourBarKinematicLoopFunction fourBarKinematicLoop = this.nextFourBar(random, clockwise, actuatedJointIndex, flipAxesRandomly, crossFourBar);
            FourBar fourBar = fourBarKinematicLoop.getFourBar();
            List joints = fourBarKinematicLoop.getLoopJoints();
            FourBarKinematicLoopFunctionTools.FourBarToJointConverter[] converters = fourBarKinematicLoop.getConverters();
            FourBarVertex[] vertices = new FourBarVertex[]{fourBar.getVertexA(), fourBar.getVertexB(), fourBar.getVertexC(), fourBar.getVertexD()};
            for (int j = 0; j < 4; ++j) {
                RevoluteJointBasics joint = (RevoluteJointBasics)joints.get(j);
                FourBarKinematicLoopFunctionTools.FourBarToJointConverter converter = converters[j];
                FourBarVertex vertex = vertices[j];
                Supplier<String> messageSupplier = () -> "Failed for :" + joint.getName();
                if (converter.getSign() > 0.0) {
                    Assertions.assertEquals((double)joint.getJointLimitLower(), (double)converter.toJointAngle(vertex.getMinAngle()), messageSupplier);
                    Assertions.assertEquals((double)joint.getJointLimitUpper(), (double)converter.toJointAngle(vertex.getMaxAngle()), messageSupplier);
                    continue;
                }
                Assertions.assertEquals((double)joint.getJointLimitLower(), (double)converter.toJointAngle(vertex.getMaxAngle()), messageSupplier);
                Assertions.assertEquals((double)joint.getJointLimitUpper(), (double)converter.toJointAngle(vertex.getMinAngle()), messageSupplier);
            }
            RevoluteJointBasics joint = fourBarKinematicLoop.getActuatedJoint();
            FourBarKinematicLoopFunctionTools.FourBarToJointConverter converter = converters[fourBarKinematicLoop.getActuatedJointIndex()];
            FourBarVertex vertex = fourBarKinematicLoop.getActuatedVertex();
            Supplier<String> messageSupplier = () -> "Failed for :" + joint.getName();
            if (converter.getSign() > 0.0) {
                Assertions.assertEquals((double)joint.getJointLimitLower(), (double)converter.toJointAngle(vertex.getMinAngle()), messageSupplier);
                Assertions.assertEquals((double)joint.getJointLimitUpper(), (double)converter.toJointAngle(vertex.getMaxAngle()), messageSupplier);
                continue;
            }
            Assertions.assertEquals((double)joint.getJointLimitLower(), (double)converter.toJointAngle(vertex.getMaxAngle()), messageSupplier);
            Assertions.assertEquals((double)joint.getJointLimitUpper(), (double)converter.toJointAngle(vertex.getMinAngle()), messageSupplier);
        }
        FourBarKinematicLoopFunction fourBarKinematicLoop = this.createFourBarExample1(random, 0, false);
        FourBar fourBar = fourBarKinematicLoop.getFourBar();
        List joints = fourBarKinematicLoop.getLoopJoints();
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter[] converters = fourBarKinematicLoop.getConverters();
        FourBarVertex[] vertices = new FourBarVertex[]{fourBar.getVertexA(), fourBar.getVertexB(), fourBar.getVertexC(), fourBar.getVertexD()};
        for (int j = 0; j < 4; ++j) {
            RevoluteJointBasics joint = (RevoluteJointBasics)joints.get(j);
            FourBarKinematicLoopFunctionTools.FourBarToJointConverter converter = converters[j];
            FourBarVertex vertex = vertices[j];
            Supplier<String> messageSupplier = () -> "Failed for :" + joint.getName();
            if (converter.getSign() > 0.0) {
                Assertions.assertEquals((double)joint.getJointLimitLower(), (double)converter.toJointAngle(vertex.getMinAngle()), messageSupplier);
                Assertions.assertEquals((double)joint.getJointLimitUpper(), (double)converter.toJointAngle(vertex.getMaxAngle()), messageSupplier);
                continue;
            }
            Assertions.assertEquals((double)joint.getJointLimitLower(), (double)converter.toJointAngle(vertex.getMaxAngle()), messageSupplier);
            Assertions.assertEquals((double)joint.getJointLimitUpper(), (double)converter.toJointAngle(vertex.getMinAngle()), messageSupplier);
        }
        RevoluteJointBasics joint = fourBarKinematicLoop.getActuatedJoint();
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converter = converters[fourBarKinematicLoop.getActuatedJointIndex()];
        FourBarVertex vertex = fourBarKinematicLoop.getActuatedVertex();
        Supplier<String> messageSupplier = () -> "Failed for :" + joint.getName();
        if (converter.getSign() > 0.0) {
            Assertions.assertEquals((double)joint.getJointLimitLower(), (double)converter.toJointAngle(vertex.getMinAngle()), messageSupplier);
            Assertions.assertEquals((double)joint.getJointLimitUpper(), (double)converter.toJointAngle(vertex.getMaxAngle()), messageSupplier);
        } else {
            Assertions.assertEquals((double)joint.getJointLimitLower(), (double)converter.toJointAngle(vertex.getMaxAngle()), messageSupplier);
            Assertions.assertEquals((double)joint.getJointLimitUpper(), (double)converter.toJointAngle(vertex.getMinAngle()), messageSupplier);
        }
    }

    private static void assertFourBarIsClosed(int iteration, FourBarKinematicLoopFunction fourBarKinematicLoop) {
        RevoluteJointBasics closingJoint = null;
        if (fourBarKinematicLoop.getJointA().isLoopClosure()) {
            closingJoint = fourBarKinematicLoop.getJointA();
        } else if (fourBarKinematicLoop.getJointB().isLoopClosure()) {
            closingJoint = fourBarKinematicLoop.getJointB();
        } else if (fourBarKinematicLoop.getJointC().isLoopClosure()) {
            closingJoint = fourBarKinematicLoop.getJointC();
        } else if (fourBarKinematicLoop.getJointD().isLoopClosure()) {
            closingJoint = fourBarKinematicLoop.getJointD();
        }
        Assertions.assertNotNull((Object)closingJoint);
        FramePoint3D error = new FramePoint3D((ReferenceFrame)closingJoint.getLoopClosureFrame());
        error.changeFrame((ReferenceFrame)closingJoint.getSuccessor().getParentJoint().getFrameAfterJoint());
        Assertions.assertEquals((double)0.0, (double)error.distanceFromOrigin(), (double)1.0E-10, (String)("Iteration: " + iteration));
    }

    private static FourBarVertices2D computeFourBarVertices2D(FourBarKinematicLoopFunction fourBarKinematicLoop) {
        RevoluteJointBasics jointA = fourBarKinematicLoop.getJointA();
        RevoluteJointBasics jointB = fourBarKinematicLoop.getJointB();
        RevoluteJointBasics jointC = fourBarKinematicLoop.getJointC();
        RevoluteJointBasics jointD = fourBarKinematicLoop.getJointD();
        RevoluteJointBasics actuatedJoint = fourBarKinematicLoop.getActuatedJoint();
        MultiBodySystemTools.getRootBody((RigidBodyBasics)actuatedJoint.getPredecessor()).updateFramesRecursively();
        ReferenceFrame fourBarLocalFrame = FourBarKinematicLoopFunctionTools.constructReferenceFrameFromPointAndAxis((String)"LocalFrame", (FramePoint3DReadOnly)new FramePoint3D((ReferenceFrame)actuatedJoint.getFrameBeforeJoint()), (Axis3D)Axis3D.Z, (FrameVector3DReadOnly)actuatedJoint.getJointAxis());
        FourBarVertices2D vertices = new FourBarVertices2D();
        vertices.setToZero(fourBarLocalFrame);
        vertices.setFromReferenceFrame((ReferenceFrame)jointA.getFrameAfterJoint(), (ReferenceFrame)jointB.getFrameAfterJoint(), (ReferenceFrame)jointC.getFrameAfterJoint(), (ReferenceFrame)jointD.getFrameAfterJoint());
        return vertices;
    }

    public FourBarKinematicLoopFunction nextFourBar(Random random, boolean clockwise, int actuatedJointIndex, boolean flipAxesRandomly, boolean crossFourBar) {
        List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)5.0, (int)4);
        if (crossFourBar) {
            int flippedIndex = random.nextInt(4);
            Collections.swap(vertices, flippedIndex, (flippedIndex + 1) % 4);
        }
        if (!clockwise) {
            Collections.reverse(vertices);
        }
        Point2D A = (Point2D)vertices.get(0);
        Point2D B = (Point2D)vertices.get(1);
        Point2D C = (Point2D)vertices.get(2);
        Point2D D = (Point2D)vertices.get(3);
        return this.nextFourBar(random, A, B, C, D, actuatedJointIndex, flipAxesRandomly);
    }

    public FourBarKinematicLoopFunction createFourBarExample1(Random random, int actuatedJointIndex, boolean flipAxesRandomly) {
        Point2D A = new Point2D(0.227, 0.1);
        Point2D B = new Point2D(0.227, -0.1);
        Point2D C = new Point2D(0.427, 0.1);
        Point2D D = new Point2D(0.427, -0.1);
        return this.nextFourBar(random, A, B, C, D, actuatedJointIndex, flipAxesRandomly);
    }

    private FourBarKinematicLoopFunction nextFourBar(Random random, Point2D A, Point2D B, Point2D C, Point2D D, int actuatedJointIndex, boolean flipAxesRandomly) {
        Vector2D AB = new Vector2D();
        Vector2D AC = new Vector2D();
        Vector2D AD = new Vector2D();
        AB.sub((Tuple2DReadOnly)B, (Tuple2DReadOnly)A);
        AC.sub((Tuple2DReadOnly)C, (Tuple2DReadOnly)A);
        AD.sub((Tuple2DReadOnly)D, (Tuple2DReadOnly)A);
        UnitVector3D commonAxis = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
        Vector3D axisA = new Vector3D((Tuple3DReadOnly)commonAxis);
        Vector3D axisB = new Vector3D((Tuple3DReadOnly)commonAxis);
        Vector3D axisC = new Vector3D((Tuple3DReadOnly)commonAxis);
        Vector3D axisD = new Vector3D((Tuple3DReadOnly)commonAxis);
        FramePoint3D jointAPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame fourBarLocalFrame = FourBarKinematicLoopFunctionTools.constructReferenceFrameFromPointAndAxis((String)"LocalFrame", (FramePoint3DReadOnly)jointAPosition, (Axis3D)Axis3D.Z, (FrameVector3DReadOnly)new FrameVector3D(worldFrame, (Tuple3DReadOnly)commonAxis));
        FramePoint3D jointBPosition = new FramePoint3D(fourBarLocalFrame, (Tuple2DReadOnly)AB);
        jointBPosition.setZ(EuclidCoreRandomTools.nextDouble((Random)random));
        jointBPosition.changeFrame(worldFrame);
        FramePoint3D jointCPosition = new FramePoint3D(fourBarLocalFrame, (Tuple2DReadOnly)AC);
        jointCPosition.setZ(EuclidCoreRandomTools.nextDouble((Random)random));
        jointCPosition.changeFrame(worldFrame);
        FramePoint3D jointDPosition = new FramePoint3D(fourBarLocalFrame, (Tuple2DReadOnly)AD);
        jointDPosition.setZ(EuclidCoreRandomTools.nextDouble((Random)random));
        jointDPosition.changeFrame(worldFrame);
        if (flipAxesRandomly) {
            if (actuatedJointIndex != 0 && random.nextBoolean()) {
                axisA.negate();
            }
            if (actuatedJointIndex != 1 && random.nextBoolean()) {
                axisB.negate();
            }
            if (actuatedJointIndex != 2 && random.nextBoolean()) {
                axisC.negate();
            }
            if (actuatedJointIndex != 3 && random.nextBoolean()) {
                axisD.negate();
            }
        }
        RigidBody rootBody = new RigidBody("root", worldFrame);
        RevoluteJoint jointA = new RevoluteJoint("jointA", (RigidBodyBasics)rootBody, (Tuple3DReadOnly)jointAPosition, (Vector3DReadOnly)axisA);
        RevoluteJoint jointB = new RevoluteJoint("jointB", (RigidBodyBasics)rootBody, (Tuple3DReadOnly)jointBPosition, (Vector3DReadOnly)axisB);
        RigidBody bodyDA = new RigidBody("bodyDA", (JointBasics)jointA, 0.0, 0.0, 0.0, 0.0, (Tuple3DReadOnly)new Vector3D());
        RigidBody bodyBC = new RigidBody("bodyBC", (JointBasics)jointB, 0.0, 0.0, 0.0, 0.0, (Tuple3DReadOnly)new Vector3D());
        jointCPosition.changeFrame((ReferenceFrame)jointB.getFrameAfterJoint());
        RevoluteJoint jointC = new RevoluteJoint("jointC", (RigidBodyBasics)bodyBC, (Tuple3DReadOnly)jointCPosition, (Vector3DReadOnly)axisC);
        jointDPosition.changeFrame((ReferenceFrame)jointA.getFrameAfterJoint());
        RevoluteJoint jointD = new RevoluteJoint("jointD", (RigidBodyBasics)bodyDA, (Tuple3DReadOnly)jointDPosition, (Vector3DReadOnly)axisD);
        RigidBody bodyCD = new RigidBody("bodyCD", (JointBasics)jointD, 0.0, 0.0, 0.0, 0.0, (Tuple3DReadOnly)new Vector3D());
        jointCPosition.changeFrame((ReferenceFrame)jointD.getFrameAfterJoint());
        jointC.setupLoopClosure((RigidBodyBasics)bodyCD, (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)jointCPosition));
        ArrayList<RevoluteJoint> joints = new ArrayList<RevoluteJoint>(Arrays.asList(jointA, jointB, jointC, jointD));
        Collections.shuffle(joints, random);
        return new FourBarKinematicLoopFunction("fourBar", joints, actuatedJointIndex);
    }

    private static class FourBarVertices2D {
        private final FramePoint2D A = new FramePoint2D();
        private final FramePoint2D B = new FramePoint2D();
        private final FramePoint2D C = new FramePoint2D();
        private final FramePoint2D D = new FramePoint2D();
        private final List<FramePoint2D> vertexList = Arrays.asList(this.A, this.B, this.C, this.D);

        private FourBarVertices2D() {
        }

        FramePoint2D get(int index) {
            return this.vertexList.get(index);
        }

        FramePoint2D getPrevious(int index) {
            return this.vertexList.get((index + 3) % 4);
        }

        FramePoint2D getNext(int index) {
            return this.vertexList.get((index + 1) % 4);
        }

        void setToZero(ReferenceFrame referenceFrame) {
            this.A.setToZero(referenceFrame);
            this.B.setToZero(referenceFrame);
            this.C.setToZero(referenceFrame);
            this.D.setToZero(referenceFrame);
        }

        void setFromReferenceFrame(ReferenceFrame frameA, ReferenceFrame frameB, ReferenceFrame frameC, ReferenceFrame frameD) {
            FramePoint3D A3D = new FramePoint3D(frameA);
            FramePoint3D B3D = new FramePoint3D(frameB);
            FramePoint3D C3D = new FramePoint3D(frameC);
            FramePoint3D D3D = new FramePoint3D(frameD);
            A3D.changeFrame(this.A.getReferenceFrame());
            B3D.changeFrame(this.D.getReferenceFrame());
            C3D.changeFrame(this.C.getReferenceFrame());
            D3D.changeFrame(this.D.getReferenceFrame());
            this.A.set((FrameTuple3DReadOnly)A3D);
            this.B.set((FrameTuple3DReadOnly)B3D);
            this.C.set((FrameTuple3DReadOnly)C3D);
            this.D.set((FrameTuple3DReadOnly)D3D);
        }

        List<FramePoint2D> vertexList() {
            return this.vertexList;
        }
    }
}

