/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.algorithms.MultiBodyResponseCalculator;
import us.ihmc.mecano.algorithms.SpatialAccelerationCalculator;
import us.ihmc.mecano.algorithms.TablePrinter;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialImpulse;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class MultiBodyResponseCalculatorTest {
    private static final int ITERATIONS = 500;
    private static final double EPSILON = 1.0E-12;
    private static final double JOINT_EPSILON = 1.0E-9;

    @Test
    public void testSpatialAccelerationIntegration() {
        Random random = new Random(4757L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        for (int i = 0; i < 500; ++i) {
            double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-20.0, (double)-1.0);
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)0.01);
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            for (JointStateType state : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, (Iterable)joints);
            }
            RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((OneDoFJoint)joints.get(0)).getPredecessor());
            rootBody.updateFramesRecursively();
            boolean considerVelocities = false;
            SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)rootBody, worldFrame, considerVelocities);
            spatialAccelerationCalculator.setGravitionalAcceleration(gravity);
            RigidBodyBasics rigidBody = ((OneDoFJoint)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            Twist bodyTwistOld = new Twist((SpatialMotionReadOnly)rigidBody.getBodyFixedFrame().getTwistOfFrame());
            Twist bodyAccelerationIntegrated = new Twist((SpatialMotionReadOnly)spatialAccelerationCalculator.getRelativeAcceleration((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)rigidBody));
            bodyAccelerationIntegrated.scale(dt);
            Twist bodyTwistNewActual = new Twist((SpatialMotionReadOnly)bodyTwistOld);
            bodyTwistNewActual.add((SpatialVectorReadOnly)bodyAccelerationIntegrated);
            joints.forEach(joint -> joint.setQd(joint.getQd() + dt * joint.getQdd()));
            rootBody.updateFramesRecursively();
            TwistReadOnly bodyTwistNewExpected = rigidBody.getBodyFixedFrame().getTwistOfFrame();
            MecanoTestTools.assertTwistEquals((String)("Iteration " + i), (TwistReadOnly)bodyTwistNewExpected, (TwistReadOnly)bodyTwistNewActual, (double)1.0E-12);
        }
    }

    @Test
    public void testPrismaticJointChain() {
        Random random = new Random(435346L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextPrismaticJointChain((Random)random, (int)numberOfJoints);
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)0.01);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentLinearInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertJointApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleWrenches(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleImpulses(random, i, joints, 1.0E-12);
        }
    }

    @Test
    public void testPrismaticJointTree() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextPrismaticJointTree((Random)random, (int)numberOfJoints);
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)0.01);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentLinearInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertJointApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleWrenches(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleImpulses(random, i, joints, 1.0E-12);
        }
    }

    @Test
    public void testRevoluteJointChain() throws Exception {
        Random random = new Random(2654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)0.01);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentLinearInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertJointApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleWrenches(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleImpulses(random, i, joints, 1.0E-12);
        }
    }

    @Test
    public void testRevoluteJointTree() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextRevoluteJointTree((Random)random, (int)numberOfJoints);
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)0.01);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentLinearInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertJointApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleWrenches(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleImpulses(random, i, joints, 1.0E-12);
        }
    }

    @Test
    public void testOneDoFJointChain() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)0.01);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentLinearInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertJointApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleWrenches(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleImpulses(random, i, joints, 1.0E-12);
        }
    }

    @Test
    public void testOneDoFJointTree() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)numberOfJoints);
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)0.01);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentLinearInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertJointApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleWrenches(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleImpulses(random, i, joints, 1.0E-12);
        }
    }

    @Test
    public void testFloatingRevoluteJointChain() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(40) + 1;
            List joints = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, numberOfJoints).getJoints();
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)0.01);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentLinearInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointWrench(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulseViaIntegration(random, i, joints, dt, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertJointApparentInertiaInverse(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleWrenches(random, i, joints, 1.0E-12);
            MultiBodyResponseCalculatorTest.assertApplyMultipleImpulses(random, i, joints, 1.0E-12);
        }
    }

    @Test
    public void testJointChain() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(20) + 1;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)0.01);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyWrench(random, i, joints, 1.0E-9);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulse(random, i, joints, 1.0E-9);
            MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulseViaIntegration(random, i, joints, dt, 1.0E-9);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentInertiaInverse(random, i, joints, 1.0E-9);
            MultiBodyResponseCalculatorTest.assertRigidBodyApparentLinearInertiaInverse(random, i, joints, 1.0E-9);
            MultiBodyResponseCalculatorTest.assertApplySingleJointWrench(random, i, joints, 1.0E-9);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulse(random, i, joints, 1.0E-9);
            MultiBodyResponseCalculatorTest.assertApplySingleJointImpulseViaIntegration(random, i, joints, dt, 1.0E-9);
            MultiBodyResponseCalculatorTest.assertJointApparentInertiaInverse(random, i, joints, 1.0E-9);
            MultiBodyResponseCalculatorTest.assertApplyMultipleWrenches(random, i, joints, 1.0E-9);
            MultiBodyResponseCalculatorTest.assertApplyMultipleImpulses(random, i, joints, 1.0E-9);
        }
    }

    private static void assertApplySingleRigidBodyWrench(Random random, int iteration, List<? extends JointBasics> joints, double epsilon) {
        MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyWrench(random, iteration, joints, Collections.emptyMap(), Collections.emptyList(), epsilon);
    }

    private static void assertApplySingleRigidBodyWrench(Random random, int iteration, List<? extends JointBasics> joints, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        for (JointStateType state : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, joints);
        }
        RigidBodyBasics target = joints.get(random.nextInt(joints.size())).getSuccessor();
        Wrench testWrench = MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)target.getBodyFixedFrame(), (ReferenceFrame)target.getBodyFixedFrame());
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        ForwardDynamicsCalculator forwardDynamicsCalculator = MultiBodyResponseCalculatorTest.setupForwardDynamicsCalculator(multiBodySystemInput, gravity, externalWrenches, Collections.singletonMap(target, testWrench), Collections.emptyMap());
        MultiBodyResponseCalculator multiBodyResponseCalculator = MultiBodyResponseCalculatorTest.setupMultiBodyResponseCalculator(multiBodySystemInput, gravity, externalWrenches);
        multiBodyResponseCalculator.applyRigidBodyWrench((RigidBodyReadOnly)target, (WrenchReadOnly)testWrench);
        MultiBodyResponseCalculatorTest.runAssertionsViaAccelerationProvider(random, iteration, joints, epsilon, forwardDynamicsCalculator, multiBodyResponseCalculator);
        DMatrixRMaj qdd_expected = forwardDynamicsCalculator.getJointAccelerationMatrix();
        DMatrixRMaj qdd_original = multiBodyResponseCalculator.getForwardDynamicsCalculator().getJointAccelerationMatrix();
        DMatrixRMaj qdd_change = multiBodyResponseCalculator.propagateWrench();
        MultiBodyResponseCalculatorTest.assertJointAccelerationMatrixEquals(multiBodySystemInput, iteration, qdd_expected, qdd_original, qdd_change, Math.max(1.0, CommonOps_DDRM.elementMaxAbs((DMatrixD1)qdd_expected)) * epsilon);
    }

    private static void assertApplySingleRigidBodyImpulse(Random random, int iteration, List<? extends JointBasics> joints, double epsilon) {
        MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulse(random, iteration, joints, Collections.emptyMap(), Collections.emptyList(), epsilon);
    }

    private static void assertApplySingleRigidBodyImpulse(Random random, int iteration, List<? extends JointBasics> joints, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        for (JointStateType state : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, joints);
        }
        RigidBodyBasics target = joints.get(random.nextInt(joints.size())).getSuccessor();
        SpatialImpulse testImpulse = MecanoRandomTools.nextSpatialImpulse((Random)random, (ReferenceFrame)target.getBodyFixedFrame(), (ReferenceFrame)target.getBodyFixedFrame());
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        ForwardDynamicsCalculator forwardDynamicsCalculator = MultiBodyResponseCalculatorTest.setupForwardDynamicsCalculator(multiBodySystemInput, gravity, externalWrenches, Collections.singletonMap(target, testImpulse), Collections.emptyMap());
        MultiBodyResponseCalculator multiBodyResponseCalculator = MultiBodyResponseCalculatorTest.setupMultiBodyResponseCalculator(multiBodySystemInput, gravity, externalWrenches);
        multiBodyResponseCalculator.applyRigidBodyImpulse((RigidBodyReadOnly)target, (SpatialImpulseReadOnly)testImpulse);
        MultiBodyResponseCalculatorTest.runAssertionViaTwistProvider(random, iteration, joints, epsilon, forwardDynamicsCalculator, multiBodyResponseCalculator);
        DMatrixRMaj qdd_expected = forwardDynamicsCalculator.getJointAccelerationMatrix();
        DMatrixRMaj qdd_original = multiBodyResponseCalculator.getForwardDynamicsCalculator().getJointAccelerationMatrix();
        DMatrixRMaj qdd_change = multiBodyResponseCalculator.propagateImpulse();
        MultiBodyResponseCalculatorTest.assertJointAccelerationMatrixEquals(multiBodySystemInput, iteration, qdd_expected, qdd_original, qdd_change, Math.max(1.0, CommonOps_DDRM.elementMaxAbs((DMatrixD1)qdd_expected)) * epsilon);
    }

    private static void assertApplySingleRigidBodyImpulseViaIntegration(Random random, int iteration, List<? extends JointBasics> joints, double dt, double epsilon) {
        MultiBodyResponseCalculatorTest.assertApplySingleRigidBodyImpulseViaIntegration(random, iteration, joints, dt, Collections.emptyMap(), Collections.emptyList(), epsilon);
    }

    private static void assertApplySingleRigidBodyImpulseViaIntegration(Random random, int iteration, List<? extends JointBasics> joints, double dt, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        for (JointStateType state : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, joints);
        }
        int numberOfDoFs = joints.stream().mapToInt(JointReadOnly::getDegreesOfFreedom).sum();
        DMatrixRMaj qd_original = new DMatrixRMaj(numberOfDoFs, 1);
        MultiBodySystemTools.extractJointsState(joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)qd_original);
        RigidBodyBasics target = joints.get(random.nextInt(joints.size())).getSuccessor();
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        Wrench externalWrench = MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)target.getBodyFixedFrame(), (ReferenceFrame)target.getBodyFixedFrame(), (double)1000.0, (double)1000.0);
        SpatialImpulse externalImpulse = new SpatialImpulse((ReferenceFrame)target.getBodyFixedFrame(), (SpatialVectorReadOnly)externalWrench);
        externalImpulse.scale(dt);
        ForwardDynamicsCalculator forwardDynamicsCalculator = MultiBodyResponseCalculatorTest.setupForwardDynamicsCalculator(multiBodySystemInput, gravity, externalWrenches, Collections.singletonMap(target, externalWrench), Collections.emptyMap());
        MultiBodyResponseCalculator multiBodyResponseCalculator = MultiBodyResponseCalculatorTest.setupMultiBodyResponseCalculator(multiBodySystemInput, gravity, externalWrenches);
        multiBodyResponseCalculator.applyRigidBodyImpulse((RigidBodyReadOnly)target, (SpatialImpulseReadOnly)externalImpulse);
        DMatrixRMaj qdd = forwardDynamicsCalculator.getJointAccelerationMatrix();
        DMatrixRMaj qd_expected = new DMatrixRMaj(numberOfDoFs, 1);
        CommonOps_DDRM.add((DMatrixD1)qd_original, (double)dt, (DMatrixD1)qdd, (DMatrixD1)qd_expected);
        DMatrixRMaj qd_change = multiBodyResponseCalculator.propagateImpulse();
        DMatrixRMaj qd_noImpulse = new DMatrixRMaj(numberOfDoFs, 1);
        CommonOps_DDRM.add((DMatrixD1)qd_original, (double)dt, (DMatrixD1)multiBodyResponseCalculator.getForwardDynamicsCalculator().getJointAccelerationMatrix(), (DMatrixD1)qd_noImpulse);
        MultiBodyResponseCalculatorTest.assertJointAccelerationMatrixEquals(multiBodySystemInput, iteration, qd_expected, qd_noImpulse, qd_change, epsilon);
        TwistReadOnly targetTwistChangeActual = multiBodyResponseCalculator.getTwistChangeProvider().getTwistOfBody((RigidBodyReadOnly)target);
        Twist targetTwistOld = new Twist((SpatialMotionReadOnly)target.getBodyFixedFrame().getTwistOfFrame());
        Twist targetAccelerationIntegrated = new Twist((SpatialMotionReadOnly)multiBodyResponseCalculator.getForwardDynamicsCalculator().getAccelerationProvider(false).getRelativeAcceleration((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)target));
        targetAccelerationIntegrated.scale(dt);
        Twist targetTwistNewActual = new Twist((SpatialMotionReadOnly)targetTwistOld);
        targetTwistNewActual.add((SpatialVectorReadOnly)targetAccelerationIntegrated);
        targetTwistNewActual.add((SpatialVectorReadOnly)targetTwistChangeActual);
        MultiBodySystemTools.insertJointsState(joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)qd_expected);
        rootBody.updateFramesRecursively();
        TwistReadOnly targetTwistNewExpected = target.getBodyFixedFrame().getTwistOfFrame();
        Twist targetTwistChangeExpected = new Twist((SpatialMotionReadOnly)targetTwistNewExpected);
        targetTwistChangeExpected.sub((SpatialVectorReadOnly)targetAccelerationIntegrated);
        targetTwistChangeExpected.sub((SpatialVectorReadOnly)targetTwistOld);
        MecanoTestTools.assertTwistEquals((String)("Iteration: " + iteration), (TwistReadOnly)targetTwistChangeExpected, (TwistReadOnly)targetTwistChangeActual, (double)epsilon);
        MecanoTestTools.assertTwistEquals((String)("Iteration: " + iteration), (TwistReadOnly)targetTwistNewExpected, (TwistReadOnly)targetTwistNewActual, (double)epsilon);
    }

    private static void assertRigidBodyApparentInertiaInverse(Random random, int iteration, List<? extends JointBasics> joints, double epsilon) {
        MultiBodyResponseCalculatorTest.assertRigidBodyApparentInertiaInverse(random, iteration, joints, Collections.emptyMap(), Collections.emptyList(), epsilon);
    }

    private static void assertRigidBodyApparentInertiaInverse(Random random, int iteration, List<? extends JointBasics> joints, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        for (JointStateType state : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, joints);
        }
        RigidBodyBasics target = joints.get(random.nextInt(joints.size())).getSuccessor();
        ReferenceFrame testWrenchFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (ReferenceFrame)target.getBodyFixedFrame());
        Wrench testWrench = MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)target.getBodyFixedFrame(), (ReferenceFrame)testWrenchFrame);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        MultiBodyResponseCalculator multiBodyResponseCalculator = MultiBodyResponseCalculatorTest.setupMultiBodyResponseCalculator(multiBodySystemInput, gravity, externalWrenches);
        DMatrixRMaj apparentSpatialInertiaInverse = new DMatrixRMaj(6, 6);
        multiBodyResponseCalculator.computeRigidBodyApparentSpatialInertiaInverse((RigidBodyReadOnly)target, testWrenchFrame, (DMatrix1Row)apparentSpatialInertiaInverse);
        DMatrixRMaj accelerationChangeMatrix = new DMatrixRMaj(6, 1);
        DMatrixRMaj testWrenchMatrix = new DMatrixRMaj(6, 1);
        testWrench.get((DMatrix)testWrenchMatrix);
        CommonOps_DDRM.mult((DMatrix1Row)apparentSpatialInertiaInverse, (DMatrix1Row)testWrenchMatrix, (DMatrix1Row)accelerationChangeMatrix);
        SpatialAcceleration actualAccelerationChange = new SpatialAcceleration((ReferenceFrame)target.getBodyFixedFrame(), ReferenceFrame.getWorldFrame(), testWrenchFrame, (DMatrix)accelerationChangeMatrix);
        actualAccelerationChange.changeFrame((ReferenceFrame)target.getBodyFixedFrame());
        multiBodyResponseCalculator.applyRigidBodyWrench((RigidBodyReadOnly)target, (WrenchReadOnly)testWrench);
        SpatialAcceleration expectedAccelerationChange = new SpatialAcceleration((SpatialMotionReadOnly)multiBodyResponseCalculator.getAccelerationChangeProvider().getAccelerationOfBody((RigidBodyReadOnly)target));
        MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedAccelerationChange, (SpatialAccelerationReadOnly)actualAccelerationChange, (double)(Math.max(1.0, expectedAccelerationChange.length()) * epsilon));
    }

    private static void assertRigidBodyApparentLinearInertiaInverse(Random random, int iteration, List<? extends JointBasics> joints, double epsilon) {
        MultiBodyResponseCalculatorTest.assertRigidBodyApparentLinearInertiaInverse(random, iteration, joints, Collections.emptyMap(), Collections.emptyList(), epsilon);
    }

    private static void assertRigidBodyApparentLinearInertiaInverse(Random random, int iteration, List<? extends JointBasics> joints, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        for (JointStateType state : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, joints);
        }
        RigidBodyBasics target = joints.get(random.nextInt(joints.size())).getSuccessor();
        ReferenceFrame testWrenchFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (ReferenceFrame)target.getBodyFixedFrame());
        Wrench testWrench = MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)target.getBodyFixedFrame(), (ReferenceFrame)testWrenchFrame);
        testWrench.getAngularPart().setToZero();
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        MultiBodyResponseCalculator multiBodyResponseCalculator = MultiBodyResponseCalculatorTest.setupMultiBodyResponseCalculator(multiBodySystemInput, gravity, externalWrenches);
        DMatrixRMaj apparentSpatialInertiaInverse = new DMatrixRMaj(3, 3);
        multiBodyResponseCalculator.computeRigidBodyApparentLinearInertiaInverse((RigidBodyReadOnly)target, testWrenchFrame, (DMatrix1Row)apparentSpatialInertiaInverse);
        DMatrixRMaj accelerationChangeMatrix = new DMatrixRMaj(3, 1);
        DMatrixRMaj testWrenchMatrix = new DMatrixRMaj(3, 1);
        testWrench.getLinearPart().get((DMatrix)testWrenchMatrix);
        CommonOps_DDRM.mult((DMatrix1Row)apparentSpatialInertiaInverse, (DMatrix1Row)testWrenchMatrix, (DMatrix1Row)accelerationChangeMatrix);
        FrameVector3D actualLinearAccelerationChange = new FrameVector3D(testWrenchFrame);
        actualLinearAccelerationChange.set((DMatrix)accelerationChangeMatrix);
        multiBodyResponseCalculator.applyRigidBodyWrench((RigidBodyReadOnly)target, (WrenchReadOnly)testWrench);
        SpatialAcceleration expectedAccelerationChange = new SpatialAcceleration((SpatialMotionReadOnly)multiBodyResponseCalculator.getAccelerationChangeProvider().getAccelerationOfBody((RigidBodyReadOnly)target));
        expectedAccelerationChange.changeFrame(testWrenchFrame);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedAccelerationChange.getLinearPart(), (EuclidFrameGeometry)actualLinearAccelerationChange, (double)(Math.max(1.0, expectedAccelerationChange.getLinearPart().norm()) * epsilon));
    }

    private static void assertApplySingleJointWrench(Random random, int iteration, List<? extends JointBasics> joints, double epsilon) {
        MultiBodyResponseCalculatorTest.assertApplySingleJointWrench(random, iteration, joints, Collections.emptyMap(), Collections.emptyList(), epsilon);
    }

    private static void assertApplySingleJointWrench(Random random, int iteration, List<? extends JointBasics> joints, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        for (JointStateType state : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, joints);
        }
        JointBasics target = joints.get(random.nextInt(joints.size()));
        DMatrixRMaj testJointWrench = RandomMatrices_DDRM.rectangle((int)target.getDegreesOfFreedom(), (int)1, (double)-10.0, (double)10.0, (Random)random);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        ForwardDynamicsCalculator forwardDynamicsCalculator = MultiBodyResponseCalculatorTest.setupForwardDynamicsCalculator(multiBodySystemInput, gravity, externalWrenches, Collections.emptyMap(), Collections.singletonMap(target, testJointWrench));
        MultiBodyResponseCalculator multiBodyResponseCalculator = MultiBodyResponseCalculatorTest.setupMultiBodyResponseCalculator(multiBodySystemInput, gravity, externalWrenches);
        if (target instanceof OneDoFJointBasics && random.nextBoolean()) {
            multiBodyResponseCalculator.applyJointWrench((OneDoFJointReadOnly)target, testJointWrench.get(0));
        } else {
            multiBodyResponseCalculator.applyJointWrench((JointReadOnly)target, (DMatrix)testJointWrench);
        }
        MultiBodyResponseCalculatorTest.runAssertionsViaAccelerationProvider(random, iteration, joints, epsilon, forwardDynamicsCalculator, multiBodyResponseCalculator);
        DMatrixRMaj qdd_expected = forwardDynamicsCalculator.getJointAccelerationMatrix();
        DMatrixRMaj qdd_original = multiBodyResponseCalculator.getForwardDynamicsCalculator().getJointAccelerationMatrix();
        DMatrixRMaj qdd_change = multiBodyResponseCalculator.propagateWrench();
        MultiBodyResponseCalculatorTest.assertJointAccelerationMatrixEquals(multiBodySystemInput, iteration, qdd_expected, qdd_original, qdd_change, Math.max(1.0, CommonOps_DDRM.elementMaxAbs((DMatrixD1)qdd_expected)) * epsilon);
    }

    private static void assertApplySingleJointImpulse(Random random, int iteration, List<? extends JointBasics> joints, double epsilon) {
        MultiBodyResponseCalculatorTest.assertApplySingleJointImpulse(random, iteration, joints, Collections.emptyMap(), Collections.emptyList(), epsilon);
    }

    private static void assertApplySingleJointImpulse(Random random, int iteration, List<? extends JointBasics> joints, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        for (JointStateType state : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, joints);
        }
        JointBasics target = joints.get(random.nextInt(joints.size()));
        DMatrixRMaj testJointImpulse = RandomMatrices_DDRM.rectangle((int)target.getDegreesOfFreedom(), (int)1, (double)-10.0, (double)10.0, (Random)random);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        ForwardDynamicsCalculator forwardDynamicsCalculator = MultiBodyResponseCalculatorTest.setupForwardDynamicsCalculator(multiBodySystemInput, gravity, externalWrenches, Collections.emptyMap(), Collections.singletonMap(target, testJointImpulse));
        MultiBodyResponseCalculator multiBodyResponseCalculator = MultiBodyResponseCalculatorTest.setupMultiBodyResponseCalculator(multiBodySystemInput, gravity, externalWrenches);
        if (target instanceof OneDoFJointBasics && random.nextBoolean()) {
            multiBodyResponseCalculator.applyJointImpulse((OneDoFJointReadOnly)target, testJointImpulse.get(0));
        } else {
            multiBodyResponseCalculator.applyJointImpulse((JointReadOnly)target, (DMatrix)testJointImpulse);
        }
        MultiBodyResponseCalculatorTest.runAssertionViaTwistProvider(random, iteration, joints, epsilon, forwardDynamicsCalculator, multiBodyResponseCalculator);
        DMatrixRMaj qdd_expected = forwardDynamicsCalculator.getJointAccelerationMatrix();
        DMatrixRMaj qdd_original = multiBodyResponseCalculator.getForwardDynamicsCalculator().getJointAccelerationMatrix();
        DMatrixRMaj qdd_change = multiBodyResponseCalculator.propagateImpulse();
        MultiBodyResponseCalculatorTest.assertJointAccelerationMatrixEquals(multiBodySystemInput, iteration, qdd_expected, qdd_original, qdd_change, Math.max(1.0, CommonOps_DDRM.elementMaxAbs((DMatrixD1)qdd_expected)) * epsilon);
    }

    private static void assertApplySingleJointImpulseViaIntegration(Random random, int iteration, List<? extends JointBasics> joints, double dt, double epsilon) {
        MultiBodyResponseCalculatorTest.assertApplySingleJointImpulseViaIntegration(random, iteration, joints, dt, Collections.emptyMap(), Collections.emptyList(), epsilon);
    }

    private static void assertApplySingleJointImpulseViaIntegration(Random random, int iteration, List<? extends JointBasics> joints, double dt, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        for (JointStateType state : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, joints);
        }
        int numberOfDoFs = joints.stream().mapToInt(JointReadOnly::getDegreesOfFreedom).sum();
        DMatrixRMaj qd_original = new DMatrixRMaj(numberOfDoFs, 1);
        MultiBodySystemTools.extractJointsState(joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)qd_original);
        JointBasics target = joints.get(random.nextInt(joints.size()));
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        DMatrixRMaj testJointEffort = RandomMatrices_DDRM.rectangle((int)target.getDegreesOfFreedom(), (int)1, (double)-10.0, (double)10.0, (Random)random);
        DMatrixRMaj testJointImpulse = new DMatrixRMaj(testJointEffort);
        CommonOps_DDRM.scale((double)dt, (DMatrixD1)testJointImpulse);
        ForwardDynamicsCalculator forwardDynamicsCalculator = MultiBodyResponseCalculatorTest.setupForwardDynamicsCalculator(multiBodySystemInput, gravity, externalWrenches, Collections.emptyMap(), Collections.singletonMap(target, testJointEffort));
        MultiBodyResponseCalculator multiBodyResponseCalculator = MultiBodyResponseCalculatorTest.setupMultiBodyResponseCalculator(multiBodySystemInput, gravity, externalWrenches);
        multiBodyResponseCalculator.applyJointImpulse((JointReadOnly)target, (DMatrix)testJointImpulse);
        DMatrixRMaj qdd = forwardDynamicsCalculator.getJointAccelerationMatrix();
        DMatrixRMaj qd_expected = new DMatrixRMaj(numberOfDoFs, 1);
        CommonOps_DDRM.add((DMatrixD1)qd_original, (double)dt, (DMatrixD1)qdd, (DMatrixD1)qd_expected);
        DMatrixRMaj qd_change = multiBodyResponseCalculator.propagateImpulse();
        DMatrixRMaj qd_noImpulse = new DMatrixRMaj(numberOfDoFs, 1);
        CommonOps_DDRM.add((DMatrixD1)qd_original, (double)dt, (DMatrixD1)multiBodyResponseCalculator.getForwardDynamicsCalculator().getJointAccelerationMatrix(), (DMatrixD1)qd_noImpulse);
        MultiBodyResponseCalculatorTest.assertJointAccelerationMatrixEquals(multiBodySystemInput, iteration, qd_expected, qd_noImpulse, qd_change, epsilon);
    }

    private static void assertJointApparentInertiaInverse(Random random, int iteration, List<? extends JointBasics> joints, double epsilon) {
        MultiBodyResponseCalculatorTest.assertJointApparentInertiaInverse(random, iteration, joints, Collections.emptyMap(), Collections.emptyList(), epsilon);
    }

    private static void assertJointApparentInertiaInverse(Random random, int iteration, List<? extends JointBasics> joints, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        for (JointStateType state : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, joints);
        }
        JointBasics target = joints.get(random.nextInt(joints.size()));
        DMatrixRMaj testWrench = RandomMatrices_DDRM.rectangle((int)target.getDegreesOfFreedom(), (int)1, (double)-10.0, (double)10.0, (Random)random);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        MultiBodyResponseCalculator multiBodyResponseCalculator = MultiBodyResponseCalculatorTest.setupMultiBodyResponseCalculator(multiBodySystemInput, gravity, externalWrenches);
        DMatrixRMaj apparentInertiaInverse = new DMatrixRMaj(target.getDegreesOfFreedom(), target.getDegreesOfFreedom());
        multiBodyResponseCalculator.computeJointApparentInertiaInverse((JointReadOnly)target, (DMatrix1Row)apparentInertiaInverse);
        DMatrixRMaj actualMotionChange = new DMatrixRMaj(target.getDegreesOfFreedom(), 1);
        CommonOps_DDRM.mult((DMatrix1Row)apparentInertiaInverse, (DMatrix1Row)testWrench, (DMatrix1Row)actualMotionChange);
        if (target instanceof OneDoFJointBasics) {
            double oneDoFJointInertiaInverse = multiBodyResponseCalculator.computeJointApparentInertiaInverse((OneDoFJointReadOnly)target);
            double expectedOneDoFJointMotionChange = oneDoFJointInertiaInverse * testWrench.get(0);
            multiBodyResponseCalculator.applyJointWrench((JointReadOnly)target, (DMatrix)testWrench);
            Assertions.assertEquals((double)expectedOneDoFJointMotionChange, (double)multiBodyResponseCalculator.getJointAccelerationChange((OneDoFJointReadOnly)target), (double)epsilon);
        } else {
            multiBodyResponseCalculator.applyJointWrench((JointReadOnly)target, (DMatrix)testWrench);
        }
        DMatrixRMaj expectedMotionChange = multiBodyResponseCalculator.getJointAccelerationChange((JointReadOnly)target);
        MultiBodyResponseCalculatorTest.assertMatrixEquals(iteration, expectedMotionChange, actualMotionChange, epsilon);
    }

    private static void assertApplyMultipleWrenches(Random random, int iteration, List<? extends JointBasics> joints, double epsilon) {
        MultiBodyResponseCalculatorTest.assertApplyMultipleWrenches(random, iteration, joints, Collections.emptyMap(), Collections.emptyList(), epsilon);
    }

    private static void assertApplyMultipleWrenches(Random random, int iteration, List<? extends JointBasics> joints, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        for (JointStateType state : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, joints);
        }
        int numberOfRigidBodyDisturbances = random.nextInt(joints.size()) + 1;
        HashMap<RigidBodyBasics, Wrench> rigidBodyDisturbances = new HashMap<RigidBodyBasics, Wrench>();
        List rigidBodies = joints.stream().map(JointBasics::getSuccessor).collect(Collectors.toList());
        for (int i = 0; i < numberOfRigidBodyDisturbances; ++i) {
            RigidBodyBasics target = (RigidBodyBasics)rigidBodies.get(random.nextInt(rigidBodies.size()));
            Wrench testWrench = MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)target.getBodyFixedFrame(), (ReferenceFrame)target.getBodyFixedFrame());
            rigidBodyDisturbances.put(target, testWrench);
        }
        int numberOfJointDisturbances = random.nextInt(joints.size()) + 1;
        HashMap<JointBasics, DMatrixRMaj> jointDisturbances = new HashMap<JointBasics, DMatrixRMaj>();
        for (int i = 0; i < numberOfJointDisturbances; ++i) {
            JointBasics target = joints.get(random.nextInt(joints.size()));
            DMatrixRMaj testWrench = RandomMatrices_DDRM.rectangle((int)target.getDegreesOfFreedom(), (int)1, (double)-10.0, (double)10.0, (Random)random);
            jointDisturbances.put(target, testWrench);
        }
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        ForwardDynamicsCalculator forwardDynamicsCalculator = MultiBodyResponseCalculatorTest.setupForwardDynamicsCalculator(multiBodySystemInput, gravity, externalWrenches, rigidBodyDisturbances, jointDisturbances);
        MultiBodyResponseCalculator multiBodyResponseCalculator = MultiBodyResponseCalculatorTest.setupMultiBodyResponseCalculator(multiBodySystemInput, gravity, externalWrenches);
        rigidBodyDisturbances.forEach((arg_0, arg_1) -> ((MultiBodyResponseCalculator)multiBodyResponseCalculator).applyRigidBodyWrench(arg_0, arg_1));
        jointDisturbances.forEach((arg_0, arg_1) -> ((MultiBodyResponseCalculator)multiBodyResponseCalculator).applyJointWrench(arg_0, arg_1));
        MultiBodyResponseCalculatorTest.runAssertionsViaAccelerationProvider(random, iteration, joints, epsilon, forwardDynamicsCalculator, multiBodyResponseCalculator);
        DMatrixRMaj qdd_expected = forwardDynamicsCalculator.getJointAccelerationMatrix();
        DMatrixRMaj qdd_original = multiBodyResponseCalculator.getForwardDynamicsCalculator().getJointAccelerationMatrix();
        DMatrixRMaj qdd_change = multiBodyResponseCalculator.propagateWrench();
        MultiBodyResponseCalculatorTest.assertJointAccelerationMatrixEquals(multiBodySystemInput, iteration, qdd_expected, qdd_original, qdd_change, Math.max(1.0, CommonOps_DDRM.elementMaxAbs((DMatrixD1)qdd_expected)) * epsilon);
    }

    private static void assertApplyMultipleImpulses(Random random, int iteration, List<? extends JointBasics> joints, double epsilon) {
        MultiBodyResponseCalculatorTest.assertApplyMultipleImpulse(random, iteration, joints, Collections.emptyMap(), Collections.emptyList(), epsilon);
    }

    private static void assertApplyMultipleImpulse(Random random, int iteration, List<? extends JointBasics> joints, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        for (JointStateType state : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, joints);
        }
        int numberOfRigidBodyDisturbances = random.nextInt(joints.size()) + 1;
        HashMap<RigidBodyBasics, SpatialImpulse> rigidBodyDisturbances = new HashMap<RigidBodyBasics, SpatialImpulse>();
        List rigidBodies = joints.stream().map(JointBasics::getSuccessor).collect(Collectors.toList());
        for (int i = 0; i < numberOfRigidBodyDisturbances; ++i) {
            RigidBodyBasics target = (RigidBodyBasics)rigidBodies.get(random.nextInt(rigidBodies.size()));
            SpatialImpulse testImpulse = MecanoRandomTools.nextSpatialImpulse((Random)random, (ReferenceFrame)target.getBodyFixedFrame(), (ReferenceFrame)target.getBodyFixedFrame());
            rigidBodyDisturbances.put(target, testImpulse);
        }
        int numberOfJointDisturbances = random.nextInt(joints.size()) + 1;
        HashMap<JointBasics, DMatrixRMaj> jointDisturbances = new HashMap<JointBasics, DMatrixRMaj>();
        for (int i = 0; i < numberOfJointDisturbances; ++i) {
            JointBasics target = joints.get(random.nextInt(joints.size()));
            DMatrixRMaj testWrench = RandomMatrices_DDRM.rectangle((int)target.getDegreesOfFreedom(), (int)1, (double)-10.0, (double)10.0, (Random)random);
            jointDisturbances.put(target, testWrench);
        }
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        ForwardDynamicsCalculator forwardDynamicsCalculator = MultiBodyResponseCalculatorTest.setupForwardDynamicsCalculator(multiBodySystemInput, gravity, externalWrenches, rigidBodyDisturbances, jointDisturbances);
        MultiBodyResponseCalculator multiBodyResponseCalculator = MultiBodyResponseCalculatorTest.setupMultiBodyResponseCalculator(multiBodySystemInput, gravity, externalWrenches);
        rigidBodyDisturbances.forEach((arg_0, arg_1) -> ((MultiBodyResponseCalculator)multiBodyResponseCalculator).applyRigidBodyImpulse(arg_0, arg_1));
        jointDisturbances.forEach((arg_0, arg_1) -> ((MultiBodyResponseCalculator)multiBodyResponseCalculator).applyJointImpulse(arg_0, arg_1));
        MultiBodyResponseCalculatorTest.runAssertionViaTwistProvider(random, iteration, joints, epsilon, forwardDynamicsCalculator, multiBodyResponseCalculator);
        DMatrixRMaj qdd_expected = forwardDynamicsCalculator.getJointAccelerationMatrix();
        DMatrixRMaj qdd_original = multiBodyResponseCalculator.getForwardDynamicsCalculator().getJointAccelerationMatrix();
        DMatrixRMaj qdd_change = multiBodyResponseCalculator.propagateImpulse();
        MultiBodyResponseCalculatorTest.assertJointAccelerationMatrixEquals(multiBodySystemInput, iteration, qdd_expected, qdd_original, qdd_change, Math.max(1.0, CommonOps_DDRM.elementMaxAbs((DMatrixD1)qdd_expected)) * epsilon);
    }

    private static void runAssertionViaTwistProvider(Random random, int iteration, List<? extends JointBasics> joints, double epsilon, ForwardDynamicsCalculator forwardDynamicsCalculator, MultiBodyResponseCalculator multiBodyResponseCalculator) {
        for (int i = 0; i < 10; ++i) {
            RigidBodyBasics body = joints.get(random.nextInt(joints.size())).getSuccessor();
            SpatialAcceleration expectedTargetAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)forwardDynamicsCalculator.getAccelerationProvider().getAccelerationOfBody((RigidBodyReadOnly)body));
            RigidBodyTwistProvider twistChangeProvider = multiBodyResponseCalculator.getTwistChangeProvider();
            RigidBodyAccelerationProvider originalAccelerationProvider = multiBodyResponseCalculator.getForwardDynamicsCalculator().getAccelerationProvider();
            SpatialAcceleration actualTargetAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)originalAccelerationProvider.getAccelerationOfBody((RigidBodyReadOnly)body));
            actualTargetAcceleration.add((SpatialVectorReadOnly)twistChangeProvider.getTwistOfBody((RigidBodyReadOnly)body));
            MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration: " + iteration + ", body: " + i), (SpatialAccelerationReadOnly)expectedTargetAcceleration, (SpatialAccelerationReadOnly)actualTargetAcceleration, (double)(Math.max(1.0, expectedTargetAcceleration.length()) * epsilon));
        }
    }

    private static void runAssertionsViaAccelerationProvider(Random random, int iteration, List<? extends JointBasics> joints, double epsilon, ForwardDynamicsCalculator forwardDynamicsCalculator, MultiBodyResponseCalculator multiBodyResponseCalculator) {
        for (int i = 0; i < 10; ++i) {
            RigidBodyBasics body = joints.get(random.nextInt(joints.size())).getSuccessor();
            SpatialAcceleration expectedTargetAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)forwardDynamicsCalculator.getAccelerationProvider().getAccelerationOfBody((RigidBodyReadOnly)body));
            RigidBodyAccelerationProvider accelerationChangeProvider = multiBodyResponseCalculator.getAccelerationChangeProvider();
            RigidBodyAccelerationProvider originalAccelerationProvider = multiBodyResponseCalculator.getForwardDynamicsCalculator().getAccelerationProvider();
            SpatialAcceleration actualTargetAcceleration = new SpatialAcceleration((SpatialMotionReadOnly)originalAccelerationProvider.getAccelerationOfBody((RigidBodyReadOnly)body));
            actualTargetAcceleration.add((SpatialVectorReadOnly)accelerationChangeProvider.getAccelerationOfBody((RigidBodyReadOnly)body));
            MecanoTestTools.assertSpatialAccelerationEquals((String)("Iteration: " + iteration + ", body: " + i), (SpatialAccelerationReadOnly)expectedTargetAcceleration, (SpatialAccelerationReadOnly)actualTargetAcceleration, (double)(Math.max(1.0, expectedTargetAcceleration.length()) * epsilon));
        }
    }

    private static void assertMatrixEquals(int iteration, DMatrixRMaj expected, DMatrixRMaj actual, double epsilon) {
        boolean areEqual = MatrixFeatures_DDRM.isEquals((DMatrixD1)expected, (DMatrixD1)actual, (double)epsilon);
        if (!areEqual) {
            System.out.println("iteration: " + iteration);
            double maxError = 0.0;
            DMatrixRMaj output = new DMatrixRMaj(expected.getNumRows(), 3);
            for (int row = 0; row < expected.getNumRows(); ++row) {
                double error = expected.get(row, 0) - actual.get(row, 0);
                output.set(row, 0, expected.get(row, 0));
                output.set(row, 1, actual.get(row, 0));
                output.set(row, 2, error);
                maxError = Math.max(maxError, Math.abs(error));
            }
            output.print(EuclidCoreIOTools.getStringFormat((int)9, (int)6));
            System.out.println("Max error: " + maxError);
        }
        Assertions.assertTrue((boolean)areEqual);
    }

    private static ForwardDynamicsCalculator setupForwardDynamicsCalculator(MultiBodySystemReadOnly input, double gravity, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, Map<? extends RigidBodyReadOnly, ? extends SpatialForceReadOnly> testRigidBodyDisturbances, Map<? extends JointReadOnly, DMatrixRMaj> testJointDisturbances) {
        ForwardDynamicsCalculator calculator = new ForwardDynamicsCalculator(input);
        calculator.setGravitionalAcceleration(gravity);
        calculator.setExternalWrenchesToZero();
        externalWrenches.forEach((arg_0, arg_1) -> ((ForwardDynamicsCalculator)calculator).setExternalWrench(arg_0, arg_1));
        testRigidBodyDisturbances.forEach((body, disturbance) -> calculator.getExternalWrench(body).add((SpatialVectorReadOnly)disturbance));
        List joints = input.getJointsToConsider();
        int numberOfDoFs = joints.stream().mapToInt(JointReadOnly::getDegreesOfFreedom).sum();
        DMatrixRMaj tauWithDisturbances = new DMatrixRMaj(numberOfDoFs, 1);
        MultiBodySystemTools.extractJointsState((List)joints, (JointStateType)JointStateType.EFFORT, (DMatrix)tauWithDisturbances);
        JointMatrixIndexProvider jointMatrixIndexProvider = input.getJointMatrixIndexProvider();
        for (Map.Entry<? extends JointReadOnly, DMatrixRMaj> entry : testJointDisturbances.entrySet()) {
            JointReadOnly joint = entry.getKey();
            DMatrixRMaj jointDisturbance = entry.getValue();
            for (int i = 0; i < joint.getDegreesOfFreedom(); ++i) {
                tauWithDisturbances.add(jointMatrixIndexProvider.getJointDoFIndices(joint)[i], 0, jointDisturbance.get(i));
            }
        }
        calculator.compute((DMatrix)tauWithDisturbances);
        return calculator;
    }

    private static MultiBodyResponseCalculator setupMultiBodyResponseCalculator(MultiBodySystemReadOnly input, double gravity, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches) {
        MultiBodyResponseCalculator multiBodyResponseCalculator = new MultiBodyResponseCalculator(input);
        ForwardDynamicsCalculator forwardDynamicsCalculator = multiBodyResponseCalculator.getForwardDynamicsCalculator();
        forwardDynamicsCalculator.setGravitionalAcceleration(gravity);
        forwardDynamicsCalculator.setExternalWrenchesToZero();
        externalWrenches.forEach((arg_0, arg_1) -> ((ForwardDynamicsCalculator)forwardDynamicsCalculator).setExternalWrench(arg_0, arg_1));
        forwardDynamicsCalculator.compute();
        return multiBodyResponseCalculator;
    }

    private static void assertJointAccelerationMatrixEquals(MultiBodySystemReadOnly input, int iteration, DMatrixRMaj qdd_expected, DMatrixRMaj qdd_original, DMatrixRMaj qdd_change, double epsilon) {
        DMatrixRMaj qdd_actual = new DMatrixRMaj(qdd_change.getNumRows(), 1);
        CommonOps_DDRM.add((DMatrixD1)qdd_original, (DMatrixD1)qdd_change, (DMatrixD1)qdd_actual);
        boolean areEqual = MatrixFeatures_DDRM.isEquals((DMatrixD1)qdd_expected, (DMatrixD1)qdd_actual, (double)epsilon);
        if (!areEqual) {
            LogTools.info((String)("iteration: " + iteration));
            double maxError = 0.0;
            DMatrixRMaj output = new DMatrixRMaj(qdd_expected.getNumRows(), 5);
            for (int row = 0; row < qdd_expected.getNumRows(); ++row) {
                double error = qdd_expected.get(row, 0) - qdd_actual.get(row, 0);
                output.set(row, 0, qdd_original.get(row, 0));
                output.set(row, 1, qdd_change.get(row, 0));
                output.set(row, 2, qdd_expected.get(row, 0));
                output.set(row, 3, qdd_actual.get(row, 0));
                output.set(row, 4, error);
                maxError = Math.max(maxError, Math.abs(error));
            }
            TablePrinter tablePrinter = new TablePrinter();
            tablePrinter.setColumnSeparator("   ");
            tablePrinter.setRow(0, "Joint", "Successor", "original", "change", "expected", "actual", "error");
            tablePrinter.setSubTable(1, 2, output);
            int row = 1;
            for (JointReadOnly joint : input.getJointMatrixIndexProvider().getIndexedJointsInOrder()) {
                for (int dof = 0; dof < joint.getDegreesOfFreedom(); ++dof) {
                    tablePrinter.setCell(row, 0, joint.getName(), TablePrinter.Alignment.LEFT);
                    tablePrinter.setCell(row, 1, joint.getSuccessor().getName(), TablePrinter.Alignment.LEFT);
                    ++row;
                }
            }
            LogTools.info((String)tablePrinter.toString());
            LogTools.info((String)("Max error: " + maxError));
        }
        Assertions.assertTrue((boolean)areEqual);
    }
}

