/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameNameRestrictionLevel;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.algorithms.InverseDynamicsCalculator;
import us.ihmc.mecano.algorithms.MultiBodyGravityGradientCalculator;
import us.ihmc.mecano.algorithms.TablePrinter;
import us.ihmc.mecano.multiBodySystem.interfaces.CrossFourBarJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FixedJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.PrismaticJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class MultiBodyGravityGradientCalculatorTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int ITERATIONS = 1000;
    private static final double GRAVITY = 10.0;
    private static final boolean ADD_EXT_WRENCHES = true;

    @BeforeEach
    public void disableNameRestriction() {
        ReferenceFrame.getWorldFrame().setNameRestrictionLevel(FrameNameRestrictionLevel.NONE);
    }

    @Test
    public void testGravityMatrixAgainstInverseDynamics() {
        Random random = new Random(345345780L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 20;
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemBasics input = MultiBodySystemBasics.toMultiBodySystemBasics((List)joints);
            InverseDynamicsCalculator inverseDynamics = new InverseDynamicsCalculator((MultiBodySystemReadOnly)input);
            inverseDynamics.setGravitionalAcceleration(-10.0);
            inverseDynamics.setConsiderCoriolisAndCentrifugalForces(false);
            inverseDynamics.setConsiderJointAccelerations(false);
            MultiBodyGravityGradientCalculator calculator = new MultiBodyGravityGradientCalculator((MultiBodySystemReadOnly)input);
            calculator.setGravitionalAcceleration(-10.0);
            if (random.nextBoolean()) {
                int numberOfWrenches = random.nextInt(3) + 1;
                for (int j = 0; j < numberOfWrenches; ++j) {
                    int bodyIndex = random.nextInt(joints.size());
                    RigidBodyBasics body = ((JointBasics)joints.get(bodyIndex)).getSuccessor();
                    Wrench wrench = MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)body.getBodyFixedFrame(), (ReferenceFrame)body.getBodyFixedFrame(), (double)10.0, (double)10.0);
                    inverseDynamics.getExternalWrench((RigidBodyReadOnly)body).set((WrenchReadOnly)wrench);
                    calculator.getExternalWrench((RigidBodyReadOnly)body).set((WrenchReadOnly)wrench);
                }
            }
            inverseDynamics.compute();
            calculator.reset();
            try {
                MecanoTestTools.assertDMatrixEquals((String)("Iteration: " + i), (DMatrix)inverseDynamics.getJointTauMatrix(), (DMatrix)calculator.getTauMatrix(), (double)1.0E-12);
                continue;
            }
            catch (Throwable e) {
                TablePrinter tablePrinter = new TablePrinter();
                int col = 0;
                int row = 1;
                for (JointBasics joint : input.getJointsToConsider()) {
                    for (int j = 0; j < joint.getDegreesOfFreedom(); ++j) {
                        String dofName = joint.getName() + " [" + MultiBodyGravityGradientCalculatorTest.toShortTypeString((JointReadOnly)joint) + "]";
                        tablePrinter.setCell(row++, col, dofName, TablePrinter.Alignment.LEFT);
                    }
                }
                DMatrixRMaj diff = new DMatrixRMaj(input.getNumberOfDoFs(), 1);
                CommonOps_DDRM.subtract((DMatrixD1)inverseDynamics.getJointTauMatrix(), (DMatrixD1)calculator.getTauMatrix(), (DMatrixD1)diff);
                CommonOps_DDRM.abs((DMatrixD1)diff);
                tablePrinter.setCell(0, ++col, "Exp.", TablePrinter.Alignment.LEFT);
                tablePrinter.setSubTable(1, col++, inverseDynamics.getJointTauMatrix());
                tablePrinter.setCell(0, col, "Act.", TablePrinter.Alignment.LEFT);
                tablePrinter.setSubTable(1, col++, calculator.getTauMatrix());
                tablePrinter.setCell(0, col, "Err.", TablePrinter.Alignment.LEFT);
                tablePrinter.setSubTable(1, col++, diff);
                System.out.println(tablePrinter);
                throw e;
            }
        }
    }

    @Test
    public void testCalculatorPrismaticJointChain() {
        Random random = new Random(2342356L);
        double dt = 1.0E-6;
        double dq = 1.0E-7;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 10;
            List joints = MultiBodySystemRandomTools.nextPrismaticJointChain((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.compareAgainstFiniteDifference(random, joints, externalWrenches, dq, 2.0E-5, i);
            this.testMultiBodyGravityGradientCalculator(random, joints, externalWrenches, dt, 1.0E-9, i);
        }
    }

    @Test
    public void testCalculatorRevoluteJointChain() {
        Random random = new Random(2342356L);
        double dt = 1.0E-6;
        double dq = 1.0E-7;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 10;
            List joints = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.compareAgainstFiniteDifference(random, joints, externalWrenches, dq, 2.0E-5, i);
            this.testMultiBodyGravityGradientCalculator(random, joints, externalWrenches, dt, 1.0E-9, i);
        }
    }

    @Test
    public void testCalculatorOneDoFJointChain() {
        Random random = new Random(2342356L);
        double dt = 1.0E-6;
        double dq = 1.0E-7;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 10;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.compareAgainstFiniteDifference(random, joints, externalWrenches, dq, 2.0E-5, i);
            this.testMultiBodyGravityGradientCalculator(random, joints, externalWrenches, dt, 1.0E-9, i);
        }
    }

    @Test
    public void testCalculatorJointChain() {
        Random random = new Random(2342350L);
        double dt = 1.0E-6;
        double dq = 1.0E-7;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 10;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.compareAgainstFiniteDifference(random, joints, externalWrenches, dq, 2.0E-5, i);
            this.testMultiBodyGravityGradientCalculator(random, joints, externalWrenches, dt, 1.0E-9, i);
        }
    }

    @Test
    public void testCalculatorRevoluteJointTree() {
        Random random = new Random(2342356L);
        double dt = 1.0E-6;
        double dq = 1.0E-7;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 10;
            List joints = MultiBodySystemRandomTools.nextRevoluteJointTree((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.compareAgainstFiniteDifference(random, joints, externalWrenches, dq, 2.0E-5, i);
            this.testMultiBodyGravityGradientCalculator(random, joints, externalWrenches, dt, 1.0E-9, i);
        }
    }

    @Test
    public void testCalculatorOneDoFJointTree() {
        Random random = new Random(2342356L);
        double dt = 1.0E-6;
        double dq = 1.0E-7;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 10;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.compareAgainstFiniteDifference(random, joints, externalWrenches, dq, 2.0E-5, i);
            this.testMultiBodyGravityGradientCalculator(random, joints, externalWrenches, dt, 1.0E-9, i);
        }
    }

    @Test
    public void testCalculatorJointTree() {
        Random random = new Random(2342350L);
        double dt = 1.0E-6;
        double dq = 1.0E-7;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 10;
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.compareAgainstFiniteDifference(random, joints, externalWrenches, dq, 2.0E-5, i);
            this.testMultiBodyGravityGradientCalculator(random, joints, externalWrenches, dt, 1.0E-9, i);
        }
    }

    private static Map<RigidBodyBasics, Wrench> nextExternalWrenches(Random random, List<? extends JointBasics> joints) {
        HashMap<RigidBodyBasics, Wrench> wrenches = new HashMap<RigidBodyBasics, Wrench>();
        int numberOfWrenches = joints.size() >= 4 ? random.nextInt(joints.size() / 4) + 1 : 1;
        while (wrenches.size() < numberOfWrenches) {
            int jointIndex = random.nextInt(joints.size());
            RigidBodyBasics body = joints.get(jointIndex).getSuccessor();
            Wrench wrench = MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)body.getBodyFixedFrame(), (ReferenceFrame)body.getBodyFixedFrame(), (double)10.0, (double)10.0);
            wrench.getLinearPart().setToZero();
            wrenches.put(body, wrench);
        }
        return wrenches;
    }

    public void compareAgainstFiniteDifference(Random random, List<? extends JointBasics> joints, Map<RigidBodyBasics, Wrench> externalWrenches, double dq, double epsilon, int iteration) {
        MultiBodySystemBasics input = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, joints);
        input.getRootBody().updateFramesRecursively();
        DMatrixRMaj expectedGradient = MultiBodyGravityGradientCalculatorTest.computeGradientByFD(input, externalWrenches, dq);
        MultiBodyGravityGradientCalculator calculator = new MultiBodyGravityGradientCalculator((MultiBodySystemReadOnly)input);
        calculator.setGravitionalAcceleration(-10.0);
        externalWrenches.forEach((body, wrench) -> calculator.getExternalWrench((RigidBodyReadOnly)body).set((WrenchReadOnly)wrench));
        calculator.reset();
        DMatrixRMaj actualGradient = calculator.getTauGradientMatrix();
        try {
            MecanoTestTools.assertDMatrixEquals((String)("Iteration: " + iteration), (DMatrix)expectedGradient, (DMatrix)actualGradient, (double)epsilon);
        }
        catch (Throwable e) {
            System.out.println("Expected gradient: ");
            System.out.println(this.printGradient(input, expectedGradient));
            System.out.println("Actual gradient: ");
            System.out.println(this.printGradient(input, actualGradient));
            DMatrixRMaj diff = new DMatrixRMaj(input.getNumberOfDoFs(), input.getNumberOfDoFs());
            CommonOps_DDRM.subtract((DMatrixD1)expectedGradient, (DMatrixD1)actualGradient, (DMatrixD1)diff);
            CommonOps_DDRM.abs((DMatrixD1)diff);
            System.out.println("Difference: ");
            System.out.println(this.printGradient(input, diff));
            System.out.println("External wrenches: ");
            System.out.println(this.printExternalWrenches(input, externalWrenches));
            throw e;
        }
    }

    private String printGradient(MultiBodySystemBasics input, DMatrixRMaj gradient) {
        TablePrinter tablePrinter = new TablePrinter();
        int col = 1;
        int row = 1;
        for (JointBasics joint : input.getJointsToConsider()) {
            for (int j = 0; j < joint.getDegreesOfFreedom(); ++j) {
                String dofName = joint.getName() + " [" + MultiBodyGravityGradientCalculatorTest.toShortTypeString((JointReadOnly)joint) + "]";
                tablePrinter.setCell(0, col++, dofName, TablePrinter.Alignment.LEFT);
                tablePrinter.setCell(row++, 0, dofName, TablePrinter.Alignment.LEFT);
            }
        }
        tablePrinter.setSubTable(1, 1, gradient);
        return tablePrinter.toString();
    }

    private String printExternalWrenches(MultiBodySystemBasics input, Map<RigidBodyBasics, Wrench> externalWrenches) {
        TablePrinter tablePrinter = new TablePrinter();
        int col = 1;
        DMatrixRMaj vector = new DMatrixRMaj(6, 1);
        for (JointBasics joint : input.getJointsToConsider()) {
            String dofName = joint.getName() + " [" + MultiBodyGravityGradientCalculatorTest.toShortTypeString((JointReadOnly)joint) + "]";
            tablePrinter.setCell(0, col, dofName, TablePrinter.Alignment.LEFT);
            Wrench wrench = externalWrenches.get(joint.getSuccessor());
            if (wrench != null) {
                wrench.get((DMatrix)vector);
            } else {
                vector.zero();
            }
            tablePrinter.setSubTable(1, col++, vector);
        }
        int row = 1;
        tablePrinter.setCell(row++, 0, "Tx", TablePrinter.Alignment.LEFT);
        tablePrinter.setCell(row++, 0, "Ty", TablePrinter.Alignment.LEFT);
        tablePrinter.setCell(row++, 0, "Tz", TablePrinter.Alignment.LEFT);
        tablePrinter.setCell(row++, 0, "Fx", TablePrinter.Alignment.LEFT);
        tablePrinter.setCell(row++, 0, "Fy", TablePrinter.Alignment.LEFT);
        tablePrinter.setCell(row++, 0, "Fz", TablePrinter.Alignment.LEFT);
        return tablePrinter.toString();
    }

    private static String toShortTypeString(JointReadOnly joint) {
        if (joint instanceof RevoluteJointReadOnly) {
            return "R";
        }
        if (joint instanceof PrismaticJointReadOnly) {
            return "P";
        }
        if (joint instanceof CrossFourBarJointReadOnly) {
            return "C";
        }
        if (joint instanceof SphericalJointReadOnly) {
            return "S";
        }
        if (joint instanceof SixDoFJointReadOnly) {
            return "6";
        }
        if (joint instanceof FixedJointReadOnly) {
            return "0";
        }
        if (joint instanceof PlanarJointReadOnly) {
            return "3";
        }
        return null;
    }

    @Test
    public void testFiniteDifferenceWithRevoluteJointChain() {
        Random random = new Random(2342356L);
        double dt = 1.0E-5;
        double dq = 1.0E-5;
        double epsilon = 1.0E-6;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 10;
            List joints = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.testFiniteDifferenceCalculator(random, joints, externalWrenches, dt, dq, epsilon, i);
        }
    }

    @Test
    public void testFiniteDifferenceWithOneDoFJointChain() {
        Random random = new Random(2342356L);
        double dt = 1.0E-5;
        double dq = 1.0E-5;
        double epsilon = 1.0E-6;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 10;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.testFiniteDifferenceCalculator(random, joints, externalWrenches, dt, dq, epsilon, i);
        }
    }

    @Test
    public void testFiniteDifferenceWithJointChain() {
        Random random = new Random(2342355L);
        double dt = 1.0E-5;
        double dq = 1.0E-5;
        double epsilon = 1.0E-6;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 10;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.testFiniteDifferenceCalculator(random, joints, externalWrenches, dt, dq, epsilon, i);
        }
    }

    @Test
    public void testFiniteDifferenceWithRevoluteJointTree() {
        Random random = new Random(2342356L);
        double dt = 1.0E-5;
        double dq = 1.0E-5;
        double epsilon = 1.0E-6;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 20;
            List joints = MultiBodySystemRandomTools.nextRevoluteJointTree((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.testFiniteDifferenceCalculator(random, joints, externalWrenches, dt, dq, epsilon, i);
        }
    }

    @Test
    public void testFiniteDifferenceWithOneDoFJointTree() {
        Random random = new Random(2342356L);
        double dt = 1.0E-5;
        double dq = 1.0E-5;
        double epsilon = 1.0E-6;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 20;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.testFiniteDifferenceCalculator(random, joints, externalWrenches, dt, dq, epsilon, i);
        }
    }

    @Test
    public void testFiniteDifferenceWithJointTree() {
        Random random = new Random(2342356L);
        double dt = 1.0E-5;
        double dq = 1.0E-5;
        double epsilon = 1.0E-6;
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = 20;
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
            Map<RigidBodyBasics, Wrench> externalWrenches = MultiBodyGravityGradientCalculatorTest.nextExternalWrenches(random, joints);
            this.testFiniteDifferenceCalculator(random, joints, externalWrenches, dt, dq, epsilon, i);
        }
    }

    public void testMultiBodyGravityGradientCalculator(Random random, List<? extends JointBasics> joints, Map<RigidBodyBasics, Wrench> externalWrenches, double dt, double epsilon, int iteration) {
        this.testCalculatorAgainstFiniteDifference(random, joints, externalWrenches, dt, input -> {
            MultiBodyGravityGradientCalculator calculator = new MultiBodyGravityGradientCalculator((MultiBodySystemReadOnly)input);
            calculator.setGravitionalAcceleration(-10.0);
            externalWrenches.forEach((body, wrench) -> calculator.getExternalWrench((RigidBodyReadOnly)body).set((WrenchReadOnly)wrench));
            calculator.reset();
            return calculator.getTauGradientMatrix();
        }, epsilon, iteration);
    }

    public void testFiniteDifferenceCalculator(Random random, List<? extends JointBasics> joints, Map<RigidBodyBasics, Wrench> externalWrenches, double dt, double dq, double epsilon, int iteration) {
        this.testCalculatorAgainstFiniteDifference(random, joints, externalWrenches, dt, input -> MultiBodyGravityGradientCalculatorTest.computeGradientByFD(input, externalWrenches, dq), epsilon, iteration);
    }

    public void testCalculatorAgainstFiniteDifference(Random random, List<? extends JointBasics> joints, Map<RigidBodyBasics, Wrench> externalWrenches, double dt, Function<MultiBodySystemBasics, DMatrixRMaj> calculatorToTest, double epsilon, int iteration) {
        MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dt);
        MultiBodySystemBasics input = MultiBodySystemBasics.toMultiBodySystemBasics(joints);
        DMatrixRMaj qDot = new DMatrixRMaj(input.getNumberOfDoFs(), 1);
        DMatrixRMaj actualDeltaGravity = new DMatrixRMaj(input.getNumberOfDoFs(), 1);
        DMatrixRMaj actualGravity = new DMatrixRMaj(input.getNumberOfDoFs(), 1);
        DMatrixRMaj expectedDeltaGravity = new DMatrixRMaj(input.getNumberOfDoFs(), 1);
        DMatrixRMaj errorDeltaGravity = new DMatrixRMaj(input.getNumberOfDoFs(), 1);
        DMatrixRMaj prevGravity = new DMatrixRMaj(input.getNumberOfDoFs(), 1);
        DMatrixRMaj expectedGravity = new DMatrixRMaj(input.getNumberOfDoFs(), 1);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, joints);
        input.getRootBody().updateFramesRecursively();
        DMatrixRMaj gradient = calculatorToTest.apply(input);
        MultiBodySystemTools.extractJointsState((List)input.getJointsToConsider(), (JointStateType)JointStateType.VELOCITY, (DMatrix)qDot);
        CommonOps_DDRM.mult((DMatrix1Row)gradient, (DMatrix1Row)qDot, (DMatrix1Row)actualDeltaGravity);
        CommonOps_DDRM.scale((double)dt, (DMatrixD1)actualDeltaGravity);
        HashMap<RigidBodyBasics, Wrench> externalWrenchesWorld = new HashMap<RigidBodyBasics, Wrench>();
        externalWrenches.forEach((body, wrench) -> {
            Wrench wrenchInWorld = new Wrench((WrenchReadOnly)wrench);
            wrenchInWorld.changeFrame(worldFrame);
            externalWrenchesWorld.put((RigidBodyBasics)body, wrenchInWorld);
        });
        InverseDynamicsCalculator calculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)input);
        calculator.setConsiderCoriolisAndCentrifugalForces(false);
        calculator.setConsiderJointAccelerations(false);
        calculator.setGravitionalAcceleration(-10.0);
        externalWrenches.forEach((body, wrench) -> calculator.getExternalWrench((RigidBodyReadOnly)body).set((WrenchReadOnly)wrench));
        calculator.compute();
        prevGravity.set((DMatrixD1)calculator.getJointTauMatrix());
        CommonOps_DDRM.add((DMatrixD1)prevGravity, (DMatrixD1)actualDeltaGravity, (DMatrixD1)actualGravity);
        input.getRootBody().updateFramesRecursively();
        integrator.integrateFromVelocitySubtree(input.getRootBody());
        input.getRootBody().updateFramesRecursively();
        calculator.setExternalWrenchesToZero();
        externalWrenchesWorld.forEach((body, wrench) -> calculator.getExternalWrench((RigidBodyReadOnly)body).setMatchingFrame((WrenchReadOnly)wrench));
        calculator.compute();
        expectedGravity.set((DMatrixD1)calculator.getJointTauMatrix());
        CommonOps_DDRM.subtract((DMatrixD1)expectedGravity, (DMatrixD1)prevGravity, (DMatrixD1)expectedDeltaGravity);
        CommonOps_DDRM.subtract((DMatrixD1)expectedDeltaGravity, (DMatrixD1)actualDeltaGravity, (DMatrixD1)errorDeltaGravity);
        try {
            MecanoTestTools.assertDMatrixEquals((String)("Iteration: " + iteration), (DMatrix)expectedGravity, (DMatrix)actualGravity, (double)epsilon);
            MecanoTestTools.assertDMatrixEquals((String)("Iteration: " + iteration), (DMatrix)expectedDeltaGravity, (DMatrix)actualDeltaGravity, (double)epsilon);
        }
        catch (Throwable e) {
            TablePrinter tablePrinter = new TablePrinter();
            int col = 0;
            tablePrinter.setCell(0, col, "Joint", TablePrinter.Alignment.LEFT);
            int row = 1;
            for (JointBasics joint : input.getJointsToConsider()) {
                for (int j = 0; j < joint.getDegreesOfFreedom(); ++j) {
                    String dofName = joint.getName() + " [" + MultiBodyGravityGradientCalculatorTest.toShortTypeString((JointReadOnly)joint) + "]";
                    tablePrinter.setCell(row++, col, dofName, TablePrinter.Alignment.LEFT);
                }
            }
            tablePrinter.setCell(0, ++col, "Act. Delta", TablePrinter.Alignment.LEFT);
            tablePrinter.setSubTable(1, col++, actualDeltaGravity);
            tablePrinter.setCell(0, col, "Exp. Delta", TablePrinter.Alignment.LEFT);
            tablePrinter.setSubTable(1, col++, expectedDeltaGravity);
            tablePrinter.setCell(0, col, "Err. Delta", TablePrinter.Alignment.LEFT);
            tablePrinter.setSubTable(1, col++, errorDeltaGravity);
            tablePrinter.setCell(0, col, "Act. Gradient", TablePrinter.Alignment.LEFT);
            CommonOps_DDRM.scale((double)dt, (DMatrixD1)gradient);
            tablePrinter.setSubTable(1, col++, gradient);
            System.out.println(tablePrinter);
            throw e;
        }
    }

    private static DMatrixRMaj computeGradientByFD(MultiBodySystemBasics input, Map<RigidBodyBasics, Wrench> externalWrenches, double dq) {
        DMatrixRMaj originalConfiguration = new DMatrixRMaj(input.getJointsToConsider().stream().mapToInt(JointReadOnly::getConfigurationMatrixSize).sum(), 1);
        MultiBodySystemTools.extractJointsState((List)input.getJointsToConsider(), (JointStateType)JointStateType.CONFIGURATION, (DMatrix)originalConfiguration);
        DMatrixRMaj originalVelocity = new DMatrixRMaj(input.getNumberOfDoFs(), 1);
        MultiBodySystemTools.extractJointsState((List)input.getJointsToConsider(), (JointStateType)JointStateType.VELOCITY, (DMatrix)originalVelocity);
        HashMap<RigidBodyBasics, Wrench> externalWrenchesWorld = new HashMap<RigidBodyBasics, Wrench>();
        externalWrenches.forEach((body, wrench) -> {
            Wrench wrenchInWorld = new Wrench((WrenchReadOnly)wrench);
            wrenchInWorld.changeFrame(worldFrame);
            externalWrenchesWorld.put((RigidBodyBasics)body, wrenchInWorld);
        });
        InverseDynamicsCalculator calculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)input);
        calculator.setConsiderCoriolisAndCentrifugalForces(false);
        calculator.setConsiderJointAccelerations(false);
        calculator.setGravitionalAcceleration(-10.0);
        MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dq);
        int nDoFs = input.getNumberOfDoFs();
        DMatrixRMaj qDot = new DMatrixRMaj(nDoFs, 1);
        DMatrixRMaj gradient = new DMatrixRMaj(nDoFs, nDoFs);
        DMatrixRMaj gradientCol = new DMatrixRMaj(nDoFs, 1);
        MultiBodySystemTools.insertJointsState((List)input.getJointsToConsider(), (JointStateType)JointStateType.VELOCITY, (DMatrix)qDot);
        input.getRootBody().updateFramesRecursively();
        calculator.setExternalWrenchesToZero();
        externalWrenchesWorld.forEach((body, wrench) -> calculator.getExternalWrench((RigidBodyReadOnly)body).setMatchingFrame((WrenchReadOnly)wrench));
        calculator.compute();
        DMatrixRMaj referenceGravity = new DMatrixRMaj(calculator.getJointTauMatrix());
        for (int dofIndex = 0; dofIndex < nDoFs; ++dofIndex) {
            qDot.zero();
            qDot.set(dofIndex, 0, 1.0);
            MultiBodySystemTools.insertJointsState((List)input.getJointsToConsider(), (JointStateType)JointStateType.VELOCITY, (DMatrix)qDot);
            input.getRootBody().updateFramesRecursively();
            integrator.integrateFromVelocitySubtree(input.getRootBody());
            input.getRootBody().updateFramesRecursively();
            calculator.setExternalWrenchesToZero();
            externalWrenchesWorld.forEach((body, wrench) -> calculator.getExternalWrench((RigidBodyReadOnly)body).setMatchingFrame((WrenchReadOnly)wrench));
            calculator.compute();
            CommonOps_DDRM.subtract((DMatrixD1)calculator.getJointTauMatrix(), (DMatrixD1)referenceGravity, (DMatrixD1)gradientCol);
            CommonOps_DDRM.scale((double)(1.0 / dq), (DMatrixD1)gradientCol);
            CommonOps_DDRM.insert((DMatrix)gradientCol, (DMatrix)gradient, (int)0, (int)dofIndex);
            MultiBodySystemTools.insertJointsState((List)input.getJointsToConsider(), (JointStateType)JointStateType.CONFIGURATION, (DMatrix)originalConfiguration);
        }
        MultiBodySystemTools.insertJointsState((List)input.getJointsToConsider(), (JointStateType)JointStateType.VELOCITY, (DMatrix)originalVelocity);
        input.getRootBody().updateFramesRecursively();
        return gradient;
    }
}

