/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.FixedJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class MultiBodySystemFactoriesTest {
    private static final int NUMBER_OF_ITERATIONS = 100;
    private static final double EPSILON = 1.0E-14;

    @Test
    public void testCloneKinematicChain() throws Exception {
        Random random = new Random(34636L);
        for (int i = 0; i < 100; ++i) {
            int jointIndex;
            List supportJoints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)5);
            RigidBodyBasics originalStart = ((JointBasics)supportJoints.get(random.nextInt(supportJoints.size()))).getSuccessor();
            List originalJoints = MultiBodySystemRandomTools.nextJointChain((Random)random, (String)"original", (RigidBodyBasics)originalStart, (int)5);
            Set jointNames = originalJoints.stream().map(JointReadOnly::getName).collect(Collectors.toSet());
            Assertions.assertEquals((int)originalJoints.size(), (int)jointNames.size());
            List originalSuccessors = originalJoints.stream().map(JointBasics::getSuccessor).collect(Collectors.toList());
            Set bodyNames = originalSuccessors.stream().map(RigidBodyReadOnly::getName).collect(Collectors.toSet());
            Assertions.assertEquals((int)originalSuccessors.size(), (int)bodyNames.size());
            String cloneSuffix = "Test";
            List<JointBasics> cloneJoints = Arrays.asList(MultiBodySystemFactories.cloneKinematicChain((JointReadOnly[])((JointReadOnly[])originalJoints.toArray(new JointBasics[originalJoints.size()])), (String)cloneSuffix));
            List cloneSuccessors = cloneJoints.stream().map(JointBasics::getSuccessor).collect(Collectors.toList());
            RigidBodyBasics cloneStart = MultiBodySystemTools.getRootBody((RigidBodyBasics)((RigidBodyBasics)cloneSuccessors.get(0)));
            Assertions.assertTrue((MultiBodySystemTools.getRootBody((RigidBodyBasics)cloneStart) != MultiBodySystemTools.getRootBody((RigidBodyBasics)originalStart) ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)cloneStart.isRootBody());
            Assertions.assertNull((Object)cloneStart.getInertia());
            Assertions.assertEquals((Object)(originalStart.getName() + cloneSuffix), (Object)cloneStart.getName());
            Assertions.assertTrue((originalStart.getBodyFixedFrame().getParent() == cloneStart.getBodyFixedFrame().getParent() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new RigidBodyTransform(), (EuclidGeometry)cloneStart.getBodyFixedFrame().getTransformToParent(), (double)1.0E-14);
            Assertions.assertEquals((int)originalJoints.size(), (int)cloneJoints.size());
            for (jointIndex = 0; jointIndex < originalJoints.size(); ++jointIndex) {
                JointBasics originalJoint = (JointBasics)originalJoints.get(jointIndex);
                JointBasics cloneJoint = cloneJoints.get(jointIndex);
                this.assertJointPropertiesEqual((JointReadOnly)originalJoint, (JointReadOnly)cloneJoint, cloneSuffix);
                String expectedCloneSuccessorName = originalJoint.getSuccessor().getName() + cloneSuffix;
                Assertions.assertEquals((Object)expectedCloneSuccessorName, (Object)cloneJoint.getSuccessor().getName());
            }
            Assertions.assertEquals((int)originalSuccessors.size(), (int)cloneSuccessors.size());
            for (int bodyIndex = 0; bodyIndex < originalSuccessors.size(); ++bodyIndex) {
                RigidBodyReadOnly originalBody = (RigidBodyReadOnly)originalSuccessors.get(bodyIndex);
                RigidBodyReadOnly cloneBody = (RigidBodyReadOnly)cloneSuccessors.get(bodyIndex);
                this.assertRigidBodyPropertiesEqual(originalBody, cloneBody, cloneSuffix);
                if (!originalBody.isRootBody()) {
                    Assertions.assertEquals((Object)(originalBody.getParentJoint().getName() + cloneSuffix), (Object)cloneBody.getParentJoint().getName());
                }
                List originalChildrenJoints = originalBody.getChildrenJoints();
                List cloneChildrenJoints = cloneBody.getChildrenJoints();
                Assertions.assertEquals((int)originalChildrenJoints.size(), (int)cloneChildrenJoints.size());
                for (int childIndex = 0; childIndex < originalChildrenJoints.size(); ++childIndex) {
                    JointReadOnly originalChildJoint = (JointReadOnly)originalChildrenJoints.get(childIndex);
                    JointReadOnly cloneChildJoint = (JointReadOnly)cloneChildrenJoints.get(childIndex);
                    Assertions.assertEquals((Object)(originalChildJoint.getName() + cloneSuffix), (Object)cloneChildJoint.getName());
                }
            }
            MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)supportJoints.get(0)).getPredecessor()).updateFramesRecursively();
            originalStart.updateFramesRecursively();
            cloneStart.updateFramesRecursively();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalStart.getParentJoint().getFrameAfterJoint().getTransformToRoot(), (EuclidGeometry)cloneStart.getBodyFixedFrame().getTransformToRoot(), (double)1.0E-14);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)((JointBasics)originalJoints.get(0)).getFrameBeforeJoint().getTransformToRoot(), (EuclidGeometry)cloneJoints.get(0).getFrameBeforeJoint().getTransformToRoot(), (double)1.0E-14);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)supportJoints);
            MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)supportJoints.get(0)).getPredecessor()).updateFramesRecursively();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalStart.getParentJoint().getFrameAfterJoint().getTransformToRoot(), (EuclidGeometry)cloneStart.getBodyFixedFrame().getTransformToRoot(), (double)1.0E-14);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)((JointBasics)originalJoints.get(0)).getFrameBeforeJoint().getTransformToRoot(), (EuclidGeometry)cloneJoints.get(0).getFrameBeforeJoint().getTransformToRoot(), (double)1.0E-14);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)originalJoints);
            MultiBodySystemTools.copyJointsState((List)originalJoints, cloneJoints, (JointStateType)JointStateType.CONFIGURATION);
            originalStart.updateFramesRecursively();
            cloneStart.updateFramesRecursively();
            for (jointIndex = 0; jointIndex < originalJoints.size(); ++jointIndex) {
                MovingReferenceFrame originalFrameAfterJoint = ((JointBasics)originalJoints.get(jointIndex)).getFrameAfterJoint();
                MovingReferenceFrame cloneFrameAfterJoint = cloneJoints.get(jointIndex).getFrameAfterJoint();
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalFrameAfterJoint.getTransformToParent(), (EuclidGeometry)cloneFrameAfterJoint.getTransformToParent(), (double)1.0E-14);
            }
            RigidBodyBasics originalLeaf = ((JointBasics)originalJoints.get(originalJoints.size() - 1)).getSuccessor();
            RigidBodyBasics cloneLeaf = cloneJoints.get(cloneJoints.size() - 1).getSuccessor();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalLeaf.getBodyFixedFrame().getTransformToRoot(), (EuclidGeometry)cloneLeaf.getBodyFixedFrame().getTransformToRoot(), (double)1.0E-14);
        }
    }

    @Test
    public void testCloneSubtree() throws Exception {
        Random random = new Random(34636L);
        for (int i = 0; i < 100; ++i) {
            int jointIndex;
            List supportJoints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)20);
            RigidBodyBasics originalStart = ((JointBasics)supportJoints.get(random.nextInt(supportJoints.size()))).getSuccessor();
            List originalJoints = MultiBodySystemRandomTools.nextJointTree((Random)random, (String)"original", (RigidBodyBasics)originalStart, (int)20);
            Set jointNames = originalJoints.stream().map(JointReadOnly::getName).collect(Collectors.toSet());
            Assertions.assertEquals((int)originalJoints.size(), (int)jointNames.size());
            List originalSuccessors = originalJoints.stream().map(JointBasics::getSuccessor).collect(Collectors.toList());
            Set bodyNames = originalSuccessors.stream().map(RigidBodyReadOnly::getName).collect(Collectors.toSet());
            Assertions.assertEquals((int)originalSuccessors.size(), (int)bodyNames.size());
            String cloneSuffix = "Test";
            RigidBodyBasics cloneStart = MultiBodySystemFactories.cloneSubtree((RigidBodyReadOnly)originalStart, (String)cloneSuffix);
            List cloneJoints = SubtreeStreams.fromChildren((RigidBodyBasics)cloneStart).collect(Collectors.toList());
            List cloneSuccessors = cloneJoints.stream().map(JointBasics::getSuccessor).collect(Collectors.toList());
            Assertions.assertTrue((MultiBodySystemTools.getRootBody((RigidBodyBasics)cloneStart) != MultiBodySystemTools.getRootBody((RigidBodyBasics)originalStart) ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)cloneStart.isRootBody());
            Assertions.assertNull((Object)cloneStart.getInertia());
            Assertions.assertEquals((Object)(originalStart.getName() + cloneSuffix), (Object)cloneStart.getName());
            Assertions.assertTrue((originalStart.getBodyFixedFrame().getParent() == cloneStart.getBodyFixedFrame().getParent() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new RigidBodyTransform(), (EuclidGeometry)cloneStart.getBodyFixedFrame().getTransformToParent(), (double)1.0E-14);
            Assertions.assertEquals((int)originalJoints.size(), (int)cloneJoints.size());
            for (jointIndex = 0; jointIndex < originalJoints.size(); ++jointIndex) {
                JointBasics originalJoint = (JointBasics)originalJoints.get(jointIndex);
                JointBasics cloneJoint = (JointBasics)cloneJoints.get(jointIndex);
                this.assertJointPropertiesEqual((JointReadOnly)originalJoint, (JointReadOnly)cloneJoint, cloneSuffix);
                String expectedCloneSuccessorName = originalJoint.getSuccessor().getName() + cloneSuffix;
                Assertions.assertEquals((Object)expectedCloneSuccessorName, (Object)cloneJoint.getSuccessor().getName());
            }
            Assertions.assertEquals((int)originalSuccessors.size(), (int)cloneSuccessors.size());
            for (int bodyIndex = 0; bodyIndex < originalSuccessors.size(); ++bodyIndex) {
                RigidBodyReadOnly originalBody = (RigidBodyReadOnly)originalSuccessors.get(bodyIndex);
                RigidBodyReadOnly cloneBody = (RigidBodyReadOnly)cloneSuccessors.get(bodyIndex);
                this.assertRigidBodyPropertiesEqual(originalBody, cloneBody, cloneSuffix);
                if (!originalBody.isRootBody()) {
                    Assertions.assertEquals((Object)(originalBody.getParentJoint().getName() + cloneSuffix), (Object)cloneBody.getParentJoint().getName());
                }
                List originalChildrenJoints = originalBody.getChildrenJoints();
                List cloneChildrenJoints = cloneBody.getChildrenJoints();
                Assertions.assertEquals((int)originalChildrenJoints.size(), (int)cloneChildrenJoints.size());
                for (int childIndex = 0; childIndex < originalChildrenJoints.size(); ++childIndex) {
                    JointReadOnly originalChildJoint = (JointReadOnly)originalChildrenJoints.get(childIndex);
                    JointReadOnly cloneChildJoint = (JointReadOnly)cloneChildrenJoints.get(childIndex);
                    Assertions.assertEquals((Object)(originalChildJoint.getName() + cloneSuffix), (Object)cloneChildJoint.getName());
                }
            }
            MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)supportJoints.get(0)).getPredecessor()).updateFramesRecursively();
            originalStart.updateFramesRecursively();
            cloneStart.updateFramesRecursively();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalStart.getParentJoint().getFrameAfterJoint().getTransformToRoot(), (EuclidGeometry)cloneStart.getBodyFixedFrame().getTransformToRoot(), (double)1.0E-14);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)((JointBasics)originalJoints.get(0)).getFrameBeforeJoint().getTransformToRoot(), (EuclidGeometry)((JointBasics)cloneJoints.get(0)).getFrameBeforeJoint().getTransformToRoot(), (double)1.0E-14);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)supportJoints);
            MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)supportJoints.get(0)).getPredecessor()).updateFramesRecursively();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalStart.getParentJoint().getFrameAfterJoint().getTransformToRoot(), (EuclidGeometry)cloneStart.getBodyFixedFrame().getTransformToRoot(), (double)1.0E-14);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)((JointBasics)originalJoints.get(0)).getFrameBeforeJoint().getTransformToRoot(), (EuclidGeometry)((JointBasics)cloneJoints.get(0)).getFrameBeforeJoint().getTransformToRoot(), (double)1.0E-14);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)originalJoints);
            MultiBodySystemTools.copyJointsState((List)originalJoints, cloneJoints, (JointStateType)JointStateType.CONFIGURATION);
            originalStart.updateFramesRecursively();
            cloneStart.updateFramesRecursively();
            for (jointIndex = 0; jointIndex < originalJoints.size(); ++jointIndex) {
                MovingReferenceFrame originalFrameAfterJoint = ((JointBasics)originalJoints.get(jointIndex)).getFrameAfterJoint();
                MovingReferenceFrame cloneFrameAfterJoint = ((JointBasics)cloneJoints.get(jointIndex)).getFrameAfterJoint();
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalFrameAfterJoint.getTransformToParent(), (EuclidGeometry)cloneFrameAfterJoint.getTransformToParent(), (double)1.0E-14);
            }
            RigidBodyBasics originalLeaf = ((JointBasics)originalJoints.get(originalJoints.size() - 1)).getSuccessor();
            RigidBodyBasics cloneLeaf = ((JointBasics)cloneJoints.get(cloneJoints.size() - 1)).getSuccessor();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalLeaf.getBodyFixedFrame().getTransformToRoot(), (EuclidGeometry)cloneLeaf.getBodyFixedFrame().getTransformToRoot(), (double)1.0E-14);
        }
    }

    @Test
    public void testCloneMultiBodySystem() throws Exception {
        Random random = new Random(346L);
        for (int i = 0; i < 100; ++i) {
            List originalJoints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)20);
            Set jointNames = originalJoints.stream().map(JointReadOnly::getName).collect(Collectors.toSet());
            Assertions.assertEquals((int)originalJoints.size(), (int)jointNames.size());
            RigidBodyBasics originalRootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)originalJoints.get(0)).getPredecessor());
            Set bodyNames = originalRootBody.subtreeStream().map(RigidBodyReadOnly::getName).collect(Collectors.toSet());
            Assertions.assertEquals((int)originalRootBody.subtreeList().size(), (int)bodyNames.size());
            String cloneSuffix = "Test";
            RigidBodyBasics cloneRootBody = MultiBodySystemFactories.cloneMultiBodySystem((RigidBodyReadOnly)originalRootBody, (ReferenceFrame)ReferenceFrame.getWorldFrame(), (String)cloneSuffix);
            List cloneJoints = SubtreeStreams.from(JointBasics.class, (Collection)cloneRootBody.getChildrenJoints()).collect(Collectors.toList());
            Assertions.assertEquals((int)originalJoints.size(), (int)cloneJoints.size());
            for (int jointIndex = 0; jointIndex < originalJoints.size(); ++jointIndex) {
                JointBasics originalJoint = (JointBasics)originalJoints.get(jointIndex);
                JointBasics cloneJoint = (JointBasics)cloneJoints.get(jointIndex);
                this.assertJointPropertiesEqual((JointReadOnly)originalJoint, (JointReadOnly)cloneJoint, cloneSuffix);
                String expectedClonePredecessorName = originalJoint.getPredecessor().getName() + cloneSuffix;
                Assertions.assertEquals((Object)expectedClonePredecessorName, (Object)cloneJoint.getPredecessor().getName());
                String expectedCloneSuccessorName = originalJoint.getSuccessor().getName() + cloneSuffix;
                Assertions.assertEquals((Object)expectedCloneSuccessorName, (Object)cloneJoint.getSuccessor().getName());
            }
            List originalBodies = originalRootBody.subtreeList();
            List cloneBodies = cloneRootBody.subtreeList();
            Assertions.assertEquals((int)originalBodies.size(), (int)cloneBodies.size());
            for (int bodyIndex = 0; bodyIndex < originalBodies.size(); ++bodyIndex) {
                RigidBodyReadOnly originalBody = (RigidBodyReadOnly)originalBodies.get(bodyIndex);
                RigidBodyReadOnly cloneBody = (RigidBodyReadOnly)cloneBodies.get(bodyIndex);
                this.assertRigidBodyPropertiesEqual(originalBody, cloneBody, cloneSuffix);
                if (!originalBody.isRootBody()) {
                    Assertions.assertEquals((Object)(originalBody.getParentJoint().getName() + cloneSuffix), (Object)cloneBody.getParentJoint().getName());
                }
                List originalChildrenJoints = originalBody.getChildrenJoints();
                List cloneChildrenJoints = cloneBody.getChildrenJoints();
                Assertions.assertEquals((int)originalChildrenJoints.size(), (int)cloneChildrenJoints.size());
                for (int childIndex = 0; childIndex < originalChildrenJoints.size(); ++childIndex) {
                    JointReadOnly originalChildJoint = (JointReadOnly)originalChildrenJoints.get(childIndex);
                    JointReadOnly cloneChildJoint = (JointReadOnly)cloneChildrenJoints.get(childIndex);
                    Assertions.assertEquals((Object)(originalChildJoint.getName() + cloneSuffix), (Object)cloneChildJoint.getName());
                }
            }
        }
    }

    @Test
    public void testCloneMultiBodySystemWithKinematicLoop() throws Exception {
        Random random = new Random(15641L);
        for (int i = 0; i < 100; ++i) {
            int numberOfJoints = 6;
            List originalPrimaryBranch = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            RigidBodyBasics originalRootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)originalPrimaryBranch.get(0)).getPredecessor());
            int loopStartIndex = random.nextInt(numberOfJoints);
            int loopEndIndex = random.nextInt(numberOfJoints);
            while (loopEndIndex == loopStartIndex) {
                loopEndIndex = random.nextInt(numberOfJoints);
            }
            if (loopStartIndex > loopEndIndex) {
                int temp = loopStartIndex;
                loopStartIndex = loopEndIndex;
                loopEndIndex = temp;
            }
            int kinematicLoopSize = random.nextInt(3) + 2;
            RigidBodyBasics loopStart = ((JointBasics)originalPrimaryBranch.get(loopStartIndex)).getSuccessor();
            RigidBodyBasics loopEnd = ((JointBasics)originalPrimaryBranch.get(loopEndIndex)).getSuccessor();
            List originalSecondaryBranch = MultiBodySystemRandomTools.nextKinematicLoopRevoluteJoints((Random)random, (String)"loop", (RigidBodyBasics)loopStart, (RigidBodyBasics)loopEnd, (int)kinematicLoopSize);
            ArrayList allOriginalJoints = new ArrayList();
            allOriginalJoints.addAll(originalPrimaryBranch);
            allOriginalJoints.addAll(originalSecondaryBranch);
            String cloneSuffix = "Test";
            RigidBodyBasics cloneRootBody = MultiBodySystemFactories.cloneMultiBodySystem((RigidBodyReadOnly)originalRootBody, (ReferenceFrame)ReferenceFrame.getWorldFrame(), (String)cloneSuffix);
            List allCloneJoints = SubtreeStreams.fromChildren((RigidBodyBasics)cloneRootBody).collect(Collectors.toList());
            Assertions.assertEquals((int)allOriginalJoints.size(), (int)allCloneJoints.size());
            for (JointBasics originalJoint : allOriginalJoints) {
                JointBasics cloneJoint = allCloneJoints.stream().filter(joint -> joint.getName().equals(originalJoint.getName() + cloneSuffix)).findFirst().get();
                this.assertJointPropertiesEqual((JointReadOnly)originalJoint, (JointReadOnly)cloneJoint, cloneSuffix);
                String expectedClonePredecessorName = originalJoint.getPredecessor().getName() + cloneSuffix;
                Assertions.assertEquals((Object)expectedClonePredecessorName, (Object)cloneJoint.getPredecessor().getName());
                String expectedCloneSuccessorName = originalJoint.getSuccessor().getName() + cloneSuffix;
                Assertions.assertEquals((Object)expectedCloneSuccessorName, (Object)cloneJoint.getSuccessor().getName());
                Assertions.assertEquals((Object)originalJoint.isLoopClosure(), (Object)cloneJoint.isLoopClosure());
                if (!originalJoint.isLoopClosure()) continue;
                Assertions.assertTrue((cloneJoint.getFrameAfterJoint() == cloneJoint.getLoopClosureFrame().getParent() ? 1 : 0) != 0);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)originalJoint.getLoopClosureFrame().getTransformToParent(), (EuclidGeometry)cloneJoint.getLoopClosureFrame().getTransformToParent(), (double)1.0E-14);
            }
            List originalBodies = originalRootBody.subtreeList();
            List cloneBodies = cloneRootBody.subtreeList();
            Assertions.assertEquals((int)originalBodies.size(), (int)cloneBodies.size(), (String)EuclidCoreIOTools.getCollectionString((String)"Name of clone bodies:\n", (String)"\n", (String)"\n", (Collection)cloneBodies, RigidBodyReadOnly::getName));
            Set cloneNameSet = cloneBodies.stream().map(RigidBodyReadOnly::getName).collect(Collectors.toSet());
            Assertions.assertEquals((int)cloneBodies.size(), (int)cloneNameSet.size());
            for (RigidBodyReadOnly originalBody : originalBodies) {
                RigidBodyBasics cloneBody = cloneBodies.stream().filter(body -> body.getName().equals(originalBody.getName() + cloneSuffix)).findFirst().get();
                this.assertRigidBodyPropertiesEqual(originalBody, (RigidBodyReadOnly)cloneBody, cloneSuffix);
                if (!originalBody.isRootBody()) {
                    Assertions.assertEquals((Object)(originalBody.getParentJoint().getName() + cloneSuffix), (Object)cloneBody.getParentJoint().getName());
                }
                Assertions.assertEquals((int)originalBody.getParentLoopClosureJoints().size(), (int)cloneBody.getParentLoopClosureJoints().size());
                for (int loopClosureIndex = 0; loopClosureIndex < originalBody.getParentLoopClosureJoints().size(); ++loopClosureIndex) {
                    Assertions.assertEquals((Object)(((JointReadOnly)originalBody.getParentLoopClosureJoints().get(loopClosureIndex)).getName() + cloneSuffix), (Object)((JointBasics)cloneBody.getParentLoopClosureJoints().get(loopClosureIndex)).getName());
                }
                List originalChildrenJoints = originalBody.getChildrenJoints();
                List cloneChildrenJoints = cloneBody.getChildrenJoints();
                Assertions.assertEquals((int)originalChildrenJoints.size(), (int)cloneChildrenJoints.size());
                for (int childIndex = 0; childIndex < originalChildrenJoints.size(); ++childIndex) {
                    JointReadOnly originalChildJoint = (JointReadOnly)originalChildrenJoints.get(childIndex);
                    JointReadOnly cloneChildJoint = (JointReadOnly)cloneChildrenJoints.get(childIndex);
                    Assertions.assertEquals((Object)(originalChildJoint.getName() + cloneSuffix), (Object)cloneChildJoint.getName());
                }
            }
        }
    }

    public void assertRigidBodyPropertiesEqual(RigidBodyReadOnly originalBody, RigidBodyReadOnly cloneBody, String cloneSuffix) {
        Assertions.assertEquals((Object)(originalBody.getName() + cloneSuffix), (Object)cloneBody.getName());
        Assertions.assertTrue((originalBody.isRootBody() == cloneBody.isRootBody() ? 1 : 0) != 0);
        MovingReferenceFrame originalBodyFixedFrame = originalBody.getBodyFixedFrame();
        MovingReferenceFrame cloneBodyFixedFrame = cloneBody.getBodyFixedFrame();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)originalBodyFixedFrame.getTransformToParent(), (EuclidGeometry)cloneBodyFixedFrame.getTransformToParent(), (double)1.0E-14);
        if (originalBody.isRootBody()) {
            Assertions.assertNull((Object)cloneBody.getInertia());
            Assertions.assertEquals((Object)(originalBodyFixedFrame.getName().replaceAll("Frame", "") + cloneSuffix + "Frame"), (Object)cloneBodyFixedFrame.getName());
            Assertions.assertTrue((originalBodyFixedFrame.getParent() == cloneBodyFixedFrame.getParent() ? 1 : 0) != 0);
        } else {
            Assertions.assertEquals((Object)(originalBodyFixedFrame.getName().replaceAll("CoM", "") + cloneSuffix + "CoM"), (Object)cloneBodyFixedFrame.getName());
            SpatialInertiaReadOnly originalInertia = originalBody.getInertia();
            SpatialInertiaReadOnly cloneInertia = cloneBody.getInertia();
            Assertions.assertEquals((double)originalInertia.getMass(), (double)cloneInertia.getMass(), (double)1.0E-14);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)originalInertia.getMomentOfInertia(), (Matrix3DReadOnly)cloneInertia.getMomentOfInertia(), (double)1.0E-14);
        }
    }

    public void assertJointPropertiesEqual(JointReadOnly originalJoint, JointReadOnly cloneJoint, String cloneSuffix) {
        Assertions.assertEquals((Object)(originalJoint.getName() + cloneSuffix), (Object)cloneJoint.getName());
        MovingReferenceFrame frameAfterOriginalJoint = originalJoint.getFrameAfterJoint();
        MovingReferenceFrame frameAfterCloneJoint = cloneJoint.getFrameAfterJoint();
        if (originalJoint instanceof FixedJoint && cloneJoint instanceof FixedJoint) {
            Assertions.assertTrue((cloneJoint.getFrameAfterJoint() == cloneJoint.getFrameBeforeJoint() ? 1 : 0) != 0);
        } else {
            Assertions.assertEquals((Object)(frameAfterOriginalJoint.getName() + cloneSuffix), (Object)frameAfterCloneJoint.getName());
        }
        MovingReferenceFrame frameBeforeOriginalJoint = originalJoint.getFrameBeforeJoint();
        MovingReferenceFrame frameBeforeCloneJoint = cloneJoint.getFrameBeforeJoint();
        if (originalJoint.getPredecessor().isRootBody() || originalJoint instanceof FixedJoint && cloneJoint instanceof FixedJoint) {
            Assertions.assertEquals((Object)frameBeforeOriginalJoint.getName().replaceAll("Frame", cloneSuffix + "Frame"), (Object)frameBeforeCloneJoint.getName());
        } else {
            Assertions.assertEquals((Object)(frameBeforeOriginalJoint.getName() + cloneSuffix), (Object)frameBeforeCloneJoint.getName());
        }
        EuclidCoreTestTools.assertEquals((EuclidGeometry)frameBeforeOriginalJoint.getTransformToParent(), (EuclidGeometry)frameBeforeCloneJoint.getTransformToParent(), (double)1.0E-14);
        Assertions.assertEquals(originalJoint.getClass(), cloneJoint.getClass());
        if (originalJoint instanceof OneDoFJointReadOnly) {
            OneDoFJointReadOnly originalOneDoFJoint = (OneDoFJointReadOnly)originalJoint;
            OneDoFJointReadOnly cloneOneDoFJoint = (OneDoFJointReadOnly)cloneJoint;
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalOneDoFJoint.getJointAxis(), (EuclidGeometry)cloneOneDoFJoint.getJointAxis(), (double)1.0E-14);
        }
    }
}

