/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MecanoTools;

public class MecanoToolsTest {
    private static final double EPSILON = 1.0E-12;
    private static final int ITERATIONS = 1000;

    @Test
    public void testStringMethod() {
        String emptyString = new String();
        Assertions.assertEquals((Object)emptyString, (Object)MecanoTools.capitalize((String)emptyString));
        Assertions.assertEquals(null, (Object)MecanoTools.capitalize(null));
        int stringSize = 10;
        Object str = new String();
        Random random = new Random(1243L);
        int randomInt = random.nextInt();
        for (int i = 0; i < 1000; ++i) {
            randomInt = random.nextInt();
            boolean upper = randomInt % 2 == 0;
            for (int j = 0; j < stringSize; ++j) {
                randomInt = random.nextInt();
                char c = true == upper ? (char)(65 + randomInt % 26) : (char)(97 + randomInt % 26);
                str = (String)str + c;
            }
            if (upper) {
                Assertions.assertEquals((Object)str, (Object)MecanoTools.capitalize((String)str));
            } else {
                Assertions.assertEquals((Object)MecanoTools.capitalize((String)str), (Object)(Character.toUpperCase(((String)str).charAt(0)) + ((String)str).substring(1, ((String)str).length())));
            }
            str = "";
        }
    }

    @Test
    public void testMatrix3DChecks() {
        Random random = new Random(1234L);
        for (int i = 0; i < 1000; ++i) {
            boolean diagonal;
            double a = random.nextDouble();
            double b = random.nextDouble();
            double c = random.nextDouble();
            Matrix3D symmetricMatrix3D = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Assertions.assertFalse((boolean)MecanoTools.isMatrix3DSymmetric((Matrix3DReadOnly)symmetricMatrix3D, (double)1.0E-12));
            symmetricMatrix3D.setM01(a);
            symmetricMatrix3D.setM10(a);
            Assertions.assertFalse((boolean)MecanoTools.isMatrix3DSymmetric((Matrix3DReadOnly)symmetricMatrix3D, (double)1.0E-12));
            symmetricMatrix3D.setM02(b);
            symmetricMatrix3D.setM20(b);
            Assertions.assertFalse((boolean)MecanoTools.isMatrix3DSymmetric((Matrix3DReadOnly)symmetricMatrix3D, (double)1.0E-12));
            symmetricMatrix3D.setM12(c);
            symmetricMatrix3D.setM21(c);
            Assertions.assertTrue((boolean)MecanoTools.isMatrix3DSymmetric((Matrix3DReadOnly)symmetricMatrix3D, (double)1.0E-12));
            int randomInt = random.nextInt();
            Matrix3D diagonalMatrix3D = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            boolean bl = diagonal = randomInt % 2 == 0;
            if (diagonal) {
                diagonalMatrix3D.setM01(0.0);
                diagonalMatrix3D.setM02(0.0);
                diagonalMatrix3D.setM12(0.0);
                diagonalMatrix3D.setM10(0.0);
                diagonalMatrix3D.setM20(0.0);
                diagonalMatrix3D.setM21(0.0);
                Assertions.assertTrue((boolean)MecanoTools.isMatrix3DDiagonal((Matrix3DReadOnly)diagonalMatrix3D, (double)1.0E-12));
                continue;
            }
            Assertions.assertFalse((boolean)MecanoTools.isMatrix3DDiagonal((Matrix3DReadOnly)diagonalMatrix3D, (double)1.0E-12));
        }
    }

    @Test
    public void testTildeForm() {
        Random random = new Random(5432L);
        int min = -100000;
        int max = 100000;
        int dimension = 0;
        for (int i = 0; i < 1000; ++i) {
            Vector3D vector3D_A = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D vector3D_B = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D expectedCrossProduct = new Vector3D();
            expectedCrossProduct.cross((Tuple3DReadOnly)vector3D_A, (Tuple3DReadOnly)vector3D_B);
            int randomInt = random.nextInt();
            switch (randomInt % 4) {
                case 0: {
                    dimension = 3;
                }
                case 1: {
                    dimension = 4;
                }
                case 2: {
                    dimension = 5;
                }
                case 3: {
                    dimension = 6;
                }
            }
            DMatrixRMaj random_matrix = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)dimension, (int)dimension, (double)min, (double)max);
            int row = Math.abs(randomInt) % (dimension - 2);
            randomInt = random.nextInt();
            int col = Math.abs(randomInt) % (dimension - 2);
            MecanoTools.toTildeForm((Tuple3DReadOnly)vector3D_A, (int)row, (int)col, (DMatrix)random_matrix);
            DMatrixRMaj tildeForm_A = CommonOps_DDRM.extract((DMatrixRMaj)random_matrix, (int)row, (int)(row + 3), (int)col, (int)(col + 3));
            Vector3D toBeTestedCrossProduct = new Vector3D(tildeForm_A.get(0, 0) * vector3D_B.getX() + tildeForm_A.get(0, 1) * vector3D_B.getY() + tildeForm_A.get(0, 2) * vector3D_B.getZ(), tildeForm_A.get(1, 0) * vector3D_B.getX() + tildeForm_A.get(1, 1) * vector3D_B.getY() + tildeForm_A.get(1, 2) * vector3D_B.getZ(), tildeForm_A.get(2, 0) * vector3D_B.getX() + tildeForm_A.get(2, 1) * vector3D_B.getY() + tildeForm_A.get(2, 2) * vector3D_B.getZ());
            Assertions.assertEquals((Object)expectedCrossProduct, (Object)toBeTestedCrossProduct);
        }
    }

    @Test
    public void testAddSubEquals() {
        Random random = new Random(1234L);
        for (int i = 0; i < 1000; ++i) {
            Matrix3D operatorMatrix3D = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            DMatrix3x3 operatorMatrix3x3 = new DMatrix3x3();
            operatorMatrix3D.get((DMatrix)operatorMatrix3x3);
            Matrix3D expectedMatrix3D = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D toBeTestedMatrix3D = new Matrix3D((Matrix3DReadOnly)expectedMatrix3D);
            expectedMatrix3D.add((Matrix3DReadOnly)operatorMatrix3D);
            MecanoTools.addEquals((int)0, (int)0, (DMatrix)operatorMatrix3x3, (Matrix3DBasics)toBeTestedMatrix3D);
            Assertions.assertEquals((Object)expectedMatrix3D, (Object)toBeTestedMatrix3D);
            expectedMatrix3D.sub((Matrix3DReadOnly)operatorMatrix3D);
            MecanoTools.subEquals((int)0, (int)0, (DMatrix)operatorMatrix3x3, (Matrix3DBasics)toBeTestedMatrix3D);
            Assertions.assertEquals((Object)expectedMatrix3D, (Object)toBeTestedMatrix3D);
        }
    }

    @Test
    public void testTranslateMomentOfInertia() {
        Matrix3D actual;
        Matrix3D expected;
        Matrix3D inertiaOriginal;
        Vector3D translation;
        Vector3D centerOfMass;
        double mass;
        int i;
        Random random = new Random(2342L);
        for (i = 0; i < 1000; ++i) {
            mass = random.nextDouble();
            centerOfMass = EuclidCoreRandomTools.nextVector3D((Random)random);
            translation = EuclidCoreRandomTools.nextVector3D((Random)random);
            inertiaOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            expected = new Matrix3D((Matrix3DReadOnly)inertiaOriginal);
            actual = new Matrix3D((Matrix3DReadOnly)inertiaOriginal);
            MecanoTools.translateMomentOfInertia((double)mass, (Tuple3DReadOnly)centerOfMass, (boolean)false, (Tuple3DReadOnly)translation, (Matrix3DBasics)actual);
            centerOfMass.add((Tuple3DReadOnly)translation);
            translation.negate();
            MecanoTools.translateMomentOfInertia((double)mass, (Tuple3DReadOnly)centerOfMass, (boolean)false, (Tuple3DReadOnly)translation, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            mass = random.nextDouble();
            centerOfMass = EuclidCoreRandomTools.nextVector3D((Random)random);
            translation = EuclidCoreRandomTools.nextVector3D((Random)random);
            inertiaOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            expected = new Matrix3D();
            Matrix3D cTilde = new Matrix3D();
            cTilde.setToTildeForm((Tuple3DReadOnly)centerOfMass);
            Matrix3D pTilde = new Matrix3D();
            pTilde.setToTildeForm((Tuple3DReadOnly)translation);
            Matrix3D cTilde_pTilde = new Matrix3D((Matrix3DReadOnly)cTilde);
            cTilde_pTilde.multiply((Matrix3DReadOnly)pTilde);
            Matrix3D pTilde_cTilde = new Matrix3D((Matrix3DReadOnly)pTilde);
            pTilde_cTilde.multiply((Matrix3DReadOnly)cTilde);
            Matrix3D pTilde_pTilde = new Matrix3D((Matrix3DReadOnly)pTilde);
            pTilde_pTilde.multiply((Matrix3DReadOnly)pTilde);
            expected.set(cTilde_pTilde);
            expected.add((Matrix3DReadOnly)pTilde_cTilde);
            expected.add((Matrix3DReadOnly)pTilde_pTilde);
            expected.scale(-mass);
            expected.add((Matrix3DReadOnly)inertiaOriginal);
            actual = new Matrix3D((Matrix3DReadOnly)inertiaOriginal);
            MecanoTools.translateMomentOfInertia((double)mass, (Tuple3DReadOnly)centerOfMass, (boolean)false, (Tuple3DReadOnly)translation, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            mass = random.nextDouble();
            centerOfMass = EuclidCoreRandomTools.nextVector3D((Random)random);
            translation = EuclidCoreRandomTools.nextVector3D((Random)random);
            inertiaOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D pre_negatedTensor = new Matrix3D((Matrix3DReadOnly)inertiaOriginal);
            Matrix3D negationTestTensor = new Matrix3D((Matrix3DReadOnly)inertiaOriginal);
            MecanoTools.translateMomentOfInertia((double)mass, (Tuple3DReadOnly)centerOfMass, (boolean)true, (Tuple3DReadOnly)translation, (Matrix3DBasics)negationTestTensor);
            translation.negate();
            MecanoTools.translateMomentOfInertia((double)mass, (Tuple3DReadOnly)centerOfMass, (boolean)false, (Tuple3DReadOnly)translation, (Matrix3DBasics)pre_negatedTensor);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)pre_negatedTensor, (Matrix3DReadOnly)negationTestTensor, (double)1.0E-12);
        }
    }

    @Test
    public void testComputeDynamicForce() throws Exception {
        Vector3D dynamicForce2;
        Vector3D dynamicForce1;
        Vector3D expected;
        Vector3D linearVelocity;
        Vector3D angularVelocity;
        Vector3D linearAcceleration;
        Vector3D angularAcceleration;
        Vector3D centerOfMassOffset;
        double mass;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            mass = random.nextDouble();
            centerOfMassOffset = new Vector3D();
            angularAcceleration = EuclidCoreRandomTools.nextVector3D((Random)random);
            linearAcceleration = EuclidCoreRandomTools.nextVector3D((Random)random);
            angularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            linearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D dynamicForce12 = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D dynamicForce22 = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicForce((double)mass, (Vector3DReadOnly)centerOfMassOffset, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce12);
            MecanoTools.computeDynamicForceFast((double)mass, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce22);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)dynamicForce12, (EuclidGeometry)dynamicForce22, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            mass = random.nextDouble();
            centerOfMassOffset = EuclidCoreRandomTools.nextVector3D((Random)random);
            angularAcceleration = new Vector3D();
            linearAcceleration = new Vector3D();
            angularVelocity = new Vector3D();
            linearVelocity = new Vector3D();
            expected = new Vector3D();
            dynamicForce1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            dynamicForce2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicForce((double)mass, (Vector3DReadOnly)centerOfMassOffset, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce1);
            MecanoTools.computeDynamicForceFast((double)mass, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)dynamicForce1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)dynamicForce2, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            mass = random.nextDouble();
            centerOfMassOffset = EuclidCoreRandomTools.nextVector3D((Random)random);
            angularAcceleration = new Vector3D();
            linearAcceleration = new Vector3D();
            angularVelocity = new Vector3D();
            angularVelocity.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)centerOfMassOffset);
            linearVelocity = new Vector3D();
            linearVelocity.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)angularVelocity);
            expected = new Vector3D();
            dynamicForce1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            dynamicForce2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicForceFast((double)mass, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce1);
            MecanoTools.computeDynamicForce((double)mass, (Vector3DReadOnly)centerOfMassOffset, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)dynamicForce1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)dynamicForce2, (double)1.0E-12);
        }
    }

    @Test
    public void testComputeDynamicMoment() throws Exception {
        Vector3D dynamicMoment2;
        Vector3D dynamicMoment1;
        Vector3D expected;
        Vector3D linearVelocity;
        Vector3D angularVelocity;
        Vector3D linearAcceleration;
        Vector3D angularAcceleration;
        Vector3D centerOfMassOffset;
        double mass;
        Matrix3D momentOfInertia;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            momentOfInertia = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            mass = random.nextDouble();
            centerOfMassOffset = new Vector3D();
            angularAcceleration = EuclidCoreRandomTools.nextVector3D((Random)random);
            linearAcceleration = EuclidCoreRandomTools.nextVector3D((Random)random);
            angularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            linearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D dynamicMoment12 = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D dynamicMoment22 = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicMoment((Matrix3DReadOnly)momentOfInertia, (double)mass, (Vector3DReadOnly)centerOfMassOffset, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicMoment12);
            MecanoTools.computeDynamicMomentFast((Matrix3DReadOnly)momentOfInertia, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DBasics)dynamicMoment22);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)dynamicMoment12, (EuclidGeometry)dynamicMoment22, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            momentOfInertia = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            mass = random.nextDouble();
            centerOfMassOffset = EuclidCoreRandomTools.nextVector3D((Random)random);
            angularAcceleration = new Vector3D();
            linearAcceleration = new Vector3D();
            angularVelocity = new Vector3D();
            linearVelocity = new Vector3D();
            expected = new Vector3D();
            dynamicMoment1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            dynamicMoment2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicMoment((Matrix3DReadOnly)momentOfInertia, (double)mass, (Vector3DReadOnly)centerOfMassOffset, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicMoment1);
            MecanoTools.computeDynamicMomentFast((Matrix3DReadOnly)momentOfInertia, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DBasics)dynamicMoment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)dynamicMoment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)dynamicMoment2, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            momentOfInertia = new Matrix3D();
            momentOfInertia.setIdentity();
            momentOfInertia.scale(random.nextDouble());
            mass = random.nextDouble();
            centerOfMassOffset = EuclidCoreRandomTools.nextVector3D((Random)random);
            angularAcceleration = new Vector3D();
            linearAcceleration = new Vector3D();
            angularVelocity = new Vector3D();
            angularVelocity.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)centerOfMassOffset);
            linearVelocity = new Vector3D();
            linearVelocity.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)angularVelocity);
            expected = new Vector3D();
            dynamicMoment1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            dynamicMoment2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicMomentFast((Matrix3DReadOnly)momentOfInertia, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DBasics)dynamicMoment1);
            MecanoTools.computeDynamicMoment((Matrix3DReadOnly)momentOfInertia, (double)mass, (Vector3DReadOnly)centerOfMassOffset, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicMoment2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)dynamicMoment1, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)dynamicMoment2, (double)1.0E-12);
        }
    }

    @Test
    public void testComputeDynamicWrench() throws Exception {
        ReferenceFrame frameA;
        ReferenceFrame bodyFrame;
        int i;
        Random random = new Random(3453L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        for (i = 0; i < 1000; ++i) {
            bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialInertia inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrame, (double)1.0, (double)1.0, (double)0.0);
            inertia.getMomentOfInertia().setIdentity();
            double rotationalInertia = random.nextDouble();
            inertia.getMomentOfInertia().scale(rotationalInertia);
            SpatialAcceleration acceleration = MecanoRandomTools.nextSpatialAcceleration((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)bodyFrame);
            Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)bodyFrame);
            twist.getLinearPart().setAndScale(EuclidCoreRandomTools.nextDouble((Random)random), (FrameTuple3DReadOnly)twist.getAngularPart());
            Wrench expectedWrenchAtBody = new Wrench(bodyFrame, bodyFrame);
            expectedWrenchAtBody.getAngularPart().setAndScale(rotationalInertia, (FrameTuple3DReadOnly)acceleration.getAngularPart());
            expectedWrenchAtBody.getLinearPart().setAndScale(inertia.getMass(), (FrameTuple3DReadOnly)acceleration.getLinearPart());
            Wrench wrenchAtBody = new Wrench(bodyFrame, bodyFrame);
            Wrench wrenchAtFrameA = new Wrench(bodyFrame, frameA);
            MecanoTools.computeDynamicMomentFast((Matrix3DReadOnly)inertia.getMomentOfInertia(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DBasics)wrenchAtBody.getAngularPart());
            MecanoTools.computeDynamicForceFast((double)inertia.getMass(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtBody.getLinearPart());
            inertia.changeFrame(frameA);
            acceleration.changeFrame(frameA);
            twist.changeFrame(frameA);
            MecanoTools.computeDynamicMoment((Matrix3DReadOnly)inertia.getMomentOfInertia(), (double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtFrameA.getAngularPart());
            MecanoTools.computeDynamicForce((double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtFrameA.getLinearPart());
            wrenchAtFrameA.changeFrame(bodyFrame);
            MecanoTestTools.assertWrenchEquals((String)("Iteration: " + i), (WrenchReadOnly)expectedWrenchAtBody, (WrenchReadOnly)wrenchAtBody, (double)1.0E-12);
            MecanoTestTools.assertWrenchEquals((String)("Iteration: " + i), (WrenchReadOnly)expectedWrenchAtBody, (WrenchReadOnly)wrenchAtFrameA, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialInertia inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrame, (double)1.0, (double)1.0, (double)0.0);
            SpatialAcceleration acceleration = MecanoRandomTools.nextSpatialAcceleration((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)bodyFrame);
            Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)bodyFrame);
            Wrench wrenchAtBody = new Wrench(bodyFrame, bodyFrame);
            Wrench wrenchAtFrameA = new Wrench(bodyFrame, frameA);
            Wrench wrenchAtFrameB = new Wrench(bodyFrame, frameB);
            MecanoTools.computeDynamicMomentFast((Matrix3DReadOnly)inertia.getMomentOfInertia(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DBasics)wrenchAtBody.getAngularPart());
            MecanoTools.computeDynamicForceFast((double)inertia.getMass(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtBody.getLinearPart());
            inertia.changeFrame(frameA);
            acceleration.changeFrame(frameA);
            twist.changeFrame(frameA);
            MecanoTools.computeDynamicMoment((Matrix3DReadOnly)inertia.getMomentOfInertia(), (double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtFrameA.getAngularPart());
            MecanoTools.computeDynamicForce((double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtFrameA.getLinearPart());
            inertia.changeFrame(frameB);
            acceleration.changeFrame(frameB);
            twist.changeFrame(frameB);
            MecanoTools.computeDynamicMoment((Matrix3DReadOnly)inertia.getMomentOfInertia(), (double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtFrameB.getAngularPart());
            MecanoTools.computeDynamicForce((double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtFrameB.getLinearPart());
            wrenchAtFrameA.changeFrame(bodyFrame);
            MecanoTestTools.assertWrenchEquals((WrenchReadOnly)wrenchAtBody, (WrenchReadOnly)wrenchAtFrameA, (double)1.0E-12);
            wrenchAtBody.changeFrame(frameB);
            MecanoTestTools.assertWrenchEquals((WrenchReadOnly)wrenchAtFrameB, (WrenchReadOnly)wrenchAtBody, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            Matrix3D momentOfInertia = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Vector3D dynamicMoment = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicMomentFast((Matrix3DReadOnly)momentOfInertia, null, null, (Vector3DBasics)dynamicMoment);
            Assertions.assertEquals((Object)EuclidCoreTools.zeroVector3D, (Object)dynamicMoment);
        }
    }

    @Test
    public void testComputeKineticCoEnergy() throws Exception {
        Random random = new Random(4636L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame expressedInFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialInertia inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)expressedInFrame);
            Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)expressedInFrame);
            double actual = MecanoTools.computeKineticCoEnergy((Matrix3DReadOnly)inertia.getMomentOfInertia(), (double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart());
            DMatrixRMaj inertiaMatrix = new DMatrixRMaj(6, 6);
            DMatrixRMaj twistMatrix = new DMatrixRMaj(6, 1);
            twist.get((DMatrix)twistMatrix);
            inertia.get((DMatrix)inertiaMatrix);
            DMatrixRMaj intermediate = new DMatrixRMaj(1, 6);
            CommonOps_DDRM.multTransA((DMatrix1Row)twistMatrix, (DMatrix1Row)inertiaMatrix, (DMatrix1Row)intermediate);
            DMatrixRMaj energyMatrix = new DMatrixRMaj(1, 1);
            CommonOps_DDRM.mult((DMatrix1Row)intermediate, (DMatrix1Row)twistMatrix, (DMatrix1Row)energyMatrix);
            double expected = 0.5 * energyMatrix.get(0);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testTransformSymmetricMatrix3D() throws Exception {
        Random random = new Random(4363L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Matrix3D expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            expected.setM10(expected.getM01());
            expected.setM20(expected.getM02());
            expected.setM21(expected.getM12());
            Matrix3D actual = new Matrix3D((Matrix3DReadOnly)expected);
            rotationMatrix.transform((Matrix3DBasics)expected);
            MecanoTools.transformSymmetricMatrix3D((RotationMatrixReadOnly)rotationMatrix, (Matrix3DBasics)actual);
        }
    }

    @Test
    public void testInverseTransformSymmetricMatrix3D() throws Exception {
        Random random = new Random(4363L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Matrix3D expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            expected.setM10(expected.getM01());
            expected.setM20(expected.getM02());
            expected.setM21(expected.getM12());
            Matrix3D actual = new Matrix3D((Matrix3DReadOnly)expected);
            rotationMatrix.inverseTransform((Matrix3DBasics)expected);
            MecanoTools.inverseTransformSymmetricMatrix3D((RotationMatrixReadOnly)rotationMatrix, (Matrix3DBasics)actual);
        }
    }

    @Test
    public void testAddEquals() {
        DMatrixRMaj actual;
        DMatrixRMaj expected;
        int startRow;
        int numCol;
        int numRow;
        int i;
        Random random = new Random(3424L);
        for (i = 0; i < 1000; ++i) {
            numRow = 6 + random.nextInt(10);
            numCol = 1 + random.nextInt(10);
            DMatrixRMaj original = RandomMatrices_DDRM.rectangle((int)numRow, (int)numCol, (double)-10.0, (double)10.0, (Random)random);
            SpatialVector vector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            startRow = numRow == 6 ? 0 : random.nextInt(numRow - 6);
            int column = numCol == 1 ? 0 : random.nextInt(numCol - 1);
            expected = new DMatrixRMaj(original.getNumRows(), original.getNumCols());
            vector.get(startRow, column, (DMatrix)expected);
            CommonOps_DDRM.addEquals((DMatrixD1)expected, (DMatrixD1)original);
            actual = new DMatrixRMaj(original);
            MecanoTools.addEquals((int)startRow, (int)column, (SpatialVectorReadOnly)vector, (DMatrixRMaj)actual);
            MecanoTestTools.assertDMatrixEquals((DMatrix)expected, (DMatrix)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            numRow = 3 + random.nextInt(10);
            numCol = 3 + random.nextInt(10);
            DMatrixRMaj matrixToAdd = RandomMatrices_DDRM.rectangle((int)numRow, (int)numCol, (double)-10.0, (double)10.0, (Random)random);
            Matrix3D original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            startRow = numRow == 3 ? 0 : random.nextInt(numRow - 3);
            int startCol = numCol == 3 ? 0 : random.nextInt(numCol - 3);
            expected = new Matrix3D();
            expected.set(startRow, startCol, (DMatrix)matrixToAdd);
            expected.add((Matrix3DReadOnly)original);
            actual = new Matrix3D((Matrix3DReadOnly)original);
            MecanoTools.addEquals((int)startRow, (int)startCol, (DMatrix)matrixToAdd, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }
}

