/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.iterators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.IteratorSearchMode;
import us.ihmc.mecano.multiBodySystem.iterators.JointIterableTest;
import us.ihmc.mecano.multiBodySystem.iterators.RigidBodyIterable;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaBasics;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class RigidBodyIterableTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testChain() {
        IteratorSearchMode mode;
        List joints;
        int numberOfJoints;
        int i;
        Random random = new Random(43954L);
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            mode = (IteratorSearchMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])IteratorSearchMode.values());
            RigidBodyReadOnly root = ((JointReadOnly)joints.get(0)).getPredecessor();
            RigidBodyIterable bodyIterable = new RigidBodyIterable(RigidBodyReadOnly.class, null, mode, root);
            for (int j = 0; j < 2; ++j) {
                Iterator iterator = bodyIterable.iterator();
                Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertTrue((root == iterator.next() ? 1 : 0) != 0);
                for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertTrue((((JointReadOnly)joints.get(jointIndex)).getSuccessor() == iterator.next() ? 1 : 0) != 0);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(50) + 1;
            joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            mode = (IteratorSearchMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])IteratorSearchMode.values());
            RigidBodyBasics rootBody = ((JointBasics)joints.get(0)).getPredecessor();
            if (random.nextBoolean()) {
                rootBody = new CustomRigidBodyType(rootBody);
            }
            ArrayList<RigidBodyBasics> bodies = new ArrayList<RigidBodyBasics>();
            bodies.add(rootBody);
            for (int jointIndex = 0; jointIndex < joints.size(); ++jointIndex) {
                RigidBodyBasics successor = ((JointBasics)joints.get(jointIndex)).getSuccessor();
                if (random.nextBoolean()) {
                    successor = new CustomRigidBodyType(successor);
                }
                bodies.add(successor);
            }
            RigidBodyIterable bodyIterable = new RigidBodyIterable(CustomRigidBodyType.class, null, mode, (RigidBodyReadOnly)rootBody);
            for (int j = 0; j < 2; ++j) {
                Iterator iterator = bodyIterable.iterator();
                for (int bodyIndex = 0; bodyIndex < bodies.size(); ++bodyIndex) {
                    if (!(bodies.get(bodyIndex) instanceof CustomRigidBodyType)) continue;
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertTrue((bodies.get(bodyIndex) == iterator.next() ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testChainWithKinematicLoop() {
        Random random = new Random(43954L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfJoints = random.nextInt(50) + 2;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            IteratorSearchMode mode = (IteratorSearchMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])IteratorSearchMode.values());
            RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)joints.get(0)).getPredecessor());
            int loopStartIndex = random.nextInt(numberOfJoints);
            int loopEndIndex = random.nextInt(numberOfJoints);
            while (loopEndIndex == loopStartIndex) {
                loopEndIndex = random.nextInt(numberOfJoints);
            }
            if (loopStartIndex > loopEndIndex) {
                int temp = loopStartIndex;
                loopStartIndex = loopEndIndex;
                loopEndIndex = temp;
            }
            int kinematicLoopSize = random.nextInt(10) + 2;
            RigidBodyBasics loopStart = ((JointBasics)joints.get(loopStartIndex)).getSuccessor();
            RigidBodyBasics loopEnd = ((JointBasics)joints.get(loopEndIndex)).getSuccessor();
            MultiBodySystemRandomTools.nextKinematicLoopRevoluteJoints((Random)random, (String)"loop", (RigidBodyBasics)loopStart, (RigidBodyBasics)loopEnd, (int)kinematicLoopSize);
            RigidBodyIterable bodyIterable = new RigidBodyIterable(RigidBodyBasics.class, null, mode, (RigidBodyReadOnly)rootBody);
            ArrayList iterableBodies = new ArrayList();
            bodyIterable.iterator().forEachRemaining(iterableBodies::add);
            Assertions.assertEquals((int)(numberOfJoints + kinematicLoopSize), (int)iterableBodies.size());
            Assertions.assertEquals((int)new HashSet(iterableBodies).size(), (int)iterableBodies.size());
        }
    }

    @Test
    public void testTreeDepth1() throws Exception {
        Random random = new Random(324534L);
        for (int i = 0; i < 1000; ++i) {
            RigidBody rootBody = new RigidBody("rootBody", ReferenceFrame.getWorldFrame());
            JointBasics rootJoint = MultiBodySystemRandomTools.nextJoint((Random)random, (String)"root", (RigidBodyBasics)rootBody);
            IteratorSearchMode mode = (IteratorSearchMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])IteratorSearchMode.values());
            RigidBody rootJointSuccessor = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"rootJointSuccessor", (JointBasics)rootJoint);
            int numberOfChildren = 10;
            for (int childIndex = 0; childIndex < numberOfChildren; ++childIndex) {
                JointBasics childJoint = MultiBodySystemRandomTools.nextJoint((Random)random, (String)"jointDepth1", (RigidBodyBasics)rootJointSuccessor);
                MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"bodyDepth1", (JointBasics)childJoint);
            }
            RigidBodyIterable bodyIterable = new RigidBodyIterable(RigidBodyReadOnly.class, null, mode, (RigidBodyReadOnly)rootBody);
            Iterator iterator = bodyIterable.iterator();
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertTrue((rootBody == iterator.next() ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertTrue((rootJointSuccessor == iterator.next() ? 1 : 0) != 0);
            for (int childIndex = 0; childIndex < numberOfChildren; ++childIndex) {
                Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertTrue((((JointBasics)rootJointSuccessor.getChildrenJoints().get(childIndex)).getSuccessor() == iterator.next() ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testTreeDepth2() throws Exception {
        RigidBodyBasics grandChildBody;
        int childIndex;
        Iterator iterator;
        RigidBodyIterable bodyIterable;
        JointBasics childJoint;
        int numberOfGrandChildrenPerChild;
        int numberOfChildren;
        RigidBody rootJointSuccessor;
        JointBasics rootJoint;
        RigidBody rootBody;
        int i;
        Random random = new Random(324534L);
        for (i = 0; i < 1000; ++i) {
            rootBody = new RigidBody("rootBody", ReferenceFrame.getWorldFrame());
            rootJoint = MultiBodySystemRandomTools.nextJoint((Random)random, (String)"root", (RigidBodyBasics)rootBody);
            rootJointSuccessor = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"rootJointSuccessor", (JointBasics)rootJoint);
            numberOfChildren = 10;
            numberOfGrandChildrenPerChild = 10;
            for (int childIndex2 = 0; childIndex2 < numberOfChildren; ++childIndex2) {
                childJoint = MultiBodySystemRandomTools.nextJoint((Random)random, (String)"jointDepth1", (RigidBodyBasics)rootJointSuccessor);
                RigidBody childBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"bodyDepth1", (JointBasics)childJoint);
                for (int grandChildIndex = 0; grandChildIndex < numberOfGrandChildrenPerChild; ++grandChildIndex) {
                    JointBasics grandChildJoint = MultiBodySystemRandomTools.nextJoint((Random)random, (String)"jointDepth2", (RigidBodyBasics)childBody);
                    MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"bodyDepth2", (JointBasics)grandChildJoint);
                }
            }
            bodyIterable = new RigidBodyIterable(RigidBodyReadOnly.class, null, IteratorSearchMode.BREADTH_FIRST_SEARCH, (RigidBodyReadOnly)rootBody);
            iterator = bodyIterable.iterator();
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertTrue((rootBody == iterator.next() ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)iterator.hasNext());
            Assertions.assertTrue((rootJointSuccessor == iterator.next() ? 1 : 0) != 0);
            for (childIndex = 0; childIndex < numberOfChildren; ++childIndex) {
                Assertions.assertTrue((boolean)iterator.hasNext());
                Assertions.assertTrue((((JointBasics)rootJointSuccessor.getChildrenJoints().get(childIndex)).getSuccessor() == iterator.next() ? 1 : 0) != 0);
            }
            for (childIndex = 0; childIndex < numberOfChildren; ++childIndex) {
                JointBasics childJoint2 = (JointBasics)rootJointSuccessor.getChildrenJoints().get(childIndex);
                for (int grandChildIndex = 0; grandChildIndex < numberOfGrandChildrenPerChild; ++grandChildIndex) {
                    grandChildBody = ((JointBasics)childJoint2.getSuccessor().getChildrenJoints().get(grandChildIndex)).getSuccessor();
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    Assertions.assertTrue((grandChildBody == iterator.next() ? 1 : 0) != 0);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            rootBody = new RigidBody("rootBody", ReferenceFrame.getWorldFrame());
            rootJoint = MultiBodySystemRandomTools.nextSixDoFJoint((Random)random, (String)"root", (RigidBodyBasics)rootBody);
            rootJointSuccessor = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"rootJointSuccessor", (JointBasics)rootJoint);
            numberOfChildren = 10;
            numberOfGrandChildrenPerChild = 10;
            for (int childIndex3 = 0; childIndex3 < numberOfChildren; ++childIndex3) {
                childJoint = MultiBodySystemRandomTools.nextSphericalJoint((Random)random, (String)"jointDepth1", (RigidBodyBasics)rootJointSuccessor);
                RigidBody childBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"bodyDepth1", (JointBasics)childJoint);
                for (int grandChildIndex = 0; grandChildIndex < numberOfGrandChildrenPerChild; ++grandChildIndex) {
                    OneDoFJoint grandChildJoint = MultiBodySystemRandomTools.nextOneDoFJoint((Random)random, (String)"jointDepth2", (RigidBodyBasics)childBody);
                    new CustomRigidBodyType((RigidBodyBasics)MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"bodyDepth2", (JointBasics)grandChildJoint));
                }
            }
            bodyIterable = new RigidBodyIterable(CustomRigidBodyType.class, null, IteratorSearchMode.BREADTH_FIRST_SEARCH, (RigidBodyReadOnly)rootBody);
            iterator = bodyIterable.iterator();
            for (childIndex = 0; childIndex < numberOfChildren; ++childIndex) {
                JointBasics childJoint3 = (JointBasics)rootJointSuccessor.getChildrenJoints().get(childIndex);
                for (int grandChildIndex = 0; grandChildIndex < numberOfGrandChildrenPerChild; ++grandChildIndex) {
                    grandChildBody = ((JointBasics)childJoint3.getSuccessor().getChildrenJoints().get(grandChildIndex)).getSuccessor();
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    CustomRigidBodyType actual = (CustomRigidBodyType)iterator.next();
                    Assertions.assertTrue((grandChildBody == actual ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testRandomTree() {
        Random random = new Random(2342L);
        for (int i = 0; i < 1000; ++i) {
            IteratorSearchMode mode = (IteratorSearchMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])IteratorSearchMode.values());
            List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)50);
            RigidBodyBasics root = ((JointBasics)joints.get(0)).getPredecessor();
            List<RigidBodyReadOnly> expectedList = switch (mode) {
                case IteratorSearchMode.DEPTH_FIRST_SEARCH -> RigidBodyIterableTest.collectDFSRigidBodies((RigidBodyReadOnly)root);
                case IteratorSearchMode.BREADTH_FIRST_SEARCH -> RigidBodyIterableTest.collectBFSRigidBodies((RigidBodyReadOnly)root);
                default -> throw new IllegalArgumentException("Unexpected value: " + mode);
            };
            RigidBodyIterable jointIterable = new RigidBodyIterable(RigidBodyReadOnly.class, null, mode, (RigidBodyReadOnly)root);
            List actualList = jointIterable.toStream().toList();
            try {
                Assertions.assertEquals(expectedList, actualList);
                if (mode != IteratorSearchMode.BREADTH_FIRST_SEARCH) continue;
                for (int j2 = 1; j2 < actualList.size(); ++j2) {
                    Assertions.assertTrue((MultiBodySystemTools.computeDistanceToRoot((RigidBodyReadOnly)((RigidBodyReadOnly)actualList.get(j2 - 1))) <= MultiBodySystemTools.computeDistanceToRoot((RigidBodyReadOnly)((RigidBodyReadOnly)actualList.get(j2))) ? 1 : 0) != 0);
                }
                continue;
            }
            catch (Throwable e) {
                System.out.println("Search mode: " + mode);
                int maxNameLength = expectedList.stream().mapToInt(j -> j.getName().length()).max().getAsInt();
                List expectedNames = expectedList.stream().map(j -> JointIterableTest.padRightToLength(j.getName(), maxNameLength)).collect(Collectors.toList());
                List actualNames = actualList.stream().map(j -> JointIterableTest.padRightToLength(j.getName(), maxNameLength)).collect(Collectors.toList());
                for (int j3 = 0; j3 < Math.max(expectedNames.size(), actualList.size()); ++j3) {
                    if (j3 < expectedNames.size()) {
                        System.out.printf("%s(%d)", expectedNames.get(j3), MultiBodySystemTools.computeDistanceToRoot((RigidBodyReadOnly)expectedList.get(j3)));
                    } else {
                        System.out.print("\t");
                    }
                    System.out.print("\t");
                    if (j3 < actualList.size()) {
                        System.out.printf("%s(%d)", actualNames.get(j3), MultiBodySystemTools.computeDistanceToRoot((RigidBodyReadOnly)((RigidBodyReadOnly)actualList.get(j3))));
                    } else {
                        System.out.print("\t");
                    }
                    System.out.println();
                }
                throw e;
            }
        }
    }

    static List<RigidBodyReadOnly> collectDFSRigidBodies(RigidBodyReadOnly root) {
        List<RigidBodyReadOnly> result = JointIterableTest.collectDFSJoints(root).stream().map(j -> j.getSuccessor()).collect(Collectors.toList());
        result.add(0, root);
        return result;
    }

    static List<RigidBodyReadOnly> collectBFSRigidBodies(RigidBodyReadOnly root) {
        List<RigidBodyReadOnly> result = JointIterableTest.collectBFSJoints(root).stream().map(j -> j.getSuccessor()).collect(Collectors.toList());
        result.add(0, root);
        return result;
    }

    private static class CustomRigidBodyType
    implements RigidBodyBasics {
        private final RigidBodyBasics rigidBody;

        public CustomRigidBodyType(RigidBodyBasics rigidBody) {
            this.rigidBody = rigidBody;
            if (!rigidBody.isRootBody()) {
                rigidBody.getParentJoint().setSuccessor((RigidBodyBasics)this);
            }
        }

        public SpatialInertiaBasics getInertia() {
            return this.rigidBody.getInertia();
        }

        public MovingReferenceFrame getBodyFixedFrame() {
            return this.rigidBody.getBodyFixedFrame();
        }

        public JointBasics getParentJoint() {
            return this.rigidBody.getParentJoint();
        }

        public void addChildJoint(JointBasics joint) {
            this.rigidBody.addChildJoint(joint);
        }

        public List<JointBasics> getChildrenJoints() {
            return this.rigidBody.getChildrenJoints();
        }

        public String toString() {
            return this.rigidBody.toString();
        }

        public String getName() {
            return this.rigidBody.getName();
        }

        public String getNameId() {
            return this.rigidBody.getNameId();
        }
    }
}

