/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.FixedFrameSpatialVectorBasicsTest;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MecanoTestTools;

public abstract class SpatialVectorBasicsTest<T extends SpatialVectorBasics>
extends FixedFrameSpatialVectorBasicsTest<FixedFrameSpatialVectorBasics> {
    private static final int ITERATIONS = 1000;

    @Override
    public abstract T newEmptySpatialVector();

    @Override
    public abstract T newRandomSpatialVector(Random var1);

    @Override
    public abstract T newSpatialVector(ReferenceFrame var1, Vector3DReadOnly var2, Vector3DReadOnly var3);

    @Override
    public abstract T newCopySpatialVector(SpatialVectorReadOnly var1);

    @Override
    public abstract double getEpsilon();

    @Override
    @Test
    public void testSetMatchingFrame() {
        Object originalSpatialVector;
        int i;
        Random random = new Random(21587L);
        for (i = 0; i < 1000; ++i) {
            T actualSpatialVector;
            originalSpatialVector = this.newSpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            T expectedSpatialVector = actualSpatialVector = this.newSpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expectedSpatialVector.setIncludingFrame(originalSpatialVector);
            expectedSpatialVector.changeFrame(actualSpatialVector.getReferenceFrame());
            actualSpatialVector.setMatchingFrame(originalSpatialVector);
            MecanoTestTools.assertSpatialVectorEquals(actualSpatialVector, expectedSpatialVector, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            T actualSpatialVector;
            originalSpatialVector = this.newSpatialVector(EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            ReferenceFrame randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector3D randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomFrame);
            FrameVector3D randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomFrame);
            T expectedSpatialVector = actualSpatialVector = this.newSpatialVector(randomAngularPart.getReferenceFrame(), (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart);
            expectedSpatialVector.setIncludingFrame(originalSpatialVector);
            expectedSpatialVector.changeFrame(actualSpatialVector.getReferenceFrame());
            actualSpatialVector.setMatchingFrame((FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            MecanoTestTools.assertSpatialVectorEquals(actualSpatialVector, expectedSpatialVector, (double)this.getEpsilon());
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                randomLinearPart.setReferenceFrame(ReferenceFrameTools.getWorldFrame());
                originalSpatialVector.setMatchingFrame((FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            });
        }
    }

    @Test
    public void testSettersIncludingFrame() {
        DMatrixRMaj randomMatrix;
        Object[] randomVectorArray;
        T randomSpatialVector;
        FrameVector3D randomLinearPart;
        FrameVector3D randomAngularPart;
        ReferenceFrame randomFrame;
        Object originalSpatialVector;
        int i;
        Random random = new Random(21623L);
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            T expectedSpatialVector = this.newRandomSpatialVector(random);
            Assertions.assertNotEquals(originalSpatialVector, expectedSpatialVector);
            originalSpatialVector.setIncludingFrame(expectedSpatialVector);
            MecanoTestTools.assertSpatialVectorEquals(originalSpatialVector, expectedSpatialVector, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            originalSpatialVector = this.newRandomSpatialVector(random);
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomFrame);
            randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomFrame);
            Assertions.assertNotEquals((Object)originalSpatialVector.getAngularPart(), (Object)randomAngularPart);
            Assertions.assertNotEquals((Object)originalSpatialVector.getLinearPart(), (Object)randomLinearPart);
            originalSpatialVector.setIncludingFrame((FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)originalSpatialVector.getAngularPart(), (Object)randomAngularPart);
            Assertions.assertEquals((Object)originalSpatialVector.getLinearPart(), (Object)randomLinearPart);
            Assertions.assertEquals((Object)originalSpatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                randomLinearPart.setReferenceFrame(ReferenceFrameTools.getWorldFrame());
                originalSpatialVector.setIncludingFrame((FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            });
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            randomLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            Assertions.assertNotEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertNotEquals((Object)randomSpatialVector.getAngularPart(), (Object)randomAngularPart);
            Assertions.assertNotEquals((Object)randomSpatialVector.getAngularPart(), (Object)randomLinearPart);
            randomSpatialVector.setIncludingFrame(randomFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getAngularPart().getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getLinearPart().getReferenceFrame(), (Object)randomFrame);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomSpatialVector.getAngularPart(), (EuclidGeometry)randomAngularPart, (double)this.getEpsilon());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomSpatialVector.getLinearPart(), (EuclidGeometry)randomLinearPart, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomVectorArray = new double[6];
            for (int index = 0; index < 6; ++index) {
                randomVectorArray[index] = random.nextDouble();
            }
            Assertions.assertFalse((boolean)randomSpatialVector.getReferenceFrame().equals((Object)randomFrame));
            randomSpatialVector.setIncludingFrame(randomFrame, randomVectorArray);
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((double)randomVectorArray[0], (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomVectorArray[1], (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomVectorArray[2], (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomVectorArray[3], (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomVectorArray[4], (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomVectorArray[5], (double)randomSpatialVector.getLinearPartZ());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomVectorArray = new double[24];
            for (int index = 0; index < 24; ++index) {
                randomVectorArray[index] = random.nextDouble();
            }
            Assertions.assertFalse((boolean)randomSpatialVector.getReferenceFrame().equals((Object)randomFrame));
            int startingArrayIndex = i % 18;
            randomSpatialVector.setIncludingFrame(randomFrame, startingArrayIndex, randomVectorArray);
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex], (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 1], (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 2], (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 3], (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 4], (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 5], (double)randomSpatialVector.getLinearPartZ());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomVectorArray = new float[24];
            for (int index = 0; index < 6; ++index) {
                randomVectorArray[index] = random.nextFloat();
            }
            Assertions.assertNotEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            randomSpatialVector.setIncludingFrame(randomFrame, (float[])randomVectorArray);
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((double)randomVectorArray[0], (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomVectorArray[1], (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomVectorArray[2], (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomVectorArray[3], (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomVectorArray[4], (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomVectorArray[5], (double)randomSpatialVector.getLinearPartZ());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomVectorArray = new float[24];
            for (int index = 0; index < 24; ++index) {
                randomVectorArray[index] = random.nextFloat();
            }
            Assertions.assertNotEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            int startingArrayIndex = i % 18;
            randomSpatialVector.setIncludingFrame(randomFrame, startingArrayIndex, (float[])randomVectorArray);
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex], (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 1], (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 2], (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 3], (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 4], (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomVectorArray[startingArrayIndex + 5], (double)randomSpatialVector.getLinearPartZ());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomMatrix = new DMatrixRMaj(6, 1);
            for (int row = 0; row < 6; ++row) {
                randomMatrix.set(row, 0, random.nextDouble());
            }
            Assertions.assertNotEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            randomSpatialVector.setIncludingFrame(randomFrame, (DMatrix)randomMatrix);
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((double)randomMatrix.get(0, 0), (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomMatrix.get(1, 0), (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomMatrix.get(2, 0), (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomMatrix.get(3, 0), (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomMatrix.get(4, 0), (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomMatrix.get(5, 0), (double)randomSpatialVector.getLinearPartZ());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomMatrix = new DMatrixRMaj(24, 1);
            for (int row = 0; row < 24; ++row) {
                randomMatrix.set(row, 0, random.nextDouble());
            }
            Assertions.assertNotEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            int startingMatrixRow = i % 18;
            randomSpatialVector.setIncludingFrame(randomFrame, startingMatrixRow, (DMatrix)randomMatrix);
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow, 0), (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 1, 0), (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 2, 0), (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 3, 0), (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 4, 0), (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 5, 0), (double)randomSpatialVector.getLinearPartZ());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialVector = this.newRandomSpatialVector(random);
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomMatrix = new DMatrixRMaj(24, 24);
            for (int row = 0; row < 24; ++row) {
                for (int column = 0; column < 24; ++column) {
                    randomMatrix.set(row, column, random.nextDouble());
                }
            }
            Assertions.assertNotEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            int startingMatrixRow = i % 18;
            int startingMatrixColumn = i % 18;
            randomSpatialVector.setIncludingFrame(randomFrame, startingMatrixRow, startingMatrixColumn, (DMatrix)randomMatrix);
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow, startingMatrixColumn), (double)randomSpatialVector.getAngularPartX());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 1, startingMatrixColumn), (double)randomSpatialVector.getAngularPartY());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 2, startingMatrixColumn), (double)randomSpatialVector.getAngularPartZ());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 3, startingMatrixColumn), (double)randomSpatialVector.getLinearPartX());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 4, startingMatrixColumn), (double)randomSpatialVector.getLinearPartY());
            Assertions.assertEquals((double)randomMatrix.get(startingMatrixRow + 5, startingMatrixColumn), (double)randomSpatialVector.getLinearPartZ());
        }
    }

    @Test
    public void testSetReferenceFrame() {
        Random random = new Random(24523L);
        for (int i = 0; i < 1000; ++i) {
            T spatialVector = this.newRandomSpatialVector(random);
            ReferenceFrame randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Assertions.assertNotEquals((Object)spatialVector.getReferenceFrame(), (Object)randomFrame);
            spatialVector.setReferenceFrame(randomFrame);
            Assertions.assertEquals((Object)spatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)spatialVector.getAngularPart().getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)spatialVector.getLinearPart().getReferenceFrame(), (Object)randomFrame);
        }
    }

    @Test
    public void testSetToZero() {
        Random random = new Random(21623L);
        for (int i = 0; i < 1000; ++i) {
            T randomSpatialVector = this.newRandomSpatialVector(random);
            ReferenceFrame randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Assertions.assertNotEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            randomSpatialVector.setToZero(randomFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getAngularPart().getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getLinearPart().getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((double)randomSpatialVector.getAngularPartX(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialVector.getAngularPartY(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialVector.getAngularPartZ(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialVector.getLinearPartX(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialVector.getLinearPartY(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialVector.getLinearPartZ(), (double)0.0);
        }
    }

    @Test
    public void testSetToNaN() {
        Random random = new Random(31843L);
        for (int i = 0; i < 1000; ++i) {
            T randomSpatialVector = this.newRandomSpatialVector(random);
            ReferenceFrame randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Assertions.assertNotEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            randomSpatialVector.setToNaN(randomFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getAngularPart().getReferenceFrame(), (Object)randomFrame);
            Assertions.assertEquals((Object)randomSpatialVector.getLinearPart().getReferenceFrame(), (Object)randomFrame);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)randomSpatialVector.getAngularPart());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)randomSpatialVector.getLinearPart());
        }
    }
}

