/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.tools.EuclidCoreIOTools;

public class TablePrinter {
    private final List<List<Cell>> tableRows = new ArrayList<List<Cell>>();
    private int numberOfColumns = 0;
    private String columnSeparator = "\t";
    private boolean needColumnResizing = false;
    private String doubleFormat = EuclidCoreIOTools.getStringFormat((int)11, (int)7);

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public void setDoubleFormat(String doubleFormat) {
        this.doubleFormat = doubleFormat;
    }

    public void setRow(int row, String ... text) {
        for (int col = 0; col < text.length; ++col) {
            this.setCell(row, col, text[col], Alignment.LEFT);
        }
    }

    public void setSubTable(int startRow, int startCol, DMatrixRMaj matrix) {
        for (int row = 0; row < matrix.getNumRows(); ++row) {
            for (int col = 0; col < matrix.getNumCols(); ++col) {
                this.setNumeric(row + startRow, col + startCol, matrix.get(row, col));
            }
        }
    }

    public void setNumeric(int row, int col, double value) {
        this.setCell(row, col, String.format(this.doubleFormat, value), Alignment.RIGHT);
    }

    public void setCell(int row, int col, String value, Alignment alignment) {
        while (this.tableRows.size() <= row) {
            this.tableRows.add(new ArrayList());
        }
        List<Cell> tableRow = this.tableRows.get(row);
        while (tableRow.size() <= col) {
            tableRow.add(new Cell());
        }
        tableRow.set(col, new Cell(value, alignment));
        this.numberOfColumns = Math.max(tableRow.size(), this.numberOfColumns);
        this.needColumnResizing = true;
    }

    private void resizeColumns() {
        int col;
        List<Cell> tableRow;
        int row;
        if (!this.needColumnResizing) {
            return;
        }
        int[] columnWidths = new int[this.numberOfColumns];
        for (row = 0; row < this.tableRows.size(); ++row) {
            tableRow = this.tableRows.get(row);
            while (tableRow.size() < this.numberOfColumns) {
                tableRow.add(new Cell());
            }
            for (col = 0; col < this.numberOfColumns; ++col) {
                Cell cell = tableRow.get(col);
                cell.trim();
                columnWidths[col] = Math.max(cell.length(), columnWidths[col]);
            }
        }
        for (row = 0; row < this.tableRows.size(); ++row) {
            tableRow = this.tableRows.get(row);
            for (col = 0; col < this.numberOfColumns; ++col) {
                tableRow.get(col).padToLength(columnWidths[col]);
            }
        }
        this.needColumnResizing = false;
    }

    public String toString() {
        this.resizeColumns();
        return EuclidCoreIOTools.getCollectionString((String)"\n", this.tableRows, tableRow -> this.rowToString((List<Cell>)tableRow));
    }

    public String rowToString(int rowIndex) {
        this.resizeColumns();
        return this.rowToString(this.tableRows.get(rowIndex));
    }

    private String rowToString(List<Cell> tableRow) {
        return EuclidCoreIOTools.getCollectionString((String)this.columnSeparator, tableRow, Cell::toString);
    }

    public static enum Alignment {
        LEFT,
        RIGHT;

    }

    private static class Cell {
        String text = "";
        Alignment alignment = Alignment.RIGHT;

        public Cell() {
        }

        public Cell(String text, Alignment alignment) {
            this.text = text;
            this.alignment = alignment;
        }

        public void trim() {
            this.text = this.text.trim();
        }

        public int length() {
            return this.text.length();
        }

        public void padToLength(int desiredLength) {
            if (this.length() >= desiredLength) {
                return;
            }
            this.text = this.alignment == Alignment.LEFT ? String.format("%-" + desiredLength + "s", this.text) : String.format("%" + desiredLength + "s", this.text);
        }

        public String toString() {
            return this.text;
        }
    }
}

