/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MecanoTools;

public class MecanoToolsTest {
    private static final double EPSILON = 1.0E-12;
    private static final int ITERATIONS = 1000;

    @Test
    public void testTranslateMomentOfInertia() {
        Matrix3D actual;
        Matrix3D expected;
        Matrix3D inertiaOriginal;
        Vector3D translation;
        Vector3D centerOfMass;
        double mass;
        int i;
        Random random = new Random(2342L);
        for (i = 0; i < 1000; ++i) {
            mass = random.nextDouble();
            centerOfMass = EuclidCoreRandomTools.nextVector3D((Random)random);
            translation = EuclidCoreRandomTools.nextVector3D((Random)random);
            inertiaOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            expected = new Matrix3D((Matrix3DReadOnly)inertiaOriginal);
            actual = new Matrix3D((Matrix3DReadOnly)inertiaOriginal);
            MecanoTools.translateMomentOfInertia((double)mass, (Tuple3DReadOnly)centerOfMass, (boolean)false, (Tuple3DReadOnly)translation, (Matrix3DBasics)actual);
            centerOfMass.add((Tuple3DReadOnly)translation);
            translation.negate();
            MecanoTools.translateMomentOfInertia((double)mass, (Tuple3DReadOnly)centerOfMass, (boolean)false, (Tuple3DReadOnly)translation, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            mass = random.nextDouble();
            centerOfMass = EuclidCoreRandomTools.nextVector3D((Random)random);
            translation = EuclidCoreRandomTools.nextVector3D((Random)random);
            inertiaOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            expected = new Matrix3D();
            Matrix3D cTilde = new Matrix3D();
            cTilde.setToTildeForm((Tuple3DReadOnly)centerOfMass);
            Matrix3D pTilde = new Matrix3D();
            pTilde.setToTildeForm((Tuple3DReadOnly)translation);
            Matrix3D cTilde_pTilde = new Matrix3D((Matrix3DReadOnly)cTilde);
            cTilde_pTilde.multiply((Matrix3DReadOnly)pTilde);
            Matrix3D pTilde_cTilde = new Matrix3D((Matrix3DReadOnly)pTilde);
            pTilde_cTilde.multiply((Matrix3DReadOnly)cTilde);
            Matrix3D pTilde_pTilde = new Matrix3D((Matrix3DReadOnly)pTilde);
            pTilde_pTilde.multiply((Matrix3DReadOnly)pTilde);
            expected.set(cTilde_pTilde);
            expected.add((Matrix3DReadOnly)pTilde_cTilde);
            expected.add((Matrix3DReadOnly)pTilde_pTilde);
            expected.scale(-mass);
            expected.add((Matrix3DReadOnly)inertiaOriginal);
            actual = new Matrix3D((Matrix3DReadOnly)inertiaOriginal);
            MecanoTools.translateMomentOfInertia((double)mass, (Tuple3DReadOnly)centerOfMass, (boolean)false, (Tuple3DReadOnly)translation, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testComputeDynamicForce() throws Exception {
        Vector3D dynamicForce2;
        Vector3D dynamicForce1;
        Vector3D expected;
        Vector3D linearVelocity;
        Vector3D angularVelocity;
        Vector3D linearAcceleration;
        Vector3D angularAcceleration;
        Vector3D centerOfMassOffset;
        double mass;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            mass = random.nextDouble();
            centerOfMassOffset = new Vector3D();
            angularAcceleration = EuclidCoreRandomTools.nextVector3D((Random)random);
            linearAcceleration = EuclidCoreRandomTools.nextVector3D((Random)random);
            angularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            linearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D dynamicForce12 = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D dynamicForce22 = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicForce((double)mass, (Vector3DReadOnly)centerOfMassOffset, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce12);
            MecanoTools.computeDynamicForceFast((double)mass, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce22);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)dynamicForce12, (Tuple3DReadOnly)dynamicForce22, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            mass = random.nextDouble();
            centerOfMassOffset = EuclidCoreRandomTools.nextVector3D((Random)random);
            angularAcceleration = new Vector3D();
            linearAcceleration = new Vector3D();
            angularVelocity = new Vector3D();
            linearVelocity = new Vector3D();
            expected = new Vector3D();
            dynamicForce1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            dynamicForce2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicForce((double)mass, (Vector3DReadOnly)centerOfMassOffset, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce1);
            MecanoTools.computeDynamicForceFast((double)mass, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce2);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)dynamicForce1, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)dynamicForce2, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            mass = random.nextDouble();
            centerOfMassOffset = EuclidCoreRandomTools.nextVector3D((Random)random);
            angularAcceleration = new Vector3D();
            linearAcceleration = new Vector3D();
            angularVelocity = new Vector3D();
            angularVelocity.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)centerOfMassOffset);
            linearVelocity = new Vector3D();
            linearVelocity.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)angularVelocity);
            expected = new Vector3D();
            dynamicForce1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            dynamicForce2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicForceFast((double)mass, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce1);
            MecanoTools.computeDynamicForce((double)mass, (Vector3DReadOnly)centerOfMassOffset, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicForce2);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)dynamicForce1, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)dynamicForce2, (double)1.0E-12);
        }
    }

    @Test
    public void testComputeDynamicMoment() throws Exception {
        Vector3D dynamicMoment2;
        Vector3D dynamicMoment1;
        Vector3D expected;
        Vector3D linearVelocity;
        Vector3D angularVelocity;
        Vector3D linearAcceleration;
        Vector3D angularAcceleration;
        Vector3D centerOfMassOffset;
        double mass;
        Matrix3D momentOfInertia;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            momentOfInertia = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            mass = random.nextDouble();
            centerOfMassOffset = new Vector3D();
            angularAcceleration = EuclidCoreRandomTools.nextVector3D((Random)random);
            linearAcceleration = EuclidCoreRandomTools.nextVector3D((Random)random);
            angularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            linearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D dynamicMoment12 = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D dynamicMoment22 = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicMoment((Matrix3DReadOnly)momentOfInertia, (double)mass, (Vector3DReadOnly)centerOfMassOffset, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicMoment12);
            MecanoTools.computeDynamicMomentFast((Matrix3DReadOnly)momentOfInertia, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DBasics)dynamicMoment22);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)dynamicMoment12, (Tuple3DReadOnly)dynamicMoment22, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            momentOfInertia = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            mass = random.nextDouble();
            centerOfMassOffset = EuclidCoreRandomTools.nextVector3D((Random)random);
            angularAcceleration = new Vector3D();
            linearAcceleration = new Vector3D();
            angularVelocity = new Vector3D();
            linearVelocity = new Vector3D();
            expected = new Vector3D();
            dynamicMoment1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            dynamicMoment2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicMoment((Matrix3DReadOnly)momentOfInertia, (double)mass, (Vector3DReadOnly)centerOfMassOffset, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicMoment1);
            MecanoTools.computeDynamicMomentFast((Matrix3DReadOnly)momentOfInertia, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DBasics)dynamicMoment2);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)dynamicMoment1, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)dynamicMoment2, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            momentOfInertia = new Matrix3D();
            momentOfInertia.setIdentity();
            momentOfInertia.scale(random.nextDouble());
            mass = random.nextDouble();
            centerOfMassOffset = EuclidCoreRandomTools.nextVector3D((Random)random);
            angularAcceleration = new Vector3D();
            linearAcceleration = new Vector3D();
            angularVelocity = new Vector3D();
            angularVelocity.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)centerOfMassOffset);
            linearVelocity = new Vector3D();
            linearVelocity.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)angularVelocity);
            expected = new Vector3D();
            dynamicMoment1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            dynamicMoment2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            MecanoTools.computeDynamicMomentFast((Matrix3DReadOnly)momentOfInertia, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DBasics)dynamicMoment1);
            MecanoTools.computeDynamicMoment((Matrix3DReadOnly)momentOfInertia, (double)mass, (Vector3DReadOnly)centerOfMassOffset, (Vector3DReadOnly)angularAcceleration, (Vector3DReadOnly)linearAcceleration, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity, (Vector3DBasics)dynamicMoment2);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)dynamicMoment1, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)dynamicMoment2, (double)1.0E-12);
        }
    }

    @Test
    public void testComputeDynamicWrench() throws Exception {
        ReferenceFrame frameA;
        ReferenceFrame bodyFrame;
        int i;
        Random random = new Random(3453L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        for (i = 0; i < 1000; ++i) {
            bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialInertia inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrame, (double)1.0, (double)1.0, (double)0.0);
            inertia.getMomentOfInertia().setIdentity();
            double rotationalInertia = random.nextDouble();
            inertia.getMomentOfInertia().scale(rotationalInertia);
            SpatialAcceleration acceleration = MecanoRandomTools.nextSpatialAcceleration((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)bodyFrame);
            Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)bodyFrame);
            twist.getLinearPart().setAndScale(EuclidCoreRandomTools.nextDouble((Random)random), (FrameTuple3DReadOnly)twist.getAngularPart());
            Wrench expectedWrenchAtBody = new Wrench(bodyFrame, bodyFrame);
            expectedWrenchAtBody.getAngularPart().setAndScale(rotationalInertia, (FrameTuple3DReadOnly)acceleration.getAngularPart());
            expectedWrenchAtBody.getLinearPart().setAndScale(inertia.getMass(), (FrameTuple3DReadOnly)acceleration.getLinearPart());
            Wrench wrenchAtBody = new Wrench(bodyFrame, bodyFrame);
            Wrench wrenchAtFrameA = new Wrench(bodyFrame, frameA);
            MecanoTools.computeDynamicMomentFast((Matrix3DReadOnly)inertia.getMomentOfInertia(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DBasics)wrenchAtBody.getAngularPart());
            MecanoTools.computeDynamicForceFast((double)inertia.getMass(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtBody.getLinearPart());
            inertia.changeFrame(frameA);
            acceleration.changeFrame(frameA);
            twist.changeFrame(frameA);
            MecanoTools.computeDynamicMoment((Matrix3DReadOnly)inertia.getMomentOfInertia(), (double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtFrameA.getAngularPart());
            MecanoTools.computeDynamicForce((double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtFrameA.getLinearPart());
            wrenchAtFrameA.changeFrame(bodyFrame);
            MecanoTestTools.assertWrenchEquals((String)("Iteration: " + i), (WrenchReadOnly)expectedWrenchAtBody, (WrenchReadOnly)wrenchAtBody, (double)1.0E-12);
            MecanoTestTools.assertWrenchEquals((String)("Iteration: " + i), (WrenchReadOnly)expectedWrenchAtBody, (WrenchReadOnly)wrenchAtFrameA, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialInertia inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrame, (double)1.0, (double)1.0, (double)0.0);
            SpatialAcceleration acceleration = MecanoRandomTools.nextSpatialAcceleration((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)bodyFrame);
            Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)bodyFrame);
            Wrench wrenchAtBody = new Wrench(bodyFrame, bodyFrame);
            Wrench wrenchAtFrameA = new Wrench(bodyFrame, frameA);
            Wrench wrenchAtFrameB = new Wrench(bodyFrame, frameB);
            MecanoTools.computeDynamicMomentFast((Matrix3DReadOnly)inertia.getMomentOfInertia(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DBasics)wrenchAtBody.getAngularPart());
            MecanoTools.computeDynamicForceFast((double)inertia.getMass(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtBody.getLinearPart());
            inertia.changeFrame(frameA);
            acceleration.changeFrame(frameA);
            twist.changeFrame(frameA);
            MecanoTools.computeDynamicMoment((Matrix3DReadOnly)inertia.getMomentOfInertia(), (double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtFrameA.getAngularPart());
            MecanoTools.computeDynamicForce((double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtFrameA.getLinearPart());
            inertia.changeFrame(frameB);
            acceleration.changeFrame(frameB);
            twist.changeFrame(frameB);
            MecanoTools.computeDynamicMoment((Matrix3DReadOnly)inertia.getMomentOfInertia(), (double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtFrameB.getAngularPart());
            MecanoTools.computeDynamicForce((double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart(), (Vector3DBasics)wrenchAtFrameB.getLinearPart());
            wrenchAtFrameA.changeFrame(bodyFrame);
            MecanoTestTools.assertWrenchEquals((WrenchReadOnly)wrenchAtBody, (WrenchReadOnly)wrenchAtFrameA, (double)1.0E-12);
            wrenchAtBody.changeFrame(frameB);
            MecanoTestTools.assertWrenchEquals((WrenchReadOnly)wrenchAtFrameB, (WrenchReadOnly)wrenchAtBody, (double)1.0E-12);
        }
    }

    @Test
    public void testComputeKineticCoEnergy() throws Exception {
        Random random = new Random(4636L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame expressedInFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialInertia inertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)expressedInFrame);
            Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)expressedInFrame);
            double actual = MecanoTools.computeKineticCoEnergy((Matrix3DReadOnly)inertia.getMomentOfInertia(), (double)inertia.getMass(), (Vector3DReadOnly)inertia.getCenterOfMassOffset(), (Vector3DReadOnly)twist.getAngularPart(), (Vector3DReadOnly)twist.getLinearPart());
            DMatrixRMaj inertiaMatrix = new DMatrixRMaj(6, 6);
            DMatrixRMaj twistMatrix = new DMatrixRMaj(6, 1);
            twist.get((DMatrix)twistMatrix);
            inertia.get((DMatrix)inertiaMatrix);
            DMatrixRMaj intermediate = new DMatrixRMaj(1, 6);
            CommonOps_DDRM.multTransA((DMatrix1Row)twistMatrix, (DMatrix1Row)inertiaMatrix, (DMatrix1Row)intermediate);
            DMatrixRMaj energyMatrix = new DMatrixRMaj(1, 1);
            CommonOps_DDRM.mult((DMatrix1Row)intermediate, (DMatrix1Row)twistMatrix, (DMatrix1Row)energyMatrix);
            double expected = 0.5 * energyMatrix.get(0);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testTransformSymmetricMatrix3D() throws Exception {
        Random random = new Random(4363L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Matrix3D expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            expected.setM10(expected.getM01());
            expected.setM20(expected.getM02());
            expected.setM21(expected.getM12());
            Matrix3D actual = new Matrix3D((Matrix3DReadOnly)expected);
            rotationMatrix.transform((Matrix3DBasics)expected);
            MecanoTools.transformSymmetricMatrix3D((RotationMatrixReadOnly)rotationMatrix, (Matrix3DBasics)actual);
        }
    }

    @Test
    public void testInverseTransformSymmetricMatrix3D() throws Exception {
        Random random = new Random(4363L);
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Matrix3D expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            expected.setM10(expected.getM01());
            expected.setM20(expected.getM02());
            expected.setM21(expected.getM12());
            Matrix3D actual = new Matrix3D((Matrix3DReadOnly)expected);
            rotationMatrix.inverseTransform((Matrix3DBasics)expected);
            MecanoTools.inverseTransformSymmetricMatrix3D((RotationMatrixReadOnly)rotationMatrix, (Matrix3DBasics)actual);
        }
    }
}

