/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.frames;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;

public class MovingReferenceFrameTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int ITERATIONS = 5000;
    private static final double EPSILON = 1.0E-12;

    private static RandomlyChangingFrame[] nextRandomlyChangingFrameTree(Random random, int numberOfReferenceFrames) {
        return MovingReferenceFrameTest.nextRandomlyChangingFrameTree("randomFrame", random, numberOfReferenceFrames);
    }

    private static RandomlyChangingFrame[] nextRandomlyChangingFrameTree(String frameNamePrefix, Random random, int numberOfReferenceFrames) {
        return MovingReferenceFrameTest.nextRandomlyChangingFrameTree(frameNamePrefix, random, worldFrame, numberOfReferenceFrames);
    }

    private static RandomlyChangingFrame[] nextRandomlyChangingFrameTree(String frameNamePrefix, Random random, ReferenceFrame rootFrame, int numberOfReferenceFrames) {
        RandomlyChangingFrame[] referenceFrames = new RandomlyChangingFrame[numberOfReferenceFrames];
        ReferenceFrame[] referenceFramesWithRoot = new ReferenceFrame[numberOfReferenceFrames + 1];
        referenceFramesWithRoot[0] = rootFrame;
        for (int i = 0; i < numberOfReferenceFrames; ++i) {
            RandomlyChangingFrame randomlyChangingFrame;
            int parentFrameIndex = random.nextInt(i + 1);
            ReferenceFrame parentFrame = referenceFramesWithRoot[parentFrameIndex];
            referenceFrames[i] = randomlyChangingFrame = new RandomlyChangingFrame(frameNamePrefix + i, parentFrame, random);
            referenceFramesWithRoot[i + 1] = randomlyChangingFrame;
        }
        return referenceFrames;
    }

    @Test
    public void testFixedInParentBug() throws Exception {
        Random random = new Random(1231L);
        RandomlyChangingFrame parentMovingFrame = MovingReferenceFrameTest.nextRandomlyChangingFrameTree(random, 1)[0];
        MovingReferenceFrame fixedInParentOne = MovingReferenceFrame.constructFrameFixedInParent((String)"fixed1", (ReferenceFrame)parentMovingFrame, (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
        MovingReferenceFrame fixedInParentTwo = MovingReferenceFrame.constructFrameFixedInParent((String)"fixed2", (ReferenceFrame)parentMovingFrame, (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
        parentMovingFrame.update();
        Twist actualTwistFrameOne = new Twist((SpatialMotionReadOnly)fixedInParentOne.getTwistOfFrame());
        Twist expectedTwistFrameOne = this.computeTwistRelativeToRootByClimbingTree(fixedInParentOne);
        Twist actualTwistFrameTwo = new Twist((SpatialMotionReadOnly)fixedInParentTwo.getTwistOfFrame());
        Twist expectedTwistFrameTwo = this.computeTwistRelativeToRootByClimbingTree(fixedInParentTwo);
        MecanoTestTools.assertTwistEquals((TwistReadOnly)actualTwistFrameOne, (TwistReadOnly)expectedTwistFrameOne, (double)1.0E-12);
        MecanoTestTools.assertTwistEquals((TwistReadOnly)actualTwistFrameTwo, (TwistReadOnly)expectedTwistFrameTwo, (double)1.0E-12);
        parentMovingFrame.update();
        actualTwistFrameOne = new Twist((SpatialMotionReadOnly)fixedInParentOne.getTwistOfFrame());
        expectedTwistFrameOne = this.computeTwistRelativeToRootByClimbingTree(fixedInParentOne);
        actualTwistFrameTwo = new Twist((SpatialMotionReadOnly)fixedInParentTwo.getTwistOfFrame());
        expectedTwistFrameTwo = this.computeTwistRelativeToRootByClimbingTree(fixedInParentTwo);
        MecanoTestTools.assertTwistEquals((TwistReadOnly)actualTwistFrameOne, (TwistReadOnly)expectedTwistFrameOne, (double)1.0E-12);
        MecanoTestTools.assertTwistEquals((TwistReadOnly)actualTwistFrameTwo, (TwistReadOnly)expectedTwistFrameTwo, (double)1.0E-12);
    }

    @Test
    public void testTypicalExample() {
        Random random = new Random(87L);
        for (int i = 0; i < 5000; ++i) {
            MovingReferenceFrame[] treeFrame = MecanoRandomTools.nextMovingReferenceFrameTree((Random)random);
            MovingReferenceFrame frameA = treeFrame[random.nextInt(treeFrame.length)];
            MovingReferenceFrame frameB = treeFrame[random.nextInt(treeFrame.length)];
            RigidBodyTransform shouldBeIdentity = new RigidBodyTransform((RigidBodyTransformReadOnly)frameB.getTransformToDesiredFrame((ReferenceFrame)frameA));
            shouldBeIdentity.multiply((RigidBodyTransformReadOnly)frameA.getTransformToDesiredFrame((ReferenceFrame)frameB));
            EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)new RigidBodyTransform(), (RigidBodyTransform)shouldBeIdentity, (double)1.0E-12);
            Twist twistARelativeToB = new Twist();
            Twist twistBRelativeToA = new Twist();
            frameA.getTwistRelativeToOther((ReferenceFrame)frameB, (TwistBasics)twistARelativeToB);
            frameB.getTwistRelativeToOther((ReferenceFrame)frameA, (TwistBasics)twistBRelativeToA);
            twistBRelativeToA.invert();
            twistBRelativeToA.changeFrame((ReferenceFrame)frameA);
            MecanoTestTools.assertTwistEquals((TwistReadOnly)twistARelativeToB, (TwistReadOnly)twistBRelativeToA, (double)1.0E-12);
        }
    }

    @Test
    public void testGetTransformAndTwistToParents() {
        Random random = new Random(87L);
        for (int i = 0; i < 5000; ++i) {
            MovingReferenceFrame[] treeFrame = MecanoRandomTools.nextMovingReferenceFrameTree((Random)random);
            MovingReferenceFrame frame = treeFrame[random.nextInt(treeFrame.length)];
            MovingReferenceFrame parent = frame.getMovingParent();
            if (parent == null) continue;
            RigidBodyTransform transformToParentOne = frame.getTransformToParent();
            RigidBodyTransform transformToParentTwo = frame.getTransformToDesiredFrame((ReferenceFrame)parent);
            EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)transformToParentOne, (RigidBodyTransform)transformToParentTwo, (double)1.0E-12);
            Twist twistRelativeToParentOne = new Twist((SpatialMotionReadOnly)frame.getTwistRelativeToParent());
            Twist twistRelativeToParentTwo = new Twist();
            frame.getTwistRelativeToOther((ReferenceFrame)parent, (TwistBasics)twistRelativeToParentTwo);
            MecanoTestTools.assertTwistEquals((TwistReadOnly)twistRelativeToParentOne, (TwistReadOnly)twistRelativeToParentTwo, (double)1.0E-12);
        }
    }

    @Test
    public void testGetTransformAndTwistToRoots() {
        MovingReferenceFrame[] treeFrame;
        int i;
        Random random = new Random(453L);
        for (i = 0; i < 5000; ++i) {
            treeFrame = MecanoRandomTools.nextMovingReferenceFrameTree((Random)random);
            MovingReferenceFrame frame = treeFrame[random.nextInt(treeFrame.length)];
            RigidBodyTransform transformToRootOne = frame.getTransformToDesiredFrame(worldFrame);
            RigidBodyTransform transformToRootTwo = this.computeTransformToRootByClimbingTree((ReferenceFrame)frame);
            EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)transformToRootOne, (RigidBodyTransform)transformToRootTwo, (double)1.0E-12);
            Twist twistOne = new Twist();
            frame.getTwistRelativeToOther(worldFrame, (TwistBasics)twistOne);
            Twist twistTwo = this.computeTwistRelativeToRootByClimbingTree(frame);
            MecanoTestTools.assertTwistEquals((TwistReadOnly)twistOne, (TwistReadOnly)twistTwo, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            ReferenceFrame anotherRoot = ReferenceFrameTools.constructARootFrame((String)"anotherRoot");
            MovingReferenceFrame[] treeFrame2 = MecanoRandomTools.nextMovingReferenceFrameTree((String)"blop", (Random)random, (ReferenceFrame)anotherRoot, (int)20);
            MovingReferenceFrame frame = treeFrame2[random.nextInt(treeFrame2.length)];
            RigidBodyTransform transformToRootOne = frame.getTransformToDesiredFrame(anotherRoot);
            RigidBodyTransform transformToRootTwo = this.computeTransformToRootByClimbingTree((ReferenceFrame)frame);
            EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)transformToRootOne, (RigidBodyTransform)transformToRootTwo, (double)1.0E-12);
            Twist twistOne = new Twist();
            frame.getTwistRelativeToOther(anotherRoot, (TwistBasics)twistOne);
            Twist twistTwo = this.computeTwistRelativeToRootByClimbingTree(frame);
            MecanoTestTools.assertTwistEquals((TwistReadOnly)twistOne, (TwistReadOnly)twistTwo, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            treeFrame = MovingReferenceFrameTest.nextRandomlyChangingFrameTree(random, 100);
            int numberOfRandomUpdates = random.nextInt(treeFrame.length / 2) + 1;
            for (int j = 0; j < numberOfRandomUpdates; ++j) {
                treeFrame[random.nextInt(treeFrame.length)].update();
            }
            for (MovingReferenceFrame frame : treeFrame) {
                RigidBodyTransform transformToRootOne = frame.getTransformToRoot();
                RigidBodyTransform transformToRootTwo = this.computeTransformToRootByClimbingTree((ReferenceFrame)frame);
                EuclidCoreTestTools.assertRigidBodyTransformEquals((RigidBodyTransform)transformToRootOne, (RigidBodyTransform)transformToRootTwo, (double)1.0E-12);
                Twist twistOne = new Twist((SpatialMotionReadOnly)frame.getTwistOfFrame());
                Twist twistTwo = this.computeTwistRelativeToRootByClimbingTree(frame);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)twistOne, (TwistReadOnly)twistTwo, (double)1.0E-12);
            }
        }
    }

    private RigidBodyTransform computeTransformToRootByClimbingTree(ReferenceFrame currentFrame) {
        if (currentFrame == null || currentFrame.isRootFrame()) {
            return new RigidBodyTransform();
        }
        RigidBodyTransform transformToRoot = new RigidBodyTransform();
        if (currentFrame.getTransformToParent() != null) {
            transformToRoot.set(currentFrame.getTransformToParent());
        }
        transformToRoot.preMultiply((RigidBodyTransformReadOnly)this.computeTransformToRootByClimbingTree(currentFrame.getParent()));
        return transformToRoot;
    }

    private Twist computeTwistRelativeToRootByClimbingTree(MovingReferenceFrame currentFrame) {
        if (currentFrame == null || currentFrame.isAStationaryFrame()) {
            return null;
        }
        Twist twistRelativeToRoot = new Twist();
        if (currentFrame.getTwistRelativeToParent() != null) {
            twistRelativeToRoot.setIncludingFrame((SpatialMotionReadOnly)currentFrame.getTwistRelativeToParent());
        } else {
            twistRelativeToRoot.setToZero((ReferenceFrame)currentFrame, currentFrame.getParent(), (ReferenceFrame)currentFrame);
        }
        Twist parentTwist = this.computeTwistRelativeToRootByClimbingTree(currentFrame.getMovingParent());
        if (parentTwist != null) {
            parentTwist.changeFrame((ReferenceFrame)currentFrame);
            twistRelativeToRoot.add((TwistReadOnly)parentTwist);
        } else {
            twistRelativeToRoot.setBaseFrame(currentFrame.getRootFrame());
        }
        return twistRelativeToRoot;
    }

    private static class RandomlyChangingFrame
    extends MovingReferenceFrame {
        private final Random random;
        private final RigidBodyTransform randomTransform = new RigidBodyTransform();
        private final Twist randomTwist = new Twist();

        public RandomlyChangingFrame(String frameName, ReferenceFrame parentFrame, Random random) {
            super(frameName, parentFrame);
            this.random = random;
        }

        protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            this.randomTransform.set(EuclidCoreRandomTools.nextRigidBodyTransform((Random)this.random));
            transformToParent.set(this.randomTransform);
        }

        protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
            this.randomTwist.setIncludingFrame((SpatialMotionReadOnly)MecanoRandomTools.nextTwist((Random)this.random, (ReferenceFrame)this, (ReferenceFrame)this.getParent(), (ReferenceFrame)this));
            twistRelativeToParentToPack.set(this.randomTwist);
        }
    }
}

