/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.algorithms.InverseDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;

@Disabled
public class InverseDynamicsCalculatorTest {
    private static final int WARMUP_ITERATIONS = 5000;
    private static final int ITERATIONS = 50000;

    @Test
    public void benchmarkForOneDoFJointChain() {
        int i;
        Random random = new Random(43L);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)30);
        InverseDynamicsCalculator calculator = new InverseDynamicsCalculator((RigidBodyReadOnly)((OneDoFJoint)joints.get(0)).getPredecessor());
        calculator.setGravitionalAcceleration(-9.81);
        long totalTime = 0L;
        for (i = 0; i < 5000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            calculator.compute();
        }
        for (i = 0; i < 50000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            long startTime = System.nanoTime();
            calculator.compute();
            totalTime += System.nanoTime() - startTime;
        }
        System.out.println("1-DoF chain: Took on average per iteration: " + (double)totalTime / 1.0E9 / 50000.0 + " seconds");
    }

    @Test
    public void benchmarkForFloatingOneDoFJointChain() {
        int i;
        Random random = new Random(43L);
        ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
        RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
        RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
        joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (RigidBodyBasics)floatingBody, (int)30));
        InverseDynamicsCalculator calculator = new InverseDynamicsCalculator((RigidBodyReadOnly)elevator);
        calculator.setGravitionalAcceleration(-9.81);
        long totalTime = 0L;
        for (i = 0; i < 5000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, joints);
            }
            calculator.compute();
        }
        for (i = 0; i < 50000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, joints);
            }
            long startTime = System.nanoTime();
            calculator.compute();
            totalTime += System.nanoTime() - startTime;
        }
        System.out.println("Floating 1-DoF chain: Took on average per iteration: " + (double)totalTime / 1.0E9 / 50000.0 + " seconds");
    }

    @Test
    public void benchmarkForOneDoFJointTree() {
        int i;
        Random random = new Random(43L);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)30);
        InverseDynamicsCalculator calculator = new InverseDynamicsCalculator((RigidBodyReadOnly)((OneDoFJoint)joints.get(0)).getPredecessor());
        calculator.setGravitionalAcceleration(-9.81);
        long totalTime = 0L;
        for (i = 0; i < 5000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            calculator.compute();
        }
        for (i = 0; i < 50000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            long startTime = System.nanoTime();
            calculator.compute();
            totalTime += System.nanoTime() - startTime;
        }
        System.out.println("1-DoF tree: Took on average per iteration: " + (double)totalTime / 1.0E9 / 50000.0 + " seconds");
    }

    @Test
    public void benchmarkForFloatingOneDoFJointTree() {
        int i;
        Random random = new Random(43L);
        ArrayList<SixDoFJoint> joints = new ArrayList<SixDoFJoint>();
        RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        joints.add(new SixDoFJoint("floating", (RigidBodyBasics)elevator));
        RigidBody floatingBody = MultiBodySystemRandomTools.nextRigidBody((Random)random, (String)"floatingBody", (JointBasics)((JointBasics)joints.get(0)));
        joints.addAll(MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (RigidBodyBasics)floatingBody, (int)30));
        InverseDynamicsCalculator calculator = new InverseDynamicsCalculator((RigidBodyReadOnly)elevator);
        calculator.setGravitionalAcceleration(-9.81);
        long totalTime = 0L;
        for (i = 0; i < 5000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, joints);
            }
            calculator.compute();
        }
        for (i = 0; i < 50000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, joints);
            }
            long startTime = System.nanoTime();
            calculator.compute();
            totalTime += System.nanoTime() - startTime;
        }
        System.out.println("Floating 1-DoF tree: Took on average per iteration: " + (double)totalTime / 1.0E9 / 50000.0 + " seconds");
    }
}

