/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import java.util.Random;
import org.ejml.EjmlUnitTests;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionBasics;

public abstract class SpatialMotionTest<T extends SpatialMotionBasics> {
    protected Random random = new Random(100L);
    protected ReferenceFrame frameA;
    protected ReferenceFrame frameB;
    protected ReferenceFrame frameC;
    protected ReferenceFrame frameD;

    public abstract T createSpatialMotionVector(ReferenceFrame var1, ReferenceFrame var2, ReferenceFrame var3, Vector3DReadOnly var4, Vector3DReadOnly var5);

    public abstract T createSpatialMotionVector(ReferenceFrame var1, ReferenceFrame var2, ReferenceFrame var3, DMatrixRMaj var4);

    @BeforeEach
    public void setUp() throws Exception {
        this.frameA = ReferenceFrameTools.constructARootFrame((String)"A");
        this.frameB = new ReferenceFrame("B", this.frameA){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.setRotationEulerAndZeroTranslation(1.0, 2.0, 3.0);
                RigidBodyTransform translation = new RigidBodyTransform();
                translation.getTranslation().set((Tuple3DReadOnly)new Vector3D(3.0, 4.0, 5.0));
                transformToParent.multiply((RigidBodyTransformReadOnly)translation);
            }
        };
        this.frameC = new ReferenceFrame("C", this.frameB){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.setRotationEulerAndZeroTranslation(1.0, 2.0, 3.0);
                RigidBodyTransform translation = new RigidBodyTransform();
                translation.getTranslation().set((Tuple3DReadOnly)new Vector3D(3.0, 4.0, 5.0));
                transformToParent.multiply((RigidBodyTransformReadOnly)translation);
            }
        };
        this.frameD = ReferenceFrameTools.constructARootFrame((String)"D");
        this.frameB.update();
        this.frameC.update();
    }

    @Test
    public void testInvert() {
        Vector3D linearPart = EuclidCoreRandomTools.nextVector3D((Random)this.random);
        Vector3D angularPart = EuclidCoreRandomTools.nextVector3D((Random)this.random);
        Vector3D linearPartInverse = new Vector3D((Tuple3DReadOnly)linearPart);
        linearPartInverse.scale(-1.0);
        Vector3D angularPartInverse = new Vector3D((Tuple3DReadOnly)angularPart);
        angularPartInverse.scale(-1.0);
        T twist1 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameA, (Vector3DReadOnly)angularPart, (Vector3DReadOnly)linearPart);
        twist1.invert();
        double epsilon = 1.0E-10;
        EuclidCoreTestTools.assertEquals((EuclidGeometry)angularPartInverse, (EuclidGeometry)twist1.getAngularPart(), (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)linearPartInverse, (EuclidGeometry)twist1.getLinearPart(), (double)epsilon);
        Assertions.assertEquals((Object)this.frameA, (Object)twist1.getReferenceFrame());
        Assertions.assertEquals((Object)this.frameB, (Object)twist1.getBaseFrame());
        Assertions.assertEquals((Object)this.frameA, (Object)twist1.getBodyFrame());
        T twist2 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameB, (Vector3DReadOnly)angularPart, (Vector3DReadOnly)linearPart);
        twist2.invert();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)angularPartInverse, (EuclidGeometry)twist2.getAngularPart(), (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)linearPartInverse, (EuclidGeometry)twist2.getLinearPart(), (double)epsilon);
        Assertions.assertEquals((Object)this.frameB, (Object)twist2.getReferenceFrame());
        Assertions.assertEquals((Object)this.frameB, (Object)twist2.getBaseFrame());
        Assertions.assertEquals((Object)this.frameA, (Object)twist2.getBodyFrame());
    }

    @Test
    public void testConstructUsingMatrix() {
        DMatrixRMaj matrix = RandomMatrices_DDRM.rectangle((int)6, (int)1, (Random)this.random);
        T spatialMotionVector = this.createSpatialMotionVector(this.frameC, this.frameD, this.frameA, matrix);
        DMatrixRMaj matrixBack = new DMatrixRMaj(6, 1);
        spatialMotionVector.get((DMatrix)matrixBack);
        EjmlUnitTests.assertEquals((DMatrix)matrix, (DMatrix)matrixBack, (double)0.0);
    }

    @Test
    public void testConstructUsingMatrixTooSmall() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            DMatrixRMaj matrix = new DMatrixRMaj(5, 1);
            this.createSpatialMotionVector(this.frameC, this.frameD, this.frameA, matrix);
        });
    }
}

