/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialImpulse;
import us.ihmc.mecano.spatial.SpatialImpulseBasicsTest;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.mecano.tools.MecanoRandomTools;

public class SpatialImpulseTest
extends SpatialImpulseBasicsTest<SpatialImpulse> {
    private static final int ITERATIONS = 1000;

    @Override
    public SpatialImpulse newEmptySpatialImpulse() {
        return new SpatialImpulse();
    }

    @Override
    public SpatialImpulse newRandomSpatialImpulse(Random random) {
        return new SpatialImpulse(EuclidFrameRandomTools.nextReferenceFrame((Random)random), EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
    }

    @Override
    public SpatialImpulse newSpatialImpulse(ReferenceFrame bodyFrame, SpatialVector spatialVector) {
        return new SpatialImpulse(bodyFrame, (SpatialVectorReadOnly)spatialVector);
    }

    @Override
    public SpatialImpulse newCopySpatialImpulse(SpatialImpulseReadOnly other) {
        return new SpatialImpulse(other);
    }

    @Override
    public double getEpsilon() {
        return 1.0E-5;
    }

    @Test
    public void testConstructors() {
        SpatialImpulse spatialImpulseByBodyFrameSpatialVector;
        SpatialVector randomSpatialVector;
        ReferenceFrame randomBodyFrame;
        ReferenceFrame randomReferenceFrame;
        int i;
        Random random = new Random(130375L);
        SpatialImpulse spatialImpulse = new SpatialImpulse();
        Assertions.assertEquals((Object)spatialImpulse.getBodyFrame(), null);
        Assertions.assertEquals((Object)spatialImpulse.getReferenceFrame(), null);
        Assertions.assertEquals((Object)spatialImpulse.getAngularPart().getReferenceFrame(), null);
        Assertions.assertEquals((Object)spatialImpulse.getLinearPart().getReferenceFrame(), null);
        Assertions.assertEquals((double)spatialImpulse.getAngularPartX(), (double)0.0);
        Assertions.assertEquals((double)spatialImpulse.getAngularPartY(), (double)0.0);
        Assertions.assertEquals((double)spatialImpulse.getAngularPartZ(), (double)0.0);
        Assertions.assertEquals((double)spatialImpulse.getLinearPartX(), (double)0.0);
        Assertions.assertEquals((double)spatialImpulse.getLinearPartY(), (double)0.0);
        Assertions.assertEquals((double)spatialImpulse.getLinearPartZ(), (double)0.0);
        for (i = 0; i < 1000; ++i) {
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialImpulse spatialImpulseByReferenceFrames = new SpatialImpulse(randomBodyFrame, randomReferenceFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFrames.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFrames.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFrames.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFrames.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)spatialImpulseByReferenceFrames.getAngularPartX(), (double)0.0);
            Assertions.assertEquals((double)spatialImpulseByReferenceFrames.getAngularPartY(), (double)0.0);
            Assertions.assertEquals((double)spatialImpulseByReferenceFrames.getAngularPartZ(), (double)0.0);
            Assertions.assertEquals((double)spatialImpulseByReferenceFrames.getLinearPartX(), (double)0.0);
            Assertions.assertEquals((double)spatialImpulseByReferenceFrames.getLinearPartY(), (double)0.0);
            Assertions.assertEquals((double)spatialImpulseByReferenceFrames.getLinearPartZ(), (double)0.0);
        }
        for (i = 0; i < 1000; ++i) {
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Vector3D randomAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D randomLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            SpatialImpulse spatialImpulseByReferenceFramesAngularPartLinearPart = new SpatialImpulse(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFramesAngularPartLinearPart.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFramesAngularPartLinearPart.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFramesAngularPartLinearPart.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFramesAngularPartLinearPart.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)spatialImpulseByReferenceFramesAngularPartLinearPart.getAngularPart(), (EuclidGeometry)randomAngularPart, (double)this.getEpsilon());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)spatialImpulseByReferenceFramesAngularPartLinearPart.getLinearPart(), (EuclidGeometry)randomLinearPart, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            DMatrixRMaj randomMatrix = new DMatrixRMaj(6, 1);
            for (int row = 0; row < 6; ++row) {
                randomMatrix.set(row, 0, random.nextDouble());
            }
            SpatialImpulse spatialImpulseByReferenceFramesDMatrix = new SpatialImpulse(randomBodyFrame, randomReferenceFrame, (DMatrix)randomMatrix);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFramesDMatrix.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFramesDMatrix.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFramesDMatrix.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFramesDMatrix.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)spatialImpulseByReferenceFramesDMatrix.getAngularPartX(), (double)randomMatrix.get(0, 0));
            Assertions.assertEquals((double)spatialImpulseByReferenceFramesDMatrix.getAngularPartY(), (double)randomMatrix.get(1, 0));
            Assertions.assertEquals((double)spatialImpulseByReferenceFramesDMatrix.getAngularPartZ(), (double)randomMatrix.get(2, 0));
            Assertions.assertEquals((double)spatialImpulseByReferenceFramesDMatrix.getLinearPartX(), (double)randomMatrix.get(3, 0));
            Assertions.assertEquals((double)spatialImpulseByReferenceFramesDMatrix.getLinearPartY(), (double)randomMatrix.get(4, 0));
            Assertions.assertEquals((double)spatialImpulseByReferenceFramesDMatrix.getLinearPartZ(), (double)randomMatrix.get(5, 0));
        }
        for (i = 0; i < 1000; ++i) {
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            double[] randomVectorArray = new double[6];
            for (int index = 0; index < 6; ++index) {
                randomVectorArray[index] = random.nextDouble();
            }
            SpatialImpulse spatialImpulseByReferenceFramesArray = new SpatialImpulse(randomBodyFrame, randomReferenceFrame, randomVectorArray);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFramesArray.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFramesArray.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFramesArray.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)spatialImpulseByReferenceFramesArray.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)spatialImpulseByReferenceFramesArray.getAngularPartX(), (double)randomVectorArray[0]);
            Assertions.assertEquals((double)spatialImpulseByReferenceFramesArray.getAngularPartY(), (double)randomVectorArray[1]);
            Assertions.assertEquals((double)spatialImpulseByReferenceFramesArray.getAngularPartZ(), (double)randomVectorArray[2]);
            Assertions.assertEquals((double)spatialImpulseByReferenceFramesArray.getLinearPartX(), (double)randomVectorArray[3]);
            Assertions.assertEquals((double)spatialImpulseByReferenceFramesArray.getLinearPartY(), (double)randomVectorArray[4]);
            Assertions.assertEquals((double)spatialImpulseByReferenceFramesArray.getLinearPartZ(), (double)randomVectorArray[5]);
        }
        for (i = 0; i < 1000; ++i) {
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            spatialImpulseByBodyFrameSpatialVector = new SpatialImpulse(randomBodyFrame, (SpatialVectorReadOnly)randomSpatialVector);
            Assertions.assertEquals((Object)spatialImpulseByBodyFrameSpatialVector.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)spatialImpulseByBodyFrameSpatialVector.getReferenceFrame(), (Object)randomSpatialVector.getReferenceFrame());
            Assertions.assertEquals((Object)spatialImpulseByBodyFrameSpatialVector.getAngularPart(), (Object)randomSpatialVector.getAngularPart());
            Assertions.assertEquals((Object)spatialImpulseByBodyFrameSpatialVector.getLinearPart(), (Object)randomSpatialVector.getLinearPart());
        }
        for (i = 0; i < 1000; ++i) {
            SpatialImpulse spatialImpulseByCopy;
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            spatialImpulseByBodyFrameSpatialVector = new SpatialImpulse(randomBodyFrame, (SpatialVectorReadOnly)(randomSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame)));
            Assertions.assertFalse((spatialImpulseByBodyFrameSpatialVector == (spatialImpulseByCopy = new SpatialImpulse((SpatialImpulseReadOnly)spatialImpulseByBodyFrameSpatialVector)) ? 1 : 0) != 0);
            Assertions.assertEquals((Object)spatialImpulseByBodyFrameSpatialVector, (Object)spatialImpulseByCopy);
        }
    }

    @Test
    public void testSet() {
        int i;
        Random random = new Random(21587L);
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Vector3D randomOriginalAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D randomOriginalLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            SpatialImpulse originalSpatialImpulse = new SpatialImpulse(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomOriginalAngularPart, (Vector3DReadOnly)randomOriginalLinearPart);
            Vector3D randomExpectedAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D randomExpectedLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            SpatialImpulse expectedSpatialImpulse = new SpatialImpulse(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomExpectedAngularPart, (Vector3DReadOnly)randomExpectedLinearPart);
            Assertions.assertNotEquals((Object)originalSpatialImpulse, (Object)expectedSpatialImpulse);
            originalSpatialImpulse.set(expectedSpatialImpulse);
            Assertions.assertEquals((Object)originalSpatialImpulse, (Object)expectedSpatialImpulse);
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomOriginalBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomOriginalReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                Vector3D randomOriginalAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
                Vector3D randomOriginalLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
                SpatialImpulse originalSpatialImpulse = new SpatialImpulse(randomOriginalBodyFrame, randomOriginalReferenceFrame, (Vector3DReadOnly)randomOriginalAngularPart, (Vector3DReadOnly)randomOriginalLinearPart);
                ReferenceFrame randomExpectedBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomExpectedReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                Vector3D randomExpectedAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
                Vector3D randomExpectedLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
                SpatialImpulse expectedSpatialImpulse = new SpatialImpulse(randomExpectedBodyFrame, randomExpectedReferenceFrame, (Vector3DReadOnly)randomExpectedAngularPart, (Vector3DReadOnly)randomExpectedLinearPart);
                originalSpatialImpulse.set(expectedSpatialImpulse);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when reference frame different for the vectors.");
        }
    }

    @Override
    @Test
    public void testSetBodyFrame() {
        Random random = new Random(58741L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Vector3D randomOriginalAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D randomOriginalLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            SpatialImpulse originalSpatialImpulse = new SpatialImpulse(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomOriginalAngularPart, (Vector3DReadOnly)randomOriginalLinearPart);
            SpatialImpulse expectedSpatialImpulse = new SpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            ReferenceFrame expectedBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            expectedSpatialImpulse.setBodyFrame(expectedBodyFrame);
            Assertions.assertEquals((Object)expectedSpatialImpulse.getBodyFrame(), (Object)expectedBodyFrame);
            Assertions.assertEquals((Object)expectedSpatialImpulse.getReferenceFrame(), (Object)originalSpatialImpulse.getReferenceFrame());
            Assertions.assertEquals((Object)expectedSpatialImpulse.getAngularPart(), (Object)originalSpatialImpulse.getAngularPart());
            Assertions.assertEquals((Object)expectedSpatialImpulse.getLinearPart(), (Object)originalSpatialImpulse.getLinearPart());
        }
    }

    @Test
    public void testSetReferenceFrame() {
        Random random = new Random(212080L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Vector3D randomOriginalAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D randomOriginalLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            SpatialImpulse originalSpatialImpulse = new SpatialImpulse(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomOriginalAngularPart, (Vector3DReadOnly)randomOriginalLinearPart);
            SpatialImpulse expectedSpatialImpulse = new SpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            ReferenceFrame expectedReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            expectedSpatialImpulse.setReferenceFrame(expectedReferenceFrame);
            Assertions.assertEquals((Object)expectedSpatialImpulse.getBodyFrame(), (Object)originalSpatialImpulse.getBodyFrame());
            Assertions.assertEquals((Object)expectedSpatialImpulse.getReferenceFrame(), (Object)expectedReferenceFrame);
            Assertions.assertEquals((Object)expectedSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)expectedReferenceFrame);
            Assertions.assertEquals((Object)expectedSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)expectedReferenceFrame);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSpatialImpulse.getAngularPart(), (EuclidGeometry)originalSpatialImpulse.getAngularPart(), (double)this.getEpsilon());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSpatialImpulse.getLinearPart(), (EuclidGeometry)originalSpatialImpulse.getLinearPart(), (double)this.getEpsilon());
        }
    }

    @Test
    public void testGets() {
        Random random = new Random(1005L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector3D randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            FrameVector3D randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            SpatialImpulse randomSpatialImpulse = new SpatialImpulse(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart(), (Object)randomAngularPart);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart(), (Object)randomLinearPart);
        }
    }

    @Test
    public void testApplyTransform() {
        SpatialImpulse expectedSpatialImpulse;
        SpatialImpulse originalSpatialImpulse;
        Vector3D sourceLinearPart;
        Vector3D sourceAngularPart;
        ReferenceFrame sourceFrame;
        ReferenceFrame randomBodyFrame;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(3456L);
        for (i = 0; i < 1000; ++i) {
            transform = new RigidBodyTransform();
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceAngularPart = new Vector3D(0.0, random.nextDouble(), 0.0);
            sourceLinearPart = new Vector3D(0.0, 0.0, random.nextDouble());
            originalSpatialImpulse = new SpatialImpulse(randomBodyFrame, sourceFrame, (Vector3DReadOnly)sourceAngularPart, (Vector3DReadOnly)sourceLinearPart);
            expectedSpatialImpulse = new SpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            transform.getTranslation().set(random.nextDouble(), 0.0, 0.0);
            expectedSpatialImpulse.applyTransform((RigidBodyTransformReadOnly)transform);
            Assertions.assertEquals((double)expectedSpatialImpulse.getAngularPartX(), (double)0.0);
            Assertions.assertEquals((double)expectedSpatialImpulse.getAngularPartY(), (double)(-transform.getTranslationX() * sourceLinearPart.getZ() + sourceAngularPart.getY()));
            Assertions.assertEquals((double)expectedSpatialImpulse.getAngularPartZ(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSpatialImpulse.getLinearPart(), (EuclidGeometry)originalSpatialImpulse.getLinearPart(), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = new RigidBodyTransform();
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceAngularPart = new Vector3D(0.0, 0.0, random.nextDouble());
            sourceLinearPart = new Vector3D(random.nextDouble(), 0.0, 0.0);
            originalSpatialImpulse = new SpatialImpulse(randomBodyFrame, sourceFrame, (Vector3DReadOnly)sourceAngularPart, (Vector3DReadOnly)sourceLinearPart);
            expectedSpatialImpulse = new SpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            transform.getTranslation().set(0.0, random.nextDouble(), 0.0);
            expectedSpatialImpulse.applyTransform((RigidBodyTransformReadOnly)transform);
            Assertions.assertEquals((double)expectedSpatialImpulse.getAngularPartX(), (double)0.0);
            Assertions.assertEquals((double)expectedSpatialImpulse.getAngularPartY(), (double)0.0);
            Assertions.assertEquals((double)expectedSpatialImpulse.getAngularPartZ(), (double)(-transform.getTranslationY() * sourceLinearPart.getX() + sourceAngularPart.getZ()));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSpatialImpulse.getLinearPart(), (EuclidGeometry)originalSpatialImpulse.getLinearPart(), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = new RigidBodyTransform();
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceAngularPart = new Vector3D(random.nextDouble(), 0.0, 0.0);
            sourceLinearPart = new Vector3D(0.0, random.nextDouble(), 0.0);
            originalSpatialImpulse = new SpatialImpulse(randomBodyFrame, sourceFrame, (Vector3DReadOnly)sourceAngularPart, (Vector3DReadOnly)sourceLinearPart);
            expectedSpatialImpulse = new SpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            transform.getTranslation().set(0.0, 0.0, random.nextDouble());
            expectedSpatialImpulse.applyTransform((RigidBodyTransformReadOnly)transform);
            Assertions.assertEquals((double)expectedSpatialImpulse.getAngularPartX(), (double)(-transform.getTranslationZ() * sourceLinearPart.getY() + sourceAngularPart.getX()));
            Assertions.assertEquals((double)expectedSpatialImpulse.getAngularPartY(), (double)0.0);
            Assertions.assertEquals((double)expectedSpatialImpulse.getAngularPartZ(), (double)0.0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSpatialImpulse.getLinearPart(), (EuclidGeometry)originalSpatialImpulse.getLinearPart(), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = new RigidBodyTransform();
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceAngularPart = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
            sourceLinearPart = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
            originalSpatialImpulse = new SpatialImpulse(randomBodyFrame, sourceFrame, (Vector3DReadOnly)sourceAngularPart, (Vector3DReadOnly)sourceLinearPart);
            expectedSpatialImpulse = new SpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            transform.getRotation().set((Orientation3DReadOnly)EuclidCoreRandomTools.nextOrientation3D((Random)random));
            expectedSpatialImpulse.applyTransform((RigidBodyTransformReadOnly)transform);
            sourceAngularPart.applyTransform((Transform)transform);
            sourceLinearPart.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSpatialImpulse.getAngularPart(), (EuclidGeometry)sourceAngularPart, (double)this.getEpsilon());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSpatialImpulse.getLinearPart(), (EuclidGeometry)sourceLinearPart, (double)this.getEpsilon());
        }
    }

    @Test
    public void testChangeFrame() {
        Random random = new Random(1005L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector3D sourceAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            FrameVector3D sourceLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            SpatialImpulse originalSpatialImpulse = new SpatialImpulse(randomBodyFrame, sourceFrame, (Vector3DReadOnly)sourceAngularPart, (Vector3DReadOnly)sourceLinearPart);
            SpatialImpulse expectedSpatialImpulse = new SpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            SpatialImpulse actualSpatialImpulse = new SpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            RigidBodyTransform transformToDesiredFrame = expectedSpatialImpulse.getReferenceFrame().getTransformToDesiredFrame(destinationFrame);
            expectedSpatialImpulse.applyTransform((RigidBodyTransformReadOnly)transformToDesiredFrame);
            expectedSpatialImpulse.setReferenceFrame(destinationFrame);
            actualSpatialImpulse.changeFrame(destinationFrame);
            Assertions.assertEquals((Object)actualSpatialImpulse.getBodyFrame(), (Object)originalSpatialImpulse.getBodyFrame());
            Assertions.assertEquals((Object)actualSpatialImpulse.getReferenceFrame(), (Object)destinationFrame);
            Assertions.assertEquals((Object)actualSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)destinationFrame);
            Assertions.assertEquals((Object)actualSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)destinationFrame);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSpatialImpulse.getAngularPart(), (EuclidGeometry)actualSpatialImpulse.getAngularPart(), (double)this.getEpsilon());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSpatialImpulse.getLinearPart(), (EuclidGeometry)actualSpatialImpulse.getLinearPart(), (double)this.getEpsilon());
        }
    }

    public void testApplyInverseTransform() throws Exception {
        SpatialImpulse expectedSpatialImpulse;
        SpatialImpulse originalSpatialImpulse;
        FrameVector3D sourceLinearPart;
        FrameVector3D sourceAngularPart;
        ReferenceFrame sourceFrame;
        ReferenceFrame randomBodyFrame;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            sourceLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            originalSpatialImpulse = new SpatialImpulse(randomBodyFrame, sourceFrame, (Vector3DReadOnly)sourceAngularPart, (Vector3DReadOnly)sourceLinearPart);
            expectedSpatialImpulse = new SpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            expectedSpatialImpulse.set(originalSpatialImpulse);
            Assertions.assertEquals((Object)originalSpatialImpulse, (Object)expectedSpatialImpulse);
            expectedSpatialImpulse.applyTransform((RigidBodyTransformReadOnly)transform);
            Assertions.assertNotEquals((Object)expectedSpatialImpulse, (Object)originalSpatialImpulse);
            expectedSpatialImpulse.applyInverseTransform((RigidBodyTransformReadOnly)transform);
            Assertions.assertTrue((boolean)expectedSpatialImpulse.epsilonEquals(originalSpatialImpulse, this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            sourceLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            originalSpatialImpulse = new SpatialImpulse(randomBodyFrame, sourceFrame, (Vector3DReadOnly)sourceAngularPart, (Vector3DReadOnly)sourceLinearPart);
            expectedSpatialImpulse = new SpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            expectedSpatialImpulse.set(originalSpatialImpulse);
            Assertions.assertEquals((Object)originalSpatialImpulse, (Object)expectedSpatialImpulse);
            expectedSpatialImpulse.applyTransform((RigidBodyTransformReadOnly)transform);
            Assertions.assertNotEquals((Object)expectedSpatialImpulse, (Object)originalSpatialImpulse);
            expectedSpatialImpulse.applyInverseTransform((RigidBodyTransformReadOnly)transform);
            Assertions.assertTrue((boolean)expectedSpatialImpulse.epsilonEquals(originalSpatialImpulse, this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            sourceAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            sourceLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            originalSpatialImpulse = new SpatialImpulse(randomBodyFrame, sourceFrame, (Vector3DReadOnly)sourceAngularPart, (Vector3DReadOnly)sourceLinearPart);
            expectedSpatialImpulse = new SpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            expectedSpatialImpulse.set(originalSpatialImpulse);
            Assertions.assertEquals((Object)originalSpatialImpulse, (Object)expectedSpatialImpulse);
            expectedSpatialImpulse.applyTransform((Transform)transform);
            Assertions.assertNotEquals((Object)expectedSpatialImpulse, (Object)originalSpatialImpulse);
            expectedSpatialImpulse.applyInverseTransform((Transform)transform);
            Assertions.assertTrue((boolean)expectedSpatialImpulse.epsilonEquals(originalSpatialImpulse, this.getEpsilon()));
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(1250L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame sourceBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector3D originalAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            FrameVector3D originalLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            SpatialImpulse originalSpatialImpulse = new SpatialImpulse(sourceBodyFrame, sourceFrame, (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)originalLinearPart);
            FrameVector3D changeAngularPart = new FrameVector3D((FrameTuple3DReadOnly)originalAngularPart);
            FrameVector3D changeLinearPart = new FrameVector3D((FrameTuple3DReadOnly)originalLinearPart);
            changeAngularPart.setElement(i % 3, originalAngularPart.getElement(i % 3) - 1.01 * this.getEpsilon());
            SpatialImpulse changedAboveSpatialImpulse = new SpatialImpulse(sourceBodyFrame, sourceFrame, (Vector3DReadOnly)changeAngularPart, (Vector3DReadOnly)originalLinearPart);
            Assertions.assertFalse((boolean)changedAboveSpatialImpulse.epsilonEquals(originalSpatialImpulse, this.getEpsilon()));
            changeAngularPart.setElement(i % 3, changeAngularPart.getElement(i % 3) + 0.99 * this.getEpsilon());
            SpatialImpulse changedBelowSpatialImpulse = new SpatialImpulse(sourceBodyFrame, sourceFrame, (Vector3DReadOnly)changeAngularPart, (Vector3DReadOnly)originalLinearPart);
            Assertions.assertTrue((boolean)changedBelowSpatialImpulse.epsilonEquals(originalSpatialImpulse, this.getEpsilon()));
            changeLinearPart.setElement(i % 3, originalLinearPart.getElement(i % 3) - 1.01 * this.getEpsilon());
            changedAboveSpatialImpulse = new SpatialImpulse(sourceBodyFrame, sourceFrame, (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)changeLinearPart);
            Assertions.assertFalse((boolean)changedAboveSpatialImpulse.epsilonEquals(originalSpatialImpulse, this.getEpsilon()));
            changeLinearPart.setElement(i % 3, originalLinearPart.getElement(i % 3) + 0.99 * this.getEpsilon());
            changedBelowSpatialImpulse = new SpatialImpulse(sourceBodyFrame, sourceFrame, (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)changeLinearPart);
            Assertions.assertTrue((boolean)changedBelowSpatialImpulse.epsilonEquals(originalSpatialImpulse, this.getEpsilon()));
            SpatialImpulse frameDifferentSpatialImpulse = new SpatialImpulse(sourceBodyFrame, EuclidFrameRandomTools.nextReferenceFrame((Random)random), (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)originalLinearPart);
            Assertions.assertFalse((boolean)originalSpatialImpulse.epsilonEquals(frameDifferentSpatialImpulse, this.getEpsilon()));
            frameDifferentSpatialImpulse = new SpatialImpulse(EuclidFrameRandomTools.nextReferenceFrame((Random)random), sourceFrame, (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)originalLinearPart);
            Assertions.assertFalse((boolean)originalSpatialImpulse.epsilonEquals(frameDifferentSpatialImpulse, this.getEpsilon()));
        }
    }

    @Test
    public void testGeometricallyEquals() {
        Random random = new Random(130375L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame sourceBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector3D originalAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            FrameVector3D originalLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            SpatialImpulse originalSpatialImpulse = new SpatialImpulse(sourceBodyFrame, sourceFrame, (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)originalLinearPart);
            FrameVector3D changeAngularPart = new FrameVector3D((FrameTuple3DReadOnly)originalAngularPart);
            FrameVector3D changeLinearPart = new FrameVector3D((FrameTuple3DReadOnly)originalLinearPart);
            changeAngularPart.setElement(i % 3, originalAngularPart.getElement(i % 3) - 1.01 * this.getEpsilon());
            SpatialImpulse changedAboveSpatialImpulse = new SpatialImpulse(sourceBodyFrame, sourceFrame, (Vector3DReadOnly)changeAngularPart, (Vector3DReadOnly)originalLinearPart);
            Assertions.assertFalse((boolean)changedAboveSpatialImpulse.geometricallyEquals(originalSpatialImpulse, this.getEpsilon()));
            changeAngularPart.setElement(i % 3, changeAngularPart.getElement(i % 3) + 0.99 * this.getEpsilon());
            SpatialImpulse changedBelowSpatialImpulse = new SpatialImpulse(sourceBodyFrame, sourceFrame, (Vector3DReadOnly)changeAngularPart, (Vector3DReadOnly)originalLinearPart);
            Assertions.assertTrue((boolean)changedBelowSpatialImpulse.geometricallyEquals(originalSpatialImpulse, this.getEpsilon()));
            changeLinearPart.setElement(i % 3, originalLinearPart.getElement(i % 3) - 1.01 * this.getEpsilon());
            changedAboveSpatialImpulse = new SpatialImpulse(sourceBodyFrame, sourceFrame, (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)changeLinearPart);
            Assertions.assertFalse((boolean)changedAboveSpatialImpulse.geometricallyEquals(originalSpatialImpulse, this.getEpsilon()));
            changeLinearPart.setElement(i % 3, originalLinearPart.getElement(i % 3) + 0.99 * this.getEpsilon());
            changedBelowSpatialImpulse = new SpatialImpulse(sourceBodyFrame, sourceFrame, (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)changeLinearPart);
            Assertions.assertTrue((boolean)changedBelowSpatialImpulse.geometricallyEquals(originalSpatialImpulse, this.getEpsilon()));
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame changeFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                Vector3D angularPart = new Vector3D(originalAngularPart.getX(), originalAngularPart.getY(), originalAngularPart.getZ());
                Vector3D linearPart = new Vector3D(originalLinearPart.getX(), originalLinearPart.getY(), originalLinearPart.getZ());
                SpatialImpulse changeReferenceFrameSpatialImpulse = new SpatialImpulse(sourceBodyFrame, changeFrame, (Vector3DReadOnly)angularPart, (Vector3DReadOnly)linearPart);
                Assertions.assertFalse((boolean)changeReferenceFrameSpatialImpulse.geometricallyEquals(originalSpatialImpulse, this.getEpsilon()));
            }, (String)"geometricallyEquals should have thrown a ReferenceFrameMatchingException error when reference frame different for the vectors.");
        }
    }

    @Test
    public void testToString() {
        Random random = new Random(130375L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame sourceBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector3D originalAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            FrameVector3D originalLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            SpatialImpulse originalSpatialImpulse = new SpatialImpulse(sourceBodyFrame, sourceFrame, (Vector3DReadOnly)originalAngularPart, (Vector3DReadOnly)originalLinearPart);
            Assertions.assertEquals((Object)originalSpatialImpulse.toString(), (Object)MecanoIOTools.getSpatialImpulseString((SpatialImpulseReadOnly)originalSpatialImpulse));
        }
    }
}

