/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialImpulseBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTools;

public abstract class FixedFrameSpatialImpulseBasicsTest<T extends FixedFrameSpatialImpulseBasics> {
    private static final int ITERATIONS = 1000;

    public abstract T newEmptySpatialImpulse();

    public abstract T newRandomSpatialImpulse(Random var1);

    public abstract T newSpatialImpulse(ReferenceFrame var1, SpatialVector var2);

    public abstract T newCopySpatialImpulse(SpatialImpulseReadOnly var1);

    public abstract double getEpsilon();

    public abstract void testSetMatchingFrame();

    @Test
    public void testSetters() {
        FrameVector3D randomLinearPart;
        FrameVector3D randomAngularPart;
        T destinationSpatialImpulse;
        SpatialVector destinationSpatialVector;
        ReferenceFrame randomReferenceFrame;
        ReferenceFrame randomBodyFrame;
        int i;
        Random random = new Random(21623L);
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T sourceSpatialImpulse = this.newRandomSpatialImpulse(random);
                T destinationSpatialImpulse = this.newRandomSpatialImpulse(random);
                destinationSpatialImpulse.set(sourceSpatialImpulse);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector sourceSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                T sourceSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, sourceSpatialVector);
                T destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
                destinationSpatialImpulse.set(sourceSpatialImpulse);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            T sourceSpatialImpulse = this.newRandomSpatialImpulse(random);
            SpatialVector spatialVectorWithSameReferenceFrame = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)sourceSpatialImpulse.getReferenceFrame());
            T destinationSpatialImpulse2 = this.newSpatialImpulse(sourceSpatialImpulse.getBodyFrame(), spatialVectorWithSameReferenceFrame);
            destinationSpatialImpulse2.set(sourceSpatialImpulse);
            Assertions.assertEquals(sourceSpatialImpulse, destinationSpatialImpulse2);
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector sourceSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                T destinationSpatialImpulse = this.newRandomSpatialImpulse(random);
                destinationSpatialImpulse.set(randomBodyFrame, (SpatialVectorReadOnly)sourceSpatialVector);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector sourceSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                T destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
                destinationSpatialImpulse.set(randomBodyFrame, (SpatialVectorReadOnly)sourceSpatialVector);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            SpatialVector sourceSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            T destinationSpatialImpulse3 = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
            destinationSpatialImpulse3.set(randomBodyFrame, (SpatialVectorReadOnly)sourceSpatialVector);
            Assertions.assertEquals((Object)destinationSpatialImpulse3.getReferenceFrame(), (Object)sourceSpatialVector.getReferenceFrame());
            Assertions.assertEquals((Object)destinationSpatialImpulse3.getAngularPart(), (Object)sourceSpatialVector.getAngularPart());
            Assertions.assertEquals((Object)destinationSpatialImpulse3.getLinearPart(), (Object)sourceSpatialVector.getLinearPart());
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                T destinationSpatialImpulse = this.newRandomSpatialImpulse(random);
                FrameVector3D randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
                FrameVector3D randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
                destinationSpatialImpulse.set(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                T destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
                FrameVector3D randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
                FrameVector3D randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
                destinationSpatialImpulse.set(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
            randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            destinationSpatialImpulse.set(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)destinationSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)destinationSpatialImpulse.getReferenceFrame(), (Object)randomAngularPart.getReferenceFrame());
            Assertions.assertEquals((Object)destinationSpatialImpulse.getAngularPart(), (Object)randomAngularPart);
            Assertions.assertEquals((Object)destinationSpatialImpulse.getLinearPart(), (Object)randomLinearPart);
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                T destinationSpatialImpulse = this.newRandomSpatialImpulse(random);
                Vector3D randomAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
                Vector3D randomLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
                destinationSpatialImpulse.set(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                T destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
                Vector3D randomAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
                Vector3D randomLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
                destinationSpatialImpulse.set(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
            randomAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            randomLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            destinationSpatialImpulse.set(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)destinationSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)destinationSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)destinationSpatialImpulse.getAngularPart(), (Tuple3DReadOnly)randomAngularPart, (double)this.getEpsilon());
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)destinationSpatialImpulse.getLinearPart(), (Tuple3DReadOnly)randomLinearPart, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                Vector3D randomAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
                Vector3D randomLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
                Point3D randomPointOfApplication = EuclidCoreRandomTools.nextPoint3D((Random)random);
                SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
                T destinationSpatialImpulse = this.newSpatialImpulse(EuclidFrameRandomTools.nextReferenceFrame((Random)random), destinationSpatialVector);
                destinationSpatialImpulse.set(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart, (Point3DReadOnly)randomPointOfApplication);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                Vector3D randomAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
                Vector3D randomLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
                Point3D randomPointOfApplication = EuclidCoreRandomTools.nextPoint3D((Random)random);
                SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                T destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
                destinationSpatialImpulse.set(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart, (Point3DReadOnly)randomPointOfApplication);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Vector3D randomAngularPart2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D randomLinearPart2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3D randomPointOfApplication = EuclidCoreRandomTools.nextPoint3D((Random)random);
            SpatialVector destinationSpatialVector2 = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            T destinationSpatialImpulse4 = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector2);
            Vector3D expectedAngularPart = new Vector3D((Tuple3DReadOnly)randomAngularPart2);
            MecanoTools.addCrossToVector((Tuple3DReadOnly)randomPointOfApplication, (Tuple3DReadOnly)randomLinearPart2, (Vector3DBasics)expectedAngularPart);
            destinationSpatialImpulse4.set(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomAngularPart2, (Vector3DReadOnly)randomLinearPart2, (Point3DReadOnly)randomPointOfApplication);
            Assertions.assertEquals((Object)destinationSpatialImpulse4.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)destinationSpatialImpulse4.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)destinationSpatialImpulse4.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)destinationSpatialImpulse4.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)destinationSpatialImpulse4.getAngularPart(), (Tuple3DReadOnly)expectedAngularPart, (double)this.getEpsilon());
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)destinationSpatialImpulse4.getLinearPart(), (Tuple3DReadOnly)randomLinearPart2, (double)this.getEpsilon());
        }
    }

    @Test
    public void testAdds() {
        ReferenceFrame randomReferenceFrame;
        ReferenceFrame randomBodyFrame;
        T destinationSpatialImpulse;
        int i;
        Random random = new Random(21623L);
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T sourceSpatialImpulse = this.newRandomSpatialImpulse(random);
                T destinationSpatialImpulse = this.newRandomSpatialImpulse(random);
                destinationSpatialImpulse.add(sourceSpatialImpulse);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector sourceSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                T sourceSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, sourceSpatialVector);
                T destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
                destinationSpatialImpulse.add(sourceSpatialImpulse);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            T sourceSpatialImpulse = this.newRandomSpatialImpulse(random);
            SpatialVector spatialVectorWithSameReferenceFrame = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)sourceSpatialImpulse.getReferenceFrame());
            T actualSpatialImpulse = this.newSpatialImpulse(sourceSpatialImpulse.getBodyFrame(), spatialVectorWithSameReferenceFrame);
            destinationSpatialImpulse = this.newCopySpatialImpulse((SpatialImpulseReadOnly)actualSpatialImpulse);
            destinationSpatialImpulse.add(sourceSpatialImpulse);
            Assertions.assertEquals((Object)destinationSpatialImpulse.getBodyFrame(), (Object)sourceSpatialImpulse.getBodyFrame());
            Assertions.assertEquals((Object)destinationSpatialImpulse.getReferenceFrame(), (Object)sourceSpatialImpulse.getReferenceFrame());
            Assertions.assertEquals((double)destinationSpatialImpulse.getAngularPartX(), (double)(sourceSpatialImpulse.getAngularPartX() + actualSpatialImpulse.getAngularPartX()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getAngularPartY(), (double)(sourceSpatialImpulse.getAngularPartY() + actualSpatialImpulse.getAngularPartY()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getAngularPartZ(), (double)(sourceSpatialImpulse.getAngularPartZ() + actualSpatialImpulse.getAngularPartZ()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getLinearPartX(), (double)(sourceSpatialImpulse.getLinearPartX() + actualSpatialImpulse.getLinearPartX()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getLinearPartY(), (double)(sourceSpatialImpulse.getLinearPartY() + actualSpatialImpulse.getLinearPartY()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getLinearPartZ(), (double)(sourceSpatialImpulse.getLinearPartZ() + actualSpatialImpulse.getLinearPartZ()));
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T destinationSpatialImpulse = this.newRandomSpatialImpulse(random);
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector originalSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
                destinationSpatialImpulse.add(randomBodyFrame, (SpatialVectorReadOnly)originalSpatialVector);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector originalSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
                SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                T destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
                destinationSpatialImpulse.add(randomBodyFrame, (SpatialVectorReadOnly)originalSpatialVector);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialVector originalSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            T destinationSpatialImpulse2 = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
            T actualSpatialImpulse = this.newCopySpatialImpulse((SpatialImpulseReadOnly)destinationSpatialImpulse2);
            destinationSpatialImpulse2.add(randomBodyFrame, (SpatialVectorReadOnly)originalSpatialVector);
            Assertions.assertEquals((Object)destinationSpatialImpulse2.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)destinationSpatialImpulse2.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)destinationSpatialImpulse2.getAngularPartX(), (double)(originalSpatialVector.getAngularPartX() + actualSpatialImpulse.getAngularPartX()));
            Assertions.assertEquals((double)destinationSpatialImpulse2.getAngularPartY(), (double)(originalSpatialVector.getAngularPartY() + actualSpatialImpulse.getAngularPartY()));
            Assertions.assertEquals((double)destinationSpatialImpulse2.getAngularPartZ(), (double)(originalSpatialVector.getAngularPartZ() + actualSpatialImpulse.getAngularPartZ()));
            Assertions.assertEquals((double)destinationSpatialImpulse2.getLinearPartX(), (double)(originalSpatialVector.getLinearPartX() + actualSpatialImpulse.getLinearPartX()));
            Assertions.assertEquals((double)destinationSpatialImpulse2.getLinearPartY(), (double)(originalSpatialVector.getLinearPartY() + actualSpatialImpulse.getLinearPartY()));
            Assertions.assertEquals((double)destinationSpatialImpulse2.getLinearPartZ(), (double)(originalSpatialVector.getLinearPartZ() + actualSpatialImpulse.getLinearPartZ()));
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T destinationSpatialImpulse = this.newRandomSpatialImpulse(random);
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                FrameVector3D randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
                FrameVector3D randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
                destinationSpatialImpulse.add(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                T destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
                FrameVector3D randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
                FrameVector3D randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
                destinationSpatialImpulse.add(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
            T actualSpatialImpulse = this.newCopySpatialImpulse((SpatialImpulseReadOnly)destinationSpatialImpulse);
            FrameVector3D randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            FrameVector3D randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            destinationSpatialImpulse.add(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)destinationSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)destinationSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)destinationSpatialImpulse.getAngularPartX(), (double)(randomAngularPart.getX() + actualSpatialImpulse.getAngularPartX()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getAngularPartY(), (double)(randomAngularPart.getY() + actualSpatialImpulse.getAngularPartY()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getAngularPartZ(), (double)(randomAngularPart.getZ() + actualSpatialImpulse.getAngularPartZ()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getLinearPartX(), (double)(randomLinearPart.getX() + actualSpatialImpulse.getLinearPartX()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getLinearPartY(), (double)(randomLinearPart.getY() + actualSpatialImpulse.getLinearPartY()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getLinearPartZ(), (double)(randomLinearPart.getZ() + actualSpatialImpulse.getLinearPartZ()));
        }
    }

    @Test
    public void testSubs() {
        ReferenceFrame randomReferenceFrame;
        ReferenceFrame randomBodyFrame;
        T destinationSpatialImpulse;
        int i;
        Random random = new Random(21623L);
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T sourceSpatialImpulse = this.newRandomSpatialImpulse(random);
                T destinationSpatialImpulse = this.newRandomSpatialImpulse(random);
                destinationSpatialImpulse.sub(sourceSpatialImpulse);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector sourceSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                T sourceSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, sourceSpatialVector);
                T destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
                destinationSpatialImpulse.sub(sourceSpatialImpulse);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            T sourceSpatialImpulse = this.newRandomSpatialImpulse(random);
            SpatialVector spatialVectorWithSameReferenceFrame = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)sourceSpatialImpulse.getReferenceFrame());
            T actualSpatialImpulse = this.newSpatialImpulse(sourceSpatialImpulse.getBodyFrame(), spatialVectorWithSameReferenceFrame);
            destinationSpatialImpulse = this.newCopySpatialImpulse((SpatialImpulseReadOnly)actualSpatialImpulse);
            destinationSpatialImpulse.sub(sourceSpatialImpulse);
            Assertions.assertEquals((Object)destinationSpatialImpulse.getBodyFrame(), (Object)sourceSpatialImpulse.getBodyFrame());
            Assertions.assertEquals((Object)destinationSpatialImpulse.getReferenceFrame(), (Object)sourceSpatialImpulse.getReferenceFrame());
            Assertions.assertEquals((double)destinationSpatialImpulse.getAngularPartX(), (double)(actualSpatialImpulse.getAngularPartX() - sourceSpatialImpulse.getAngularPartX()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getAngularPartY(), (double)(actualSpatialImpulse.getAngularPartY() - sourceSpatialImpulse.getAngularPartY()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getAngularPartZ(), (double)(actualSpatialImpulse.getAngularPartZ() - sourceSpatialImpulse.getAngularPartZ()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getLinearPartX(), (double)(actualSpatialImpulse.getLinearPartX() - sourceSpatialImpulse.getLinearPartX()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getLinearPartY(), (double)(actualSpatialImpulse.getLinearPartY() - sourceSpatialImpulse.getLinearPartY()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getLinearPartZ(), (double)(actualSpatialImpulse.getLinearPartZ() - sourceSpatialImpulse.getLinearPartZ()));
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T destinationSpatialImpulse = this.newRandomSpatialImpulse(random);
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector originalSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
                destinationSpatialImpulse.sub(randomBodyFrame, (SpatialVectorReadOnly)originalSpatialVector);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector originalSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
                SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                T destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
                destinationSpatialImpulse.sub(randomBodyFrame, (SpatialVectorReadOnly)originalSpatialVector);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialVector originalSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            T destinationSpatialImpulse2 = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
            T actualSpatialImpulse = this.newCopySpatialImpulse((SpatialImpulseReadOnly)destinationSpatialImpulse2);
            destinationSpatialImpulse2.sub(randomBodyFrame, (SpatialVectorReadOnly)originalSpatialVector);
            Assertions.assertEquals((Object)destinationSpatialImpulse2.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)destinationSpatialImpulse2.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)destinationSpatialImpulse2.getAngularPartX(), (double)(actualSpatialImpulse.getAngularPartX() - originalSpatialVector.getAngularPartX()));
            Assertions.assertEquals((double)destinationSpatialImpulse2.getAngularPartY(), (double)(actualSpatialImpulse.getAngularPartY() - originalSpatialVector.getAngularPartY()));
            Assertions.assertEquals((double)destinationSpatialImpulse2.getAngularPartZ(), (double)(actualSpatialImpulse.getAngularPartZ() - originalSpatialVector.getAngularPartZ()));
            Assertions.assertEquals((double)destinationSpatialImpulse2.getLinearPartX(), (double)(actualSpatialImpulse.getLinearPartX() - originalSpatialVector.getLinearPartX()));
            Assertions.assertEquals((double)destinationSpatialImpulse2.getLinearPartY(), (double)(actualSpatialImpulse.getLinearPartY() - originalSpatialVector.getLinearPartY()));
            Assertions.assertEquals((double)destinationSpatialImpulse2.getLinearPartZ(), (double)(actualSpatialImpulse.getLinearPartZ() - originalSpatialVector.getLinearPartZ()));
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T destinationSpatialImpulse = this.newRandomSpatialImpulse(random);
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                FrameVector3D randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
                FrameVector3D randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
                destinationSpatialImpulse.sub(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
                T destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
                FrameVector3D randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
                FrameVector3D randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
                destinationSpatialImpulse.sub(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            }, (String)"Set should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
            T actualSpatialImpulse = this.newCopySpatialImpulse((SpatialImpulseReadOnly)destinationSpatialImpulse);
            FrameVector3D randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            FrameVector3D randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            destinationSpatialImpulse.sub(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)destinationSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)destinationSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)destinationSpatialImpulse.getAngularPartX(), (double)(actualSpatialImpulse.getAngularPartX() - randomAngularPart.getX()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getAngularPartY(), (double)(actualSpatialImpulse.getAngularPartY() - randomAngularPart.getY()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getAngularPartZ(), (double)(actualSpatialImpulse.getAngularPartZ() - randomAngularPart.getZ()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getLinearPartX(), (double)(actualSpatialImpulse.getLinearPartX() - randomLinearPart.getX()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getLinearPartY(), (double)(actualSpatialImpulse.getLinearPartY() - randomLinearPart.getY()));
            Assertions.assertEquals((double)destinationSpatialImpulse.getLinearPartZ(), (double)(actualSpatialImpulse.getLinearPartZ() - randomLinearPart.getZ()));
        }
    }
}

