/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.FixedFrameSpatialImpulseBasicsTest;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialImpulseBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTools;

public abstract class SpatialImpulseBasicsTest<T extends SpatialImpulseBasics>
extends FixedFrameSpatialImpulseBasicsTest<FixedFrameSpatialImpulseBasics> {
    private static final int ITERATIONS = 1000;

    @Override
    public abstract T newEmptySpatialImpulse();

    @Override
    public abstract T newRandomSpatialImpulse(Random var1);

    @Override
    public abstract T newSpatialImpulse(ReferenceFrame var1, SpatialVector var2);

    @Override
    public abstract T newCopySpatialImpulse(SpatialImpulseReadOnly var1);

    @Override
    public abstract double getEpsilon();

    @Override
    @Test
    public void testSetMatchingFrame() {
        int i;
        Random random = new Random(21623L);
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T sourceSpatialImpulse = this.newRandomSpatialImpulse(random);
                T destinationSpatialImpulse = this.newRandomSpatialImpulse(random);
                destinationSpatialImpulse.setMatchingFrame(sourceSpatialImpulse);
            }, (String)"SetMatchingFrame should have thrown a ReferenceFrameMatchingException error when any of the reference frames different for the SpatialImpulses.");
        }
        for (i = 0; i < 1000; ++i) {
            T destinationSpatialImpulse;
            ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            SpatialVector sourceSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
            SpatialVector destinationSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)EuclidFrameRandomTools.nextReferenceFrame((Random)random));
            T sourceSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, sourceSpatialVector);
            T expectedSpatialVector = destinationSpatialImpulse = this.newSpatialImpulse(randomBodyFrame, destinationSpatialVector);
            expectedSpatialVector.setIncludingFrame(sourceSpatialImpulse);
            expectedSpatialVector.changeFrame(destinationSpatialImpulse.getReferenceFrame());
            destinationSpatialImpulse.setMatchingFrame(sourceSpatialImpulse);
            Assertions.assertEquals((Object)destinationSpatialImpulse.getBodyFrame(), (Object)sourceSpatialImpulse.getBodyFrame());
            Assertions.assertEquals((Object)destinationSpatialImpulse.getReferenceFrame(), (Object)sourceSpatialImpulse.getReferenceFrame());
            Assertions.assertEquals((Object)destinationSpatialImpulse.getAngularPart(), (Object)expectedSpatialVector.getAngularPart());
            Assertions.assertEquals((Object)destinationSpatialImpulse.getLinearPart(), (Object)expectedSpatialVector.getLinearPart());
        }
        for (i = 0; i < 1000; ++i) {
            T sourceSpatialImpulse = this.newRandomSpatialImpulse(random);
            SpatialVector spatialVectorWithSameReferenceFrame = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)sourceSpatialImpulse.getReferenceFrame());
            T destinationSpatialImpulse = this.newSpatialImpulse(sourceSpatialImpulse.getBodyFrame(), spatialVectorWithSameReferenceFrame);
            destinationSpatialImpulse.setMatchingFrame(sourceSpatialImpulse);
            Assertions.assertEquals(sourceSpatialImpulse, destinationSpatialImpulse);
        }
    }

    @Test
    public void testSetBodyFrame() {
        Random random = new Random(21587L);
        for (int i = 0; i < 1000; ++i) {
            T originalSpatialImpulse = this.newRandomSpatialImpulse(random);
            T expectedSpatialImpulse = this.newCopySpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            expectedSpatialImpulse.setBodyFrame(randomBodyFrame);
            Assertions.assertEquals((Object)expectedSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)expectedSpatialImpulse.getReferenceFrame(), (Object)originalSpatialImpulse.getReferenceFrame());
            Assertions.assertEquals((Object)expectedSpatialImpulse.getAngularPart(), (Object)originalSpatialImpulse.getAngularPart());
            Assertions.assertEquals((Object)expectedSpatialImpulse.getLinearPart(), (Object)originalSpatialImpulse.getLinearPart());
        }
    }

    @Test
    public void testToZero() {
        Random random = new Random(19547L);
        for (int i = 0; i < 1000; ++i) {
            T randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomSpatialImpulse.setToZero(randomBodyFrame, randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartX(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartY(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartX(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartX(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartY(), (double)0.0);
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartZ(), (double)0.0);
        }
    }

    @Test
    public void testToNaN() {
        Random random = new Random(19547L);
        for (int i = 0; i < 1000; ++i) {
            T randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomSpatialImpulse.setToNaN(randomBodyFrame, randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)randomSpatialImpulse.getAngularPart());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)randomSpatialImpulse.getLinearPart());
        }
    }

    @Test
    public void testSetIncludingFrame() {
        Vector3D expectedAngularPart;
        DMatrixRMaj randomMatrix;
        Object[] randomVectorArray;
        FrameVector3D randomLinearPart;
        FrameVector3D randomAngularPart;
        ReferenceFrame randomBodyFrame;
        T randomSpatialImpulse;
        SpatialVector randomSpatialVector;
        ReferenceFrame randomReferenceFrame;
        int i;
        Random random = new Random(25414L);
        for (i = 0; i < 1000; ++i) {
            T originalSpatialImpulse = this.newRandomSpatialImpulse(random);
            T expectedSpatialImpulse = this.newCopySpatialImpulse((SpatialImpulseReadOnly)originalSpatialImpulse);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            expectedSpatialImpulse.setIncludingFrame((SpatialVectorReadOnly)randomSpatialVector);
            Assertions.assertEquals((Object)expectedSpatialImpulse.getBodyFrame(), (Object)originalSpatialImpulse.getBodyFrame());
            Assertions.assertEquals((Object)expectedSpatialImpulse.getReferenceFrame(), (Object)randomSpatialVector.getReferenceFrame());
            Assertions.assertEquals((Object)expectedSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomSpatialVector.getReferenceFrame());
            Assertions.assertEquals((Object)expectedSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomSpatialVector.getReferenceFrame());
            Assertions.assertEquals((Object)expectedSpatialImpulse.getAngularPart(), (Object)randomSpatialVector.getAngularPart());
            Assertions.assertEquals((Object)expectedSpatialImpulse.getLinearPart(), (Object)randomSpatialVector.getLinearPart());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomSpatialVector = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)randomReferenceFrame);
            randomSpatialImpulse.setIncludingFrame(randomBodyFrame, (SpatialVectorReadOnly)randomSpatialVector);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomSpatialVector.getReferenceFrame());
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomSpatialVector.getReferenceFrame());
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomSpatialVector.getReferenceFrame());
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart(), (Object)randomSpatialVector.getAngularPart());
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart(), (Object)randomSpatialVector.getLinearPart());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            randomSpatialImpulse.setIncludingFrame(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomAngularPart.getReferenceFrame());
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomAngularPart.getReferenceFrame());
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomLinearPart.getReferenceFrame());
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart(), (Object)randomAngularPart);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart(), (Object)randomLinearPart);
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T randomSpatialImpulse = this.newRandomSpatialImpulse(random);
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrameAngular = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomReferenceFrameLinear = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                FrameVector3D randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrameAngular);
                FrameVector3D randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrameLinear);
                randomSpatialImpulse.setIncludingFrame(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart);
            }, (String)"SetIncludingFrame should have thrown a ReferenceFrameMatchingException error when reference frame different for the vectors.");
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            randomLinearPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            randomSpatialImpulse.setIncludingFrame(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomSpatialImpulse.getAngularPart(), (Tuple3DReadOnly)randomAngularPart, (double)this.getEpsilon());
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomSpatialImpulse.getLinearPart(), (Tuple3DReadOnly)randomLinearPart, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomVectorArray = new double[6];
            for (int index = 0; index < 6; ++index) {
                randomVectorArray[index] = random.nextDouble();
            }
            randomSpatialImpulse.setIncludingFrame(randomBodyFrame, randomReferenceFrame, randomVectorArray);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartX(), (double)randomVectorArray[0]);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartY(), (double)randomVectorArray[1]);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartZ(), (double)randomVectorArray[2]);
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartX(), (double)randomVectorArray[3]);
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartY(), (double)randomVectorArray[4]);
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartZ(), (double)randomVectorArray[5]);
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomVectorArray = new double[24];
            for (int index = 0; index < 24; ++index) {
                randomVectorArray[index] = random.nextDouble();
            }
            int startingArrayIndex = i % 18;
            randomSpatialImpulse.setIncludingFrame(randomBodyFrame, randomReferenceFrame, startingArrayIndex, randomVectorArray);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartX(), (double)randomVectorArray[startingArrayIndex]);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartY(), (double)randomVectorArray[++startingArrayIndex]);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartZ(), (double)randomVectorArray[++startingArrayIndex]);
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartX(), (double)randomVectorArray[++startingArrayIndex]);
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartY(), (double)randomVectorArray[++startingArrayIndex]);
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartZ(), (double)randomVectorArray[++startingArrayIndex]);
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomVectorArray = new float[6];
            for (int index = 0; index < 6; ++index) {
                randomVectorArray[index] = random.nextFloat();
            }
            randomSpatialImpulse.setIncludingFrame(randomBodyFrame, randomReferenceFrame, (float[])randomVectorArray);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartX(), (double)randomVectorArray[0], (double)this.getEpsilon());
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartY(), (double)randomVectorArray[1], (double)this.getEpsilon());
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartZ(), (double)randomVectorArray[2], (double)this.getEpsilon());
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartX(), (double)randomVectorArray[3], (double)this.getEpsilon());
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartY(), (double)randomVectorArray[4], (double)this.getEpsilon());
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartZ(), (double)randomVectorArray[5], (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomVectorArray = new float[24];
            for (int index = 0; index < 24; ++index) {
                randomVectorArray[index] = random.nextFloat();
            }
            int startingArrayIndex = i % 18;
            randomSpatialImpulse.setIncludingFrame(randomBodyFrame, randomReferenceFrame, startingArrayIndex, (float[])randomVectorArray);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartX(), (double)randomVectorArray[startingArrayIndex]);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartY(), (double)randomVectorArray[++startingArrayIndex]);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartZ(), (double)randomVectorArray[++startingArrayIndex]);
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartX(), (double)randomVectorArray[++startingArrayIndex]);
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartY(), (double)randomVectorArray[++startingArrayIndex]);
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartZ(), (double)randomVectorArray[++startingArrayIndex]);
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomMatrix = new DMatrixRMaj(6, 1);
            for (int row = 0; row < 6; ++row) {
                randomMatrix.set(row, 0, random.nextDouble());
            }
            randomSpatialImpulse.setIncludingFrame(randomBodyFrame, randomReferenceFrame, (DMatrix)randomMatrix);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartX(), (double)randomMatrix.get(0, 0));
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartY(), (double)randomMatrix.get(1, 0));
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartZ(), (double)randomMatrix.get(2, 0));
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartX(), (double)randomMatrix.get(3, 0));
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartY(), (double)randomMatrix.get(4, 0));
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartZ(), (double)randomMatrix.get(5, 0));
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomMatrix = new DMatrixRMaj(24, 1);
            for (int row = 0; row < 24; ++row) {
                randomMatrix.set(row, 0, random.nextDouble());
            }
            int startingArrayIndex = i % 18;
            randomSpatialImpulse.setIncludingFrame(randomBodyFrame, randomReferenceFrame, startingArrayIndex, (DMatrix)randomMatrix);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartX(), (double)randomMatrix.get(startingArrayIndex, 0));
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartY(), (double)randomMatrix.get(++startingArrayIndex, 0));
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartZ(), (double)randomMatrix.get(++startingArrayIndex, 0));
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartX(), (double)randomMatrix.get(++startingArrayIndex, 0));
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartY(), (double)randomMatrix.get(++startingArrayIndex, 0));
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartZ(), (double)randomMatrix.get(++startingArrayIndex, 0));
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomMatrix = new DMatrixRMaj(24, 24);
            for (int row = 0; row < 24; ++row) {
                for (int column = 0; column < 24; ++column) {
                    randomMatrix.set(row, column, random.nextDouble());
                }
            }
            int startingArrayIndex = i % 18;
            int startingMatrixColumn = i % 18;
            randomSpatialImpulse.setIncludingFrame(randomBodyFrame, randomReferenceFrame, startingArrayIndex, startingMatrixColumn, (DMatrix)randomMatrix);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartX(), (double)randomMatrix.get(startingArrayIndex, startingMatrixColumn));
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartY(), (double)randomMatrix.get(++startingArrayIndex, startingMatrixColumn));
            Assertions.assertEquals((double)randomSpatialImpulse.getAngularPartZ(), (double)randomMatrix.get(++startingArrayIndex, startingMatrixColumn));
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartX(), (double)randomMatrix.get(++startingArrayIndex, startingMatrixColumn));
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartY(), (double)randomMatrix.get(++startingArrayIndex, startingMatrixColumn));
            Assertions.assertEquals((double)randomSpatialImpulse.getLinearPartZ(), (double)randomMatrix.get(++startingArrayIndex, startingMatrixColumn));
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomAngularPart = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D randomLinearPart2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3D randomPointOfApplication = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expectedAngularPart = new Vector3D((Tuple3DReadOnly)randomAngularPart);
            MecanoTools.addCrossToVector((Tuple3DReadOnly)randomPointOfApplication, (Tuple3DReadOnly)randomLinearPart2, (Vector3DBasics)expectedAngularPart);
            randomSpatialImpulse.setIncludingFrame(randomBodyFrame, randomReferenceFrame, (Vector3DReadOnly)randomAngularPart, (Vector3DReadOnly)randomLinearPart2, (Point3DReadOnly)randomPointOfApplication);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomSpatialImpulse.getAngularPart(), (Tuple3DReadOnly)expectedAngularPart, (double)this.getEpsilon());
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomSpatialImpulse.getLinearPart(), (Tuple3DReadOnly)randomLinearPart2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            randomSpatialImpulse = this.newRandomSpatialImpulse(random);
            randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            FrameVector3D randomLinearPart3 = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            FramePoint3D randomPointOfApplication = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)randomReferenceFrame);
            expectedAngularPart = new FrameVector3D((FrameTuple3DReadOnly)randomAngularPart);
            MecanoTools.addCrossToVector((Tuple3DReadOnly)randomPointOfApplication, (Tuple3DReadOnly)randomLinearPart3, (Vector3DBasics)expectedAngularPart);
            randomSpatialImpulse.setIncludingFrame(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart3, (FramePoint3DReadOnly)randomPointOfApplication);
            Assertions.assertEquals((Object)randomSpatialImpulse.getBodyFrame(), (Object)randomBodyFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getAngularPart().getReferenceFrame(), (Object)randomReferenceFrame);
            Assertions.assertEquals((Object)randomSpatialImpulse.getLinearPart().getReferenceFrame(), (Object)randomReferenceFrame);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomSpatialImpulse.getAngularPart(), (Tuple3DReadOnly)expectedAngularPart, (double)this.getEpsilon());
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomSpatialImpulse.getLinearPart(), (Tuple3DReadOnly)randomLinearPart3, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
                T randomSpatialImpulse = this.newRandomSpatialImpulse(random);
                ReferenceFrame randomBodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomAnularReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                ReferenceFrame randomLinearReferenceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
                FrameVector3D randomAngularPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomAnularReferenceFrame);
                FrameVector3D randomLinearPart = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomLinearReferenceFrame);
                FramePoint3D randomPointOfApplication = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)randomAnularReferenceFrame);
                FrameVector3D expectedAngularPart = new FrameVector3D((FrameTuple3DReadOnly)randomAngularPart);
                MecanoTools.addCrossToVector((Tuple3DReadOnly)randomPointOfApplication, (Tuple3DReadOnly)randomLinearPart, (Vector3DBasics)expectedAngularPart);
                randomSpatialImpulse.setIncludingFrame(randomBodyFrame, (FrameVector3DReadOnly)randomAngularPart, (FrameVector3DReadOnly)randomLinearPart, (FramePoint3DReadOnly)randomPointOfApplication);
            }, (String)"SetIncludingFrame should have thrown a ReferenceFrameMatchingException error when reference frame different for the vectors.");
        }
    }
}

