/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.graphviz;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.RigidBodyTransform;

public class ReferenceFrameTreeViewer {
    private final ReferenceFrame rootFrame;
    private Format format = Format.SVG;
    private Predicate<ReferenceFrame> filter = frame -> true;
    private final List<LabelProvider> labelProviders = new ArrayList<LabelProvider>();

    public ReferenceFrameTreeViewer(ReferenceFrame rootFrameToView) {
        this.rootFrame = rootFrameToView;
        this.labelProviders.add(frame -> frame.getName() + ", nameId: " + frame.hashCode());
    }

    public ReferenceFrameTreeViewer addLabelProvider(LabelProvider labelProvider) {
        this.labelProviders.add(labelProvider);
        return this;
    }

    public ReferenceFrameTreeViewer addTransformToParentLabel() {
        return this.addLabelProvider(frame -> {
            if (!frame.isRootFrame()) {
                return "Transform to parent:\n" + ReferenceFrameTreeViewer.getTransformLabel(frame.getTransformToParent());
            }
            return null;
        });
    }

    public ReferenceFrameTreeViewer renderingFormat(Format format) {
        this.format = format;
        return this;
    }

    public ReferenceFrameTreeViewer setFilter(Predicate<ReferenceFrame> filter) {
        this.filter = filter;
        return this;
    }

    public void view(String outputFileName) {
        MutableGraph graph = Factory.mutGraph((String)"ReferenceFrameTreeView").setDirected(true);
        MutableNode rootNode = this.createFrameNode(this.rootFrame, graph);
        this.addChildrenToGraph(this.rootFrame, rootNode, graph);
        try {
            Graphviz.fromGraph((MutableGraph)graph).render(this.format).toFile(new File(outputFileName + "." + this.format.name().toLowerCase()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addChildrenToGraph(ReferenceFrame currentFrame, MutableNode currentNode, MutableGraph graph) {
        for (int childIndex = 0; childIndex < currentFrame.getNumberOfChildren(); ++childIndex) {
            ReferenceFrame child = currentFrame.getChild(childIndex);
            if (this.filter.test(child)) {
                MutableNode childNode = this.createFrameNode(child, graph);
                graph.addLink((LinkTarget)currentNode.addLink((LinkTarget)childNode));
                this.addChildrenToGraph(child, childNode, graph);
                continue;
            }
            this.addChildrenToGraph(child, currentNode, graph);
        }
    }

    private MutableNode createFrameNode(ReferenceFrame frame, MutableGraph graph) {
        Object label = this.labelProviders.get(0).getLabel(frame);
        for (int i = 1; i < this.labelProviders.size(); ++i) {
            String additionalLabel = this.labelProviders.get(i).getLabel(frame);
            if (additionalLabel == null) continue;
            label = (String)label + "\n" + additionalLabel;
        }
        MutableNode frameNode = Factory.mutNode((String)label);
        graph.add((LinkSource)frameNode);
        return frameNode;
    }

    public static String getLabelOf(double ... values) {
        return EuclidCoreIOTools.getStringOf((String)"(", (String)")", (String)", ", (double[])values);
    }

    public static String getOrientationLabel(Orientation3DReadOnly orientation) {
        return "(y,p,r) = " + ReferenceFrameTreeViewer.getLabelOf(orientation.getYaw(), orientation.getPitch(), orientation.getRoll());
    }

    public static String getTransformLabel(RigidBodyTransform transform) {
        String translationAsString = transform.getTranslation().toString();
        return "(x,y,z) = " + translationAsString + "\n" + ReferenceFrameTreeViewer.getOrientationLabel((Orientation3DReadOnly)transform.getRotation());
    }

    public static void viewSimpleReferenceFrameTree(ReferenceFrame rootFrameToView) {
        new ReferenceFrameTreeViewer(rootFrameToView).view("frameView");
    }

    public static void viewReferenceFrameTree(ReferenceFrame rootFrameToView) {
        new ReferenceFrameTreeViewer(rootFrameToView).addTransformToParentLabel().view("frameView");
    }

    public static void main(String[] args) {
        Random random = new Random(435634L);
        EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        new ReferenceFrameTreeViewer(ReferenceFrame.getWorldFrame()).addTransformToParentLabel().view("ReferenceFrameTreeViewExample");
    }

    public static interface LabelProvider {
        public String getLabel(ReferenceFrame var1);
    }
}

