/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.graphviz;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.graphviz.ReferenceFrameTreeViewer;
import us.ihmc.mecano.multiBodySystem.interfaces.FixedJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class MultiBodySystemViewer {
    private final RigidBodyReadOnly rootBody;
    private Format format = Format.SVG;
    private Display display = Display.JOINTS;
    private final List<JointLabelProvider> jointLabelProviders = new ArrayList<JointLabelProvider>();
    private final List<RigidBodyLabelProvider> rigidBodyLabelProviders = new ArrayList<RigidBodyLabelProvider>();

    public MultiBodySystemViewer(RigidBodyReadOnly rootBody) {
        this.rootBody = rootBody;
        this.jointLabelProviders.add(joint -> joint.getName() + ", nameId: " + joint.hashCode());
        this.rigidBodyLabelProviders.add(rigidBody -> rigidBody.getName() + ", nameId: " + rigidBody.hashCode());
    }

    public MultiBodySystemViewer setDisplay(Display display) {
        this.display = display;
        return this;
    }

    public MultiBodySystemViewer addLabelProvider(JointLabelProvider labelProvider) {
        this.jointLabelProviders.add(labelProvider);
        return this;
    }

    public MultiBodySystemViewer addLabelProvider(RigidBodyLabelProvider labelProvider) {
        this.rigidBodyLabelProviders.add(labelProvider);
        return this;
    }

    public MultiBodySystemViewer showJointType() {
        this.jointLabelProviders.add(joint -> joint.getClass().getSimpleName());
        return this;
    }

    public MultiBodySystemViewer showJointStates(JointStateType ... jointStateTypes) {
        for (JointStateType state : jointStateTypes) {
            this.jointLabelProviders.add(joint -> MultiBodySystemViewer.getJointStateAsString(joint, state));
        }
        return this;
    }

    public MultiBodySystemViewer showOneDoFJointAxis() {
        this.jointLabelProviders.add(MultiBodySystemViewer::getJointAxisLabel);
        return this;
    }

    public MultiBodySystemViewer showRigidBodyMass() {
        this.rigidBodyLabelProviders.add(rigidBody -> {
            if (rigidBody.isRootBody()) {
                return null;
            }
            return "mass = " + ReferenceFrameTreeViewer.getLabelOf(rigidBody.getInertia().getMass());
        });
        return this;
    }

    public MultiBodySystemViewer showRigidBodyInertia() {
        this.rigidBodyLabelProviders.add(rigidBody -> {
            if (rigidBody.isRootBody()) {
                return null;
            }
            return "inertia =\n" + MultiBodySystemViewer.getMatrixLabel(rigidBody.getInertia().getMomentOfInertia());
        });
        return this;
    }

    public MultiBodySystemViewer showRigidBodyCenterOfMass() {
        this.rigidBodyLabelProviders.add(rigidBody -> {
            if (rigidBody.isRootBody()) {
                return null;
            }
            FramePoint3D centerOfMass = new FramePoint3D((FrameTuple3DReadOnly)rigidBody.getInertia().getCenterOfMassOffset());
            centerOfMass.changeFrame((ReferenceFrame)rigidBody.getParentJoint().getFrameAfterJoint());
            return "center of mass = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)centerOfMass);
        });
        return this;
    }

    public MultiBodySystemViewer renderingFormat(Format format) {
        this.format = format;
        return this;
    }

    public void view(String outputFileName) {
        MutableGraph graph = Factory.mutGraph((String)"MultiBodySystemView").setDirected(true);
        MutableNode rootNode = this.createRigidBodyNode(this.rootBody, graph);
        this.addChildrenToGraph(this.rootBody, rootNode, graph);
        try {
            Graphviz.fromGraph((MutableGraph)graph).render(this.format).toFile(new File(outputFileName + "." + this.format.name().toLowerCase()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addChildrenToGraph(RigidBodyReadOnly currentBody, MutableNode currentNode, MutableGraph graph) {
        block5: for (JointReadOnly childJoint : currentBody.getChildrenJoints()) {
            RigidBodyReadOnly childBody = childJoint.getSuccessor();
            switch (this.display) {
                case RIGID_BODIES: {
                    MutableNode childBodyNode = this.createRigidBodyNode(childBody, graph);
                    graph.addLink((LinkTarget)currentNode.addLink((LinkTarget)childBodyNode));
                    this.addChildrenToGraph(childBody, childBodyNode, graph);
                    continue block5;
                }
                case JOINTS: {
                    MutableNode childJointNode = this.createJointNode(childJoint, graph);
                    graph.addLink((LinkTarget)currentNode.addLink((LinkTarget)childJointNode));
                    this.addChildrenToGraph(childBody, childJointNode, graph);
                    continue block5;
                }
                case BOTH: {
                    MutableNode childJointNode = this.createJointNode(childJoint, graph);
                    MutableNode childBodyNode = this.createRigidBodyNode(childBody, graph);
                    graph.addLink((LinkTarget)currentNode.addLink((LinkTarget)childJointNode));
                    graph.addLink((LinkTarget)childJointNode.addLink((LinkTarget)childBodyNode));
                    this.addChildrenToGraph(childBody, childBodyNode, graph);
                    continue block5;
                }
            }
            throw new RuntimeException("Unexpected value for Display: " + this.display);
        }
    }

    private MutableNode createRigidBodyNode(RigidBodyReadOnly rigidBody, MutableGraph graph) {
        Object label = this.rigidBodyLabelProviders.get(0).getLabel(rigidBody);
        for (int i = 1; i < this.rigidBodyLabelProviders.size(); ++i) {
            String additionalLabel = this.rigidBodyLabelProviders.get(i).getLabel(rigidBody);
            if (additionalLabel == null) continue;
            label = (String)label + "\n" + additionalLabel;
        }
        MutableNode rigidBodyNode = Factory.mutNode((String)label);
        rigidBodyNode.add((Attributes)Color.DARKORCHID);
        graph.add((LinkSource)rigidBodyNode);
        return rigidBodyNode;
    }

    private MutableNode createJointNode(JointReadOnly joint, MutableGraph graph) {
        Object label = this.jointLabelProviders.get(0).getLabel(joint);
        for (int i = 1; i < this.jointLabelProviders.size(); ++i) {
            String additionalLabel = this.jointLabelProviders.get(i).getLabel(joint);
            if (additionalLabel == null) continue;
            label = (String)label + "\n" + additionalLabel;
        }
        MutableNode jointNode = Factory.mutNode((String)label);
        jointNode.add((Attributes)Color.DARKGREEN);
        graph.add((LinkSource)jointNode);
        return jointNode;
    }

    private static String getJointStateAsString(JointReadOnly joint, JointStateType state) {
        if (joint instanceof SixDoFJointReadOnly) {
            return MultiBodySystemViewer.getSixDoFJointStateAsString((SixDoFJointReadOnly)joint, state);
        }
        if (joint instanceof OneDoFJointReadOnly) {
            return MultiBodySystemViewer.getOneDoFJointStateAsString((OneDoFJointReadOnly)joint, state);
        }
        if (joint instanceof PlanarJointReadOnly) {
            return MultiBodySystemViewer.getPlanarJointStateAsString((PlanarJointReadOnly)joint, state);
        }
        if (joint instanceof SphericalJointReadOnly) {
            return MultiBodySystemViewer.getSphericalJointStateAsString((SphericalJointReadOnly)joint, state);
        }
        if (joint instanceof FixedJointReadOnly) {
            return MultiBodySystemViewer.getFixedJointStateAsString((FixedJointReadOnly)joint);
        }
        throw new UnsupportedOperationException("Unsupported joint type: " + joint.getClass().getName());
    }

    private static String getSixDoFJointStateAsString(SixDoFJointReadOnly joint, JointStateType state) {
        switch (state) {
            case CONFIGURATION: {
                Pose3DReadOnly pose = joint.getJointPose();
                return "(x,y,z) = " + pose.getPosition().toString() + "\n" + ReferenceFrameTreeViewer.getOrientationLabel((Orientation3DReadOnly)pose.getOrientation());
            }
            case VELOCITY: {
                TwistReadOnly jointTwist = joint.getJointTwist();
                return "linear velocity = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)jointTwist.getLinearPart()) + "\nangular velocity = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)jointTwist.getAngularPart());
            }
            case ACCELERATION: {
                SpatialAccelerationReadOnly jointAcceleration = joint.getJointAcceleration();
                return "linear acceleration = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)jointAcceleration.getLinearPart()) + "\nangular acceleration = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)jointAcceleration.getAngularPart());
            }
            case EFFORT: {
                WrenchReadOnly jointWrench = joint.getJointWrench();
                return "force = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)jointWrench.getLinearPart()) + "\nmoment = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)jointWrench.getAngularPart());
            }
        }
        throw new UnsupportedOperationException("Unsupported value of JointStateType: " + state);
    }

    private static String getPlanarJointStateAsString(PlanarJointReadOnly joint, JointStateType state) {
        switch (state) {
            case CONFIGURATION: {
                Pose3DReadOnly pose = joint.getJointPose();
                return "(x,z) = " + ReferenceFrameTreeViewer.getLabelOf(pose.getX(), pose.getZ()) + "\n(pitch) = " + ReferenceFrameTreeViewer.getLabelOf(pose.getPitch());
            }
            case VELOCITY: {
                TwistReadOnly jointTwist = joint.getJointTwist();
                return "linear velocity = " + ReferenceFrameTreeViewer.getLabelOf(jointTwist.getLinearPartX(), jointTwist.getLinearPartZ()) + "\nangular velocity = " + ReferenceFrameTreeViewer.getLabelOf(jointTwist.getAngularPartY());
            }
            case ACCELERATION: {
                SpatialAccelerationReadOnly jointAcceleration = joint.getJointAcceleration();
                return "linear acceleration = " + ReferenceFrameTreeViewer.getLabelOf(jointAcceleration.getLinearPartX(), jointAcceleration.getLinearPartZ()) + "\nangular acceleration = " + ReferenceFrameTreeViewer.getLabelOf(jointAcceleration.getAngularPartY());
            }
            case EFFORT: {
                WrenchReadOnly jointWrench = joint.getJointWrench();
                return "force = " + ReferenceFrameTreeViewer.getLabelOf(jointWrench.getLinearPartX(), jointWrench.getLinearPartZ()) + "\nmoment = " + ReferenceFrameTreeViewer.getLabelOf(jointWrench.getAngularPartY());
            }
        }
        throw new UnsupportedOperationException("Unsupported value of JointStateType: " + state);
    }

    private static String getSphericalJointStateAsString(SphericalJointReadOnly joint, JointStateType state) {
        switch (state) {
            case CONFIGURATION: {
                return ReferenceFrameTreeViewer.getOrientationLabel((Orientation3DReadOnly)joint.getJointOrientation());
            }
            case VELOCITY: {
                return "angular velocity = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)joint.getJointAngularVelocity());
            }
            case ACCELERATION: {
                return "angular acceleration = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)joint.getJointAngularAcceleration());
            }
            case EFFORT: {
                return "moment = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)joint.getJointTorque());
            }
        }
        throw new UnsupportedOperationException("Unsupported value of JointStateType: " + state);
    }

    private static String getOneDoFJointStateAsString(OneDoFJointReadOnly joint, JointStateType state) {
        switch (state) {
            case CONFIGURATION: {
                return "q = " + ReferenceFrameTreeViewer.getLabelOf(joint.getQ());
            }
            case VELOCITY: {
                return "qd = " + ReferenceFrameTreeViewer.getLabelOf(joint.getQd());
            }
            case ACCELERATION: {
                return "qdd = " + ReferenceFrameTreeViewer.getLabelOf(joint.getQdd());
            }
            case EFFORT: {
                return "tau = " + ReferenceFrameTreeViewer.getLabelOf(joint.getTau());
            }
        }
        throw new UnsupportedOperationException("Unsupported value of JointStateType: " + state);
    }

    private static String getFixedJointStateAsString(FixedJointReadOnly joint) {
        return null;
    }

    private static String getMatrixLabel(Matrix3DReadOnly matrix) {
        Object ret = EuclidCoreIOTools.getStringOf((String)"/", (String)" \\\\\n", (String)", ", (double[])new double[]{matrix.getM00(), matrix.getM01(), matrix.getM02()});
        ret = (String)ret + EuclidCoreIOTools.getStringOf((String)"|", (String)" |\n", (String)", ", (double[])new double[]{matrix.getM10(), matrix.getM11(), matrix.getM12()});
        ret = (String)ret + EuclidCoreIOTools.getStringOf((String)"\\\\", (String)" /", (String)", ", (double[])new double[]{matrix.getM20(), matrix.getM21(), matrix.getM22()});
        return ret;
    }

    private static String getJointAxisLabel(JointReadOnly joint) {
        if (joint instanceof OneDoFJointReadOnly) {
            return "axis = " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)((OneDoFJointReadOnly)joint).getJointAxis());
        }
        return null;
    }

    public static void viewSimpleJointSubtree(RigidBodyReadOnly rootBody) {
        new MultiBodySystemViewer(rootBody).setDisplay(Display.JOINTS).view("jointSystemView");
    }

    public static void viewJointSubtree(RigidBodyReadOnly rootBody) {
        new MultiBodySystemViewer(rootBody).setDisplay(Display.JOINTS).showJointStates(JointStateType.CONFIGURATION, JointStateType.VELOCITY).view("jointSystemView");
    }

    public static void viewSimpleRigidBodySubtree(RigidBodyReadOnly rootBody) {
        new MultiBodySystemViewer(rootBody).setDisplay(Display.RIGID_BODIES).view("rigidBodySystemView");
    }

    public static void viewRigidBodySubtree(RigidBodyReadOnly rootBody) {
        new MultiBodySystemViewer(rootBody).setDisplay(Display.RIGID_BODIES).showRigidBodyMass().showRigidBodyCenterOfMass().showRigidBodyInertia().view("rigidBodySystemView");
    }

    public static void main(String[] args) {
        Random random = new Random(43535L);
        List joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)30);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)joints.get(0)).getSuccessor());
        for (JointStateType stateToRandomize : JointStateType.values()) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
        }
        new MultiBodySystemViewer((RigidBodyReadOnly)rootBody).showJointType().showOneDoFJointAxis().showRigidBodyMass().showRigidBodyCenterOfMass().showRigidBodyInertia().showJointStates(JointStateType.CONFIGURATION, JointStateType.VELOCITY, JointStateType.ACCELERATION, JointStateType.EFFORT).setDisplay(Display.BOTH).view("MultiBodySystemViewExample");
    }

    public static enum Display {
        RIGID_BODIES,
        JOINTS,
        BOTH;

    }

    public static interface JointLabelProvider {
        public String getLabel(JointReadOnly var1);
    }

    public static interface RigidBodyLabelProvider {
        public String getLabel(RigidBodyReadOnly var1);
    }
}

