/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.log;

import java.util.function.Supplier;
import us.ihmc.commons.allocations.AllocationProfiler;
import us.ihmc.log.LogTools;

public class LogToolsAllocationDemo {
    public LogToolsAllocationDemo() {
        new SubclassOne();
    }

    public static void main(String[] args) {
        String demo_there = "Demo there";
        LogTools.error((String)demo_there);
        LogTools.warn((String)demo_there);
        LogTools.info((String)demo_there);
        LogTools.debug((String)demo_there);
        LogTools.trace((String)demo_there);
        AllocationProfiler profiler = new AllocationProfiler();
        profiler.setRecordClassLoader(true);
        profiler.setRecordStaticMemberInitialization(true);
        System.out.println("Wrapped integer:\n" + profiler.recordAllocations(() -> LogTools.info((String)demo_there, (Object)new Integer(9))));
        System.out.println("Inline consts:\n" + profiler.recordAllocations(() -> LogTools.info((String)demo_there, (Object)9, (Object)true)));
        Supplier<Object> stringSupplier = () -> {
            StringBuilder builder = new StringBuilder();
            builder.append("hello");
            builder.append("there");
            return builder.toString();
        };
        System.out.println("String supplier:\n" + profiler.recordAllocations(() -> LogTools.info((String)demo_there, (Supplier)stringSupplier)));
        System.out.println("New class with subclasses:\n" + profiler.recordAllocations(() -> new LogToolsAllocationDemo()));
    }

    public class SubclassOne {
        public SubclassOne() {
            LogTools.debug((String)"Hello subsclass level 1");
            new SubSubClassOne();
        }

        class SubSubClassOne {
            public SubSubClassOne() {
                LogTools.debug((String)"Hi I'm subclass 2");
            }
        }
    }
}

