/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.bulletphysics.collision.dispatch.PairCachingGhostObject;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.dynamics.character.KinematicCharacterController;
import com.bulletphysics.linearmath.Transform;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import java.io.IOException;
import javax.vecmath.Vector3f;

public class PhysicsCharacter
extends PhysicsCollisionObject {
    protected KinematicCharacterController character;
    protected float stepHeight;
    protected com.jme3.math.Vector3f walkDirection = new com.jme3.math.Vector3f();
    protected float fallSpeed = 55.0f;
    protected float jumpSpeed = 10.0f;
    protected int upAxis = 1;
    protected PairCachingGhostObject gObject;
    protected boolean locationDirty = false;
    protected final Quaternion tmp_inverseWorldRotation = new Quaternion();
    private Transform tempTrans = new Transform(Converter.convert(new Matrix3f()));
    private com.jme3.math.Transform physicsLocation = new com.jme3.math.Transform();
    private Vector3f tempVec = new Vector3f();

    public PhysicsCharacter() {
    }

    public PhysicsCharacter(CollisionShape shape, float stepHeight) {
        this.collisionShape = shape;
        if (!(shape.getCShape() instanceof ConvexShape)) {
            throw new UnsupportedOperationException("Kinematic character nodes cannot have mesh collision shapes");
        }
        this.stepHeight = stepHeight;
        this.buildObject();
    }

    protected void buildObject() {
        if (this.gObject == null) {
            this.gObject = new PairCachingGhostObject();
        }
        this.gObject.setCollisionFlags(16);
        this.gObject.setCollisionFlags(this.gObject.getCollisionFlags() & 0xFFFFFFFB);
        this.gObject.setCollisionShape(this.collisionShape.getCShape());
        this.gObject.setUserPointer((Object)this);
        this.character = new KinematicCharacterController(this.gObject, (ConvexShape)this.collisionShape.getCShape(), this.stepHeight);
    }

    public void warp(com.jme3.math.Vector3f location) {
        this.character.warp(Converter.convert(location, this.tempVec));
    }

    public void setWalkDirection(com.jme3.math.Vector3f vec) {
        this.walkDirection.set(vec);
        this.character.setWalkDirection(Converter.convert(this.walkDirection, this.tempVec));
    }

    public com.jme3.math.Vector3f getWalkDirection() {
        return this.walkDirection;
    }

    public void setUpAxis(int axis) {
        this.upAxis = axis;
        this.character.setUpAxis(axis);
    }

    public int getUpAxis() {
        return this.upAxis;
    }

    public void setFallSpeed(float fallSpeed) {
        this.fallSpeed = fallSpeed;
        this.character.setFallSpeed(fallSpeed);
    }

    public float getFallSpeed() {
        return this.fallSpeed;
    }

    public void setJumpSpeed(float jumpSpeed) {
        this.jumpSpeed = jumpSpeed;
        this.character.setJumpSpeed(jumpSpeed);
    }

    public float getJumpSpeed() {
        return this.jumpSpeed;
    }

    public void setGravity(float value) {
        this.character.setGravity(value);
    }

    public float getGravity() {
        return this.character.getGravity();
    }

    public void setMaxSlope(float slopeRadians) {
        this.character.setMaxSlope(slopeRadians);
    }

    public float getMaxSlope() {
        return this.character.getMaxSlope();
    }

    public boolean onGround() {
        return this.character.onGround();
    }

    public void jump() {
        this.character.jump();
    }

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        if (!(collisionShape.getCShape() instanceof ConvexShape)) {
            throw new UnsupportedOperationException("Kinematic character nodes cannot have mesh collision shapes");
        }
        super.setCollisionShape(collisionShape);
        if (this.gObject == null) {
            this.buildObject();
        } else {
            this.gObject.setCollisionShape(collisionShape.getCShape());
        }
    }

    public void setPhysicsLocation(com.jme3.math.Vector3f location) {
        this.warp(location);
    }

    public com.jme3.math.Vector3f getPhysicsLocation(com.jme3.math.Vector3f trans) {
        if (trans == null) {
            trans = new com.jme3.math.Vector3f();
        }
        this.gObject.getWorldTransform(this.tempTrans);
        Converter.convert(this.tempTrans.origin, this.physicsLocation.getTranslation());
        return trans.set(this.physicsLocation.getTranslation());
    }

    public com.jme3.math.Vector3f getPhysicsLocation() {
        this.gObject.getWorldTransform(this.tempTrans);
        Converter.convert(this.tempTrans.origin, this.physicsLocation.getTranslation());
        return this.physicsLocation.getTranslation();
    }

    public void setCcdSweptSphereRadius(float radius) {
        this.gObject.setCcdSweptSphereRadius(radius);
    }

    public void setCcdMotionThreshold(float threshold) {
        this.gObject.setCcdMotionThreshold(threshold);
    }

    public float getCcdSweptSphereRadius() {
        return this.gObject.getCcdSweptSphereRadius();
    }

    public float getCcdMotionThreshold() {
        return this.gObject.getCcdMotionThreshold();
    }

    public float getCcdSquareMotionThreshold() {
        return this.gObject.getCcdSquareMotionThreshold();
    }

    public KinematicCharacterController getControllerId() {
        return this.character;
    }

    public PairCachingGhostObject getObjectId() {
        return this.gObject;
    }

    public void destroy() {
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule((Savable)this);
        capsule.write(this.stepHeight, "stepHeight", 1.0f);
        capsule.write(this.getGravity(), "gravity", 29.400002f);
        capsule.write(this.getMaxSlope(), "maxSlope", 1.0f);
        capsule.write(this.fallSpeed, "fallSpeed", 55.0f);
        capsule.write(this.jumpSpeed, "jumpSpeed", 10.0f);
        capsule.write(this.upAxis, "upAxis", 1);
        capsule.write(this.getCcdMotionThreshold(), "ccdMotionThreshold", 0.0f);
        capsule.write(this.getCcdSweptSphereRadius(), "ccdSweptSphereRadius", 0.0f);
        capsule.write((Savable)this.getPhysicsLocation(new com.jme3.math.Vector3f()), "physicsLocation", (Savable)new com.jme3.math.Vector3f());
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule capsule = e.getCapsule((Savable)this);
        this.stepHeight = capsule.readFloat("stepHeight", 1.0f);
        this.buildObject();
        this.character = new KinematicCharacterController(this.gObject, (ConvexShape)this.collisionShape.getCShape(), this.stepHeight);
        this.setGravity(capsule.readFloat("gravity", 29.400002f));
        this.setMaxSlope(capsule.readFloat("maxSlope", 1.0f));
        this.setFallSpeed(capsule.readFloat("fallSpeed", 55.0f));
        this.setJumpSpeed(capsule.readFloat("jumpSpeed", 10.0f));
        this.setUpAxis(capsule.readInt("upAxis", 1));
        this.setCcdMotionThreshold(capsule.readFloat("ccdMotionThreshold", 0.0f));
        this.setCcdSweptSphereRadius(capsule.readFloat("ccdSweptSphereRadius", 0.0f));
        this.setPhysicsLocation((com.jme3.math.Vector3f)capsule.readSavable("physicsLocation", (Savable)new com.jme3.math.Vector3f()));
    }
}

