/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.bulletphysics.dynamics.constraintsolver.SliderConstraint;
import com.bulletphysics.linearmath.Transform;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.io.IOException;

public class SliderJoint
extends PhysicsJoint {
    protected Matrix3f rotA;
    protected Matrix3f rotB;
    protected boolean useLinearReferenceFrameA;

    public SliderJoint() {
    }

    public SliderJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB, Matrix3f rotA, Matrix3f rotB, boolean useLinearReferenceFrameA) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.rotA = rotA;
        this.rotB = rotB;
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.createJoint();
    }

    public SliderJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB, boolean useLinearReferenceFrameA) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.createJoint();
    }

    public float getLowerLinLimit() {
        return ((SliderConstraint)this.constraint).getLowerLinLimit();
    }

    public void setLowerLinLimit(float lowerLinLimit) {
        ((SliderConstraint)this.constraint).setLowerLinLimit(lowerLinLimit);
    }

    public float getUpperLinLimit() {
        return ((SliderConstraint)this.constraint).getUpperLinLimit();
    }

    public void setUpperLinLimit(float upperLinLimit) {
        ((SliderConstraint)this.constraint).setUpperLinLimit(upperLinLimit);
    }

    public float getLowerAngLimit() {
        return ((SliderConstraint)this.constraint).getLowerAngLimit();
    }

    public void setLowerAngLimit(float lowerAngLimit) {
        ((SliderConstraint)this.constraint).setLowerAngLimit(lowerAngLimit);
    }

    public float getUpperAngLimit() {
        return ((SliderConstraint)this.constraint).getUpperAngLimit();
    }

    public void setUpperAngLimit(float upperAngLimit) {
        ((SliderConstraint)this.constraint).setUpperAngLimit(upperAngLimit);
    }

    public float getSoftnessDirLin() {
        return ((SliderConstraint)this.constraint).getSoftnessDirLin();
    }

    public void setSoftnessDirLin(float softnessDirLin) {
        ((SliderConstraint)this.constraint).setSoftnessDirLin(softnessDirLin);
    }

    public float getRestitutionDirLin() {
        return ((SliderConstraint)this.constraint).getRestitutionDirLin();
    }

    public void setRestitutionDirLin(float restitutionDirLin) {
        ((SliderConstraint)this.constraint).setRestitutionDirLin(restitutionDirLin);
    }

    public float getDampingDirLin() {
        return ((SliderConstraint)this.constraint).getDampingDirLin();
    }

    public void setDampingDirLin(float dampingDirLin) {
        ((SliderConstraint)this.constraint).setDampingDirLin(dampingDirLin);
    }

    public float getSoftnessDirAng() {
        return ((SliderConstraint)this.constraint).getSoftnessDirAng();
    }

    public void setSoftnessDirAng(float softnessDirAng) {
        ((SliderConstraint)this.constraint).setSoftnessDirAng(softnessDirAng);
    }

    public float getRestitutionDirAng() {
        return ((SliderConstraint)this.constraint).getRestitutionDirAng();
    }

    public void setRestitutionDirAng(float restitutionDirAng) {
        ((SliderConstraint)this.constraint).setRestitutionDirAng(restitutionDirAng);
    }

    public float getDampingDirAng() {
        return ((SliderConstraint)this.constraint).getDampingDirAng();
    }

    public void setDampingDirAng(float dampingDirAng) {
        ((SliderConstraint)this.constraint).setDampingDirAng(dampingDirAng);
    }

    public float getSoftnessLimLin() {
        return ((SliderConstraint)this.constraint).getSoftnessLimLin();
    }

    public void setSoftnessLimLin(float softnessLimLin) {
        ((SliderConstraint)this.constraint).setSoftnessLimLin(softnessLimLin);
    }

    public float getRestitutionLimLin() {
        return ((SliderConstraint)this.constraint).getRestitutionLimLin();
    }

    public void setRestitutionLimLin(float restitutionLimLin) {
        ((SliderConstraint)this.constraint).setRestitutionLimLin(restitutionLimLin);
    }

    public float getDampingLimLin() {
        return ((SliderConstraint)this.constraint).getDampingLimLin();
    }

    public void setDampingLimLin(float dampingLimLin) {
        ((SliderConstraint)this.constraint).setDampingLimLin(dampingLimLin);
    }

    public float getSoftnessLimAng() {
        return ((SliderConstraint)this.constraint).getSoftnessLimAng();
    }

    public void setSoftnessLimAng(float softnessLimAng) {
        ((SliderConstraint)this.constraint).setSoftnessLimAng(softnessLimAng);
    }

    public float getRestitutionLimAng() {
        return ((SliderConstraint)this.constraint).getRestitutionLimAng();
    }

    public void setRestitutionLimAng(float restitutionLimAng) {
        ((SliderConstraint)this.constraint).setRestitutionLimAng(restitutionLimAng);
    }

    public float getDampingLimAng() {
        return ((SliderConstraint)this.constraint).getDampingLimAng();
    }

    public void setDampingLimAng(float dampingLimAng) {
        ((SliderConstraint)this.constraint).setDampingLimAng(dampingLimAng);
    }

    public float getSoftnessOrthoLin() {
        return ((SliderConstraint)this.constraint).getSoftnessOrthoLin();
    }

    public void setSoftnessOrthoLin(float softnessOrthoLin) {
        ((SliderConstraint)this.constraint).setSoftnessOrthoLin(softnessOrthoLin);
    }

    public float getRestitutionOrthoLin() {
        return ((SliderConstraint)this.constraint).getRestitutionOrthoLin();
    }

    public void setRestitutionOrthoLin(float restitutionOrthoLin) {
        ((SliderConstraint)this.constraint).setRestitutionOrthoLin(restitutionOrthoLin);
    }

    public float getDampingOrthoLin() {
        return ((SliderConstraint)this.constraint).getDampingOrthoLin();
    }

    public void setDampingOrthoLin(float dampingOrthoLin) {
        ((SliderConstraint)this.constraint).setDampingOrthoLin(dampingOrthoLin);
    }

    public float getSoftnessOrthoAng() {
        return ((SliderConstraint)this.constraint).getSoftnessOrthoAng();
    }

    public void setSoftnessOrthoAng(float softnessOrthoAng) {
        ((SliderConstraint)this.constraint).setSoftnessOrthoAng(softnessOrthoAng);
    }

    public float getRestitutionOrthoAng() {
        return ((SliderConstraint)this.constraint).getRestitutionOrthoAng();
    }

    public void setRestitutionOrthoAng(float restitutionOrthoAng) {
        ((SliderConstraint)this.constraint).setRestitutionOrthoAng(restitutionOrthoAng);
    }

    public float getDampingOrthoAng() {
        return ((SliderConstraint)this.constraint).getDampingOrthoAng();
    }

    public void setDampingOrthoAng(float dampingOrthoAng) {
        ((SliderConstraint)this.constraint).setDampingOrthoAng(dampingOrthoAng);
    }

    public boolean isPoweredLinMotor() {
        return ((SliderConstraint)this.constraint).getPoweredLinMotor();
    }

    public void setPoweredLinMotor(boolean poweredLinMotor) {
        ((SliderConstraint)this.constraint).setPoweredLinMotor(poweredLinMotor);
    }

    public float getTargetLinMotorVelocity() {
        return ((SliderConstraint)this.constraint).getTargetLinMotorVelocity();
    }

    public void setTargetLinMotorVelocity(float targetLinMotorVelocity) {
        ((SliderConstraint)this.constraint).setTargetLinMotorVelocity(targetLinMotorVelocity);
    }

    public float getMaxLinMotorForce() {
        return ((SliderConstraint)this.constraint).getMaxLinMotorForce();
    }

    public void setMaxLinMotorForce(float maxLinMotorForce) {
        ((SliderConstraint)this.constraint).setMaxLinMotorForce(maxLinMotorForce);
    }

    public boolean isPoweredAngMotor() {
        return ((SliderConstraint)this.constraint).getPoweredAngMotor();
    }

    public void setPoweredAngMotor(boolean poweredAngMotor) {
        ((SliderConstraint)this.constraint).setPoweredAngMotor(poweredAngMotor);
    }

    public float getTargetAngMotorVelocity() {
        return ((SliderConstraint)this.constraint).getTargetAngMotorVelocity();
    }

    public void setTargetAngMotorVelocity(float targetAngMotorVelocity) {
        ((SliderConstraint)this.constraint).setTargetAngMotorVelocity(targetAngMotorVelocity);
    }

    public float getMaxAngMotorForce() {
        return ((SliderConstraint)this.constraint).getMaxAngMotorForce();
    }

    public void setMaxAngMotorForce(float maxAngMotorForce) {
        ((SliderConstraint)this.constraint).setMaxAngMotorForce(maxAngMotorForce);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(((SliderConstraint)this.constraint).getDampingDirAng(), "dampingDirAng", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getDampingDirLin(), "dampingDirLin", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getDampingLimAng(), "dampingLimAng", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getDampingLimLin(), "dampingLimLin", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getDampingOrthoAng(), "dampingOrthoAng", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getDampingOrthoLin(), "dampingOrthoLin", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getLowerAngLimit(), "lowerAngLimit", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getLowerLinLimit(), "lowerLinLimit", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getMaxAngMotorForce(), "maxAngMotorForce", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getMaxLinMotorForce(), "maxLinMotorForce", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getPoweredAngMotor(), "poweredAngMotor", false);
        capsule.write(((SliderConstraint)this.constraint).getPoweredLinMotor(), "poweredLinMotor", false);
        capsule.write(((SliderConstraint)this.constraint).getRestitutionDirAng(), "restitutionDirAng", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getRestitutionDirLin(), "restitutionDirLin", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getRestitutionLimAng(), "restitutionLimAng", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getRestitutionLimLin(), "restitutionLimLin", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getRestitutionOrthoAng(), "restitutionOrthoAng", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getRestitutionOrthoLin(), "restitutionOrthoLin", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getSoftnessDirAng(), "softnessDirAng", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getSoftnessDirLin(), "softnessDirLin", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getSoftnessLimAng(), "softnessLimAng", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getSoftnessLimLin(), "softnessLimLin", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getSoftnessOrthoAng(), "softnessOrthoAng", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getSoftnessOrthoLin(), "softnessOrthoLin", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getTargetAngMotorVelocity(), "targetAngMotorVelicoty", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getTargetLinMotorVelocity(), "targetLinMotorVelicoty", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getUpperAngLimit(), "upperAngLimit", 0.0f);
        capsule.write(((SliderConstraint)this.constraint).getUpperLinLimit(), "upperLinLimit", 0.0f);
        capsule.write(this.useLinearReferenceFrameA, "useLinearReferenceFrameA", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        float dampingDirAng = capsule.readFloat("dampingDirAng", 0.0f);
        float dampingDirLin = capsule.readFloat("dampingDirLin", 0.0f);
        float dampingLimAng = capsule.readFloat("dampingLimAng", 0.0f);
        float dampingLimLin = capsule.readFloat("dampingLimLin", 0.0f);
        float dampingOrthoAng = capsule.readFloat("dampingOrthoAng", 0.0f);
        float dampingOrthoLin = capsule.readFloat("dampingOrthoLin", 0.0f);
        float lowerAngLimit = capsule.readFloat("lowerAngLimit", 0.0f);
        float lowerLinLimit = capsule.readFloat("lowerLinLimit", 0.0f);
        float maxAngMotorForce = capsule.readFloat("maxAngMotorForce", 0.0f);
        float maxLinMotorForce = capsule.readFloat("maxLinMotorForce", 0.0f);
        boolean poweredAngMotor = capsule.readBoolean("poweredAngMotor", false);
        boolean poweredLinMotor = capsule.readBoolean("poweredLinMotor", false);
        float restitutionDirAng = capsule.readFloat("restitutionDirAng", 0.0f);
        float restitutionDirLin = capsule.readFloat("restitutionDirLin", 0.0f);
        float restitutionLimAng = capsule.readFloat("restitutionLimAng", 0.0f);
        float restitutionLimLin = capsule.readFloat("restitutionLimLin", 0.0f);
        float restitutionOrthoAng = capsule.readFloat("restitutionOrthoAng", 0.0f);
        float restitutionOrthoLin = capsule.readFloat("restitutionOrthoLin", 0.0f);
        float softnessDirAng = capsule.readFloat("softnessDirAng", 0.0f);
        float softnessDirLin = capsule.readFloat("softnessDirLin", 0.0f);
        float softnessLimAng = capsule.readFloat("softnessLimAng", 0.0f);
        float softnessLimLin = capsule.readFloat("softnessLimLin", 0.0f);
        float softnessOrthoAng = capsule.readFloat("softnessOrthoAng", 0.0f);
        float softnessOrthoLin = capsule.readFloat("softnessOrthoLin", 0.0f);
        float targetAngMotorVelicoty = capsule.readFloat("targetAngMotorVelicoty", 0.0f);
        float targetLinMotorVelicoty = capsule.readFloat("targetLinMotorVelicoty", 0.0f);
        float upperAngLimit = capsule.readFloat("upperAngLimit", 0.0f);
        float upperLinLimit = capsule.readFloat("upperLinLimit", 0.0f);
        this.useLinearReferenceFrameA = capsule.readBoolean("useLinearReferenceFrameA", false);
        this.createJoint();
        ((SliderConstraint)this.constraint).setDampingDirAng(dampingDirAng);
        ((SliderConstraint)this.constraint).setDampingDirLin(dampingDirLin);
        ((SliderConstraint)this.constraint).setDampingLimAng(dampingLimAng);
        ((SliderConstraint)this.constraint).setDampingLimLin(dampingLimLin);
        ((SliderConstraint)this.constraint).setDampingOrthoAng(dampingOrthoAng);
        ((SliderConstraint)this.constraint).setDampingOrthoLin(dampingOrthoLin);
        ((SliderConstraint)this.constraint).setLowerAngLimit(lowerAngLimit);
        ((SliderConstraint)this.constraint).setLowerLinLimit(lowerLinLimit);
        ((SliderConstraint)this.constraint).setMaxAngMotorForce(maxAngMotorForce);
        ((SliderConstraint)this.constraint).setMaxLinMotorForce(maxLinMotorForce);
        ((SliderConstraint)this.constraint).setPoweredAngMotor(poweredAngMotor);
        ((SliderConstraint)this.constraint).setPoweredLinMotor(poweredLinMotor);
        ((SliderConstraint)this.constraint).setRestitutionDirAng(restitutionDirAng);
        ((SliderConstraint)this.constraint).setRestitutionDirLin(restitutionDirLin);
        ((SliderConstraint)this.constraint).setRestitutionLimAng(restitutionLimAng);
        ((SliderConstraint)this.constraint).setRestitutionLimLin(restitutionLimLin);
        ((SliderConstraint)this.constraint).setRestitutionOrthoAng(restitutionOrthoAng);
        ((SliderConstraint)this.constraint).setRestitutionOrthoLin(restitutionOrthoLin);
        ((SliderConstraint)this.constraint).setSoftnessDirAng(softnessDirAng);
        ((SliderConstraint)this.constraint).setSoftnessDirLin(softnessDirLin);
        ((SliderConstraint)this.constraint).setSoftnessLimAng(softnessLimAng);
        ((SliderConstraint)this.constraint).setSoftnessLimLin(softnessLimLin);
        ((SliderConstraint)this.constraint).setSoftnessOrthoAng(softnessOrthoAng);
        ((SliderConstraint)this.constraint).setSoftnessOrthoLin(softnessOrthoLin);
        ((SliderConstraint)this.constraint).setTargetAngMotorVelocity(targetAngMotorVelicoty);
        ((SliderConstraint)this.constraint).setTargetLinMotorVelocity(targetLinMotorVelicoty);
        ((SliderConstraint)this.constraint).setUpperAngLimit(upperAngLimit);
        ((SliderConstraint)this.constraint).setUpperLinLimit(upperLinLimit);
    }

    protected void createJoint() {
        Transform transA = new Transform(Converter.convert(this.rotA));
        Converter.convert(this.pivotA, transA.origin);
        Converter.convert(this.rotA, transA.basis);
        Transform transB = new Transform(Converter.convert(this.rotB));
        Converter.convert(this.pivotB, transB.origin);
        Converter.convert(this.rotB, transB.basis);
        this.constraint = new SliderConstraint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), transA, transB, this.useLinearReferenceFrameA);
    }
}

