/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.bulletphysics.dynamics.constraintsolver.HingeConstraint;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;

public class HingeJoint
extends PhysicsJoint {
    protected Vector3f axisA;
    protected Vector3f axisB;
    protected boolean angularOnly = false;
    protected float biasFactor = 0.3f;
    protected float relaxationFactor = 1.0f;
    protected float limitSoftness = 0.9f;

    public HingeJoint() {
    }

    public HingeJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB, Vector3f axisA, Vector3f axisB) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.axisA = axisA;
        this.axisB = axisB;
        this.createJoint();
    }

    public void enableMotor(boolean enable, float targetVelocity, float maxMotorImpulse) {
        ((HingeConstraint)this.constraint).enableAngularMotor(enable, targetVelocity, maxMotorImpulse);
    }

    public void setLimit(float low, float high) {
        ((HingeConstraint)this.constraint).setLimit(low, high);
    }

    public void setLimit(float low, float high, float _softness, float _biasFactor, float _relaxationFactor) {
        this.biasFactor = _biasFactor;
        this.relaxationFactor = _relaxationFactor;
        this.limitSoftness = _softness;
        ((HingeConstraint)this.constraint).setLimit(low, high, _softness, _biasFactor, _relaxationFactor);
    }

    public float getUpperLimit() {
        return ((HingeConstraint)this.constraint).getUpperLimit();
    }

    public float getLowerLimit() {
        return ((HingeConstraint)this.constraint).getLowerLimit();
    }

    public void setAngularOnly(boolean angularOnly) {
        this.angularOnly = angularOnly;
        ((HingeConstraint)this.constraint).setAngularOnly(angularOnly);
    }

    public float getHingeAngle() {
        return ((HingeConstraint)this.constraint).getHingeAngle();
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.axisA, "axisA", (Savable)new Vector3f());
        capsule.write((Savable)this.axisB, "axisB", (Savable)new Vector3f());
        capsule.write(this.angularOnly, "angularOnly", false);
        capsule.write(((HingeConstraint)this.constraint).getLowerLimit(), "lowerLimit", 1.0E30f);
        capsule.write(((HingeConstraint)this.constraint).getUpperLimit(), "upperLimit", -1.0E30f);
        capsule.write(this.biasFactor, "biasFactor", 0.3f);
        capsule.write(this.relaxationFactor, "relaxationFactor", 1.0f);
        capsule.write(this.limitSoftness, "limitSoftness", 0.9f);
        capsule.write(((HingeConstraint)this.constraint).getEnableAngularMotor(), "enableAngularMotor", false);
        capsule.write(((HingeConstraint)this.constraint).getMotorTargetVelosity(), "targetVelocity", 0.0f);
        capsule.write(((HingeConstraint)this.constraint).getMaxMotorImpulse(), "maxMotorImpulse", 0.0f);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.axisA = (Vector3f)capsule.readSavable("axisA", (Savable)new Vector3f());
        this.axisB = (Vector3f)capsule.readSavable("axisB", (Savable)new Vector3f());
        this.angularOnly = capsule.readBoolean("angularOnly", false);
        float lowerLimit = capsule.readFloat("lowerLimit", 1.0E30f);
        float upperLimit = capsule.readFloat("upperLimit", -1.0E30f);
        this.biasFactor = capsule.readFloat("biasFactor", 0.3f);
        this.relaxationFactor = capsule.readFloat("relaxationFactor", 1.0f);
        this.limitSoftness = capsule.readFloat("limitSoftness", 0.9f);
        boolean enableAngularMotor = capsule.readBoolean("enableAngularMotor", false);
        float targetVelocity = capsule.readFloat("targetVelocity", 0.0f);
        float maxMotorImpulse = capsule.readFloat("maxMotorImpulse", 0.0f);
        this.createJoint();
        this.enableMotor(enableAngularMotor, targetVelocity, maxMotorImpulse);
        ((HingeConstraint)this.constraint).setLimit(lowerLimit, upperLimit, this.limitSoftness, this.biasFactor, this.relaxationFactor);
    }

    protected void createJoint() {
        this.constraint = new HingeConstraint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), Converter.convert(this.pivotA), Converter.convert(this.pivotB), Converter.convert(this.axisA), Converter.convert(this.axisB));
    }
}

