/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.collision.PhysicsRayTestResult;
import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.control.AbstractPhysicsControl;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.TempVars;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BetterCharacterControl
extends AbstractPhysicsControl
implements PhysicsTickListener,
JmeCloneable {
    protected static final Logger logger = Logger.getLogger(BetterCharacterControl.class.getName());
    protected PhysicsRigidBody rigidBody;
    protected float radius;
    protected float height;
    protected float mass;
    protected float duckedFactor = 0.6f;
    protected final Vector3f localUp = new Vector3f(0.0f, 1.0f, 0.0f);
    protected final Vector3f localForward = new Vector3f(0.0f, 0.0f, 1.0f);
    protected final Vector3f localLeft = new Vector3f(1.0f, 0.0f, 0.0f);
    protected final Quaternion localForwardRotation = new Quaternion(Quaternion.DIRECTION_Z);
    protected final Vector3f viewDirection = new Vector3f(0.0f, 0.0f, 1.0f);
    protected final Vector3f location = new Vector3f();
    protected final Quaternion rotation = new Quaternion(Quaternion.DIRECTION_Z);
    protected final Vector3f rotatedViewDirection = new Vector3f(0.0f, 0.0f, 1.0f);
    protected final Vector3f walkDirection = new Vector3f();
    protected final Vector3f jumpForce;
    protected float physicsDamping = 0.9f;
    protected final Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    protected final Vector3f velocity = new Vector3f();
    protected boolean jump = false;
    protected boolean onGround = false;
    protected boolean ducked = false;
    protected boolean wantToUnDuck = false;

    public BetterCharacterControl() {
        this.jumpForce = new Vector3f();
    }

    public BetterCharacterControl(float radius, float height, float mass) {
        this.radius = radius;
        this.height = height;
        this.mass = mass;
        this.rigidBody = new PhysicsRigidBody(this.getShape(), mass);
        this.jumpForce = new Vector3f(0.0f, mass * 5.0f, 0.0f);
        this.rigidBody.setAngularFactor(0.0f);
    }

    @Override
    public void update(float tpf) {
        super.update(tpf);
        this.rigidBody.getPhysicsLocation(this.location);
        this.applyPhysicsTransform(this.location, this.rotation);
    }

    @Override
    public void render(RenderManager rm, ViewPort vp) {
        super.render(rm, vp);
    }

    @Override
    public void prePhysicsTick(PhysicsSpace space, float tpf) {
        this.checkOnGround();
        if (this.wantToUnDuck && this.checkCanUnDuck()) {
            this.setHeightPercent(1.0f);
            this.wantToUnDuck = false;
            this.ducked = false;
        }
        TempVars vars = TempVars.get();
        Vector3f currentVelocity = vars.vect2.set(this.velocity);
        float existingLeftVelocity = this.velocity.dot(this.localLeft);
        float existingForwardVelocity = this.velocity.dot(this.localForward);
        Vector3f counter = vars.vect1;
        counter.set(-(existingLeftVelocity *= this.physicsDamping), 0.0f, -(existingForwardVelocity *= this.physicsDamping));
        this.localForwardRotation.multLocal(counter);
        this.velocity.addLocal(counter);
        float designatedVelocity = this.walkDirection.length();
        if (designatedVelocity > 0.0f) {
            Vector3f localWalkDirection = vars.vect1;
            localWalkDirection.set(this.walkDirection).normalizeLocal();
            float existingVelocity = this.velocity.dot(localWalkDirection);
            float finalVelocity = designatedVelocity - existingVelocity;
            localWalkDirection.multLocal(finalVelocity);
            this.velocity.addLocal(localWalkDirection);
        }
        if (currentVelocity.distance(this.velocity) > 1.0E-4f) {
            this.rigidBody.setLinearVelocity(this.velocity);
        }
        if (this.jump) {
            Vector3f rotatedJumpForce = vars.vect1;
            rotatedJumpForce.set(this.jumpForce);
            this.rigidBody.applyImpulse(this.localForwardRotation.multLocal(rotatedJumpForce), Vector3f.ZERO);
            this.jump = false;
        }
        vars.release();
    }

    @Override
    public void physicsTick(PhysicsSpace space, float tpf) {
        this.rigidBody.getLinearVelocity(this.velocity);
    }

    public void warp(Vector3f vec) {
        this.setPhysicsLocation(vec);
    }

    public void jump() {
        if (!this.onGround) {
            return;
        }
        this.jump = true;
    }

    public void setJumpForce(Vector3f jumpForce) {
        this.jumpForce.set(jumpForce);
    }

    public Vector3f getJumpForce() {
        return this.jumpForce;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void setDucked(boolean enabled) {
        if (enabled) {
            this.setHeightPercent(this.duckedFactor);
            this.ducked = true;
            this.wantToUnDuck = false;
        } else if (this.checkCanUnDuck()) {
            this.setHeightPercent(1.0f);
            this.ducked = false;
        } else {
            this.wantToUnDuck = true;
        }
    }

    public boolean isDucked() {
        return this.ducked;
    }

    public void setDuckedFactor(float factor) {
        this.duckedFactor = factor;
    }

    public float getDuckedFactor() {
        return this.duckedFactor;
    }

    public void setWalkDirection(Vector3f vec) {
        this.walkDirection.set(vec);
    }

    public Vector3f getWalkDirection() {
        return this.walkDirection;
    }

    public void setViewDirection(Vector3f vec) {
        this.viewDirection.set(vec);
        this.updateLocalViewDirection();
    }

    public Vector3f getViewDirection() {
        return this.viewDirection;
    }

    public void resetForward(Vector3f vec) {
        if (vec == null) {
            vec = Vector3f.UNIT_Z;
        }
        this.localForward.set(vec);
        this.updateLocalCoordinateSystem();
    }

    public Vector3f getVelocity() {
        return this.velocity;
    }

    public void setGravity(Vector3f gravity) {
        this.rigidBody.setGravity(gravity);
        this.localUp.set(gravity).normalizeLocal().negateLocal();
        this.updateLocalCoordinateSystem();
    }

    public Vector3f getGravity() {
        return this.rigidBody.getGravity();
    }

    public Vector3f getGravity(Vector3f store) {
        return this.rigidBody.getGravity(store);
    }

    public void setPhysicsDamping(float physicsDamping) {
        this.physicsDamping = physicsDamping;
    }

    public float getPhysicsDamping() {
        return this.physicsDamping;
    }

    protected void setHeightPercent(float percent) {
        this.scale.setY(percent);
        this.rigidBody.setCollisionShape(this.getShape());
    }

    protected void checkOnGround() {
        TempVars vars = TempVars.get();
        Vector3f location = vars.vect1;
        Vector3f rayVector = vars.vect2;
        float height = this.getFinalHeight();
        location.set(this.localUp).multLocal(height).addLocal(this.location);
        rayVector.set(this.localUp).multLocal(-height - 0.1f).addLocal(location);
        List<PhysicsRayTestResult> results = this.space.rayTest(location, rayVector);
        vars.release();
        for (PhysicsRayTestResult physicsRayTestResult : results) {
            if (physicsRayTestResult.getCollisionObject().equals(this.rigidBody)) continue;
            this.onGround = true;
            return;
        }
        this.onGround = false;
    }

    protected boolean checkCanUnDuck() {
        TempVars vars = TempVars.get();
        Vector3f location = vars.vect1;
        Vector3f rayVector = vars.vect2;
        location.set(this.localUp).multLocal(1.0E-4f).addLocal(this.location);
        rayVector.set(this.localUp).multLocal(this.height + 1.0E-4f).addLocal(location);
        List<PhysicsRayTestResult> results = this.space.rayTest(location, rayVector);
        vars.release();
        for (PhysicsRayTestResult physicsRayTestResult : results) {
            if (physicsRayTestResult.getCollisionObject().equals(this.rigidBody)) continue;
            return false;
        }
        return true;
    }

    protected CollisionShape getShape() {
        CapsuleCollisionShape capsuleCollisionShape = new CapsuleCollisionShape(this.getFinalRadius(), this.getFinalHeight() - 2.0f * this.getFinalRadius());
        CompoundCollisionShape compoundCollisionShape = new CompoundCollisionShape();
        Vector3f addLocation = new Vector3f(0.0f, this.getFinalHeight() / 2.0f, 0.0f);
        compoundCollisionShape.addChildShape(capsuleCollisionShape, addLocation);
        return compoundCollisionShape;
    }

    protected float getFinalHeight() {
        return this.height * this.scale.getY();
    }

    protected float getFinalRadius() {
        return this.radius * this.scale.getZ();
    }

    protected void updateLocalCoordinateSystem() {
        this.calculateNewForward(this.localForwardRotation, this.localForward, this.localUp);
        this.localLeft.set(this.localUp).crossLocal(this.localForward);
        this.rigidBody.setPhysicsRotation(this.localForwardRotation);
        this.updateLocalViewDirection();
    }

    protected void updateLocalViewDirection() {
        this.localForwardRotation.multLocal(this.rotatedViewDirection.set(this.viewDirection));
        this.calculateNewForward(this.rotation, this.rotatedViewDirection, this.localUp);
    }

    protected final void calculateNewForward(Quaternion rotation, Vector3f direction, Vector3f worldUpVector) {
        if (direction == null) {
            return;
        }
        TempVars vars = TempVars.get();
        Vector3f newLeft = vars.vect1;
        Vector3f newLeftNegate = vars.vect2;
        newLeft.set(worldUpVector).crossLocal(direction).normalizeLocal();
        if (newLeft.equals((Object)Vector3f.ZERO)) {
            if (direction.x != 0.0f) {
                newLeft.set(direction.y, -direction.x, 0.0f).normalizeLocal();
            } else {
                newLeft.set(0.0f, direction.z, -direction.y).normalizeLocal();
            }
            logger.log(Level.INFO, "Zero left for direction {0}, up {1}", new Object[]{direction, worldUpVector});
        }
        newLeftNegate.set(newLeft).negateLocal();
        direction.set(worldUpVector).crossLocal(newLeftNegate).normalizeLocal();
        if (direction.equals((Object)Vector3f.ZERO)) {
            direction.set(Vector3f.UNIT_Z);
            logger.log(Level.INFO, "Zero left for left {0}, up {1}", new Object[]{newLeft, worldUpVector});
        }
        if (rotation != null) {
            rotation.fromAxes(newLeft, worldUpVector, direction);
        }
        vars.release();
    }

    @Override
    protected void setPhysicsLocation(Vector3f vec) {
        this.rigidBody.setPhysicsLocation(vec);
        this.location.set(vec);
    }

    @Override
    protected void setPhysicsRotation(Quaternion quat) {
        this.rotation.set(quat);
        this.rotation.multLocal(this.rotatedViewDirection.set(this.viewDirection));
        this.updateLocalViewDirection();
    }

    @Override
    protected void addPhysics(PhysicsSpace space) {
        space.getGravity(this.localUp).normalizeLocal().negateLocal();
        this.updateLocalCoordinateSystem();
        space.addCollisionObject(this.rigidBody);
        space.addTickListener(this);
    }

    @Override
    protected void removePhysics(PhysicsSpace space) {
        space.removeCollisionObject(this.rigidBody);
        space.removeTickListener(this);
    }

    @Override
    protected void createSpatialData(Spatial spat) {
        this.rigidBody.setUserObject(this.spatial);
    }

    @Override
    protected void removeSpatialData(Spatial spat) {
        this.rigidBody.setUserObject(null);
    }

    public Control cloneForSpatial(Spatial spatial) {
        BetterCharacterControl control = new BetterCharacterControl(this.radius, this.height, this.mass);
        control.setJumpForce(this.jumpForce);
        return control;
    }

    public Object jmeClone() {
        BetterCharacterControl control = new BetterCharacterControl(this.radius, this.height, this.mass);
        control.setJumpForce(this.jumpForce);
        control.spatial = this.spatial;
        return control;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.radius, "radius", 1.0f);
        oc.write(this.height, "height", 1.0f);
        oc.write(this.mass, "mass", 1.0f);
        oc.write((Savable)this.jumpForce, "jumpForce", (Savable)new Vector3f(0.0f, this.mass * 5.0f, 0.0f));
        oc.write(this.physicsDamping, "physicsDamping", 0.9f);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule in = im.getCapsule((Savable)this);
        this.radius = in.readFloat("radius", 1.0f);
        this.height = in.readFloat("height", 2.0f);
        this.mass = in.readFloat("mass", 80.0f);
        this.physicsDamping = in.readFloat("physicsDamping", 0.9f);
        this.jumpForce.set((Vector3f)in.readSavable("jumpForce", (Savable)new Vector3f(0.0f, this.mass * 5.0f, 0.0f)));
        this.rigidBody = new PhysicsRigidBody(this.getShape(), this.mass);
        this.jumpForce.set(new Vector3f(0.0f, this.mass * 5.0f, 0.0f));
        this.rigidBody.setAngularFactor(0.0f);
    }
}

