/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.bulletphysics.collision.shapes.StaticPlaneShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Plane;
import java.io.IOException;

public class PlaneCollisionShape
extends CollisionShape {
    private Plane plane;

    public PlaneCollisionShape() {
    }

    public PlaneCollisionShape(Plane plane) {
        this.plane = plane;
        this.createShape();
    }

    public final Plane getPlane() {
        return this.plane;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.plane, "collisionPlane", (Savable)new Plane());
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.plane = (Plane)capsule.readSavable("collisionPlane", (Savable)new Plane());
        this.createShape();
    }

    protected void createShape() {
        this.cShape = new StaticPlaneShape(Converter.convert(this.plane.getNormal()), this.plane.getConstant());
        this.cShape.setLocalScaling(Converter.convert(this.getScale()));
        this.cShape.setMargin(this.margin);
    }
}

