/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.bulletphysics.collision.shapes.ConvexHullShape;
import com.bulletphysics.util.ObjectArrayList;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.io.IOException;
import java.nio.FloatBuffer;
import javax.vecmath.Vector3f;

public class HullCollisionShape
extends CollisionShape {
    private float[] points;

    public HullCollisionShape() {
    }

    public HullCollisionShape(Mesh mesh) {
        this.points = this.getPoints(mesh);
        this.createShape(this.points);
    }

    public HullCollisionShape(float[] points) {
        this.points = points;
        this.createShape(this.points);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.points, "points", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        Mesh mesh = (Mesh)capsule.readSavable("hullMesh", null);
        this.points = mesh != null ? this.getPoints(mesh) : capsule.readFloatArray("points", null);
        this.createShape(this.points);
    }

    protected void createShape(float[] points) {
        ObjectArrayList pointList = new ObjectArrayList();
        for (int i = 0; i < points.length; i += 3) {
            pointList.add((Object)new Vector3f(points[i], points[i + 1], points[i + 2]));
        }
        this.cShape = new ConvexHullShape(pointList);
        this.cShape.setLocalScaling(Converter.convert(this.getScale()));
        this.cShape.setMargin(this.margin);
    }

    protected float[] getPoints(Mesh mesh) {
        FloatBuffer vertices = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        vertices.rewind();
        int components = mesh.getVertexCount() * 3;
        float[] pointsArray = new float[components];
        for (int i = 0; i < components; i += 3) {
            pointsArray[i] = vertices.get();
            pointsArray[i + 1] = vertices.get();
            pointsArray[i + 2] = vertices.get();
        }
        return pointsArray;
    }
}

