/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;
import javax.vecmath.Vector3f;

public abstract class CollisionShape
implements Savable {
    protected com.bulletphysics.collision.shapes.CollisionShape cShape;
    protected com.jme3.math.Vector3f scale = new com.jme3.math.Vector3f(1.0f, 1.0f, 1.0f);
    protected float margin = 0.0f;

    public void calculateLocalInertia(float mass, Vector3f vector) {
        if (this.cShape == null) {
            return;
        }
        if (this instanceof MeshCollisionShape) {
            vector.set(0.0f, 0.0f, 0.0f);
        } else {
            this.cShape.calculateLocalInertia(mass, vector);
        }
    }

    public com.bulletphysics.collision.shapes.CollisionShape getCShape() {
        return this.cShape;
    }

    public void setCShape(com.bulletphysics.collision.shapes.CollisionShape cShape) {
        this.cShape = cShape;
    }

    public void setScale(com.jme3.math.Vector3f scale) {
        this.scale.set(scale);
        this.cShape.setLocalScaling(Converter.convert(scale));
    }

    public float getMargin() {
        return this.cShape.getMargin();
    }

    public void setMargin(float margin) {
        this.cShape.setMargin(margin);
        this.margin = margin;
    }

    public com.jme3.math.Vector3f getScale() {
        return this.scale;
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.scale, "scale", (Savable)new com.jme3.math.Vector3f(1.0f, 1.0f, 1.0f));
        capsule.write(this.getMargin(), "margin", 0.0f);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.scale = (com.jme3.math.Vector3f)capsule.readSavable("scale", (Savable)new com.jme3.math.Vector3f(1.0f, 1.0f, 1.0f));
        this.margin = capsule.readFloat("margin", 0.0f);
    }
}

