/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.bulletphysics.collision.shapes.CapsuleShape;
import com.bulletphysics.collision.shapes.CapsuleShapeX;
import com.bulletphysics.collision.shapes.CapsuleShapeZ;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;

public class CapsuleCollisionShape
extends CollisionShape {
    protected float radius;
    protected float height;
    protected int axis;

    public CapsuleCollisionShape() {
    }

    public CapsuleCollisionShape(float radius, float height) {
        this.radius = radius;
        this.height = height;
        this.axis = 1;
        CapsuleShape capShape = new CapsuleShape(radius, height);
        this.cShape = capShape;
    }

    public CapsuleCollisionShape(float radius, float height, int axis) {
        this.radius = radius;
        this.height = height;
        this.axis = axis;
        this.createShape();
    }

    public float getRadius() {
        return this.radius;
    }

    public float getHeight() {
        return this.height;
    }

    public int getAxis() {
        return this.axis;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.radius, "radius", 0.5f);
        capsule.write(this.height, "height", 1.0f);
        capsule.write(this.axis, "axis", 1);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.radius = capsule.readFloat("radius", 0.5f);
        this.height = capsule.readFloat("height", 0.5f);
        this.axis = capsule.readInt("axis", 1);
        this.createShape();
    }

    protected void createShape() {
        switch (this.axis) {
            case 0: {
                this.cShape = new CapsuleShapeX(this.radius, this.height);
                break;
            }
            case 1: {
                this.cShape = new CapsuleShape(this.radius, this.height);
                break;
            }
            case 2: {
                this.cShape = new CapsuleShapeZ(this.radius, this.height);
            }
        }
        this.cShape.setLocalScaling(Converter.convert(this.getScale()));
        this.cShape.setMargin(this.margin);
    }
}

