/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.bulletphysics.collision.shapes.BoxShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;

public class BoxCollisionShape
extends CollisionShape {
    private Vector3f halfExtents;

    public BoxCollisionShape() {
    }

    public BoxCollisionShape(Vector3f halfExtents) {
        this.halfExtents = halfExtents;
        this.createShape();
    }

    public final Vector3f getHalfExtents() {
        return this.halfExtents;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.halfExtents, "halfExtents", (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        Vector3f halfExtents;
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.halfExtents = halfExtents = (Vector3f)capsule.readSavable("halfExtents", (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
        this.createShape();
    }

    protected void createShape() {
        this.cShape = new BoxShape(Converter.convert(this.halfExtents));
        this.cShape.setLocalScaling(Converter.convert(this.getScale()));
        this.cShape.setMargin(this.margin);
    }
}

