/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;

public abstract class PhysicsCollisionObject
implements Savable {
    protected CollisionShape collisionShape;
    public static final int COLLISION_GROUP_NONE = 0;
    public static final int COLLISION_GROUP_01 = 1;
    public static final int COLLISION_GROUP_02 = 2;
    public static final int COLLISION_GROUP_03 = 4;
    public static final int COLLISION_GROUP_04 = 8;
    public static final int COLLISION_GROUP_05 = 16;
    public static final int COLLISION_GROUP_06 = 32;
    public static final int COLLISION_GROUP_07 = 64;
    public static final int COLLISION_GROUP_08 = 128;
    public static final int COLLISION_GROUP_09 = 256;
    public static final int COLLISION_GROUP_10 = 512;
    public static final int COLLISION_GROUP_11 = 1024;
    public static final int COLLISION_GROUP_12 = 2048;
    public static final int COLLISION_GROUP_13 = 4096;
    public static final int COLLISION_GROUP_14 = 8192;
    public static final int COLLISION_GROUP_15 = 16384;
    public static final int COLLISION_GROUP_16 = 32768;
    protected int collisionGroup = 1;
    protected int collisionGroupsMask = 1;
    private Object userObject;

    public void setCollisionShape(CollisionShape collisionShape) {
        this.collisionShape = collisionShape;
    }

    public CollisionShape getCollisionShape() {
        return this.collisionShape;
    }

    public int getCollisionGroup() {
        return this.collisionGroup;
    }

    public void setCollisionGroup(int collisionGroup) {
        this.collisionGroup = collisionGroup;
    }

    public void addCollideWithGroup(int collisionGroup) {
        this.collisionGroupsMask |= collisionGroup;
    }

    public void removeCollideWithGroup(int collisionGroup) {
        this.collisionGroupsMask &= ~collisionGroup;
    }

    public void setCollideWithGroups(int collisionGroups) {
        this.collisionGroupsMask = collisionGroups;
    }

    public int getCollideWithGroups() {
        return this.collisionGroupsMask;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule((Savable)this);
        capsule.write(this.collisionGroup, "collisionGroup", 1);
        capsule.write(this.collisionGroupsMask, "collisionGroupsMask", 1);
        capsule.write((Savable)this.collisionShape, "collisionShape", null);
    }

    public void read(JmeImporter e) throws IOException {
        CollisionShape shape;
        InputCapsule capsule = e.getCapsule((Savable)this);
        this.collisionGroup = capsule.readInt("collisionGroup", 1);
        this.collisionGroupsMask = capsule.readInt("collisionGroupsMask", 1);
        this.collisionShape = shape = (CollisionShape)capsule.readSavable("collisionShape", null);
    }
}

