/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BulletAppState
implements AppState,
PhysicsTickListener {
    protected boolean initialized = false;
    protected Application app;
    protected AppStateManager stateManager;
    protected ScheduledThreadPoolExecutor executor;
    protected PhysicsSpace pSpace;
    protected ThreadingType threadingType = ThreadingType.SEQUENTIAL;
    protected PhysicsSpace.BroadphaseType broadphaseType = PhysicsSpace.BroadphaseType.DBVT;
    protected Vector3f worldMin = new Vector3f(-10000.0f, -10000.0f, -10000.0f);
    protected Vector3f worldMax = new Vector3f(10000.0f, 10000.0f, 10000.0f);
    protected float speed = 1.0f;
    protected boolean active = true;
    protected boolean debugEnabled = false;
    protected BulletDebugAppState debugAppState;
    protected float tpf;
    protected Future physicsFuture;
    private Callable<Boolean> parallelPhysicsUpdate = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            BulletAppState.this.pSpace.update(BulletAppState.this.tpf * BulletAppState.this.getSpeed());
            return true;
        }
    };
    long detachedPhysicsLastUpdate = 0L;
    private Callable<Boolean> detachedPhysicsUpdate = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            BulletAppState.this.pSpace.update(BulletAppState.this.getPhysicsSpace().getAccuracy() * BulletAppState.this.getSpeed());
            BulletAppState.this.pSpace.distributeEvents();
            long update = System.currentTimeMillis() - BulletAppState.this.detachedPhysicsLastUpdate;
            BulletAppState.this.detachedPhysicsLastUpdate = System.currentTimeMillis();
            BulletAppState.this.executor.schedule(BulletAppState.this.detachedPhysicsUpdate, (long)Math.round(BulletAppState.this.getPhysicsSpace().getAccuracy() * 1000000.0f) - update * 1000L, TimeUnit.MICROSECONDS);
            return true;
        }
    };

    public BulletAppState() {
    }

    public BulletAppState(PhysicsSpace.BroadphaseType broadphaseType) {
        this(new Vector3f(-10000.0f, -10000.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f), broadphaseType);
    }

    public BulletAppState(Vector3f worldMin, Vector3f worldMax) {
        this(worldMin, worldMax, PhysicsSpace.BroadphaseType.AXIS_SWEEP_3);
    }

    public BulletAppState(Vector3f worldMin, Vector3f worldMax, PhysicsSpace.BroadphaseType broadphaseType) {
        this.worldMin.set(worldMin);
        this.worldMax.set(worldMax);
        this.broadphaseType = broadphaseType;
    }

    private boolean startPhysicsOnExecutor() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = new ScheduledThreadPoolExecutor(1);
        final BulletAppState app = this;
        Callable<Boolean> call = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                BulletAppState.this.detachedPhysicsLastUpdate = System.currentTimeMillis();
                BulletAppState.this.pSpace = new PhysicsSpace(BulletAppState.this.worldMin, BulletAppState.this.worldMax, BulletAppState.this.broadphaseType);
                BulletAppState.this.pSpace.addTickListener(app);
                return true;
            }
        };
        try {
            return this.executor.submit(call).get();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(BulletAppState.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (ExecutionException ex) {
            Logger.getLogger(BulletAppState.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public PhysicsSpace getPhysicsSpace() {
        return this.pSpace;
    }

    public void startPhysics() {
        if (this.initialized) {
            return;
        }
        if (this.threadingType == ThreadingType.PARALLEL) {
            this.startPhysicsOnExecutor();
        } else {
            this.pSpace = new PhysicsSpace(this.worldMin, this.worldMax, this.broadphaseType);
        }
        this.pSpace.addTickListener(this);
        this.initialized = true;
    }

    public void stopPhysics() {
        if (!this.initialized) {
            return;
        }
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        this.pSpace.removeTickListener(this);
        this.pSpace.destroy();
        this.initialized = false;
    }

    public void initialize(AppStateManager stateManager, Application app) {
        this.app = app;
        this.stateManager = stateManager;
        this.startPhysics();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setEnabled(boolean enabled) {
        this.active = enabled;
    }

    public boolean isEnabled() {
        return this.active;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void stateAttached(AppStateManager stateManager) {
        if (!this.initialized) {
            this.startPhysics();
        }
        if (this.threadingType == ThreadingType.PARALLEL) {
            PhysicsSpace.setLocalThreadPhysicsSpace(this.pSpace);
        }
        if (this.debugEnabled) {
            this.debugAppState = new BulletDebugAppState(this.pSpace);
            stateManager.attach((AppState)this.debugAppState);
        }
    }

    public void stateDetached(AppStateManager stateManager) {
    }

    public void update(float tpf) {
        if (this.debugEnabled && this.debugAppState == null && this.pSpace != null) {
            this.debugAppState = new BulletDebugAppState(this.pSpace);
            this.stateManager.attach((AppState)this.debugAppState);
        } else if (!this.debugEnabled && this.debugAppState != null) {
            this.stateManager.detach((AppState)this.debugAppState);
            this.debugAppState = null;
        }
        if (!this.active) {
            return;
        }
        this.pSpace.distributeEvents();
        this.tpf = tpf;
    }

    public void render(RenderManager rm) {
        if (!this.active) {
            return;
        }
        if (this.threadingType == ThreadingType.PARALLEL) {
            this.physicsFuture = this.executor.submit(this.parallelPhysicsUpdate);
        } else if (this.threadingType == ThreadingType.SEQUENTIAL) {
            this.pSpace.update(this.active ? this.tpf * this.speed : 0.0f);
        }
    }

    public void postRender() {
        if (this.physicsFuture != null) {
            try {
                this.physicsFuture.get();
                this.physicsFuture = null;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(BulletAppState.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(BulletAppState.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void cleanup() {
        if (this.debugAppState != null) {
            this.stateManager.detach((AppState)this.debugAppState);
            this.debugAppState = null;
        }
        this.stopPhysics();
    }

    public ThreadingType getThreadingType() {
        return this.threadingType;
    }

    public void setThreadingType(ThreadingType threadingType) {
        this.threadingType = threadingType;
    }

    public void setBroadphaseType(PhysicsSpace.BroadphaseType broadphaseType) {
        this.broadphaseType = broadphaseType;
    }

    public void setWorldMin(Vector3f worldMin) {
        this.worldMin = worldMin;
    }

    public void setWorldMax(Vector3f worldMax) {
        this.worldMax = worldMax;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    @Override
    public void prePhysicsTick(PhysicsSpace space, float f) {
    }

    @Override
    public void physicsTick(PhysicsSpace space, float f) {
    }

    public static enum ThreadingType {
        SEQUENTIAL,
        PARALLEL;

    }
}

