/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.utilities;

import java.util.logging.Level;
import java.util.logging.Logger;
import jme3dae.transformers.ValueTransformer;

public class IntegerListTransformer
implements ValueTransformer<String, int[]> {
    public static IntegerListTransformer create() {
        return new IntegerListTransformer();
    }

    private IntegerListTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<int[]> transform(String value) {
        int[] result = null;
        String[] tokens = (value = value.trim().replace('\n', ' ')).trim().split(" ");
        if (tokens.length > 0) {
            result = new int[tokens.length];
            try {
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i];
                    result[i] = Integer.parseInt(token);
                }
            }
            catch (NumberFormatException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "", ex);
                result = null;
            }
        }
        return ValueTransformer.TransformedValue.create(result);
    }
}

