/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.utilities;

import jme3dae.transformers.ValueTransformer;

public class HexSequenceTransformer
implements ValueTransformer<String, byte[]> {
    public static HexSequenceTransformer create() {
        return new HexSequenceTransformer();
    }

    private HexSequenceTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<byte[]> transform(String value) {
        byte[] data = null;
        if (value != null && !value.isEmpty()) {
            data = this.parse(value);
        }
        return ValueTransformer.TransformedValue.create(data);
    }

    private byte[] parse(String value) {
        byte[] data = new byte[value.length() / 2];
        for (int i = 0; i < value.length(); i += 2) {
            String s = "0x" + value.substring(i, i + 2);
            data[i / 2] = (byte)(0xFF & Integer.decode(s));
        }
        return data;
    }
}

