/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import com.jme3.math.Vector3f;
import jme3dae.transformers.ValueTransformer;

public class Vector3fTransformer
implements ValueTransformer<String, Vector3f> {
    public static Vector3fTransformer create() {
        return new Vector3fTransformer();
    }

    private Vector3fTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<Vector3f> transform(String value) {
        String[] c;
        Vector3f v = null;
        if (value != null && !value.isEmpty() && (c = value.split(" ")).length == 3) {
            try {
                float x = Float.parseFloat(c[0]);
                float y = Float.parseFloat(c[1]);
                float z = Float.parseFloat(c[2]);
                v = new Vector3f(x, y, z);
            }
            catch (NumberFormatException ex) {
                System.err.println("Vector3fTransformer: not a float string");
            }
        }
        return ValueTransformer.TransformedValue.create(v);
    }
}

