/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import java.util.List;
import jme3dae.DAENode;
import jme3dae.collada14.transformers.GeometryTransformer;
import jme3dae.collada14.transformers.InputShared;
import jme3dae.collada14.transformers.PolygonData;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.Bindings;
import jme3dae.utilities.Conditions;
import jme3dae.utilities.MeasuringUnit;
import jme3dae.utilities.PolygonArrayTransformer;
import jme3dae.utilities.Todo;
import jme3dae.utilities.Tuple2;

public class TrianglesTransformer
extends GeometryTransformer<Tuple2<DAENode, Bindings>, Geometry> {
    public static TrianglesTransformer create() {
        return new TrianglesTransformer();
    }

    private TrianglesTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<Geometry> transform(Tuple2<DAENode, Bindings> value) {
        Geometry geom = null;
        DAENode triangles = value.getA();
        Bindings bindings = value.getB();
        Tuple2<Integer, List<InputShared>> inputData = this.getInputs(triangles);
        List<InputShared> inputs = inputData.getB();
        int chunkSize = inputData.getA();
        ValueTransformer.TransformedValue<Integer> triangleCount = triangles.getAttribute("count", INTEGER);
        Conditions.checkTrue(triangleCount.isDefined(), "Collada 1.4.1 requires triangle count attribute for triangle element");
        ValueTransformer.TransformedValue<int[]> primitives = triangles.getChild("p").getContent(INTEGER_LIST);
        if (primitives.isDefined()) {
            int[] indices = primitives.get();
            PolygonData[] polygons = new PolygonData[triangleCount.get().intValue()];
            for (int i = 0; i < polygons.length; ++i) {
                polygons[i] = PolygonData.create(3);
            }
            for (InputShared inputShared : inputs) {
                inputShared.transferData(chunkSize, indices, polygons);
            }
            MeasuringUnit unit = triangles.getRootNode().getParsedData(MeasuringUnit.class);
            ValueTransformer.TransformedValue<Tuple2<Mesh, PolygonData[]>> mesh = PolygonArrayTransformer.create().transform(Tuple2.create(unit, polygons));
            if (mesh.isDefined()) {
                triangles.setParsedData(mesh.get().getB());
                triangles.setParsedData(mesh.get().getA());
                geom = new Geometry("model");
                geom.setMesh(mesh.get().getA());
                geom.setModelBound((BoundingVolume)new BoundingBox());
                geom.updateModelBound();
                this.applyMaterial(geom, triangles, bindings);
            } else {
                Todo.task("unable to generate mesh, AHHHH!");
            }
        } else {
            Todo.task("triangles element has no p child. Maybe extra element contains data?");
        }
        return ValueTransformer.TransformedValue.create(geom);
    }
}

