/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import com.jme3.texture.Texture;
import jme3dae.DAENode;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.Conditions;
import jme3dae.utilities.Todo;
import jme3dae.utilities.TransformerPack;

public class TextureElementTransformer
implements TransformerPack<DAENode, Texture> {
    public static TextureElementTransformer create() {
        return new TextureElementTransformer();
    }

    private TextureElementTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<Texture> transform(DAENode textureNode) {
        Texture texture = null;
        if (textureNode != null && textureNode.hasName("texture")) {
            ValueTransformer.TransformedValue<String> textureLink = textureNode.getAttribute("texture", TEXT);
            Conditions.checkTrue(textureLink.isDefined());
            DAENode textureLinkedNode = textureNode.getLinkedNode(textureLink.get());
            if (textureLinkedNode.hasName("newparam")) {
                DAENode samplerNode = textureLinkedNode.getChild("sampler2D");
                Conditions.checkTrue(samplerNode.hasName("sampler2D"));
                ValueTransformer.TransformedValue<String> sourceLink = samplerNode.getChild("source").getContent(TEXT);
                Conditions.checkTrue(sourceLink.isDefined());
                DAENode surface = samplerNode.getLinkedNode(sourceLink.get()).getChild("surface");
                DAENode initFrom = surface.getChild("init_from");
                Conditions.checkTrue(initFrom.hasName("init_from"));
                ValueTransformer.TransformedValue<String> imageLink = initFrom.getContent(TEXT);
                DAENode imageNode = initFrom.getLinkedNode(imageLink.get());
                texture = imageNode.getParsedData(Texture.class);
            } else if (textureLinkedNode.hasName("image")) {
                texture = textureLinkedNode.getParsedData(Texture.class);
                DAENode extra = textureNode.getChild("extra");
                DAENode tech = extra.getChild("technique");
                if (tech.getAttribute("profile", TEXT).contains("MAYA")) {
                    ValueTransformer.TransformedValue<Boolean> wrapU = tech.getChild("wrapU").getContent(BOOLEAN);
                    ValueTransformer.TransformedValue<Boolean> wrapV = tech.getChild("wrapV").getContent(BOOLEAN);
                    Todo.task("parse MAYA technique");
                }
                Todo.implementThis();
            }
            Todo.task("parse the remaining values, check for optional/missing nodes");
        }
        return ValueTransformer.TransformedValue.create(texture);
    }
}

