/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import com.jme3.animation.Bone;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.LinkedList;
import java.util.List;
import jme3dae.DAENode;
import jme3dae.FXEnhancerInfo;
import jme3dae.collada14.ColladaSpec141;
import jme3dae.collada14.transformers.ColorRGBATransformer;
import jme3dae.collada14.transformers.InstanceControllerTransformer;
import jme3dae.collada14.transformers.MeshTransformer;
import jme3dae.collada14.transformers.SemanticTransformer;
import jme3dae.collada14.transformers.TransformationElementTransformer;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.Bindings;
import jme3dae.utilities.Conditions;
import jme3dae.utilities.Todo;
import jme3dae.utilities.TransformerPack;
import jme3dae.utilities.Tuple2;

public class SceneTransformer
implements TransformerPack<Tuple2<DAENode, Node>, Void> {
    public static SceneTransformer create() {
        return new SceneTransformer();
    }

    private SceneTransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<Void> transform(Tuple2<DAENode, Node> value) {
        DAENode scene = value.getA();
        Node root = value.getB();
        Conditions.checkTrue(scene.hasName("scene"), "Expected 'scene' got " + scene);
        for (DAENode instancePhysicsScene : scene.getChildren("instance_physics_scene")) {
            Todo.parse(instancePhysicsScene);
        }
        DAENode instanceVisualScene = scene.getChild("instance_visual_scene");
        if (instanceVisualScene.isDefined()) {
            this.parseInstanceVisualScene(instanceVisualScene, root);
        }
        return ValueTransformer.TransformedValue.create(null);
    }

    private void parseInstanceVisualScene(DAENode instanceVisualScene, Node jmeRoot) {
        Conditions.checkTrue(instanceVisualScene.hasName("instance_visual_scene"));
        ValueTransformer.TransformedValue<String> url = instanceVisualScene.getAttribute("url", TEXT);
        Conditions.checkTrue(url.isDefined(), "Collada spec 1.4.1 requires url attribute for instance_visual_scene element");
        DAENode visualScene = instanceVisualScene.getLinkedNode(url.get());
        Conditions.checkTrue(visualScene.hasName("visual_scene"), "Expected 'visual_scene' got " + visualScene);
        DAENode extra = visualScene.getChild("extra");
        List<DAENode> evaluateSceneList = visualScene.getChildren("evaluate_scene");
        DAENode asset = visualScene.getChild("asset");
        if (extra.isDefined()) {
            Todo.parse(extra);
        }
        if (!evaluateSceneList.isEmpty()) {
            Todo.parse(evaluateSceneList.get(0));
        }
        if (asset.isDefined()) {
            Todo.parse(asset);
        }
        this.parseVisualScene(visualScene, jmeRoot);
    }

    private void parseSkin(DAENode instanceController, DAENode skin, DAENode bindMaterial, Node sceneLink) {
        DAENode geometry = skin.getLinkedSource();
        DAENode mesh = geometry.getChild("mesh");
        LinkedList jmeGeometries = new LinkedList();
        for (DAENode dAENode : mesh.getChildren("triangles")) {
        }
        Todo.implementThis();
    }

    private DAENode findSemanticInput(DAENode parent, ColladaSpec141.Semantic s) {
        for (DAENode input : parent.getChildren("input")) {
            ValueTransformer.TransformedValue<ColladaSpec141.Semantic> sem = input.getAttribute("semantic", SemanticTransformer.create());
            if (!sem.isDefined() || sem.get() != s) continue;
            return input;
        }
        return DAENode.NONE;
    }

    private void parseVisualScene(DAENode visualScene, Node jmeRoot) {
        Conditions.checkTrue(visualScene.hasName("visual_scene"));
        DAENode asset = visualScene.getChild("asset");
        List<DAENode> nodeList = visualScene.getChildren("node");
        List<DAENode> evaluateSceneList = visualScene.getChildren("evaluate_scene");
        List<DAENode> extraList = visualScene.getChildren("extra");
        if (asset.isDefined()) {
            Todo.parse(asset);
        }
        if (!evaluateSceneList.isEmpty()) {
            Todo.parse(evaluateSceneList.get(0));
        }
        if (!extraList.isEmpty()) {
            Todo.parse(extraList.get(0));
        }
        for (DAENode node : nodeList) {
            this.parseNode(node, jmeRoot);
        }
    }

    private void parseNode(DAENode node, Node jmeRoot) {
        FXEnhancerInfo FX_INFO = node.getRootNode().getParsedData(FXEnhancerInfo.class);
        Conditions.checkTrue(node.hasName("node"));
        ValueTransformer.TransformedValue<String> optionalType = node.getAttribute("type", TEXT);
        ValueTransformer.TransformedValue<String[]> optionaLayers = node.getAttribute("layer", NAME_LIST);
        ValueTransformer.TransformedValue<String> optionalName = node.getAttribute("name", TEXT);
        DAENode optionalAsset = node.getChild("asset");
        List<DAENode> optionalExtras = node.getChildren("extra");
        List<DAENode> transformElements = node.getChildren("lookat", "matrix", "rotate", "scale", "skew", "translate");
        List<DAENode> optionalInstanceCameras = node.getChildren("instance_camera");
        List<DAENode> optionalInstanceControllers = node.getChildren("instance_controller");
        List<DAENode> optionalInstanceGeometries = node.getChildren("instance_geometry");
        List<DAENode> optionalInstanceLights = node.getChildren("instance_light");
        List<DAENode> optionaInstanceNodes = node.getChildren("instance_node");
        List<DAENode> optionaNodes = node.getChildren("node");
        Node jmeNode = new Node(optionalName.isDefined() ? optionalName.get() : "");
        node.setParsedData(jmeNode);
        ValueTransformer.TransformedValue<Transform> optionalTransform = TransformationElementTransformer.create().transform(transformElements);
        if (optionalTransform.isDefined()) {
            jmeNode.setLocalTransform(optionalTransform.get());
        }
        jmeRoot.attachChild((Spatial)jmeNode);
        for (DAENode instanceGeometry : optionalInstanceGeometries) {
            this.parseInstanceGeometry(instanceGeometry, jmeNode);
        }
        if (!FX_INFO.getIgnoreLights()) {
            for (DAENode instanceLight : optionalInstanceLights) {
                this.parseInstanceLight(instanceLight, jmeNode);
            }
        }
        for (DAENode childNode : optionaNodes) {
            this.parseNode(childNode, jmeNode);
        }
        for (DAENode instanceCamera : optionalInstanceCameras) {
            this.parseInstanceCamera(instanceCamera, jmeNode);
        }
        for (DAENode instanceController : optionalInstanceControllers) {
            this.parseInstanceController(instanceController, jmeNode);
        }
        for (DAENode instanceNode : optionaInstanceNodes) {
            this.parseInstanceNode(instanceNode, jmeNode);
        }
        if (optionalType.isDefined()) {
            if (optionalType.get().equals(ColladaSpec141.NodeType.JOINT.name())) {
                Bone bone = new Bone(node.getAttribute("sid", TEXT).get());
                node.setParsedData(bone);
                Bone parent = node.getParent().getParsedData(Bone.class);
                if (parent != null) {
                    parent.addChild(bone);
                }
            } else {
                Todo.task("parse node type " + optionalType.get());
            }
        }
        if (optionaLayers.isDefined()) {
            Todo.task("implement parsing of node layer list");
        }
        if (optionalAsset.isDefined()) {
            Todo.task("parse " + optionalAsset);
        }
        if (!optionalExtras.isEmpty()) {
            Todo.task("implement parsing of optional extras");
        }
    }

    private void parseInstanceGeometry(DAENode instanceGeometry, Node jmeNode) {
        Conditions.checkTrue(instanceGeometry.hasName("instance_geometry"));
        DAENode optionalBindMaterial = instanceGeometry.getChild("bind_material");
        Bindings materialBindings = Bindings.create();
        this.parseBindMaterial(optionalBindMaterial, materialBindings);
        List<DAENode> optionalExtras = instanceGeometry.getChildren("extra");
        ValueTransformer.TransformedValue<String> url = instanceGeometry.getAttribute("url", TEXT);
        Conditions.checkTrue(url.isDefined(), "Collada spec 1.4.1 requires url attribute for instance_geometry element");
        ValueTransformer.TransformedValue<String> optionalName = instanceGeometry.getAttribute("name", TEXT);
        DAENode geometry = instanceGeometry.getLinkedNode(url.get());
        Conditions.checkTrue(geometry.isDefined(), "Cannot find linked node " + url.get());
        Conditions.checkTrue(geometry.hasName("geometry"), "Collada spec 1.4.1 requires geometry here");
        DAENode geometryOptionalAsset = geometry.getChild("asset");
        List<DAENode> geometricElement = geometry.getChildren("convex_mesh", "mesh", "spline");
        Conditions.checkValue(geometricElement.size(), 1);
        DAENode geomElement = geometricElement.get(0);
        ValueTransformer.TransformedValue<Object> jmeMeshNode = ValueTransformer.TransformedValue.create(null);
        if (geomElement.hasName("convex_mesh")) {
            Todo.task("implement parsing of convex_mesh geometry");
        } else if (geomElement.hasName("mesh")) {
            jmeMeshNode = MeshTransformer.create().transform(Tuple2.create(geomElement, materialBindings));
        } else if (geomElement.hasName("spline")) {
            Todo.task("implement parsing of spline geometry");
        }
        if (jmeMeshNode.isDefined()) {
            ((Node)jmeMeshNode.get()).setName(optionalName.isDefined() ? optionalName.get() : "");
            for (Spatial spatial : ((Node)jmeMeshNode.get()).getChildren()) {
                spatial.setName(url.get());
            }
            jmeNode.attachChild((Spatial)jmeMeshNode.get());
        }
    }

    private void parseInstanceLight(DAENode instanceLight, Node jmeNode) {
        Conditions.checkTrue(instanceLight.hasName("instance_light"), "expected instance light, got " + instanceLight);
        ValueTransformer.TransformedValue<String> url = instanceLight.getAttribute("url", TEXT);
        Conditions.checkTrue(url.isDefined(), "Collada 1.4.1 requires instance_light url to be defined");
        DAENode light = instanceLight.getLinkedNode(url.get());
        Conditions.checkTrue(light.isDefined(), "Cannote resolve link " + url.get());
        Conditions.checkTrue(light.hasName("light"), "Collada 1.4.1 requires instance_light url to point to a light element");
        DAENode techniqueCommon = light.getChild("technique_common");
        Conditions.checkTrue(techniqueCommon.isDefined(), "Collara 1.4.1 requires a technique_common chid for light element");
        List<DAENode> lightElement = techniqueCommon.getChildren("ambient", "directional", "point", "spot");
        Conditions.checkTrue(lightElement.size() == 1, "Collada 1.4.1 requires one ambient or directional or point or spot element per light");
        DAENode lightNode = lightElement.get(0);
        ColorRGBA color = lightNode.getChild("color").getContent(ColorRGBATransformer.create()).get();
        Transform worldTransform = jmeNode.getWorldTransform();
        jmeNode.updateGeometricState();
        if (lightNode.hasName("directional")) {
            DirectionalLight dl = new DirectionalLight();
            Vector3f dir = new Vector3f(0.0f, 0.0f, -1.0f);
            dir = worldTransform.transformVector(dir, dir);
            dl.setDirection(dir.normalizeLocal());
            dl.setColor(color);
            Node p = jmeNode;
            while (p.getParent() != null) {
                p = p.getParent();
            }
            p.addLight((Light)dl);
        } else if (lightNode.hasName("point")) {
            PointLight pl = new PointLight();
            Vector3f pos = worldTransform.transformVector(new Vector3f(), new Vector3f());
            pl.setColor(color);
            pl.setPosition(pos);
            pl.setRadius(100.0f);
            Node p = jmeNode;
            while (p.getParent() != null) {
                p = p.getParent();
            }
            p.addLight((Light)pl);
            Todo.task("set arbitrary radius 100 for point light at " + jmeNode.getWorldTranslation());
        } else {
            Todo.task("Parse light of type " + lightNode);
        }
    }

    private void parseInstanceCamera(DAENode instanceCamera, Node jmeNode) {
        Todo.implementThis();
    }

    private void parseInstanceController(DAENode instanceController, Node jmeNode) {
        ValueTransformer.TransformedValue<Node> r = InstanceControllerTransformer.create().transform(instanceController);
        if (r.isDefined()) {
            jmeNode.attachChild((Spatial)r.get());
        }
    }

    private void parseInstanceNode(DAENode instanceNode, Node jmeNode) {
        Conditions.checkTrue(instanceNode.hasName("instance_node"));
        List<DAENode> optionalExtras = instanceNode.getChildren("extra");
        ValueTransformer.TransformedValue<String> url = instanceNode.getAttribute("url", TEXT);
        Conditions.checkTrue(url.isDefined());
        DAENode linkedNode = instanceNode.getLinkedNode(url.get());
        if (!optionalExtras.isEmpty()) {
            Todo.task("parse extra elements of linked node element");
        }
        if (linkedNode.isDefined()) {
            Conditions.checkTrue(linkedNode.hasName("node"), "Collada 1.4.1 requires node element here");
            this.parseNode(linkedNode, jmeNode);
        } else {
            Todo.task("linked node " + url.get() + "not found, maybe external resource?");
        }
    }

    private void parseBindMaterial(DAENode bindMaterial, Bindings materialBindings) {
        materialBindings.put("bind_material", bindMaterial);
    }

    private void dumpGeometry(Geometry geometry) {
        System.out.println("Geometry " + geometry.getName());
        Material mat = geometry.getMaterial();
        if (mat != null) {
            for (MatParam matParam : mat.getParams()) {
                System.out.println(matParam.getName() + " = " + matParam.getValue());
            }
        }
    }
}

