/*
 * Decompiled with CFR 0.152.
 */
package jme3dae.collada14.transformers;

import com.jme3.math.ColorRGBA;
import jme3dae.transformers.ValueTransformer;

public class ColorRGBATransformer
implements ValueTransformer<String, ColorRGBA> {
    public static ColorRGBATransformer create() {
        return new ColorRGBATransformer();
    }

    private ColorRGBATransformer() {
    }

    @Override
    public ValueTransformer.TransformedValue<ColorRGBA> transform(String value) {
        String[] rgba;
        ColorRGBA color = null;
        if (!((value = value.trim()).isEmpty() || (rgba = value.split(" ")).length != 3 && rgba.length != 4)) {
            try {
                float red = Float.parseFloat(rgba[0]);
                float green = Float.parseFloat(rgba[1]);
                float blue = Float.parseFloat(rgba[2]);
                float alpha = rgba.length == 3 ? 1.0f : Float.parseFloat(rgba[3]);
                color = new ColorRGBA(red, green, blue, alpha);
            }
            catch (Exception ex) {
                System.err.println("COLORGBATransformer: not a number");
            }
        }
        return ValueTransformer.TransformedValue.create(color);
    }
}

