/*
 * Decompiled with CFR 0.152.
 */
package jme3dae;

import com.jme3.asset.AssetManager;
import com.jme3.scene.Node;
import jme3dae.DAENode;
import jme3dae.FXEnhancerInfo;
import jme3dae.collada14.ColladaDocumentV14;
import jme3dae.transformers.ValueTransformer;
import jme3dae.utilities.Tuple2;

public class ColladaDocumentFactory {
    private static FXEnhancerInfo fxInfo = FXEnhancerInfo.create(FXEnhancerInfo.NormalMapGenerator.OFF, FXEnhancerInfo.TwoSidedMaterial.OFF);

    public static void setFXEnhance(FXEnhancerInfo info) {
        fxInfo = info;
    }

    private ColladaDocumentFactory() {
    }

    public static ValueTransformer<Tuple2<DAENode, AssetManager>, Node> newColladaDocumentParser(DAENode root) {
        return ColladaDocumentV14.create(fxInfo);
    }

    public static class FXSettingsGenerator {
        private FXEnhancerInfo fx = FXEnhancerInfo.create(FXEnhancerInfo.IgnoreMeasuringUnit.OFF);

        public FXSettingsGenerator setIgnoreMeasuringUnit(FXEnhancerInfo.IgnoreMeasuringUnit v) {
            this.fx = new FXEnhancerInfo(this.fx.getAutoBump(), this.fx.getTwoSided(), v == FXEnhancerInfo.IgnoreMeasuringUnit.ON, this.fx.getIgnoreLights(), this.fx.getUseJME3Materials());
            return this;
        }

        public FXSettingsGenerator setNormalMapGeneration(FXEnhancerInfo.NormalMapGenerator v) {
            this.fx = new FXEnhancerInfo(v == FXEnhancerInfo.NormalMapGenerator.ON, this.fx.getTwoSided(), this.fx.getIgnoreMeasuringUnit(), this.fx.getIgnoreLights(), this.fx.getUseJME3Materials());
            return this;
        }

        public FXSettingsGenerator setIgnoreLights(FXEnhancerInfo.IgnoreLights v) {
            this.fx = new FXEnhancerInfo(this.fx.getAutoBump(), this.fx.getTwoSided(), this.fx.getIgnoreMeasuringUnit(), v == FXEnhancerInfo.IgnoreLights.ON, this.fx.getUseJME3Materials());
            return this;
        }

        public FXSettingsGenerator setTwoSidedMaterial(FXEnhancerInfo.TwoSidedMaterial m) {
            this.fx = new FXEnhancerInfo(this.fx.getAutoBump(), m == FXEnhancerInfo.TwoSidedMaterial.ON, this.fx.getIgnoreMeasuringUnit(), this.fx.getIgnoreLights(), this.fx.getUseJME3Materials());
            return this;
        }

        public FXSettingsGenerator setUseJME3Materials(FXEnhancerInfo.UseJME3Materials m) {
            this.fx = new FXEnhancerInfo(this.fx.getAutoBump(), this.fx.getTwoSided(), this.fx.getIgnoreMeasuringUnit(), this.fx.getIgnoreLights(), m == FXEnhancerInfo.UseJME3Materials.ON);
            return this;
        }

        public FXEnhancerInfo get() {
            return this.fx;
        }
    }
}

